/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.componentmanager;

import com.ibm.msg.client.commonservices.CSIException;
import com.ibm.msg.client.commonservices.componentmanager.Component;
import com.ibm.msg.client.commonservices.componentmanager.ComponentListener;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.StartupTracer;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ComponentManager {
    private static HashMap listenerRegistry;
    private static HashMap componentRegistry;
    private static boolean useStartupTrace;
    private static StartupTracer startupTrace;
    public static final String COMPONENT_VRMF = "COMPONENT_VRMF";
    public static final String PROVIDER_NAME = "XMSC_PROVIDER_NAME";
    public static final String WMQ_PROVIDER = "com.ibm.msg.client.wmq";
    public static final String MQTT_PROVIDER = "com.ibm.msg.client.mqtt";
    public static final String RTT_PROVIDER = "com.ibm.msg.client.rtt";
    public static final String WPM_PROVIDER = "com.ibm.msg.client.wpm";
    public static final String TRT_PROVIDER = "com.ibm.msg.client.tempore";
    public static final String J2SE_COMMONSERVICE = "com.ibm.msg.client.commonservices.j2se";
    public static final String J2ME_COMMONSERVICE = "com.ibm.msg.client.commonservices.j2me";
    public static final String WMQ_JMS_CLASSES = "com.ibm.mq.jms";
    public static final String JAVA_MSG_SERVICE_CLIENT = "com.ibm.msg.client.jms";
    public static final int COMPONENT_VERSION_INDEX = 0;
    public static final int COMPONENT_RELEASE_INDEX = 1;
    public static final int COMPONENT_MODIFICATION_INDEX = 2;
    public static final int COMPONENT_FIX_INDEX = 3;
    private static final String COMP_CLASS = "CompClass";
    private static final String COMP_INFO_FILE = "META-INF/compinfo.properties";
    private static final String COMP_LIST = "CompList";
    private int waitTimeout = 30000;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ComponentManager compMgr;
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/componentmanager/ComponentManager.java, jmscc.commonservices, k701, k701-112-140304 1.28.1.1 09/08/17 08:31:04";
    static final /* synthetic */ boolean $assertionsDisabled;

    public void addComponentListener(String componentType, ComponentListener listener) {
        ComponentManager._traceEntry(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "addComponentListener(String,ComponentListener)", new Object[]{componentType, listener});
        if (!$assertionsDisabled && listenerRegistry == null) {
            throw new AssertionError((Object)"listenerRegistry not initialized - check sequence of static initilization");
        }
        Vector<ComponentListener> entry = (Vector<ComponentListener>)listenerRegistry.get(componentType);
        if (entry != null) {
            entry.add(listener);
        } else {
            entry = new Vector<ComponentListener>();
            entry.add(listener);
            listenerRegistry.put(componentType, entry);
        }
        ComponentManager._traceExit(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "addComponentListener(String,ComponentListener)", null, -1);
    }

    private Component[] findComponent(ArrayList preLoadedComponents, String type, HashMap filters) throws Exception {
        ComponentManager._traceEntry(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "findComponent(String,HashMap)", new Object[]{type, filters});
        ArrayList results = preLoadedComponents;
        Enumeration<URL> resources = ClassLoader.getSystemResources(COMP_INFO_FILE);
        ComponentManager._traceData(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "findComponent(String,HashMap)", "Using main system classloader", ClassLoader.class);
        this.locateComponents(results, resources);
        ClassLoader thisClassesLoader = this.getClass().getClassLoader();
        resources = thisClassesLoader.getResources(COMP_INFO_FILE);
        ComponentManager._traceData(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "findComponent(String,HashMap)", "Using class's classloader", thisClassesLoader);
        this.locateComponents(results, resources);
        ClassLoader threadContextClassloader = Thread.currentThread().getContextClassLoader();
        resources = threadContextClassloader.getResources(COMP_INFO_FILE);
        ComponentManager._traceData(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "findComponent(String,HashMap)", "Using thread context classloader", threadContextClassloader);
        this.locateComponents(results, resources);
        if (results.size() == 0) {
            if (type != null && type.equals("CSI")) {
                CSIException traceRet1 = new CSIException(NLSServices.getMessage("JMSCS0003"));
                ComponentManager._traceThrowing(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "findComponent(String,HashMap)", traceRet1, 1);
                throw traceRet1;
            }
            if (type != null && type.equals("MPI")) {
                CSIException traceRet2 = new CSIException(NLSServices.getMessage("JMSCS0004"));
                ComponentManager._traceThrowing(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "findComponent(String,HashMap)", traceRet2, 2);
                throw traceRet2;
            }
            CSIException traceRet3 = new CSIException(NLSServices.getMessage("JMSCS0004"));
            ComponentManager._traceThrowing(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "findComponent(String,HashMap)", traceRet3, 3);
            throw traceRet3;
        }
        Object[] temp = results.toArray();
        ComponentManager._traceData(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "findComponent(String,HashMap)", "Copying array contents", temp);
        Component[] components = new Component[temp.length];
        System.arraycopy(temp, 0, components, 0, temp.length);
        ComponentManager._traceExit(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "findComponent(String,HashMap)", components, -1);
        return components;
    }

    private void locateComponents(ArrayList results, Enumeration resources) {
        ComponentManager._traceData(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "locateComponents(ArrayList results, Enumeration resources)", "Enumeration of compinfo.properites", resources);
        while (resources != null && resources.hasMoreElements()) {
            URL url = (URL)resources.nextElement();
            ComponentManager._traceData(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "findComponent(String,HashMap)", "Got URI", url);
            try {
                Properties props = new Properties();
                props.load(url.openStream());
                String compList = props.getProperty(COMP_LIST);
                StringTokenizer components = new StringTokenizer(compList, ",");
                while (components.hasMoreElements()) {
                    String prefix = components.nextToken();
                    prefix = prefix + "_";
                    String componentClass = props.getProperty(prefix + COMP_CLASS);
                    ComponentManager._traceData(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "findComponent(String,HashMap)", "Getting componentClass", componentClass);
                    Component comp = (Component)this.dynamicLoadClass(componentClass, this.getClass()).newInstance();
                    results.add(comp);
                }
            }
            catch (Exception e) {
                ComponentManager._traceCatchBlock(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "findComponent(String,HashMap)", e, -1);
            }
        }
        ComponentManager._traceData(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "locateComponents(ArrayList results, Enumeration resources)", "Enumeration done", null);
    }

    public Component getComponent(String type, HashMap filters) throws CSIException {
        Component bestSoFar;
        block10: {
            ComponentManager._traceEntry("c.i.m.c.commonservices.componentmanager.ComponentManager", "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponent(String,HashMap)", new Object[]{type, filters});
            bestSoFar = null;
            try {
                Vector entry = (Vector)componentRegistry.get(type);
                if (entry == null) break block10;
                Iterator it = entry.iterator();
                bestSoFar = null;
                while (it.hasNext()) {
                    Component comp = (Component)it.next();
                    if (!this.checkComponent(comp, filters)) continue;
                    if (bestSoFar == null) {
                        bestSoFar = comp;
                        continue;
                    }
                    if (comp.getName().equals(bestSoFar.getName())) {
                        int[] compVersion = comp.getVersion();
                        int[] bestSoFarVersion = bestSoFar.getVersion();
                        if (compVersion == null || bestSoFarVersion == null || compVersion.length != 4 || bestSoFarVersion.length != 4) continue;
                        boolean setBestSoFar = false;
                        for (int i = 0; i < compVersion.length && !setBestSoFar; ++i) {
                            if (compVersion[i] >= bestSoFarVersion[i]) continue;
                            ComponentManager._traceData(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponent(String,HashMap)", "Best component so far updated due to version rule to", comp.getName());
                            bestSoFar = comp;
                            setBestSoFar = true;
                        }
                        continue;
                    }
                    String[] inPreferenceTo = comp.getInPreferenceTo();
                    boolean setBestSoFar = false;
                    for (int i = 0; inPreferenceTo != null && i < inPreferenceTo.length && !setBestSoFar; ++i) {
                        if (!inPreferenceTo[i].equals(bestSoFar.getName())) continue;
                        ComponentManager._traceData(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponent(String,HashMap)", "Best component so far updated due to inPreferenceTo rule to", comp.getName());
                        bestSoFar = comp;
                    }
                }
            }
            catch (Exception e) {
                ComponentManager._traceCatchBlock(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponent(String,HashMap)", e, -1);
            }
        }
        if (bestSoFar == null) {
            if (type.equals("CSI")) {
                CSIException traceRet1 = new CSIException(NLSServices.getMessage("JMSCS0003"));
                ComponentManager._traceThrowing(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponent(String,HashMap)", traceRet1, 1);
                throw traceRet1;
            }
            if (type.equals("MPI")) {
                CSIException traceRet2 = new CSIException(NLSServices.getMessage("JMSCS0004"));
                ComponentManager._traceThrowing(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponent(String,HashMap)", traceRet2, 2);
                throw traceRet2;
            }
            CSIException traceRet3 = new CSIException(NLSServices.getMessage("JMSCS0005") + " " + type);
            ComponentManager._traceThrowing("c.i.m.c.commonservices.componentmanager.ComponentManager", "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponent(String,HashMap)", traceRet3, 3);
            throw traceRet3;
        }
        ComponentManager._traceExit("c.i.m.c.commonservices.componentmanager.ComponentManager", "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponent(String,HashMap)", bestSoFar, -1);
        return bestSoFar;
    }

    public Component[] getComponents(String type, HashMap filters) throws CSIException {
        ComponentManager._traceEntry(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponents(String,HashMap)", new Object[]{type, filters});
        Component[] components = new Component[]{};
        ArrayList<Component> results = new ArrayList<Component>();
        Vector entry = (Vector)componentRegistry.get(type);
        if (entry != null) {
            Iterator it = entry.iterator();
            while (it.hasNext()) {
                Component comp = (Component)it.next();
                if (!this.checkComponent(comp, filters)) continue;
                results.add(comp);
            }
            if (results.size() == 0) {
                if (type.equals("CSI")) {
                    CSIException traceRet1 = new CSIException(NLSServices.getMessage("JMSCS0003"));
                    ComponentManager._traceThrowing(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponents(String,HashMap)", traceRet1, 1);
                    throw traceRet1;
                }
                if (type.equals("MPI")) {
                    CSIException traceRet2 = new CSIException(NLSServices.getMessage("JMSCS0004"));
                    ComponentManager._traceThrowing(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponents(String,HashMap)", traceRet2, 2);
                    throw traceRet2;
                }
                CSIException traceRet3 = new CSIException(NLSServices.getMessage("JMSCS0005") + " " + type);
                ComponentManager._traceThrowing(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponents(String,HashMap)", traceRet3, 3);
                throw traceRet3;
            }
            Object[] temp = results.toArray();
            components = new Component[temp.length];
            System.arraycopy(temp, 0, components, 0, temp.length);
        }
        ComponentManager._traceExit(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponents(String,HashMap)", components, -1);
        return components;
    }

    public Component[] getComponents(HashMap filters) {
        ComponentManager._traceEntry(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponents(HashMap)", new Object[]{filters});
        Component[] components = new Component[]{};
        ArrayList<Component> results = new ArrayList<Component>();
        Iterator compRegIt = componentRegistry.values().iterator();
        while (compRegIt.hasNext()) {
            Vector entry = (Vector)compRegIt.next();
            Iterator it = entry.iterator();
            while (it.hasNext()) {
                Component comp = (Component)it.next();
                if (!this.checkComponent(comp, filters)) continue;
                results.add(comp);
            }
        }
        if (results.size() <= 0) {
            return null;
        }
        Object[] temp = results.toArray();
        components = new Component[temp.length];
        System.arraycopy(temp, 0, components, 0, temp.length);
        ComponentManager._traceExit(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponents(HashMap)", components, -1);
        return components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component[] getComponentsWithWait(String type, HashMap filters) throws CSIException {
        ComponentManager._traceEntry(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponentsWithWait(String,HashMap)", new Object[]{type, filters});
        Component[] comps = null;
        try {
            comps = this.getComponents(type, filters);
        }
        catch (CSIException e1) {
            ComponentManager._traceCatchBlock(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponentsWithWait(String,HashMap)", e1, 1);
        }
        while (comps == null || comps.length == 0) {
            try {
                HashMap e1 = componentRegistry;
                synchronized (e1) {
                    long t1 = System.currentTimeMillis();
                    componentRegistry.wait(this.waitTimeout);
                    if (System.currentTimeMillis() - t1 > (long)this.waitTimeout) {
                        if (type.equals("CSI")) {
                            CSIException traceRet1 = new CSIException(NLSServices.getMessage("JMSCS0003"));
                            ComponentManager._traceThrowing(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponentsWithWait(String,HashMap)", traceRet1, 1);
                            throw traceRet1;
                        }
                        if (type.equals("MPI")) {
                            CSIException traceRet2 = new CSIException(NLSServices.getMessage("JMSCS0004"));
                            ComponentManager._traceThrowing(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponentsWithWait(String,HashMap)", traceRet2, 2);
                            throw traceRet2;
                        }
                        CSIException traceRet3 = new CSIException(NLSServices.getMessage("JMSCS0005") + " " + type);
                        ComponentManager._traceThrowing(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponentsWithWait(String,HashMap)", traceRet3, 3);
                        throw traceRet3;
                    }
                }
            }
            catch (InterruptedException e) {
                ComponentManager._traceCatchBlock(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponentsWithWait(String,HashMap)", e, 2);
            }
            try {
                comps = this.getComponents(type, filters);
            }
            catch (CSIException e2) {
                ComponentManager._traceCatchBlock(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponentsWithWait(String,HashMap)", e2, 3);
            }
        }
        ComponentManager._traceExit(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponentsWithWait(String,HashMap)", comps, -1);
        return comps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponentWithWait(String type, HashMap filters) throws CSIException {
        ComponentManager._traceEntry(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponentWithWait(String,HashMap)", new Object[]{type, filters});
        Component comp = null;
        try {
            comp = this.getComponent(type, filters);
        }
        catch (CSIException e1) {
            ComponentManager._traceCatchBlock(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponentWithWait(String,HashMap)", e1, 1);
        }
        while (comp == null) {
            try {
                HashMap e1 = componentRegistry;
                synchronized (e1) {
                    long t1 = System.currentTimeMillis();
                    componentRegistry.wait(this.waitTimeout);
                    if (System.currentTimeMillis() - t1 > (long)this.waitTimeout) {
                        if (type.equals("CSI")) {
                            CSIException traceRet1 = new CSIException(NLSServices.getMessage("JMSCS0003"));
                            ComponentManager._traceThrowing(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponentWithWait(String,HashMap)", traceRet1, 1);
                            throw traceRet1;
                        }
                        if (type.equals("MPI")) {
                            CSIException traceRet2 = new CSIException(NLSServices.getMessage("JMSCS0004"));
                            ComponentManager._traceThrowing(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponentWithWait(String,HashMap)", traceRet2, 2);
                            throw traceRet2;
                        }
                        CSIException traceRet3 = new CSIException(NLSServices.getMessage("JMSCS0005") + " " + type);
                        ComponentManager._traceThrowing(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponentWithWait(String,HashMap)", traceRet3, 3);
                        throw traceRet3;
                    }
                }
            }
            catch (InterruptedException e) {
                ComponentManager._traceCatchBlock(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponentWithWait(String,HashMap)", e, 2);
            }
            try {
                comp = this.getComponent(type, filters);
            }
            catch (CSIException e1) {
                ComponentManager._traceCatchBlock(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponentWithWait(String,HashMap)", e1, 3);
            }
        }
        ComponentManager._traceExit(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getComponentWithWait(String,HashMap)", comp, -1);
        return comp;
    }

    protected void init() {
        this.init(new ArrayList());
    }

    protected void init(final ArrayList preLoadedComponents) {
        Object o = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("com.ibm.msg.client.commonservices.trace.startup");
                }
                catch (AccessControlException ace) {
                    System.err.println("Failed to query system property " + ace);
                    return null;
                }
            }
        });
        if (o != null && ((String)o).equalsIgnoreCase("TRUE") && startupTrace == null) {
            startupTrace = StartupTracer.getInstance();
        }
        ComponentManager._traceEntry(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "init()", null);
        if (componentRegistry == null) {
            componentRegistry = new HashMap();
            try {
                o = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return ComponentManager.this.findComponent(preLoadedComponents, null, null);
                        }
                        catch (Exception e) {
                            return e;
                        }
                    }
                });
                if (o instanceof Exception) {
                    throw (Exception)o;
                }
                Component[] components = (Component[])o;
                for (int i = 0; i < components.length; ++i) {
                    this.registerComponent(components[i]);
                }
            }
            catch (Exception e) {
                ComponentManager._traceData(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "init()", "Exception when finding/registering components", e);
            }
        }
        ComponentManager._traceExit(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "init()", null, -1);
    }

    private void notifyListeners(Component component, boolean registering) {
        ComponentManager._traceEntry(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "notifyListeners(Component,boolean)", new Object[]{component, registering});
        Vector entry = (Vector)listenerRegistry.get(component.getType());
        if (entry != null) {
            for (int i = 0; i < entry.size(); ++i) {
                ComponentListener listener = (ComponentListener)entry.get(i);
                ComponentManager._traceData(this, null, "notifyListeners(Component, boolean)", "Notifying listener", listener.getClass());
                if (registering) {
                    listener.componentRegistered(component);
                    continue;
                }
                listener.componentUnregistered(component);
            }
        } else {
            ComponentManager._traceData(this, null, "notifyListeners(Component, boolean)", "No listeners to notify for this component", component.getName());
        }
        ComponentManager._traceExit(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "notifyListeners(Component,boolean)", null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerComponent(Component comp) {
        ComponentManager._traceEntry(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "registerComponent(Component)", new Object[]{comp});
        String componentType = comp.getType();
        Vector entry = (Vector)componentRegistry.get(componentType);
        if (entry == null) {
            Vector<Component> newEntry = new Vector<Component>();
            newEntry.add(comp);
            HashMap hashMap = componentRegistry;
            synchronized (hashMap) {
                componentRegistry.put(componentType, newEntry);
                this.notifyListeners(comp, true);
                componentRegistry.notify();
            }
        }
        boolean alreadyRegistered = false;
        Iterator it = entry.iterator();
        while (it.hasNext() && !alreadyRegistered) {
            Component temp = (Component)it.next();
            if (!temp.getClass().equals(comp.getClass())) continue;
            alreadyRegistered = true;
            ComponentManager._traceData(this, null, "notifyListeners(Component, boolean)", "The component has already been register, no further work needed", temp.getName());
        }
        if (!alreadyRegistered) {
            HashMap hashMap = componentRegistry;
            synchronized (hashMap) {
                entry.add(comp);
                this.notifyListeners(comp, true);
                componentRegistry.notify();
            }
        }
        ComponentManager._traceExit(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "registerComponent(Component)", null, -1);
    }

    public void removeComponentListener(String componentType, ComponentListener listener) {
        ComponentManager._traceEntry(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "removeComponentListener(String,ComponentListener)", new Object[]{componentType, listener});
        Vector entry = (Vector)listenerRegistry.get(componentType);
        if (entry != null) {
            entry.remove(listener);
        }
        ComponentManager._traceExit(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "removeComponentListener(String,ComponentListener)", null, -1);
    }

    public void unregisterComponent(Component comp) {
        ComponentManager._traceEntry(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "unregisterComponent(Component)", new Object[]{comp});
        Vector entry = (Vector)componentRegistry.get(comp.getType());
        if (entry != null) {
            entry.remove(comp);
            this.notifyListeners(comp, false);
        }
        ComponentManager._traceExit(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "unregisterComponent(Component)", null, -1);
    }

    public void setWaitTimeout(int timeout) {
        ComponentManager._traceData(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "setWaitTimeout(int)", "setter", new Integer(timeout));
        this.waitTimeout = timeout;
    }

    public static void initSingleton(ArrayList preLoadedComponents) {
        if (compMgr == null) {
            compMgr = new ComponentManager();
            compMgr.init(preLoadedComponents);
        }
    }

    public static ComponentManager getInstance() {
        if (compMgr == null) {
            compMgr = new ComponentManager();
            compMgr.init();
        }
        ComponentManager._traceData(null, "c.i.m.c.commonservices.componentmanager.ComponentManager", "getter", "getInstance()", compMgr);
        return compMgr;
    }

    private boolean checkComponent(Component comp, HashMap filters) {
        ComponentManager._traceEntry(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "checkComponent(Component,HashMap)", new Object[]{comp, filters});
        if (!comp.isSuitable(filters)) {
            ComponentManager._traceExit(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "checkComponent(Component,HashMap)", false, 1);
            return false;
        }
        if (filters != null) {
            String provider = (String)filters.get(PROVIDER_NAME);
            boolean providerMatched = true;
            if (provider != null && !provider.equals(comp.getName())) {
                providerMatched = false;
            }
            boolean versionMatched = true;
            int[] compVersion = comp.getVersion();
            int[] versionFilter = (int[])filters.get(COMPONENT_VRMF);
            if (versionFilter != null && compVersion != null && compVersion.length == 4 && versionFilter.length == 4) {
                for (int i = 0; i < compVersion.length; ++i) {
                    if (compVersion[i] == versionFilter[i] || versionFilter[i] == -1) continue;
                    versionMatched = false;
                }
            }
            if (!providerMatched || !versionMatched) {
                ComponentManager._traceExit(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "checkComponent(Component,HashMap)", false, 2);
                return false;
            }
        }
        ComponentManager._traceExit(this, "c.i.m.c.commonservices.componentmanager.ComponentManager", "checkComponent(Component,HashMap)", true, 3);
        return true;
    }

    public static void setUseStartupTrace(boolean value) {
        useStartupTrace = value;
    }

    public static void _traceExit(Object parentClass, String parentClassName, String methodSignature, Object returnValue, int exitIndex) {
        if (useStartupTrace) {
            if (startupTrace != null) {
                startupTrace.methodExit(8, parentClass, parentClassName, methodSignature, returnValue, exitIndex);
            }
        } else if (Trace.isOn) {
            Trace.exit(parentClass, parentClassName, methodSignature, returnValue, exitIndex);
        }
    }

    public static void _traceEntry(Object parentClass, String parentClassName, String methodSignature, Object[] parameters) {
        if (useStartupTrace) {
            if (startupTrace != null) {
                startupTrace.methodEntry(8, parentClass, parentClassName, methodSignature, parameters);
            }
        } else if (Trace.isOn) {
            Trace.entry(parentClass, parentClassName, methodSignature, parameters);
        }
    }

    public static void _traceData(Object parentClass, String parentClassName, String methodSignature, String uniqueDescription, Object data) {
        if (useStartupTrace) {
            if (startupTrace != null) {
                startupTrace.traceData(9, parentClass, parentClassName, methodSignature, uniqueDescription, data);
            }
        } else if (Trace.isOn) {
            Trace.data(null, parentClassName, methodSignature, uniqueDescription, data);
        }
    }

    public static void _traceThrowing(Object parentClass, String parentClassName, String methodSignature, Throwable thrown, int exitIndex) {
        if (useStartupTrace) {
            if (startupTrace != null) {
                startupTrace.throwing(1, parentClass, parentClassName, methodSignature, thrown, exitIndex);
            }
        } else if (Trace.isOn) {
            Trace.throwing(parentClass, parentClassName, methodSignature, thrown, exitIndex);
        }
    }

    public static void _traceCatchBlock(Object parentClass, String parentClassName, String methodSignature, Throwable thrown, int exitIndex) {
        if (useStartupTrace) {
            if (startupTrace != null) {
                startupTrace.catchBlock(1, parentClass, parentClassName, methodSignature, thrown, exitIndex);
            }
        } else if (Trace.isOn) {
            Trace.catchBlock(parentClass, parentClassName, methodSignature, thrown, exitIndex);
        }
    }

    public Class dynamicLoadClass(final String name, final Class loadingClass) throws ClassNotFoundException {
        Object[] results = (Object[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Class<?> cls = null;
                ClassNotFoundException exception = null;
                ClassLoader threadClassloader = Thread.currentThread().getContextClassLoader();
                ClassLoader classClassloader = loadingClass.getClassLoader();
                if (threadClassloader != null) {
                    try {
                        ComponentManager._traceData(this, "CommonClassLoading", "dynamicLoadClass()", "Classload Step 1: Threadcontext Classloader", threadClassloader);
                        cls = Class.forName(name, true, threadClassloader);
                        ComponentManager._traceData(this, "CommonClassLoading", "dynamicLoadClass()", "Step 1 After load:", cls);
                    }
                    catch (ClassNotFoundException e) {
                        ComponentManager._traceData(this, "CommonClassLoading", "dynamicLoadClass()", "Expected Excetion", e.getClass() + "::" + e.getMessage());
                    }
                }
                if (cls == null && classClassloader != null) {
                    try {
                        ComponentManager._traceData(this, "CommonClassLoading", "dynamicLoadClass()", "Classload Step 2: Loading Class Classlodaer ", classClassloader);
                        cls = Class.forName(name, true, classClassloader);
                        ComponentManager._traceData(this, "CommonClassLoading", "dynamicLoadClass()", "Step 2 After load:", cls);
                    }
                    catch (ClassNotFoundException e) {
                        ComponentManager._traceData(this, "CommonClassLoading", "dynamicLoadClass()", "Expected Excetion", e.getClass() + "::" + e.getMessage());
                    }
                }
                if (cls == null) {
                    try {
                        ComponentManager._traceData(this, "CommonClassLoading", "dynamicLoadClass()", "Classload Step 3: class.forName()", "not using specific classloader");
                        cls = Class.forName(name);
                        ComponentManager._traceData(this, "CommonClassLoading", "dynamicLoadClass()", "Step 3 After class:", cls);
                        ComponentManager._traceData(this, "CommonClassLoading", "dynamicLoadClass()", "Step 3 Classloader", cls == null ? "n/a" : cls.getClassLoader().toString());
                    }
                    catch (ClassNotFoundException e) {
                        ComponentManager._traceData(this, "CommonClassLoading", "dynamicLoadClass()", "Expected Excetion", e.getClass() + "::" + e.getMessage());
                        exception = e;
                    }
                }
                Object[] traceRet1 = new Object[]{cls, exception};
                return traceRet1;
            }
        });
        if (results[1] != null && results[1] instanceof ClassNotFoundException) {
            throw (ClassNotFoundException)results[1];
        }
        if (results[0] instanceof Class) {
            return (Class)results[0];
        }
        return null;
    }

    static {
        $assertionsDisabled = !ComponentManager.class.desiredAssertionStatus();
        listenerRegistry = new HashMap();
        componentRegistry = null;
        useStartupTrace = true;
        compMgr = null;
    }
}

