/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.commandmanager;

import com.ibm.msg.client.commonservices.CSIException;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Command
implements Serializable {
    private static final long serialVersionUID = 7543533149884228613L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/commandmanager/Command.java, jmscc.commonservices, k701, k701-112-140304 1.19.1.1 09/08/17 08:35:38";
    public static String COMMAND;
    public static String EXCEPTION;
    public static final int UNSUBMITED = 1;
    public static final int PENDING = 2;
    public static final int SUCCESS = 3;
    public static final int FAIL = 4;
    public HashMap parameters = new HashMap();
    public Map results = Collections.synchronizedMap(new HashMap());
    private int state = 1;
    private Object stateLock = new Object();
    private String uid;

    public static Command createCommand(String commandType) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.commandmanager.Command", "createCommand(String)", new Object[]{commandType});
        }
        Command command = new Command();
        command.parameters.put(COMMAND, commandType);
        command.uid = System.currentTimeMillis() + commandType;
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.commandmanager.Command", "createCommand(String)", command);
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        int tempState;
        Object object = this.stateLock;
        synchronized (object) {
            tempState = this.state;
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.commonservices.commandmanager.Command", "getState()", "getter", new Integer(tempState));
        }
        return tempState;
    }

    public String getUID() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.commonservices.commandmanager.Command", "getUID()", "getter", this.uid);
        }
        return this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(int state) throws Exception {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.commandmanager.Command", "setState(int)", new Object[]{new Integer(state)});
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (state <= this.state) {
                String msg = NLSServices.getMessage("JMSCS0015");
                CSIException traceRet1 = new CSIException(msg);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.commonservices.commandmanager.Command", "setState(int)", traceRet1);
                }
                throw traceRet1;
            }
            this.state = state;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.commandmanager.Command", "setState(int)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFailed(Exception exception) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.commonservices.commandmanager.Command", "setFailed(Exception)", "setter", exception);
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state < 4) {
                this.results.put(EXCEPTION, exception);
                this.state = 4;
            }
        }
    }

    public byte[] flatten() {
        byte[] bytes;
        block4: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.commandmanager.Command", "flatten()");
            }
            bytes = null;
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(this.parameters);
                oos.writeObject(this.results);
                oos.writeInt(this.getState());
                oos.writeObject(this.uid);
                bytes = bos.toByteArray();
            }
            catch (Exception e) {
                if (!Trace.isOn) break block4;
                Trace.catchBlock(this, "com.ibm.msg.client.commonservices.commandmanager.Command", "flatten()", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.commandmanager.Command", "flatten()", bytes);
        }
        return bytes;
    }

    public void unFlatten(byte[] bytes) throws Exception {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.commandmanager.Command", "unFlatten(byte [ ])", new Object[]{bytes});
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            this.parameters = (HashMap)ois.readObject();
            this.results = (HashMap)ois.readObject();
            this.setState(ois.readInt());
            this.uid = (String)ois.readObject();
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.commonservices.commandmanager.Command", "unFlatten(byte [ ])", e);
            }
            Exception x = new Exception("Problem with Comand Object send accross network");
            x.setStackTrace(e.getStackTrace());
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.commonservices.commandmanager.Command", "unFlatten(byte [ ])", x);
            }
            throw x;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.commandmanager.Command", "unFlatten(byte [ ])");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.commandmanager.Command", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/commandmanager/Command.java, jmscc.commonservices, k701, k701-112-140304  1.19.1.1 09/08/17 08:35:38");
        }
        COMMAND = "cmd";
        EXCEPTION = "exc";
    }
}

