/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices;

import com.ibm.msg.client.commonservices.CSIException;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.util.HashMap;

public class Utils {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/Utils.java, jmscc.commonservices, k701, k701-112-140304 1.15.1.1 09/08/17 09:03:50";
    private static Utils utils;
    private HashMap objectAdapters;
    private ObjectFormatAdapter genericAdapter;

    private Utils() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.Utils", "<init>()");
        }
        this.objectAdapters = new HashMap();
        this.objectAdapters.put([B.class, new ByteArrayFormatAdapter());
        this.genericAdapter = new GenericFormatAdapter();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.Utils", "<init>()");
        }
    }

    public static StringBuffer formatObject(Object input) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Utils", "formatObject(Object)", new Object[]{input});
        }
        StringBuffer retVal = Utils.formatObject(input, -1);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Utils", "formatObject(Object)", retVal);
        }
        return retVal;
    }

    public static StringBuffer formatObject(Object input, int maxLength) {
        ObjectFormatAdapter adapter;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Utils", "formatObject(Object,int)", new Object[]{input, new Integer(maxLength)});
        }
        if ((adapter = (ObjectFormatAdapter)Utils.utils.objectAdapters.get(input.getClass())) == null) {
            adapter = Utils.utils.genericAdapter;
        }
        StringBuffer retVal = adapter.formatObject(input, maxLength);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Utils", "formatObject(Object,int)", retVal);
        }
        return retVal;
    }

    public static StringBuffer formatObjectDetailed(Object input) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Utils", "formatObjectDetailed(Object)", new Object[]{input});
        }
        StringBuffer retVal = Utils.formatObjectDetailed(input, -1);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Utils", "formatObjectDetailed(Object)", retVal);
        }
        return retVal;
    }

    public static StringBuffer formatObjectDetailed(Object input, int maxLength) {
        ObjectFormatAdapter adapter;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Utils", "formatObjectDetailed(Object,int)", new Object[]{input, new Integer(maxLength)});
        }
        if ((adapter = (ObjectFormatAdapter)Utils.utils.objectAdapters.get(input.getClass())) == null) {
            adapter = Utils.utils.genericAdapter;
        }
        StringBuffer retVal = adapter.formatObjectDetailed(input, maxLength);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Utils", "formatObjectDetailed(Object,int)", retVal);
        }
        return retVal;
    }

    public static StringBuffer bytesToHex(byte[] bArray, int maxLength) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Utils", "bytesToHex(byte [ ],int)", new Object[]{bArray, new Integer(maxLength)});
        }
        StringBuffer hex = new StringBuffer();
        if (bArray == null) {
            hex.append("<null>");
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.commonservices.Utils", "bytesToHex(byte [ ],int)", hex, 1);
            }
            return hex;
        }
        int dumpLength = bArray.length;
        if (maxLength != -1 && maxLength < dumpLength) {
            dumpLength = maxLength;
        }
        for (int i = 0; i < dumpLength; ++i) {
            int binByte = bArray[i];
            if (binByte < 0) {
                binByte += 256;
            }
            if (binByte < 16) {
                hex.append('0');
            }
            hex.append(Integer.toHexString(binByte).toUpperCase());
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Utils", "bytesToHex(byte [ ],int)", hex, 2);
        }
        return hex;
    }

    public static StringBuffer bytesToHex(byte[] bArray) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Utils", "bytesToHex(byte [ ])", new Object[]{bArray});
        }
        StringBuffer retVal = Utils.bytesToHex(bArray, -1);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Utils", "bytesToHex(byte [ ])", retVal);
        }
        return retVal;
    }

    public static byte[] hexToBytes(String hex) throws CSIException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Utils", "hexToBytes(String)", new Object[]{hex});
        }
        byte[] out = null;
        if (hex != null) {
            int len = hex.length();
            if (len % 2 != 0) {
                CSIException e = new CSIException("Invalid Hex String");
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.commonservices.Utils", "hexToBytes(String)", e, 1);
                }
                throw e;
            }
            out = new byte[len /= 2];
            for (int i = 0; i < len; ++i) {
                int digit1 = Character.digit(hex.charAt(2 * i), 16);
                int digit2 = Character.digit(hex.charAt(2 * i + 1), 16);
                if (digit1 == -1 || digit2 == -1) {
                    CSIException e2 = new CSIException("Invalid Hex String");
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.commonservices.Utils", "hexToBytes(String)", e2, 2);
                    }
                    throw e2;
                }
                out[i] = (byte)(digit1 * 16 + digit2);
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Utils", "hexToBytes(String)", out);
        }
        return out;
    }

    static boolean byteArraysEqual(byte[] a, byte[] b) {
        boolean result;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Utils", "byteArraysEqual(byte [ ],byte [ ])", new Object[]{a, b});
        }
        if (a == b) {
            result = true;
        } else if (a.length != b.length) {
            result = false;
        } else {
            result = true;
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                if (a[i] == b[i]) continue;
                result = false;
                break;
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Utils", "byteArraysEqual(byte [ ],byte [ ])", result);
        }
        return result;
    }

    protected static StringBuffer getFormattedHexBytes(byte[] toDump, int maxLength) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Utils", "getFormattedHexBytes(byte [ ],int)", new Object[]{toDump, new Integer(maxLength)});
        }
        StringBuffer buffer = new StringBuffer();
        if (maxLength == 0) {
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.commonservices.Utils", "getFormattedHexBytes(byte [ ],int)", buffer, 1);
            }
            return buffer;
        }
        int dumpLength = toDump.length;
        if (maxLength != -1 && maxLength < dumpLength) {
            dumpLength = maxLength;
        }
        for (int lineStart = 0; lineStart < dumpLength; lineStart += 16) {
            int lineEnd = Math.min(lineStart + 16, dumpLength);
            StringBuffer hex = new StringBuffer();
            StringBuffer ascii = new StringBuffer();
            for (int i = lineStart; i < lineEnd; ++i) {
                int b = toDump[i];
                b = (b + 256) % 256;
                int c1 = b / 16;
                int c2 = b % 16;
                hex.append((char)(c1 < 10 ? 48 + c1 : 97 + c1 - 10));
                hex.append((char)(c2 < 10 ? 48 + c2 : 97 + c2 - 10));
                if (i % 2 == 1) {
                    hex.append(' ');
                }
                if (b >= 32 && b <= 126) {
                    ascii.append((char)b);
                    continue;
                }
                ascii.append('.');
            }
            int pad = 16 - (lineEnd - lineStart);
            int spaces = (pad * 5 + pad % 2) / 2;
            spaces += 3;
            for (int i = 0; i < spaces; ++i) {
                hex.append(' ');
            }
            String offset = "0000" + Integer.toHexString(lineStart);
            offset = offset.substring(offset.length() - 4);
            buffer.append(offset);
            buffer.append(":  ");
            buffer.append(hex.toString());
            buffer.append(ascii.toString());
            buffer.append('\n');
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Utils", "getFormattedHexBytes(byte [ ],int)", buffer, 2);
        }
        return buffer;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.Utils", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/Utils.java, jmscc.commonservices, k701, k701-112-140304  1.15.1.1 09/08/17 09:03:50");
        }
        utils = null;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Utils", "static()");
        }
        utils = new Utils();
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Utils", "static()");
        }
    }

    class ByteArrayFormatAdapter
    extends ObjectFormatAdapter {
        ByteArrayFormatAdapter() {
        }

        StringBuffer formatObject(Object input, int maxLength) throws ClassCastException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.ByteArrayFormatAdapter", "formatObject(Object,int)", new Object[]{input, new Integer(maxLength)});
            }
            byte[] bytes = (byte[])input;
            StringBuffer output = Utils.bytesToHex(bytes, maxLength);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.commonservices.ByteArrayFormatAdapter", "formatObject(Object,int)", output);
            }
            return output;
        }

        StringBuffer formatObjectDetailed(Object input, int maxLength) throws ClassCastException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.ByteArrayFormatAdapter", "formatObjectDetailed(Object,int)", new Object[]{input, new Integer(maxLength)});
            }
            byte[] bytes = (byte[])input;
            StringBuffer output = Utils.getFormattedHexBytes(bytes, maxLength);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.commonservices.ByteArrayFormatAdapter", "formatObjectDetailed(Object,int)", output);
            }
            return output;
        }
    }

    class GenericFormatAdapter
    extends ObjectFormatAdapter {
        GenericFormatAdapter() {
        }

        StringBuffer formatObject(Object input, int maxLength) throws ClassCastException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.GenericFormatAdapter", "formatObject(Object,int)", new Object[]{input, new Integer(maxLength)});
            }
            StringBuffer output = new StringBuffer();
            if (maxLength == 0) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.commonservices.GenericFormatAdapter", "formatObject(Object,int)", output, 1);
                }
                return output;
            }
            output.append(input.toString());
            if (maxLength < 0 || output.length() <= maxLength) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.commonservices.GenericFormatAdapter", "formatObject(Object,int)", output, 2);
                }
                return output;
            }
            String fullOutput = output.toString();
            fullOutput = ((Object)fullOutput.subSequence(0, maxLength - 1)).toString();
            output = new StringBuffer(fullOutput);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.GenericFormatAdapter", "formatObject(Object,int)", output, 3);
            }
            return output;
        }
    }

    private abstract class ObjectFormatAdapter {
        private ObjectFormatAdapter() {
        }

        abstract StringBuffer formatObject(Object var1, int var2) throws ClassCastException;

        StringBuffer formatObjectDetailed(Object input, int maxLength) throws ClassCastException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.ObjectFormatAdapter", "formatObjectDetailed(Object,int)", new Object[]{input, new Integer(maxLength)});
            }
            StringBuffer traceRet1 = this.formatObject(input, maxLength);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.commonservices.ObjectFormatAdapter", "formatObjectDetailed(Object,int)", traceRet1);
            }
            return traceRet1;
        }
    }
}

