/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices;

import com.ibm.msg.client.commonservices.trace.Trace;
import java.util.HashMap;

public class ReentrantMutex {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/ReentrantMutex.java, jmscc.commonservices, k701, k701-112-140304 1.2 11/09/06 09:33:30";
    public static final int NO_WAIT = 0;
    public static final int WAIT_INDEFINITE = -1;
    private Thread owner = null;
    private int lockCount = 0;

    public synchronized boolean acquire(int timeout) {
        return this.acquire(timeout, 1);
    }

    public synchronized boolean acquire(int timeout, int depth) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.ReentrantMutex", "acquire(int, int)", new Object[]{new Integer(timeout)});
        }
        switch (timeout) {
            case -1: 
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (depth == 0) {
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.commonservices.ReentrantMutex", "acquire(int, int)", 1);
            }
            return true;
        }
        Thread currentThread = Thread.currentThread();
        if (currentThread == this.owner) {
            this.lockAcquired(currentThread, depth);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.commonservices.ReentrantMutex", "acquire(int, int)", 2);
            }
            return true;
        }
        if (this.owner == null) {
            this.lockAcquired(currentThread, depth);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.commonservices.ReentrantMutex", "acquire(int, int)", 3);
            }
            return true;
        }
        if (timeout == 0) {
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.commonservices.ReentrantMutex", "acquire(int, int)", 3);
            }
            return false;
        }
        while (true) {
            try {
                do {
                    this.wait();
                } while (this.owner != null);
                this.lockAcquired(currentThread, depth);
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.commonservices.ReentrantMutex", "acquire(int, int)", 6);
                }
                return true;
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
    }

    public String toString() {
        return this.owner == null ? "unowned" : "owned by " + this.owner + " depth " + this.lockCount;
    }

    private void lockAcquired(Thread currentThread, int depth) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.ReentrantMutex", "lockAquired(Thread, int)", new Object[]{new Integer(depth)});
        }
        this.owner = currentThread;
        this.lockCount += depth;
        if (Trace.isOn) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("Thread", currentThread);
            data.put("lockCount", new Integer(this.lockCount));
            Trace.data(this, "com.ibm.msg.client.commonservices.ReentrantMutex", "lockAquired(Thread, int)", "new lock acquired", data);
            Trace.exit(this, "com.ibm.msg.client.commonservices.ReentrantMutex", "lockAquired(Thread, int)");
        }
    }

    public synchronized void release() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.ReentrantMutex", "release()");
        }
        if (Thread.currentThread() == this.owner && this.lockCount > 0) {
            --this.lockCount;
            if (this.lockCount == 0) {
                this.owner = null;
                this.notifyAll();
            }
        }
        if (Trace.isOn) {
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            data.put("lockCount", new Integer(this.lockCount));
            Trace.data(this, "com.ibm.msg.client.commonservices.ReentrantMutex", "release()", "lock released", data);
            Trace.exit(this, "com.ibm.msg.client.commonservices.ReentrantMutex", "release()");
        }
    }

    public synchronized int fullyRelease() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.ReentrantMutex", "fullyRelease()");
        }
        int heldCount = 0;
        if (Thread.currentThread() == this.owner) {
            heldCount = this.lockCount;
            if (this.lockCount > 0) {
                this.lockCount = 0;
                this.owner = null;
                this.notifyAll();
            }
        }
        if (Trace.isOn) {
            Trace.data(this, "after fully releasing - ", (Object)this.toString());
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.ReentrantMutex", "fullyRelease()", new Integer(heldCount));
        }
        return heldCount;
    }

    public synchronized boolean isHeldByCurrentThread() {
        boolean retval;
        boolean bl = retval = this.owner == Thread.currentThread();
        if (Trace.isOn) {
            Trace.data(this, "isHeldByCurrentThread()", (Object)new Boolean(retval));
        }
        return retval;
    }

    public synchronized void forceClear() {
        this.lockCount = 0;
        this.owner = null;
        if (Trace.isOn) {
            Trace.data(this, "forceClear", (Object)this.toString());
        }
    }
}

