/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.Log;

import com.ibm.msg.client.commonservices.Log.LogFormatter;
import com.ibm.msg.client.commonservices.Log.LogHandler;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.provider.log.CSPLog;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;

public class StartupLog
implements CSPLog {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/Log/StartupLog.java, jmscc.commonservices, k701, k701-112-140304 1.12.1.1 09/08/17 07:36:11";
    public static final String LINE = "-------------------------------------------------------\n";
    private Calendar calendar;
    private Date date;
    private PrintStream outputStream = System.err;

    public StartupLog() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.Log.StartupLog", "<init>()");
        }
        this.date = new Date();
        this.calendar = new GregorianCalendar();
        this.outputStream = Trace.errorStream;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.Log.StartupLog", "<init>()");
        }
    }

    StringBuffer appendTimestamp(StringBuffer buffer, long millis) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.Log.StartupLog", "appendTimestamp(StringBuffer,long)", new Object[]{buffer, new Long(millis)});
        }
        this.date.setTime(millis);
        this.calendar.setTime(this.date);
        int day = this.calendar.get(5);
        int month = this.calendar.get(2) + 1;
        int year = this.calendar.get(1);
        int h = this.calendar.get(11);
        int m = this.calendar.get(12);
        int s = this.calendar.get(13);
        if (day < 10) {
            buffer.append("0" + day + "/");
        } else {
            buffer.append(day + "/");
        }
        if (month < 10) {
            buffer.append("0" + month + "/");
        } else {
            buffer.append(month + "/");
        }
        buffer.append(year + " ");
        if (h < 10) {
            buffer.append("0" + h + ":");
        } else {
            buffer.append(h + ":");
        }
        if (m < 10) {
            buffer.append("0" + m + ":");
        } else {
            buffer.append(m + ":");
        }
        if (s < 10) {
            buffer.append("0" + s + ":");
        } else {
            buffer.append(s + " ");
        }
        buffer.append("[" + millis + "] ");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.Log.StartupLog", "appendTimestamp(StringBuffer,long)", buffer);
        }
        return buffer;
    }

    public void close() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.Log.StartupLog", "close()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.Log.StartupLog", "close()");
        }
    }

    private StringBuffer getBaseMessage(Object parentClass) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.Log.StartupLog", "getBaseMessage(Object)", new Object[]{parentClass});
        }
        StringBuffer output = new StringBuffer();
        this.appendTimestamp(output, System.currentTimeMillis());
        String className = null;
        if (parentClass instanceof String) {
            className = (String)parentClass;
        } else if (parentClass != null) {
            className = parentClass.getClass().getName();
        }
        output.append('[' + Thread.currentThread().getName() + "] ");
        output.append(className);
        output.append(' ');
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.Log.StartupLog", "getBaseMessage(Object)", output);
        }
        return output;
    }

    public void initialize() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.Log.StartupLog", "initialize()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.Log.StartupLog", "initialize()");
        }
    }

    public void log(Object parentClass, String parentClassName, String methodSignature, String key, HashMap inserts) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.Log.StartupLog", "log(Object,String,String,String,HashMap)", new Object[]{parentClass, parentClassName, methodSignature, key, inserts});
        }
        StringBuffer output = this.getBaseMessage(parentClass == null ? parentClassName : parentClass);
        String message = NLSServices.getMessage(key, inserts);
        String explanation = NLSServices.getExplanation(key, inserts);
        String action = NLSServices.getUserAction(key, inserts);
        output.append('\n');
        output.append(message);
        output.append('\n');
        output.append(NLSServices.getMessage("JMSCS0007"));
        output.append(explanation);
        output.append('\n');
        output.append(NLSServices.getMessage("JMSCS0008"));
        output.append(action);
        output.append('\n');
        output.append(LINE);
        this.outputStream.println(output);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.Log.StartupLog", "log(Object,String,String,String,HashMap)");
        }
    }

    public void logNLS(Object parentClass, String parentClassName, String methodSignature, String NLSMessage) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.Log.StartupLog", "logNLS(Object,String,String,String)", new Object[]{parentClass, parentClassName, methodSignature, NLSMessage});
        }
        StringBuffer output = this.getBaseMessage(parentClass == null ? parentClassName : parentClass);
        output.append('\n');
        output.append(NLSMessage);
        output.append('\n');
        output.append(LINE);
        this.outputStream.println(output);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.Log.StartupLog", "logNLS(Object,String,String,String)");
        }
    }

    public void setLogFormatter(LogFormatter newFormatter) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.commonservices.Log.StartupLog", "setLogFormatter(LogFormatter)", "setter", newFormatter);
        }
        newFormatter.getClass();
    }

    public void setLogHandler(LogHandler newHandler) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.commonservices.Log.StartupLog", "setLogHandler(LogHandler)", "setter", newHandler);
        }
        newHandler.getClass();
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.Log.StartupLog", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/Log/StartupLog.java, jmscc.commonservices, k701, k701-112-140304  1.12.1.1 09/08/17 07:36:11");
        }
    }
}

