/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.Log;

import com.ibm.msg.client.commonservices.CSIException;
import com.ibm.msg.client.commonservices.CSIListener;
import com.ibm.msg.client.commonservices.CommonServices;
import com.ibm.msg.client.commonservices.Log.NullLog;
import com.ibm.msg.client.commonservices.Log.StartupLog;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.provider.log.CSPLog;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

public final class Log {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/Log/Log.java, jmscc.commonservices, k701, k701-112-140304 1.17.1.4 12/03/22 15:07:06";
    public static final String logStatusProperty = "com.ibm.msg.client.commonservices.log.status";
    public static final String logStatusProperty_ON = "ON";
    public static final String logStatusProperty_OFF = "OFF";
    public static final String logStatusProperty_default = "ON";
    public static final String startupLogProperty = "com.ibm.msg.client.commonservices.Log.startup";
    public static boolean isOn;
    private static CSPLog currentLogger;
    private static CSPLog functionalLogger;
    private static NullLog nullLogger;
    private static StartupLog startupLogger;
    private static Hashtable currentlylogging;
    static boolean startuplogging;
    protected static boolean initialized;
    protected static boolean listening;
    private static String lineSeparatorProperty;
    private static String lineSeparator;
    private static int titleSize;
    private static LogHandler LogHandler;
    private static Object LogLock;

    private Log() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.Log.Log", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.Log.Log", "<init>()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOn(boolean LogOn) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Log.Log", "setOn(boolean)", new Object[]{LogOn});
        }
        Object object = LogLock = new Object();
        synchronized (object) {
            if (isOn != LogOn) {
                isOn = LogOn;
                if (LogOn) {
                    currentLogger = functionalLogger;
                    currentLogger.initialize();
                } else {
                    currentLogger = nullLogger;
                }
                if (null != LogHandler) {
                    LogHandler.setOn(isOn);
                }
            } else if (LogOn && currentLogger != functionalLogger) {
                isOn = false;
                currentLogger = functionalLogger;
                currentLogger.initialize();
                isOn = LogOn;
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "setOn(boolean)");
        }
    }

    public static void registerLogHandler(LogHandler handler) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Log.Log", "registerLogHandler(LogHandler)", new Object[]{handler});
        }
        LogHandler = handler;
        handler.setOn(isOn);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "registerLogHandler(LogHandler)");
        }
    }

    public static void setCSPLog(CSPLog newLogr) {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.Log.Log", "setCSPLog(CSPLog)", "setter", (Object)newLogr);
        }
        functionalLogger = null == newLogr ? nullLogger : newLogr;
        Log.setOn(isOn);
    }

    public static CSPLog getCSPLog() {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Log.Log", "getCSPLog()");
        }
        if (null == functionalLogger || functionalLogger instanceof NullLog) {
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "getCSPLog()", (Object)null, 1);
            }
            return null;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "getCSPLog()", functionalLogger, 2);
        }
        return functionalLogger;
    }

    private static boolean logable() {
        Thread currentThread;
        Boolean alreadylogging;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Log.Log", "logable()");
        }
        if (null == (alreadylogging = (Boolean)currentlylogging.get(currentThread = Thread.currentThread())) || !alreadylogging.booleanValue()) {
            currentlylogging.put(currentThread, new Boolean(true));
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "logable()", true, 1);
            }
            return true;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "logable()", false, 2);
        }
        return false;
    }

    private static void endLogging() {
        Thread currentThread;
        Boolean alreadylogging;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Log.Log", "endLogging()");
        }
        if (null == (alreadylogging = (Boolean)currentlylogging.get(currentThread = Thread.currentThread())) || !alreadylogging.booleanValue()) {
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "endLogging()", 1);
            }
            return;
        }
        currentlylogging.remove(currentThread);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "endLogging()", 2);
        }
    }

    public static void log(Object parentClass, String parentClassName, String methodSignature, String key, HashMap inserts) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Log.Log", "log(Object,String,String,String,HashMap)", new Object[]{parentClass, parentClassName, methodSignature, key, inserts});
        }
        Log.logInternal(parentClass, parentClassName, methodSignature, key, inserts);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "log(Object,String,String,String,HashMap)");
        }
    }

    public static void log(Object parentClass, String methodSignature, String key, HashMap inserts) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Log.Log", "log(Object,String,String,HashMap)", new Object[]{parentClass, methodSignature, key, inserts});
        }
        Log.logInternal(parentClass, null, methodSignature, key, inserts);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "log(Object,String,String,HashMap)");
        }
    }

    public static void log(String parentClassName, String methodSignature, String key, HashMap inserts) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Log.Log", "log(String,String,String,HashMap)", new Object[]{parentClassName, methodSignature, key, inserts});
        }
        Log.logInternal(null, parentClassName, methodSignature, key, inserts);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "log(String,String,String,HashMap)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logInternal(Object parentClass, String parentClassName, String methodSignature, String key, HashMap inserts) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Log.Log", "logInternal(Object,String,String,String,HashMap)", new Object[]{parentClass, parentClassName, methodSignature, key, inserts});
        }
        if (isOn && Log.logable()) {
            if (inserts != null) {
                Iterator iterator = inserts.keySet().iterator();
                while (iterator.hasNext()) {
                    Object itemKey = iterator.next();
                    Object itemValue = inserts.get(itemKey);
                    if (!(itemValue instanceof Exception)) continue;
                    String msg = Log.flattenExceptionToString((Exception)itemValue);
                    inserts.put(itemKey, msg);
                }
            }
            try {
                currentLogger.log(parentClass, parentClassName, methodSignature, key, inserts);
            }
            catch (Throwable t) {
                block16: {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.commonservices.Log.Log", "logInternal(Object,String,String,String,HashMap)", t, 1);
                    }
                    try {
                        System.err.println("Failed to write to log file. Attempting StartupLogger");
                        startupLogger.log(parentClass, parentClassName, methodSignature, key, inserts);
                    }
                    catch (Throwable t1) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.msg.client.commonservices.Log.Log", "logInternal(Object,String,String,String,HashMap)", t1, 2);
                        }
                        System.err.println("Failed to use StartupLogger. Writing directly");
                        System.err.println(t1.getMessage());
                        t1.printStackTrace();
                        System.err.println();
                        System.err.println(t.getMessage());
                        t.printStackTrace();
                        System.err.println();
                        System.err.println(parentClassName + ": " + methodSignature);
                        System.err.println(key);
                        if (inserts == null) break block16;
                        System.err.println(inserts.toString());
                    }
                }
                Log.endLogging();
                HashMap<String, Throwable> data = new HashMap<String, Throwable>();
                data.put("exception", t);
                Trace.ffst("com.ibm.msg.client.commonservices.Log.Log", "LogDataInternal(Object, String, String, String, HashMap)", "XC006001", data, null);
            }
            finally {
                if (Trace.isOn) {
                    Trace.finallyBlock("com.ibm.msg.client.commonservices.Log.Log", "logInternal(Object,String,String,String,HashMap)");
                }
                Log.endLogging();
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "logInternal(Object,String,String,String,HashMap)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logNLSInternal(Object parentClass, String parentClassName, String methodSignature, String NLSMessage) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Log.Log", "logNLSInternal(Object,String,String,String)", new Object[]{parentClass, parentClassName, methodSignature, NLSMessage});
        }
        if (isOn && Log.logable()) {
            try {
                currentLogger.logNLS(parentClass, parentClassName, methodSignature, NLSMessage);
            }
            catch (Throwable t) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.msg.client.commonservices.Log.Log", "logNLSInternal(Object,String,String,String)", t);
                }
                Log.endLogging();
                HashMap<String, Throwable> data = new HashMap<String, Throwable>();
                data.put("exception", t);
                Trace.ffst("com.ibm.msg.client.commonservices.Log.Log", "LogNLSInternal(Object, String, String, String)", "XC006002", data, null);
            }
            finally {
                if (Trace.isOn) {
                    Trace.finallyBlock("com.ibm.msg.client.commonservices.Log.Log", "logNLSInternal(Object,String,String,String)");
                }
                Log.endLogging();
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "logNLSInternal(Object,String,String,String)");
        }
    }

    public static void initialize() throws CSIException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Log.Log", "initialize()");
        }
        if (!initialized) {
            try {
                functionalLogger = CommonServices.getLog();
                initialized = true;
                PropertyStore.register(logStatusProperty, "ON");
                String LogOn = PropertyStore.getStringProperty(logStatusProperty);
                if (null != LogOn && LogOn.equalsIgnoreCase("ON")) {
                    Log.setOn(true);
                } else {
                    Log.setOn(false);
                }
            }
            catch (CSIException csie) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.msg.client.commonservices.Log.Log", "initialize()", csie);
                }
                if (!listening) {
                    functionalLogger = startuplogging ? startupLogger : new NullLog();
                    CSIListener listener = new CSIListener(){

                        public void onCSIInitialize() {
                            if (Trace.isOn) {
                                Trace.entry(this, "com.ibm.msg.client.commonservices.Log.Log", "onCSIInitialize()");
                            }
                            try {
                                Log.initialize();
                                listening = false;
                                CommonServices.removeCSIListener(this);
                                PropertyStore.register("com.ibm.msg.client.commonservices.Log.status", Log.logStatusProperty_OFF);
                                String LogOn = PropertyStore.getStringProperty("com.ibm.msg.client.commonservices.Log.status");
                                if (null != LogOn && LogOn.equalsIgnoreCase("ON")) {
                                    Log.setOn(true);
                                } else {
                                    Log.setOn(false);
                                }
                            }
                            catch (CSIException csie2) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.commonservices.Log.null", "onCSIInitialize()", csie2);
                                }
                                HashMap<String, CSIException> hash = new HashMap<String, CSIException>();
                                hash.put("Exception", csie2);
                                Trace.ffst(this, "onCSIInitialize", "Failed to initialize CSI from Log listener", hash, null);
                            }
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.commonservices.Log.null", "onCSIInitialize()");
                            }
                        }
                    };
                    CommonServices.addCSIListener(listener);
                    listening = true;
                }
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.commonservices.Log.Log", "initialize()", csie);
                }
                throw csie;
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "initialize()");
        }
    }

    public static void logNLS(Object parentClass, String methodSignature, String NLSMessage) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Log.Log", "logNLS(Object,String,String)", new Object[]{parentClass, methodSignature, NLSMessage});
        }
        Log.logNLSInternal(parentClass, null, methodSignature, NLSMessage);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "logNLS(Object,String,String)");
        }
    }

    public static void logNLS(Object parentClass, String parentClassName, String methodSignature, String NLSMessage) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Log.Log", "logNLS(Object,String,String,String)", new Object[]{parentClass, parentClassName, methodSignature, NLSMessage});
        }
        Log.logNLSInternal(parentClass, parentClassName, methodSignature, NLSMessage);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "logNLS(Object,String,String,String)");
        }
    }

    public static void logNLS(String parentClassName, String methodSignature, String NLSMessage) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Log.Log", "logNLS(String,String,String)", new Object[]{parentClassName, methodSignature, NLSMessage});
        }
        Log.logNLSInternal(null, parentClassName, methodSignature, NLSMessage);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "logNLS(String,String,String)");
        }
    }

    private static String flattenExceptionToString(Exception e) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Log.Log", "flattenExceptionToString(Exception)", new Object[]{e});
        }
        int depth = 0;
        Throwable currentEx = e;
        StringBuffer sb = new StringBuffer();
        boolean returnedByGetLinkedException = false;
        while (currentEx != null) {
            if (depth == 0) {
                sb.append(lineSeparator);
                sb.append(Log.padTitle(NLSServices.getMessage("JMSCS0011")));
            } else if (returnedByGetLinkedException) {
                sb.append(Log.padTitle(NLSServices.getMessage("JMSCS0017", Integer.toString(depth))));
                returnedByGetLinkedException = false;
            } else {
                sb.append(Log.padTitle(NLSServices.getMessage("JMSCS0014", Integer.toString(depth))));
            }
            sb.append(currentEx.toString());
            sb.append(lineSeparator);
            sb.append(Log.padTitle(NLSServices.getMessage("JMSCS0012")));
            sb.append(currentEx.getClass());
            sb.append(lineSeparator);
            Log.dumpStackTrace(currentEx, sb);
            Throwable nextEx = currentEx.getCause();
            if (nextEx == null) {
                try {
                    Method getLinkedExceptionMethod = currentEx.getClass().getMethod("getLinkedException", null);
                    currentEx = (Throwable)getLinkedExceptionMethod.invoke((Object)currentEx, (Object[])null);
                    returnedByGetLinkedException = true;
                }
                catch (NoSuchMethodException e1) {
                    if (Trace.isOn) {
                        Trace.data("com.ibm.msg.client.commonservices.Log.Log", "flattenExceptionToString()", "NoSuchMethodException caught during reflection of getLinkedException()", null);
                    }
                    currentEx = null;
                }
                catch (SecurityException e1) {
                    if (Trace.isOn) {
                        Trace.data("com.ibm.msg.client.commonservices.Log.Log", "flattenExceptionToString()", "SecurityException caught during reflection of getLinkedException()", (Object)e1);
                    }
                    currentEx = null;
                }
                catch (IllegalArgumentException e1) {
                    if (Trace.isOn) {
                        Trace.data("com.ibm.msg.client.commonservices.Log.Log", "flattenExceptionToString()", "IllegalArgumentException caught during reflection of getLinkedException()", (Object)e1);
                    }
                    currentEx = null;
                }
                catch (IllegalAccessException e1) {
                    if (Trace.isOn) {
                        Trace.data("com.ibm.msg.client.commonservices.Log.Log", "flattenExceptionToString()", "IllegalAccessException caught during reflection of getLinkedException()", (Object)e1);
                    }
                    currentEx = null;
                }
                catch (InvocationTargetException e1) {
                    if (Trace.isOn) {
                        Trace.data("com.ibm.msg.client.commonservices.Log.Log", "flattenExceptionToString()", "InvocationTargetException caught during reflection of getLinkedException()", (Object)e1);
                    }
                    currentEx = null;
                }
                catch (ClassCastException e1) {
                    if (Trace.isOn) {
                        Trace.data("com.ibm.msg.client.commonservices.Log.Log", "flattenExceptionToString()", "ClassCastException caught during reflection of getLinkedException()", (Object)e1);
                    }
                    currentEx = null;
                }
                catch (Throwable e1) {
                    if (Trace.isOn) {
                        Trace.data("com.ibm.msg.client.commonservices.Log.Log", "flattenExceptionToString()", "Throwable caught during reflection of getLinkedException()", (Object)e1);
                    }
                    currentEx = null;
                }
            } else {
                currentEx = nextEx;
            }
            ++depth;
        }
        String traceRet1 = sb.toString();
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "flattenExceptionToString(Exception)", (Object)traceRet1);
        }
        return traceRet1;
    }

    private static String padTitle(String text) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Log.Log", "padTitle(String)", new Object[]{text});
        }
        StringBuffer buffer = new StringBuffer(titleSize);
        int textLength = text.trim().length();
        int padding = titleSize - textLength;
        for (int count = 0; count < padding; ++count) {
            buffer.append(" ");
        }
        buffer.append(text.trim()).append(" : ");
        String traceRet1 = buffer.toString();
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "padTitle(String)", (Object)traceRet1);
        }
        return traceRet1;
    }

    private static void dumpStackTrace(Throwable e, StringBuffer sb) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.Log.Log", "dumpStackTrace(final Throwable,StringBuffer)", new Object[]{e, sb});
        }
        StackTraceElement[] stack = e.getStackTrace();
        for (int count = 0; count < stack.length; ++count) {
            String prefix = count == 0 ? NLSServices.getMessage("JMSCS0013") : "";
            String className = stack[count].getClassName();
            String methodName = stack[count].getMethodName();
            String fileName = stack[count].getFileName();
            int line = stack[count].getLineNumber();
            sb.append(Log.padTitle(prefix));
            sb.append(className);
            sb.append(".");
            sb.append(methodName);
            sb.append("(");
            sb.append(fileName);
            sb.append(":");
            sb.append(line);
            sb.append(")");
            sb.append(lineSeparator);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "dumpStackTrace(final Throwable,StringBuffer)");
        }
    }

    static {
        block5: {
            if (Trace.isOn) {
                Trace.data("com.ibm.msg.client.commonservices.Log.Log", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/Log/Log.java, jmscc.commonservices, k701, k701-112-140304  1.17.1.4 12/03/22 15:07:06");
            }
            isOn = false;
            currentLogger = null;
            functionalLogger = null;
            nullLogger = null;
            startupLogger = null;
            currentlylogging = null;
            startuplogging = false;
            initialized = false;
            listening = false;
            lineSeparatorProperty = "line.separator";
            lineSeparator = null;
            titleSize = 30;
            LogHandler = null;
            if (Trace.isOn) {
                Trace.entry("com.ibm.msg.client.commonservices.Log.Log", "static()");
            }
            nullLogger = new NullLog();
            startupLogger = new StartupLog();
            functionalLogger = nullLogger;
            currentLogger = nullLogger;
            currentlylogging = new Hashtable();
            PropertyStore.register(lineSeparatorProperty, "\n");
            lineSeparator = PropertyStore.getStringProperty(lineSeparatorProperty);
            try {
                Log.initialize();
            }
            catch (CSIException csie) {
                if (!Trace.isOn) break block5;
                Trace.catchBlock("com.ibm.msg.client.commonservices.Log.Log", "static()", csie);
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.Log.Log", "static()");
        }
        LogLock = new Object();
    }

    public static interface LogHandler {
        public void setOn(boolean var1);
    }
}

