/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices;

import com.ibm.msg.client.commonservices.CSIException;
import com.ibm.msg.client.commonservices.CSIListener;
import com.ibm.msg.client.commonservices.componentmanager.Component;
import com.ibm.msg.client.commonservices.componentmanager.ComponentListener;
import com.ibm.msg.client.commonservices.componentmanager.ComponentManager;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.provider.CSPCommonServices;
import com.ibm.msg.client.commonservices.provider.commandmanager.CSPCommandManager;
import com.ibm.msg.client.commonservices.provider.log.CSPLog;
import com.ibm.msg.client.commonservices.provider.nls.CSPNLSServices;
import com.ibm.msg.client.commonservices.provider.propertystore.CSPPropertyStore;
import com.ibm.msg.client.commonservices.provider.trace.CSPTrace;
import com.ibm.msg.client.commonservices.provider.workqueue.CSPWorkQueueManager;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public final class CommonServices {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/CommonServices.java, jmscc.commonservices, k701, k701-112-140304 1.45.1.3 11/03/24 13:12:46";
    private static CSPCommonServices implementation;
    private static Vector listeners;
    public static final String TRACE_FILENAME = "TraceFilename";
    public static final String FDC_FILENAME = "FDCFilename";
    public static final String FDC_TITLE = "FDCTitle";
    public static final String PRODUCT_NAME = "ProductName";
    private static CSPCommandManager commandManagerImplementation;
    private static CSPLog logImplementation;
    private static CSPNLSServices nlsServicesImplementation;
    private static CSPPropertyStore propertyStoreImplementation;
    private static CSPTrace traceImplementation;
    private static CSPWorkQueueManager workQueueManagerImplementation;
    public static final int commandManagerModule = 1;
    public static final int logModule = 2;
    public static final int nlsServicesModule = 3;
    public static final int propertyStoreModule = 4;
    public static final int traceModule = 5;
    public static final int workQueueManagerModule = 6;
    private static final String PRODUCTIZATION_PROPS = "META-INF/product.properties";
    private static Properties productization;

    private CommonServices() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.CommonServices", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.CommonServices", "<init>()");
        }
    }

    public static boolean isInitialized() {
        return implementation != null;
    }

    public static boolean isModuleInitialized(int module) throws CSIException {
        switch (module) {
            case 1: {
                return commandManagerImplementation != null;
            }
            case 2: {
                return logImplementation != null;
            }
            case 3: {
                return nlsServicesImplementation != null;
            }
            case 4: {
                return propertyStoreImplementation != null;
            }
            case 5: {
                return traceImplementation != null;
            }
            case 6: {
                return workQueueManagerImplementation != null;
            }
        }
        String msg = NLSServices.getMessage("JMSCS0002");
        CSIException thrown = new CSIException(msg);
        if (Trace.isOn) {
            Trace.throwing("com.ibm.msg.client.commonservices.CommonServices", "getTrace()", thrown);
        }
        throw thrown;
    }

    public static synchronized CSPTrace getTrace() throws CSIException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.CommonServices", "getTrace()");
        }
        if (implementation == null) {
            String msg = NLSServices.getMessage("JMSCS0002");
            CSIException thrown = new CSIException(msg);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.commonservices.CommonServices", "getTrace()", thrown);
            }
            throw thrown;
        }
        if (traceImplementation == null) {
            traceImplementation = implementation.getTrace();
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.CommonServices", "getTrace()", traceImplementation);
        }
        return traceImplementation;
    }

    public static synchronized CSPLog getLog() throws CSIException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.CommonServices", "getLog()");
        }
        if (implementation == null) {
            String msg = NLSServices.getMessage("JMSCS0002");
            CSIException thrown = new CSIException(msg);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.commonservices.CommonServices", "getLog()", thrown);
            }
            throw thrown;
        }
        if (logImplementation == null) {
            logImplementation = implementation.getLog();
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.CommonServices", "getLog()", logImplementation);
        }
        return logImplementation;
    }

    public static synchronized CSPWorkQueueManager getWorkQueueManager() throws CSIException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.CommonServices", "getWorkQueueManager()");
        }
        if (implementation == null) {
            String msg = NLSServices.getMessage("JMSCS0002");
            CSIException thrown = new CSIException(msg);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.commonservices.CommonServices", "getWorkQueueManager()", thrown);
            }
            throw thrown;
        }
        if (workQueueManagerImplementation == null) {
            workQueueManagerImplementation = implementation.getWorkQueueManager();
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.CommonServices", "getWorkQueueManager()", workQueueManagerImplementation);
        }
        return workQueueManagerImplementation;
    }

    public static synchronized CSPNLSServices getNLSServices() throws CSIException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.CommonServices", "getNLSServices()");
        }
        if (implementation == null) {
            String msg = "Unable to locate NLS services at this stage of initialization; PI commonservices will now be used";
            CSIException thrown = new CSIException(msg);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.commonservices.CommonServices", "getNLSServices()", thrown);
            }
            throw thrown;
        }
        if (nlsServicesImplementation == null) {
            nlsServicesImplementation = implementation.getNLSServices();
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.CommonServices", "getNLSServices()", nlsServicesImplementation);
        }
        return nlsServicesImplementation;
    }

    public static synchronized CSPCommandManager getCommandManager() throws CSIException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.CommonServices", "getCommandManager()");
        }
        if (implementation == null) {
            String msg = NLSServices.getMessage("JMSCS0002");
            CSIException thrown = new CSIException(msg);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.commonservices.CommonServices", "getCommandManager()", thrown);
            }
            throw thrown;
        }
        if (commandManagerImplementation == null) {
            commandManagerImplementation = implementation.getCommandManager();
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.CommonServices", "getCommandManager()", commandManagerImplementation);
        }
        return commandManagerImplementation;
    }

    public static synchronized CSPPropertyStore getPropertyStore() throws CSIException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.CommonServices", "getPropertyStore()");
        }
        if (implementation == null) {
            String msg = NLSServices.getMessage("JMSCS0002");
            CSIException thrown = new CSIException(msg);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.commonservices.CommonServices", "getPropertyStore()", thrown);
            }
            throw thrown;
        }
        if (propertyStoreImplementation == null) {
            propertyStoreImplementation = implementation.getPropertyStore();
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.CommonServices", "getCommandManager()", propertyStoreImplementation);
        }
        return propertyStoreImplementation;
    }

    private static boolean loadProperties(Enumeration resources) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.CommonServices", "loadProperties(Enumeration)", new Object[]{resources});
        }
        boolean success = false;
        while (resources.hasMoreElements() && !success) {
            URL url = (URL)resources.nextElement();
            try {
                productization.load(url.openStream());
                if (Trace.isOn) {
                    Trace.data("com.ibm.msg.client.commonservices.CommonServices", "loadProperites()", "Productization Properites loaded from ", (Object)url);
                }
                success = true;
            }
            catch (IOException e) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.msg.client.commonservices.CommonServices", "loadProperties(Enumeration)", e);
                }
                if (!Trace.isOn) continue;
                Trace.data("com.ibm.msg.client.commonservices.CommonServices", "loadProperites()", "Unable to load properties ", (Object)e.getMessage());
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.CommonServices", "loadProperties(Enumeration)", success);
        }
        return success;
    }

    public static Properties getProductization() {
        block7: {
            if (Trace.isOn) {
                Trace.entry("com.ibm.msg.client.commonservices.CommonServices", "getProductization()");
            }
            if (productization == null) {
                productization = new Properties();
                productization.put(FDC_FILENAME, "JMSCC%COUNT%.FDC");
                productization.put(FDC_TITLE, "JMS Common Client First Failure Symptom Report");
                productization.put(PRODUCT_NAME, "IBM WebSphere MQ classes for JMS");
                productization.put(TRACE_FILENAME, "mqjms_%PID%.trc");
                try {
                    ClassLoader thisClassesLoader;
                    Enumeration<URL> resources = ClassLoader.getSystemResources(PRODUCTIZATION_PROPS);
                    if (!CommonServices.loadProperties(resources) && !CommonServices.loadProperties(resources = (thisClassesLoader = CommonServices.class.getClassLoader()).getResources(PRODUCTIZATION_PROPS))) {
                        ClassLoader threadContextClassloader = Thread.currentThread().getContextClassLoader();
                        resources = threadContextClassloader.getResources(PRODUCTIZATION_PROPS);
                        CommonServices.loadProperties(resources);
                    }
                }
                catch (IOException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.commonservices.CommonServices", "getProductization()", e);
                    }
                    if (!Trace.isOn) break block7;
                    Trace.data("com.ibm.msg.client.commonservices.CommonServices", "getProductization()", "Unable to load properties ", (Object)e.getMessage());
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.CommonServices", "getProductization()", productization);
        }
        return productization;
    }

    public static void addCSIListener(CSIListener newListener) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.CommonServices", "addCSIListener(CSIListener)", new Object[]{newListener});
        }
        CommonServices.getListeners().add(newListener);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.CommonServices", "addCSIListener(CSIListener)");
        }
    }

    public static void removeCSIListener(CSIListener listener) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.CommonServices", "removeCSIListener(CSIListener)", new Object[]{listener});
        }
        CommonServices.getListeners().remove(listener);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.CommonServices", "removeCSIListener(CSIListener)");
        }
    }

    public static void notifyListeners() {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.CommonServices", "notifyListeners()");
        }
        if (CommonServices.getListeners() != null) {
            Vector clonedListeners = (Vector)listeners.clone();
            Iterator listenersIterator = clonedListeners.iterator();
            while (listenersIterator.hasNext()) {
                CSIListener listener = (CSIListener)listenersIterator.next();
                try {
                    if (Trace.isOn) {
                        Trace.traceData("CommonServices", "notifyListeners", "notifying listener", (Object)listener);
                    }
                    listener.onCSIInitialize();
                }
                catch (Throwable t) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.commonservices.CommonServices", "notifyListeners()", t);
                    }
                    if (!Trace.isOn) continue;
                    Trace.traceData("CommonServices", "notifyListeners", "Throwable thrown from CSIListener. Caught and swallowed", (Object)t);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.CommonServices", "notifyListeners()");
        }
    }

    private static synchronized Vector getListeners() {
        if (listeners == null) {
            listeners = new Vector();
        }
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.CommonServices", "getListeners()", "getter", (Object)listeners);
        }
        return listeners;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.CommonServices", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/CommonServices.java, jmscc.commonservices, k701, k701-112-140304  1.45.1.3 11/03/24 13:12:46");
        }
        implementation = null;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.CommonServices", "static()");
        }
        ComponentManager compMgr = ComponentManager.getInstance();
        try {
            Component component = compMgr.getComponent("CSI", null);
            implementation = (CSPCommonServices)component.getFactoryInstance();
            PropertyStore.initialize();
            Trace.initialize();
        }
        catch (Exception e1) {
            if (Trace.isOn) {
                Trace.data("com.ibm.msg.client.commonservices.CommonServices", "static()", "Caught expected exception", (Object)e1);
            }
            CSIInitializeListener listener = new CommonServices().new CSIInitializeListener();
            compMgr.addComponentListener("CSI", listener);
        }
        CommonServices.notifyListeners();
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.CommonServices", "static()");
        }
        productization = null;
    }

    class CSIInitializeListener
    implements ComponentListener {
        CSIInitializeListener() {
        }

        public void componentRegistered(Component component) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.CSIInitializeListener", "componentRegistered(Component)", new Object[]{component});
            }
            if (component.getType().equals("CSI")) {
                implementation = (CSPCommonServices)component.getFactoryInstance();
                CommonServices.notifyListeners();
                ComponentManager compMgr = ComponentManager.getInstance();
                compMgr.removeComponentListener("CSI", this);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.CSIInitializeListener", "componentRegistered(Component)");
            }
        }

        public void componentUnregistered(Component component) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.CSIInitializeListener", "componentUnregistered(Component)", new Object[]{component});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.CSIInitializeListener", "componentUnregistered(Component)");
            }
        }
    }
}

