/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.admin;

import com.ibm.mq.jms.admin.AP;
import com.ibm.mq.jms.admin.AdminObject;
import com.ibm.mq.jms.admin.AdminService;
import com.ibm.mq.jms.admin.BAO;
import com.ibm.mq.jms.admin.ConfigEnvironment;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;

public class JMSAdmin {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.mq.jms.admin/src/com/ibm/mq/jms/admin/JMSAdmin.java, jmscc.admin, k701, k701-112-140304  1.28.1.7 11/03/22 11:03:48";
    private static final String DEF_CONFIG_FILENAME = "JMSAdmin.config";
    private static final String CLASSNAME = "com.ibm.mq.jms.admin.JMSAdmin";
    private static final int VERB_NON = -1;
    private static final int VERB_END = 0;
    private static final int VERB_DEF = 1;
    private static final int VERB_CHG = 2;
    private static final int VERB_DIS = 3;
    private static final int VERB_DEL = 4;
    private static final int VERB_COP = 5;
    private static final int VERB_MOV = 6;
    private static final int VERB_ALT = 7;
    private static JMSAdmin program;
    private AdminService service;
    private boolean verbose;
    private String cfgFilename;
    private String icf;
    private String purl;
    private String auth;
    private String userdn;
    private String userpw;
    protected static PrintWriter pw;
    private BufferedReader in;
    private Properties config;
    private String wildCardCharacter;

    protected JMSAdmin(boolean verbosity, Properties cfg, AdminService svc, PrintWriter pw) {
        this.service = null;
        this.verbose = false;
        this.cfgFilename = DEF_CONFIG_FILENAME;
        this.icf = null;
        this.purl = null;
        this.auth = "none";
        this.userdn = null;
        this.userpw = null;
        this.in = new BufferedReader(new InputStreamReader(System.in));
        this.wildCardCharacter = "*";
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "<init>(boolean,Properties,AdminService,PrintWriter)", new Object[]{verbosity, cfg, svc, pw});
        }
        this.verbose = verbosity;
        this.cfgFilename = "UNDEFINED";
        if (pw == null) {
            JMSAdmin.initializePW();
        } else {
            JMSAdmin.pw = pw;
        }
        if (cfg != null) {
            this.setConfigVariables(cfg);
        }
        if (svc != null) {
            this.service = svc;
        }
        this.checkServiceActive(this.service);
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "<init>(boolean,Properties,AdminService,PrintWriter)");
        }
    }

    private void checkServiceActive(AdminService as) {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "checkServiceActive(AdminService)", new Object[]{as});
        }
        if (as == null || !as.isActive()) {
            pw.println(ConfigEnvironment.getMessage("JMSADM4110"));
            pw.flush();
            System.exit(-1);
        } else if (this.verbose) {
            pw.println(ConfigEnvironment.getMessage("JMSADM4003"));
            pw.flush();
        }
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "checkServiceActive(AdminService)");
        }
    }

    private JMSAdmin(boolean verbosity, String cfgfn) {
        block17: {
            this.service = null;
            this.verbose = false;
            this.cfgFilename = DEF_CONFIG_FILENAME;
            this.icf = null;
            this.purl = null;
            this.auth = "none";
            this.userdn = null;
            this.userpw = null;
            this.in = new BufferedReader(new InputStreamReader(System.in));
            this.wildCardCharacter = "*";
            if (Trace.isOn) {
                Trace.entry(this, CLASSNAME, "<init>(boolean,String)", new Object[]{verbosity, cfgfn});
            }
            this.verbose = verbosity;
            this.cfgFilename = cfgfn;
            if (pw == null) {
                JMSAdmin.initializePW();
            }
            this.loadConfig(this.cfgFilename);
            try {
                this.service = new AdminService(this.icf, this.purl, this.auth, this.config);
            }
            catch (JMSSecurityException jmse) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, CLASSNAME, "<init>(boolean,String)", jmse, 1);
                }
                pw.println((Object)jmse);
                pw.flush();
            }
            pw.println();
            pw.println(ConfigEnvironment.getMessage("JMSADM1003"));
            pw.println(ConfigEnvironment.getMessage("JMSADM4000"));
            pw.println();
            pw.flush();
            try {
                if (this.verbose) {
                    pw.println(ConfigEnvironment.getMessage("JMSADM4002"));
                    pw.println("   " + ConfigEnvironment.getMessage("JMSADM4094") + ": " + this.service.getICF());
                    pw.println("   " + ConfigEnvironment.getMessage("JMSADM4095") + ": " + this.service.getPURL());
                    pw.flush();
                }
                if (this.service.needsAuthorization()) {
                    if (this.userdn == null) {
                        pw.print(ConfigEnvironment.getMessage("JMSADM4134") + ": ");
                        pw.flush();
                        this.userdn = this.in.readLine();
                    }
                    if (this.userpw == null) {
                        pw.print(ConfigEnvironment.getMessage("JMSADM4135") + ": ");
                        pw.flush();
                        this.userpw = this.in.readLine();
                    }
                    pw.println("");
                    pw.flush();
                }
                this.service.initJNDI(this.userdn, this.userpw);
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, CLASSNAME, "<init>(boolean,String)", e, 2);
                }
                if (this.verbose) {
                    pw.println(ConfigEnvironment.getMessage("JMSADM4008") + ": " + e);
                    pw.flush();
                }
                System.exit(-1);
            }
            this.checkServiceActive(this.service);
            this.commandLoop();
            try {
                this.service.stopJNDI();
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, CLASSNAME, "<init>(boolean,String)", e, 3);
                }
                if (!this.verbose) break block17;
                pw.println(ConfigEnvironment.getMessage("JMSADM4008") + ": " + e);
                pw.flush();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "<init>(boolean,String)");
        }
    }

    private void commandLoop() {
        block18: {
            if (Trace.isOn) {
                Trace.entry(this, CLASSNAME, "commandLoop()");
            }
            boolean carryOn = true;
            String inLine = null;
            int commandNum = 1;
            if (this.verbose) {
                pw.println("\n" + ConfigEnvironment.getMessage("JMSADM4085") + "\n");
            }
            pw.flush();
            while (carryOn) {
                pw.print(this.service.getPathString() + "> ");
                pw.flush();
                StringBuffer buf = new StringBuffer();
                try {
                    boolean sameCommand = true;
                    while (sameCommand) {
                        inLine = this.in.readLine();
                        if (inLine == null) continue;
                        if (inLine.length() == 0) {
                            sameCommand = false;
                        } else if (inLine.charAt(0) == '*' || inLine.charAt(0) == '#' || inLine.charAt(0) == '/') {
                            inLine = "";
                            sameCommand = false;
                        } else if (inLine.charAt(inLine.length() - 1) != '+') {
                            sameCommand = false;
                        } else {
                            inLine = inLine.substring(0, inLine.length() - 1);
                        }
                        if (inLine.length() <= 0) continue;
                        buf.append(" " + inLine);
                    }
                }
                catch (IOException ex) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, CLASSNAME, "commandLoop()", ex, 1);
                    }
                    pw.println(ConfigEnvironment.getMessage("JMSADM4086") + ": " + ex);
                    pw.flush();
                }
                inLine = buf.toString();
                if (inLine.length() > 0) {
                    ++commandNum;
                    if (this.execCommand(inLine)) continue;
                    carryOn = false;
                    continue;
                }
                pw.println("");
            }
            try {
                this.in.close();
                pw.flush();
            }
            catch (IOException ex) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, CLASSNAME, "commandLoop()", ex, 2);
                }
                if (!this.verbose) break block18;
                pw.println(ConfigEnvironment.getMessage("JMSADM4008") + ": " + ex);
                pw.flush();
            }
        }
        this.exitMessage();
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "commandLoop()");
        }
    }

    protected boolean execCommand(String cmdLine) {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "execCommand(String)", new Object[]{cmdLine});
        }
        boolean retCode = true;
        Command c = new Command(cmdLine);
        if (c.getArgCount() == -1) {
            pw.println(ConfigEnvironment.getMessage("JMSADM4120"));
            pw.flush();
        } else {
            int v = c.getVerb();
            if (v == 0) {
                if (c.getObjType() == -1 && c.getObjName() == null) {
                    retCode = false;
                } else {
                    pw.println(ConfigEnvironment.getMessage("JMSADM4120"));
                }
                pw.flush();
            } else if (v == 1) {
                this.doDefine(c);
            } else if (v == 7) {
                this.doAlter(c);
            } else if (v == 2) {
                if (c.getObjType() == -2) {
                    String ctxname = c.getObjName();
                    try {
                        this.service.chContext(ctxname);
                    }
                    catch (Exception e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, CLASSNAME, "execCommand(String)", e);
                        }
                        pw.println(ConfigEnvironment.getMessage("JMSADM4097"));
                        pw.flush();
                    }
                } else {
                    pw.println(ConfigEnvironment.getMessage("JMSADM4120"));
                    pw.flush();
                }
            } else if (v == 3) {
                if (c.getObjType() == -2) {
                    if (c.getObjName() == null && c.getArgCount() == 0) {
                        this.doDisplayCtx();
                    } else {
                        pw.println(ConfigEnvironment.getMessage("JMSADM4120"));
                    }
                } else if (c.getArgCount() == -1) {
                    pw.println(ConfigEnvironment.getMessage("JMSADM4120"));
                } else {
                    this.doDisplay(c);
                }
            } else if (v == 4) {
                if (c.getObjType() == -2) {
                    this.doDeleteCtx(c.getObjName());
                } else {
                    this.doDelete(c);
                }
            } else if (v == 5) {
                this.doCopy(c);
            } else if (v == 6) {
                this.doMove(c);
            } else if (c.getVerbString() != null) {
                pw.println(ConfigEnvironment.getMessage("JMSADM4087") + ": " + c.getVerbString());
            }
        }
        pw.println("");
        pw.flush();
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "execCommand(String)", retCode);
        }
        return retCode;
    }

    private void loadConfig(String fn) {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "loadConfig(String)", new Object[]{fn});
        }
        this.config = new Properties();
        try {
            this.config.load(new FileInputStream(fn));
        }
        catch (IOException e1) {
            if (Trace.isOn) {
                Trace.catchBlock(this, CLASSNAME, "loadConfig(String)", e1, 1);
            }
            try {
                String sep = PropertyStore.file_separator;
                String installPath = "MQ_JAVA_INSTALL_PATH";
                PropertyStore.register(installPath, "");
                String newfn = PropertyStore.getStringProperty(installPath) + sep + "bin" + sep + fn;
                this.config.load(new FileInputStream(newfn));
            }
            catch (IOException e2) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, CLASSNAME, "loadConfig(String)", e2, 2);
                }
                pw.println(ConfigEnvironment.getMessage("JMSADM4121") + ": " + fn);
                if (this.verbose) {
                    pw.println("\n" + e2);
                }
                pw.flush();
                if (Trace.isOn) {
                    Trace.exit((Object)this, CLASSNAME, "loadConfig(String)", 1);
                }
                return;
            }
        }
        this.setConfigVariables(this.config);
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "loadConfig(String)", 2);
        }
    }

    private void setConfigVariables(Properties cfg) {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "setConfigVariables(Properties)", new Object[]{cfg});
        }
        this.icf = cfg.getProperty("INITIAL_CONTEXT_FACTORY");
        this.purl = cfg.getProperty("PROVIDER_URL");
        String thisauth = cfg.getProperty("SECURITY_AUTHENTICATION");
        this.userdn = cfg.getProperty("PROVIDER_USERDN");
        this.userpw = cfg.getProperty("PROVIDER_PASSWORD");
        if (this.icf == null || this.purl == null) {
            Exception e = new Exception(ConfigEnvironment.getMessage("JMSADM4105"));
            pw.println(e);
            pw.flush();
            if (Trace.isOn) {
                Trace.exit((Object)this, CLASSNAME, "setConfigVariables(Properties)", 1);
            }
            return;
        }
        this.icf = this.icf.trim();
        this.purl = this.purl.trim();
        if (thisauth != null) {
            this.auth = thisauth;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "setConfigVariables(Properties)", 2);
        }
    }

    private void doDefine(Command c) {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "doDefine(Command)", new Object[]{c});
        }
        AdminObject aobj = null;
        if (c.getObjType() == -2) {
            String ctxname = c.getObjName();
            try {
                this.service.mkContext(ctxname);
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, CLASSNAME, "doDefine(Command)", e, 1);
                }
                pw.println(ConfigEnvironment.getMessage("JMSADM4111"));
                if (this.verbose) {
                    pw.println("\n" + e);
                }
                pw.flush();
            }
        } else {
            Hashtable<String, String> props = new Hashtable<String, String>();
            int argcount = c.getArgCount();
            for (int i = 0; i < argcount; ++i) {
                if (c.getArgValue(i) != null) {
                    if (c.getArgValue(i).length() <= 0) continue;
                    props.put(c.getArgName(i), c.getArgValue(i));
                    continue;
                }
                props.put(c.getArgName(i), "<null>");
            }
            aobj = new AdminObject(c.getObjType(), props);
            if (aobj.errorRaised()) {
                pw.println(ConfigEnvironment.getMessage("JMSADM4112"));
                pw.flush();
                int errType = aobj.getErrorType();
                switch (errType) {
                    case 0: {
                        pw.println(ConfigEnvironment.getMessage("JMSADM4129", aobj.getErrorString1()));
                        pw.flush();
                        break;
                    }
                    case 1: {
                        pw.println(ConfigEnvironment.getMessage("JMSADM4125", aobj.getErrorString1(), aobj.getErrorString2()));
                        pw.flush();
                        break;
                    }
                    case 3: {
                        pw.println(ConfigEnvironment.getMessage("JMSADM4127") + ": " + aobj.getErrorString1());
                        pw.flush();
                        break;
                    }
                    case 4: {
                        pw.println(ConfigEnvironment.getMessage("JMSADM4128", aobj.getErrorString1(), aobj.getErrorString2()));
                        pw.flush();
                        break;
                    }
                    case 5: {
                        pw.println(aobj.getErrorString1());
                        pw.flush();
                    }
                }
                aobj.resetError();
            } else {
                try {
                    this.service.bind(c.getObjName(), aobj);
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, CLASSNAME, "doDefine(Command)", e, 2);
                    }
                    pw.println(ConfigEnvironment.getMessage("JMSADM4113"));
                    if (this.verbose) {
                        pw.println("\n" + e);
                    }
                    pw.flush();
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "doDefine(Command)");
        }
    }

    private void doAlter(Command c) {
        AdminObject newObject;
        AdminObject aobj;
        int objType;
        block39: {
            if (Trace.isOn) {
                Trace.entry(this, CLASSNAME, "doAlter(Command)", new Object[]{c});
            }
            objType = c.getObjType();
            String alias = c.getObjName();
            aobj = null;
            if (alias == null) {
                if (Trace.isOn) {
                    Trace.exit((Object)this, CLASSNAME, "doAlter(Command)", 1);
                }
                return;
            }
            try {
                aobj = this.service.get(alias);
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, CLASSNAME, "doAlter(Command)", e, 1);
                }
                if (!this.verbose) break block39;
                pw.println(ConfigEnvironment.getMessage("JMSADM4008") + ": " + e);
                pw.flush();
            }
        }
        if (aobj == null) {
            pw.println(ConfigEnvironment.getMessage("JMSADM4096"));
            pw.flush();
            if (Trace.isOn) {
                Trace.exit((Object)this, CLASSNAME, "doAlter(Command)", 2);
            }
            return;
        }
        if (!this.objectTypeMatch(objType, aobj.getType())) {
            if (Trace.isOn) {
                Trace.exit((Object)this, CLASSNAME, "doAlter(Command)", 3);
            }
            return;
        }
        Hashtable props = aobj.getProperties();
        if (this.isConnectionFactoryObject(aobj) && props.get("TRANSPORT") != null) {
            if (props.get("TRANSPORT").equals("BIND")) {
                this.removeClientProperties(props);
                this.removeDirectProperties(props);
            }
            if (props.get("TRANSPORT").equals("CLIENT")) {
                this.removeDirectProperties(props);
            }
        }
        String transportStartedAs = null;
        if (props.get("TRANSPORT") != null) {
            transportStartedAs = props.get("TRANSPORT").toString().toUpperCase();
        }
        int argcount = c.getArgCount();
        boolean userSetCNL = false;
        for (int i = 0; i < argcount; ++i) {
            if (c.getArgValue(i) == null) {
                String longName = this.toLongName(c.getArgName(i));
                if (longName != null) {
                    props.remove(longName);
                    continue;
                }
                pw.println(ConfigEnvironment.getMessage("JMSADM4125", aobj.getObject().getClass().getName(), c.getArgName(i)));
                pw.flush();
                continue;
            }
            String argName = c.getArgName(i);
            String argValue = c.getArgValue(i);
            String longName = this.toLongName(argName);
            if (longName == null) {
                pw.println(ConfigEnvironment.getMessage("JMSADM4125", aobj.getObject().getClass().getName(), argName));
                pw.flush();
                continue;
            }
            if (longName.equalsIgnoreCase("HOSTNAME") && !userSetCNL) {
                String originalConnectionNameList = (String)props.get("CONNECTIONNAMELIST");
                if (originalConnectionNameList == null) continue;
                int endHost = originalConnectionNameList.indexOf(40);
                String strippedConnectionNameList = endHost == -1 ? (originalConnectionNameList.length() > 0 ? ((endHost = originalConnectionNameList.indexOf(44)) == -1 ? originalConnectionNameList : originalConnectionNameList.substring(endHost)) : "") : originalConnectionNameList.substring(endHost);
                if (argValue == null || argValue.trim().length() == 0 || argValue.trim().equals("()") || argValue.trim().equals(",")) continue;
                props.put("CONNECTIONNAMELIST", argValue + strippedConnectionNameList);
                continue;
            }
            if (longName.equalsIgnoreCase("PORT") && !userSetCNL) {
                String originalConnectionNameList = (String)props.get("CONNECTIONNAMELIST");
                if (originalConnectionNameList == null) continue;
                int startPort = originalConnectionNameList.indexOf(40);
                int endPort = originalConnectionNameList.indexOf(41);
                String uptoPort = originalConnectionNameList.substring(0, startPort + 1);
                String afterPort = originalConnectionNameList.substring(endPort);
                String strippedConnectionNameList = uptoPort + argValue + afterPort;
                props.put("CONNECTIONNAMELIST", strippedConnectionNameList);
                continue;
            }
            if (longName.equalsIgnoreCase("CONNECTIONNAMELIST")) {
                userSetCNL = true;
                props.put(longName, argValue);
                continue;
            }
            props.put(longName, argValue);
        }
        props.remove("VERSION");
        String transportEndedAs = null;
        if (props.get("TRANSPORT") != null) {
            transportEndedAs = props.get("TRANSPORT").toString().toUpperCase();
        }
        if (this.isConnectionFactoryObject(aobj)) {
            if (transportStartedAs.equals("CLIENT") && transportEndedAs.equals("BIND")) {
                this.removeClientProperties(props);
                this.removeDirectProperties(props);
            }
            if (transportStartedAs.equals("DIRECT") && transportEndedAs.equals("BIND")) {
                this.removeClientProperties(props);
                this.removeDirectProperties(props);
            }
            if (transportStartedAs.equals("DIRECTHTTP") && transportEndedAs.equals("BIND")) {
                this.removeClientProperties(props);
            }
        }
        if ((newObject = new AdminObject(c.getObjType(), props)).errorRaised()) {
            pw.println(ConfigEnvironment.getMessage("JMSADM4112"));
            pw.flush();
            int errType = newObject.getErrorType();
            switch (errType) {
                case 0: {
                    pw.println(ConfigEnvironment.getMessage("JMSADM4129", newObject.getErrorString1()));
                    pw.flush();
                    break;
                }
                case 1: {
                    pw.println(ConfigEnvironment.getMessage("JMSADM4125", newObject.getErrorString1(), newObject.getErrorString2()));
                    pw.flush();
                    break;
                }
                case 3: {
                    pw.println(ConfigEnvironment.getMessage("JMSADM4127") + ": " + newObject.getErrorString1());
                    pw.flush();
                    break;
                }
                case 4: {
                    pw.println(ConfigEnvironment.getMessage("JMSADM4128", newObject.getErrorString1(), newObject.getErrorString2()));
                    pw.flush();
                }
            }
            newObject.resetError();
        } else {
            try {
                this.service.rebind(c.getObjName(), newObject);
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, CLASSNAME, "doAlter(Command)", e, 2);
                }
                pw.println(ConfigEnvironment.getMessage("JMSADM4113"));
                if (this.verbose) {
                    pw.println("\n" + e);
                }
                pw.flush();
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "doAlter(Command)", 4);
        }
    }

    private boolean isConnectionFactoryObject(AdminObject o) {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "isConnectionFactoryObject(AdminObject)", new Object[]{o});
        }
        try {
            BAO tmp = (BAO)o.getBAOObject();
            if (tmp.name().indexOf("QCF") != -1 || tmp.name().indexOf("TCF") != -1 || tmp.name().indexOf("CF") != -1) {
                if (Trace.isOn) {
                    Trace.exit(this, CLASSNAME, "isConnectionFactoryObject(AdminObject)", true, 1);
                }
                return true;
            }
            if (Trace.isOn) {
                Trace.exit(this, CLASSNAME, "isConnectionFactoryObject(AdminObject)", false, 2);
            }
            return false;
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, CLASSNAME, "isConnectionFactoryObject(AdminObject)", e);
            }
            if (Trace.isOn) {
                Trace.exit(this, CLASSNAME, "isConnectionFactoryObject(AdminObject)", false, 3);
            }
            return false;
        }
    }

    private void removeClientProperties(Hashtable props) {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "removeClientProperties(Hashtable)", new Object[]{props});
        }
        props.remove("HOSTNAME");
        props.remove("CHANNEL");
        props.remove("RECEXIT");
        props.remove("RECEXITINIT");
        props.remove("SECEXIT");
        props.remove("SECEXITINIT");
        props.remove("SENDEXIT");
        props.remove("SENDEXITINIT");
        props.remove("SSLCIPHERSUITE");
        props.remove("SSLCRL");
        props.remove("SSLPEERNAME");
        props.remove("SENDEXIT");
        props.remove("SSLPEERNAME");
        props.remove("PORT");
        props.remove("CCSID");
        props.remove("LOCALADDRESS");
        props.remove("SSLRESETCOUNT");
        props.remove("SSLFIPSREQUIRED");
        props.remove("CCDTURL");
        props.remove("CLIENTRECONNECTOPTIONS");
        props.remove("CONNECTIONNAMELIST");
        props.remove("CLIENTRECONNECTTIMEOUT");
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "removeClientProperties(Hashtable)");
        }
    }

    private void removeDirectProperties(Hashtable props) {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "removeDirectProperties(Hashtable)", new Object[]{props});
        }
        props.remove("MULTICAST");
        props.remove("PROXYHOSTNAME");
        props.remove("PROXYPORT");
        props.remove("DIRECTAUTH");
        props.remove("MAXBUFFSIZE");
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "removeDirectProperties(Hashtable)");
        }
    }

    private String toLongName(String p) {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "toLongName(String)", new Object[]{p});
        }
        String traceRet1 = AP.getLongName(p);
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "toLongName(String)", traceRet1);
        }
        return traceRet1;
    }

    private void doCopy(Command c) {
        AdminObject aobj;
        int objType;
        block14: {
            if (Trace.isOn) {
                Trace.entry(this, CLASSNAME, "doCopy(Command)", new Object[]{c});
            }
            objType = c.getObjType();
            String alias = c.getObjName();
            aobj = null;
            if (alias == null) {
                if (Trace.isOn) {
                    Trace.exit((Object)this, CLASSNAME, "doCopy(Command)", 1);
                }
                return;
            }
            try {
                aobj = this.service.get(alias);
            }
            catch (Exception e) {
                if (!Trace.isOn) break block14;
                Trace.catchBlock(this, CLASSNAME, "doCopy(Command)", e, 1);
            }
        }
        if (aobj == null) {
            pw.println(ConfigEnvironment.getMessage("JMSADM4096"));
            pw.flush();
            if (Trace.isOn) {
                Trace.exit((Object)this, CLASSNAME, "doCopy(Command)", 2);
            }
            return;
        }
        if (!this.objectTypeMatch(objType, aobj.getType())) {
            if (Trace.isOn) {
                Trace.exit((Object)this, CLASSNAME, "doCopy(Command)", 3);
            }
            return;
        }
        try {
            this.service.bind(c.getArgValue(0), aobj);
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, CLASSNAME, "doCopy(Command)", e, 2);
            }
            pw.println(ConfigEnvironment.getMessage("JMSADM4113"));
            if (this.verbose) {
                pw.println("\n" + e);
            }
            pw.flush();
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "doCopy(Command)", 4);
        }
    }

    private void doMove(Command c) {
        AdminObject aobj;
        String alias;
        int objType;
        block19: {
            if (Trace.isOn) {
                Trace.entry(this, CLASSNAME, "doMove(Command)", new Object[]{c});
            }
            objType = c.getObjType();
            alias = c.getObjName();
            aobj = null;
            if (alias == null) {
                if (Trace.isOn) {
                    Trace.exit((Object)this, CLASSNAME, "doMove(Command)", 1);
                }
                return;
            }
            try {
                aobj = this.service.get(alias);
            }
            catch (Exception e) {
                if (!Trace.isOn) break block19;
                Trace.catchBlock(this, CLASSNAME, "doMove(Command)", e, 1);
            }
        }
        if (aobj == null) {
            pw.println(ConfigEnvironment.getMessage("JMSADM4096"));
            pw.flush();
            if (Trace.isOn) {
                Trace.exit((Object)this, CLASSNAME, "doMove(Command)", 2);
            }
            return;
        }
        if (!this.objectTypeMatch(objType, aobj.getType())) {
            if (Trace.isOn) {
                Trace.exit((Object)this, CLASSNAME, "doMove(Command)", 3);
            }
            return;
        }
        try {
            this.service.bind(c.getArgValue(0), aobj);
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, CLASSNAME, "doMove(Command)", e, 2);
            }
            pw.println(ConfigEnvironment.getMessage("JMSADM4113"));
            if (this.verbose) {
                pw.println("\n" + e);
            }
            pw.flush();
            if (Trace.isOn) {
                Trace.exit((Object)this, CLASSNAME, "doMove(Command)", 4);
            }
            return;
        }
        try {
            this.service.unbind(alias);
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, CLASSNAME, "doMove(Command)", e, 3);
            }
            pw.println(ConfigEnvironment.getMessage("JMSADM4122"));
            if (this.verbose) {
                pw.println("\n" + e);
            }
            pw.flush();
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "doMove(Command)", 5);
        }
    }

    private void doDisplay(Command c) {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "doDisplay(Command)", new Object[]{c});
        }
        int objType = c.getObjType();
        String alias = c.getObjName();
        AdminObject aobj = null;
        if (alias == null) {
            if (Trace.isOn) {
                Trace.exit((Object)this, CLASSNAME, "doDisplay(Command)", 1);
            }
            return;
        }
        if (alias.indexOf(this.wildCardCharacter) != -1) {
            try {
                this.service.get(alias);
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, CLASSNAME, "doDisplay(Command)", e, 1);
                }
                this.doWildcardDisplay(c);
                if (Trace.isOn) {
                    Trace.exit((Object)this, CLASSNAME, "doDisplay(Command)", 2);
                }
                return;
            }
        }
        try {
            aobj = this.service.get(alias);
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, CLASSNAME, "doDisplay(Command)", e, 2);
            }
            pw.println(e.getMessage());
            pw.flush();
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, CLASSNAME, "doDisplay(Command)", e, 3);
            }
            pw.println(ConfigEnvironment.getMessage("JMSADM4096"));
            if (this.verbose) {
                pw.println("\n" + e);
            }
            pw.flush();
        }
        if (aobj == null) {
            if (Trace.isOn) {
                Trace.exit((Object)this, CLASSNAME, "doDisplay(Command)", 3);
            }
            return;
        }
        if (!this.objectTypeMatch(objType, aobj.getType())) {
            if (Trace.isOn) {
                Trace.exit((Object)this, CLASSNAME, "doDisplay(Command)", 4);
            }
            return;
        }
        Hashtable props = aobj.getProperties();
        if (this.isConnectionFactoryObject(aobj) && props.get("TRANSPORT") != null) {
            if (props.get("TRANSPORT").equals("BIND")) {
                this.removeClientProperties(props);
                this.removeDirectProperties(props);
            }
            if (props.get("TRANSPORT").equals("CLIENT")) {
                this.removeDirectProperties(props);
            }
        }
        TreeMap sortedProps = new TreeMap();
        Enumeration propsEnum = props.keys();
        while (propsEnum.hasMoreElements()) {
            String key = (String)propsEnum.nextElement();
            sortedProps.put(key, props.get(key));
        }
        Iterator keys = sortedProps.keySet().iterator();
        while (keys.hasNext()) {
            pw.println("");
            pw.flush();
            String key = (String)keys.next();
            Object val = sortedProps.get(key);
            if (val != null) {
                pw.print("    " + key + "(" + (String)val + ")");
            } else {
                pw.print("    " + key + "(*error*)");
            }
            pw.flush();
        }
        pw.println("");
        pw.flush();
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "doDisplay(Command)", 5);
        }
    }

    private void doDisplayCtx() {
        block10: {
            if (Trace.isOn) {
                Trace.entry(this, CLASSNAME, "doDisplayCtx()");
            }
            int numCtx = 0;
            int numAdm = 0;
            int numOth = 0;
            pw.print("\n  " + ConfigEnvironment.getMessage("JMSADM4089", this.service.getPathString()));
            pw.flush();
            try {
                Vector entries = this.service.getContents();
                for (int i = 0; i < entries.size(); i += 2) {
                    String type = (String)entries.elementAt(i);
                    String icon = null;
                    if (type.endsWith("Context") || type.endsWith("ContextImpl") || type.endsWith("LDAPCtx")) {
                        icon = "[D]";
                        ++numCtx;
                    } else if (type.endsWith("MQQueueConnectionFactory") || type.endsWith("MQTopicConnectionFactory") || type.endsWith("MQQueue") || type.endsWith("MQTopic") || type.endsWith("MQXAQueueConnectionFactory") || type.endsWith("MQXATopicConnectionFactory") || type.endsWith("JMSWrapXAQueueConnectionFactory") || type.endsWith("JMSWrapXATopicConnectionFactory") || type.endsWith("MQXAConnectionFactory") || type.endsWith("MQConnectionFactory")) {
                        icon = " a ";
                        ++numAdm;
                    } else {
                        icon = "   ";
                        ++numOth;
                    }
                    String name = (String)entries.elementAt(i + 1);
                    name = this.padToLength(name, 25, ' ');
                    if (i == 0) {
                        pw.print("\n");
                    }
                    pw.print("\n  " + icon + " " + name + " " + type);
                    pw.flush();
                }
                pw.println("\n\n  " + (numCtx + numAdm + numOth) + " " + ConfigEnvironment.getMessage("JMSADM4098"));
                pw.println("    " + numCtx + " " + ConfigEnvironment.getMessage("JMSADM4099"));
                pw.println("    " + (numAdm + numOth) + " " + ConfigEnvironment.getMessage("JMSADM4100") + ", " + numAdm + " " + ConfigEnvironment.getMessage("JMSADM4101"));
                pw.flush();
            }
            catch (Exception e) {
                if (!Trace.isOn) break block10;
                Trace.catchBlock(this, CLASSNAME, "doDisplayCtx()", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "doDisplayCtx()");
        }
    }

    private void doWildcardDisplay(Command c) {
        block8: {
            if (Trace.isOn) {
                Trace.entry(this, CLASSNAME, "doWildcardDisplay(Command)", new Object[]{c});
            }
            int theObjectType = c.getObjType();
            String objName = c.getObjName();
            String startsWith = "";
            String endsWith = "";
            if (!objName.equals(this.wildCardCharacter)) {
                int wCardIndex = objName.indexOf(this.wildCardCharacter);
                startsWith = objName.substring(0, wCardIndex);
                endsWith = objName.substring(wCardIndex + 1);
            }
            try {
                Vector entries = this.service.getContents();
                String namePrefix = this.service.getNamePrefix();
                for (int i = 1; i < entries.size(); i += 2) {
                    String name = (String)entries.elementAt(i);
                    if (!name.endsWith(endsWith) || !name.startsWith(startsWith) && (namePrefix == null || !name.startsWith(namePrefix + startsWith))) continue;
                    AdminObject aobj = null;
                    try {
                        aobj = this.service.get(name);
                        if (aobj == null || theObjectType != aobj.getType()) continue;
                        BAO myObj = (BAO)aobj.getBAOObject();
                        String disCommand = myObj.name() + "(" + name + ")";
                        pw.print(disCommand);
                        this.doDisplay(new Command(c.getVerbString() + " " + disCommand));
                        pw.println("");
                        continue;
                    }
                    catch (Exception e) {
                        if (!Trace.isOn) continue;
                        Trace.catchBlock(this, CLASSNAME, "doWildcardDisplay(Command)", e, 1);
                    }
                }
            }
            catch (Exception e) {
                if (!Trace.isOn) break block8;
                Trace.catchBlock(this, CLASSNAME, "doWildcardDisplay(Command)", e, 2);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "doWildcardDisplay(Command)");
        }
    }

    private String padToLength(String str, int length, char padChar) {
        int i;
        int padSize;
        boolean rJustify;
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "padToLength(String,int,char)", new Object[]{str, new Integer(length), new Character(padChar)});
        }
        boolean bl = rJustify = length < 0;
        if (rJustify) {
            length = -1 * length;
        }
        if ((padSize = length - str.length()) < 1) {
            if (Trace.isOn) {
                Trace.exit(this, CLASSNAME, "padToLength(String,int,char)", str, 1);
            }
            return str;
        }
        StringBuffer buf = null;
        if (!rJustify) {
            buf = new StringBuffer(str);
            for (i = 0; i < padSize; ++i) {
                buf.append(padChar);
            }
        } else {
            buf = new StringBuffer();
            for (i = 0; i < padSize; ++i) {
                buf.append(padChar);
            }
            buf.append(str);
        }
        String traceRet1 = buf.toString();
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "padToLength(String,int,char)", traceRet1, 2);
        }
        return traceRet1;
    }

    private void doDeleteCtx(String ctxname) {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "doDeleteCtx(String)", new Object[]{ctxname});
        }
        try {
            this.service.rmContext(ctxname);
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, CLASSNAME, "doDeleteCtx(String)", e);
            }
            if (e instanceof ContextNotEmptyException) {
                pw.println(ConfigEnvironment.getMessage("JMSADM4009"));
                if (this.verbose) {
                    pw.println("\n" + e);
                }
                pw.flush();
            }
            if (e instanceof InvalidNameException) {
                pw.println(ConfigEnvironment.getMessage("JMSADM4115"));
                if (this.verbose) {
                    pw.println("\n" + e);
                }
                pw.flush();
            }
            pw.println(ConfigEnvironment.getMessage("JMSADM4130"));
            if (this.verbose) {
                pw.println("\n" + e);
            }
            pw.flush();
        }
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "doDeleteCtx(String)");
        }
    }

    private void doDelete(Command c) {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "doDelete(Command)", new Object[]{c});
        }
        int objType = c.getObjType();
        String alias = c.getObjName();
        AdminObject aobj = null;
        try {
            aobj = this.service.get(alias);
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, CLASSNAME, "doDelete(Command)", e, 1);
            }
            pw.println("\n" + (Object)((Object)e));
            pw.flush();
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, CLASSNAME, "doDelete(Command)", e, 2);
            }
            pw.println(ConfigEnvironment.getMessage("JMSADM4096"));
            if (this.verbose) {
                pw.println("\n" + e);
            }
            pw.flush();
        }
        if (aobj != null) {
            if (!this.objectTypeMatch(objType, aobj.getType())) {
                if (Trace.isOn) {
                    Trace.exit((Object)this, CLASSNAME, "doDelete(Command)", 1);
                }
                return;
            }
            try {
                this.service.unbind(alias);
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, CLASSNAME, "doDelete(Command)", e, 3);
                }
                pw.println(ConfigEnvironment.getMessage("JMSADM4096"));
                if (this.verbose) {
                    pw.println("\n" + e);
                }
                pw.flush();
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "doDelete(Command)", 2);
        }
    }

    public static void initializePW() {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "initializePW()");
        }
        if (pw == null) {
            try {
                String encProp = "console.encoding";
                PropertyStore.register(encProp, "");
                String encoding = PropertyStore.getStringProperty(encProp);
                pw = NLSServices.isWindowsLatinCodepage() && encoding != "" && encoding != null ? new PrintWriter(new OutputStreamWriter((OutputStream)System.out, encoding)) : new PrintWriter(new OutputStreamWriter(System.out));
            }
            catch (UnsupportedEncodingException uee) {
                if (Trace.isOn) {
                    Trace.catchBlock(CLASSNAME, "initializePW()", uee);
                }
                pw = new PrintWriter(new OutputStreamWriter(System.out));
            }
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "initializePW()");
        }
    }

    public static void main(String[] args) {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "main(String [ ])", new Object[]{args});
        }
        boolean verbosity = false;
        String cfgfn = DEF_CONFIG_FILENAME;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].toUpperCase();
            if (arg.equals("-V")) {
                verbosity = true;
                continue;
            }
            if (arg.equals("-CFG")) {
                if (i + 1 >= args.length) continue;
                cfgfn = args[++i];
                continue;
            }
            if (arg.equals("-T")) {
                Trace.setOn(true);
                continue;
            }
            if (pw == null) {
                JMSAdmin.initializePW();
            }
            pw.println(ConfigEnvironment.getMessage("JMSADM5003") + ": " + args[i]);
            pw.flush();
        }
        program = new JMSAdmin(verbosity, cfgfn);
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "main(String [ ])");
        }
    }

    private boolean objectTypeMatch(int exp, int act) {
        boolean match;
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "objectTypeMatch(int,int)", new Object[]{new Integer(exp), new Integer(act)});
        }
        boolean bl = match = exp == act;
        if (!match) {
            pw.println(ConfigEnvironment.getMessage("JMSADM4131"));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "objectTypeMatch(int,int)", match);
        }
        return match;
    }

    private void exitMessage() {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "exitMessage()");
        }
        pw.println(ConfigEnvironment.getMessage("JMSADM4001") + "\n");
        pw.flush();
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "exitMessage()");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data(CLASSNAME, "static", "SCCS id", (Object)sccsid);
        }
        program = null;
        pw = null;
    }

    private class Command {
        private final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999.    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        final int VERB_NON = -1;
        final int VERB_END = 0;
        final int VERB_DEF = 1;
        final int VERB_CHG = 2;
        final int VERB_DIS = 3;
        final int VERB_DEL = 4;
        final int VERB_COP = 5;
        final int VERB_REN = 6;
        final int VERB_ALT = 7;
        private int verb = -1;
        private String verbString = null;
        private int objType = -1;
        private String objName = null;
        private int targType = -1;
        private String targName = null;
        private int numArgs = 0;
        private String[] argName = null;
        private String[] argValue = null;

        public Command(String inLine) {
            String command;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.mq.jms.admin.Command", "<init>(String)", new Object[]{inLine});
            }
            boolean STATE_IDLE = false;
            boolean STATE_NAME = true;
            int STATE_VAL = 2;
            this.numArgs = 0;
            this.verb = -1;
            this.verbString = null;
            Vector<String> vTokens = new Vector<String>();
            StringBuffer currName = null;
            StringBuffer currVal = null;
            int state = 0;
            boolean carryOn = true;
            int errorPos = -1;
            int parenthLevel = 0;
            for (int i = 0; i < inLine.length() && carryOn; ++i) {
                char ch = inLine.charAt(i);
                if (ch == '(') {
                    if (state == 2) {
                        currVal.append(ch);
                        ++parenthLevel;
                        continue;
                    }
                    if (state == 0) {
                        errorPos = i;
                        carryOn = false;
                        continue;
                    }
                    if (state != 1) continue;
                    vTokens.addElement(currName.toString().toUpperCase());
                    currName = null;
                    currVal = new StringBuffer();
                    state = 2;
                    parenthLevel = 0;
                    continue;
                }
                if (ch == ')') {
                    if (state == 2) {
                        if (parenthLevel == 0) {
                            vTokens.addElement(currVal.toString());
                            currVal = null;
                            state = 0;
                            continue;
                        }
                        currVal.append(ch);
                        --parenthLevel;
                        continue;
                    }
                    if (state == 0) {
                        errorPos = i;
                        carryOn = false;
                        continue;
                    }
                    if (state != 1) continue;
                    errorPos = i;
                    carryOn = false;
                    continue;
                }
                if (ch == ' ' || ch == '\t' || ch == '\n') {
                    if (state == 0) continue;
                    if (state == 2) {
                        currVal.append(ch);
                        continue;
                    }
                    if (state != 1) continue;
                    vTokens.addElement(currName.toString());
                    vTokens.addElement(null);
                    currName = null;
                    state = 0;
                    continue;
                }
                if (state == 0) {
                    currName = new StringBuffer();
                    currName.append(ch);
                    state = 1;
                    continue;
                }
                if (state == 1) {
                    currName.append(ch);
                    continue;
                }
                if (state != 2) continue;
                currVal.append(ch);
            }
            if (state == 2) {
                errorPos = inLine.length();
            } else if (state != 0 && state == 1) {
                vTokens.addElement(currName.toString());
                vTokens.addElement(null);
                currName = null;
                state = 0;
            }
            int tokenCount = vTokens.size();
            String[] tokens = new String[tokenCount];
            for (int i = 0; i < tokenCount; ++i) {
                tokens[i] = (String)vTokens.elementAt(i);
            }
            vTokens = null;
            if (errorPos != -1) {
                pw.println(ConfigEnvironment.getMessage("JMSADM4123"));
                pw.flush();
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.mq.jms.admin.Command", "<init>(String)", 1);
                }
                return;
            }
            if (tokenCount == 0) {
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.mq.jms.admin.Command", "<init>(String)", 2);
                }
                return;
            }
            this.verbString = command = tokens[0].toUpperCase();
            if (command.equals("END")) {
                this.verb = 0;
            } else if (command.equals("DEF") || command.equals("DEFINE")) {
                this.verb = 1;
            } else if (command.equals("CHG") || command.equals("CHANGE")) {
                this.verb = 2;
            } else if (command.equals("DIS") || command.equals("DISPLAY")) {
                this.verb = 3;
            } else if (command.equals("DEL") || command.equals("DELETE")) {
                this.verb = 4;
            } else if (command.equals("CP") || command.equals("COPY")) {
                this.verb = 5;
            } else if (command.equals("MV") || command.equals("MOVE")) {
                this.verb = 6;
            } else if (command.equals("ALT") || command.equals("ALTER")) {
                this.verb = 7;
            }
            if (this.verb != -1) {
                if (this.verb == 0) {
                    if (tokenCount != 2) {
                        this.numArgs = -1;
                    }
                } else if (this.verb == 3) {
                    if (tokenCount != 4) {
                        this.numArgs = -1;
                    }
                } else if (this.verb == 1) {
                    if (tokenCount < 4 || tokens[3] == null) {
                        this.numArgs = -1;
                    }
                } else if (this.verb == 4) {
                    if (tokenCount != 4 || tokens[3] == null) {
                        this.numArgs = -1;
                    }
                } else if (this.verb == 2) {
                    if (tokenCount != 4 || tokens[3] == null) {
                        this.numArgs = -1;
                    }
                } else if (this.verb == 5) {
                    if (tokenCount != 6 || tokens[3] == null || tokens[5] == null) {
                        this.numArgs = -1;
                    }
                } else if (this.verb == 6) {
                    if (tokenCount != 6 || tokens[3] == null || tokens[5] == null) {
                        this.numArgs = -1;
                    }
                } else if (this.verb == 7 && (tokenCount < 4 || tokens[3] == null)) {
                    this.numArgs = -1;
                }
                if (this.numArgs == -1) {
                    if (Trace.isOn) {
                        Trace.exit((Object)this, "com.ibm.mq.jms.admin.Command", "<init>(String)", 3);
                    }
                    return;
                }
                if (this.verb != 0) {
                    String arg = tokens[2].toUpperCase();
                    if (arg.equals("CF")) {
                        this.objType = 8;
                    } else if (arg.equals("QCF")) {
                        this.objType = 0;
                    } else if (arg.equals("Q")) {
                        this.objType = 1;
                    } else if (arg.equals("TCF")) {
                        this.objType = 2;
                    } else if (arg.equals("T")) {
                        this.objType = 3;
                    } else if (arg.equals("CTX")) {
                        this.objType = -2;
                    } else if (arg.equals("XACF")) {
                        this.objType = 9;
                    } else if (arg.equals("XAQCF")) {
                        this.objType = 4;
                    } else if (arg.equals("XATCF")) {
                        this.objType = 5;
                    } else if (arg.equals("WSQCF")) {
                        this.objType = 6;
                    } else if (arg.equals("WSTCF")) {
                        this.objType = 7;
                    } else {
                        this.numArgs = -1;
                        if (Trace.isOn) {
                            Trace.exit((Object)this, "com.ibm.mq.jms.admin.Command", "<init>(String)", 4);
                        }
                        return;
                    }
                    this.objName = tokens[3];
                    this.numArgs = (tokenCount - 4) / 2;
                    if (this.verb == 3) {
                        if (this.objType == -2 && this.objName != null || this.objType != -2 && this.objName == null) {
                            this.numArgs = -1;
                        }
                    } else if (this.verb == 5 || this.verb == 6) {
                        String targ = tokens[4].toUpperCase();
                        if (arg.equals("CF")) {
                            this.targType = 8;
                        } else if (targ.equals("QCF")) {
                            this.targType = 0;
                        } else if (targ.equals("Q")) {
                            this.targType = 1;
                        } else if (targ.equals("TCF")) {
                            this.targType = 2;
                        } else if (targ.equals("T")) {
                            this.targType = 3;
                        } else if (targ.equals("CTX")) {
                            this.targType = -2;
                        } else if (arg.equals("XACF")) {
                            this.targType = 9;
                        } else if (targ.equals("XAQCF")) {
                            this.targType = 4;
                        } else if (targ.equals("XATCF")) {
                            this.targType = 5;
                        } else if (arg.equals("WSQCF")) {
                            this.objType = 6;
                        } else if (arg.equals("WSTCF")) {
                            this.objType = 7;
                        } else {
                            this.numArgs = -1;
                        }
                        if (this.objType == -2 || this.targType == -2 || this.objType != this.targType) {
                            this.numArgs = -1;
                        }
                    } else if (this.verb == 7 && this.objType == -2) {
                        this.numArgs = -1;
                    }
                    if (!(this.objName != null && this.objName.length() != 0 || this.verb == 0 || this.verb == 3 && this.objType == -2)) {
                        this.numArgs = -1;
                    }
                    if (this.numArgs == -1) {
                        if (Trace.isOn) {
                            Trace.exit((Object)this, "com.ibm.mq.jms.admin.Command", "<init>(String)", 5);
                        }
                        return;
                    }
                    if (this.numArgs > 0) {
                        this.argName = new String[this.numArgs];
                        this.argValue = new String[this.numArgs];
                        for (int i = 0; i < this.numArgs; ++i) {
                            this.argName[i] = tokens[4 + i * 2];
                            this.argValue[i] = tokens[5 + i * 2];
                        }
                        if (!(this.verb != 5 && this.verb != 6 || this.argValue[0] != null && this.argValue[0].length() != 0)) {
                            this.numArgs = -1;
                        }
                    }
                }
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.mq.jms.admin.Command", "<init>(String)", 6);
            }
        }

        public int getVerb() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.mq.jms.admin.Command", "getVerb()", "getter", new Integer(this.verb));
            }
            return this.verb;
        }

        public String getVerbString() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.mq.jms.admin.Command", "getVerbString()", "getter", this.verbString);
            }
            return this.verbString;
        }

        public int getObjType() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.mq.jms.admin.Command", "getObjType()", "getter", new Integer(this.objType));
            }
            return this.objType;
        }

        public String getObjName() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.mq.jms.admin.Command", "getObjName()", "getter", this.objName);
            }
            return this.objName;
        }

        public int getTargType() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.mq.jms.admin.Command", "getTargType()", "getter", new Integer(this.targType));
            }
            return this.targType;
        }

        public String getTargName() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.mq.jms.admin.Command", "getTargName()", "getter", this.targName);
            }
            return this.targName;
        }

        public String getArgName(int i) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.mq.jms.admin.Command", "getArgName(int)", new Object[]{new Integer(i)});
            }
            String traceRet1 = this.argName[i];
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.mq.jms.admin.Command", "getArgName(int)", traceRet1);
            }
            return traceRet1;
        }

        public String getArgValue(int i) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.mq.jms.admin.Command", "getArgValue(int)", new Object[]{new Integer(i)});
            }
            String traceRet1 = this.argValue[i];
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.mq.jms.admin.Command", "getArgValue(int)", traceRet1);
            }
            return traceRet1;
        }

        public int getArgCount() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.mq.jms.admin.Command", "getArgCount()", "getter", new Integer(this.numArgs));
            }
            return this.numArgs;
        }
    }
}

