/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.admin;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.MQXAConnectionFactory;
import com.ibm.mq.jms.MQXAQueueConnectionFactory;
import com.ibm.mq.jms.MQXATopicConnectionFactory;
import com.ibm.mq.jms.admin.AdminObject;
import com.ibm.mq.jms.admin.ConfigEnvironment;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class AdminService {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.mq.jms.admin/src/com/ibm/mq/jms/admin/AdminService.java, jmscc.admin, k701, k701-112-140304  1.15.1.1 09/08/17 09:13:29";
    private static final String CLASSNAME = "com.ibm.mq.jms.admin.AdminService";
    private static final int SYSTEM_NONE = -1;
    private static final int SYSTEM_FS = 0;
    private static final int SYSTEM_LDAP = 1;
    private static final int SYSTEM_WEBSPHERE = 2;
    private static final String DEFAULT_PREFIX = "cn=";
    static final int AUTH_NONE = 0;
    static final int AUTH_SIMPLE = 1;
    static final int AUTH_CRAM_MD5 = 2;
    static final String CTX_INIT = "=INIT";
    static final String CTX_UP = "=UP";
    protected boolean active = false;
    protected Context ictx = null;
    protected Context cctx = null;
    private String cctxString = null;
    private Vector parentChain = null;
    private Vector parentChainString = null;
    private String initialContextFactory = null;
    private String providerURL = null;
    private int authentication = 0;
    protected Hashtable properties;
    protected static final String USE_INITIAL_DIR_CONTEXT = "USE_INITIAL_DIR_CONTEXT";
    protected static final String NAME_PREFIX = "NAME_PREFIX";
    protected static final String NAME_READABILITY = "NAME_READABILITY_MARKER";
    protected static final String ICF_CONFIG_TRUE = "TRUE";
    protected static final String ICF_CONFIG_FALSE = "FALSE";

    AdminService(String icf, String purl, String auth, Hashtable properties) throws JMSSecurityException {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "<init>(String,String,String,Hashtable)", new Object[]{icf, purl, auth, properties});
        }
        this.properties = properties;
        this.initialContextFactory = icf;
        this.providerURL = purl;
        if (auth.toUpperCase().equals("NONE")) {
            this.authentication = 0;
        } else if (auth.toUpperCase().equals("SIMPLE")) {
            this.authentication = 1;
        } else if (auth.toUpperCase().equals("CRAM_MD5") || auth.toUpperCase().equals("CRAM-MD5")) {
            this.authentication = 2;
        } else {
            this.authentication = 0;
            JMSSecurityException traceRet1 = new JMSSecurityException(ConfigEnvironment.getMessage("JMSADM4139"));
            if (Trace.isOn) {
                Trace.throwing(this, CLASSNAME, "<init>(String,String,String,Hashtable)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "<init>(String,String,String,Hashtable)");
        }
    }

    void initJNDI(String id, String pw) throws NamingException, JMSException, ClassNotFoundException {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "initJNDI(String,String)", new Object[]{id, pw});
        }
        if (!this.active) {
            Hashtable env = (Hashtable)this.properties.clone();
            env.put("java.naming.factory.initial", this.initialContextFactory);
            env.put("java.naming.provider.url", this.providerURL);
            env.put("java.naming.security.authentication", this.authentication == 0 ? "none" : (this.authentication == 1 ? "simple" : (this.authentication == 2 ? "CRAM_MD5" : null)));
            env.put("java.naming.referral", "throw");
            if (this.needsAuthorization()) {
                env.put("java.naming.security.principal", id);
                env.put("java.naming.security.credentials", pw);
            }
            try {
                this.setICFProperties();
                this.ictx = ((String)this.properties.get(USE_INITIAL_DIR_CONTEXT)).toUpperCase().equals(ICF_CONFIG_TRUE) ? new InitialDirContext(env) : new InitialContext(env);
            }
            catch (NamingException e) {
                Exception e1;
                if (Trace.isOn) {
                    Trace.catchBlock(this, CLASSNAME, "initJNDI(String,String)", e);
                }
                if ((e1 = (Exception)e.getRootCause()) instanceof ClassNotFoundException) {
                    ClassNotFoundException e2 = (ClassNotFoundException)e1;
                    this.cctxString = ConfigEnvironment.getMessage("JMSADM4142");
                    System.out.println(this.cctxString + "\n");
                    if (Trace.isOn) {
                        Trace.throwing(this, CLASSNAME, "initJNDI(String,String)", e2, 1);
                    }
                    throw e2;
                }
                this.cctxString = ConfigEnvironment.getMessage("JMSADM4110");
                System.out.println(this.cctxString + "\n");
                if (Trace.isOn) {
                    Trace.throwing(this, CLASSNAME, "initJNDI(String,String)", e, 2);
                }
                throw e;
            }
            this.parentChain = new Vector();
            this.parentChain.addElement(this.cctx);
            this.parentChainString = new Vector();
            this.parentChainString.addElement(ConfigEnvironment.getMessage("JMSADM4007"));
            this.cctx = this.ictx;
            this.cctxString = ConfigEnvironment.getMessage("JMSADM4007");
            this.active = true;
        }
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "initJNDI(String,String)");
        }
    }

    boolean needsAuthorization() {
        boolean traceRet1;
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "needsAuthorization()");
        }
        boolean bl = traceRet1 = this.authentication != 0;
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "needsAuthorization()", traceRet1);
        }
        return traceRet1;
    }

    void stopJNDI() throws NamingException {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "stopJNDI()");
        }
        if (this.active) {
            try {
                this.ictx.close();
                this.active = false;
                this.parentChain = null;
                this.ictx = null;
                this.cctx = null;
            }
            catch (NamingException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, CLASSNAME, "stopJNDI()", e);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, CLASSNAME, "stopJNDI()", e);
                }
                throw e;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "stopJNDI()");
        }
    }

    /*
     * WARNING - void declaration
     */
    AdminObject get(String alias) throws NamingException, JMSException {
        void var3_6;
        int objType;
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "get(String)", new Object[]{alias});
        }
        if (!this.active) {
            JMSException e = new JMSException(ConfigEnvironment.getMessage("JMSADM4104"));
            if (Trace.isOn) {
                Trace.throwing(this, CLASSNAME, "get(String)", e, 1);
            }
            throw e;
        }
        Object retObj = null;
        try {
            String fullAlias = alias;
            if (this.properties.get(NAME_PREFIX) != null && !fullAlias.startsWith((String)this.properties.get(NAME_PREFIX))) {
                fullAlias = this.properties.get(NAME_PREFIX) + fullAlias;
            }
            retObj = this.cctx.lookup(fullAlias);
        }
        catch (NamingException e1) {
            if (Trace.isOn) {
                Trace.catchBlock(this, CLASSNAME, "get(String)", e1);
            }
            if (Trace.isOn) {
                Trace.throwing(this, CLASSNAME, "get(String)", e1, 2);
            }
            throw e1;
        }
        String className = retObj.getClass().getName();
        if (className.equals("com.ibm.ejs.jms.mq.JMSWrapXAQueueConnectionFactory")) {
            objType = 6;
        } else if (className.equals("com.ibm.ejs.jms.mq.JMSWrapXATopicConnectionFactory")) {
            objType = 7;
        } else if (retObj instanceof MQXAQueueConnectionFactory) {
            objType = 4;
        } else if (retObj instanceof MQXATopicConnectionFactory) {
            objType = 5;
        } else if (retObj instanceof MQXAConnectionFactory) {
            objType = 9;
        } else if (retObj instanceof MQQueueConnectionFactory) {
            objType = 0;
        } else if (retObj instanceof MQQueue) {
            objType = 1;
        } else if (retObj instanceof MQTopicConnectionFactory) {
            objType = 2;
        } else if (retObj instanceof MQTopic) {
            objType = 3;
        } else if (retObj instanceof MQConnectionFactory) {
            objType = 8;
        } else {
            String refClass = null;
            if (retObj instanceof Reference) {
                refClass = ((Reference)retObj).getClassName();
            }
            JMSException e = refClass != null && refClass.startsWith("com.ibm.ejs") ? new JMSException(ConfigEnvironment.getMessage("JMSADM4137")) : new JMSException(ConfigEnvironment.getMessage("JMSADM4106"));
            if (Trace.isOn) {
                Trace.throwing(this, CLASSNAME, "get(String)", e, 3);
            }
            throw e;
        }
        AdminObject traceRet1 = new AdminObject((int)var3_6, retObj, alias);
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "get(String)", traceRet1);
        }
        return traceRet1;
    }

    Vector getContents() throws NamingException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "getContents()");
        }
        if (!this.active) {
            JMSException e = new JMSException(ConfigEnvironment.getMessage("JMSADM4104"));
            if (Trace.isOn) {
                Trace.throwing(this, CLASSNAME, "getContents()", e, 1);
            }
            throw e;
        }
        Vector<String> objs = new Vector<String>();
        NamingEnumeration<NameClassPair> ne = null;
        try {
            ne = this.cctx.list("");
            while (ne.hasMore()) {
                int idx;
                NameClassPair nc = ne.next();
                String objType = nc.getClassName();
                String name = nc.getName();
                if (this.properties.get(NAME_READABILITY) != null && (idx = name.indexOf((String)this.properties.get(NAME_READABILITY))) != -1) {
                    name = name.substring(0, idx);
                }
                objs.addElement(objType);
                objs.addElement(name);
            }
        }
        catch (NamingException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, CLASSNAME, "getContents()", e);
            }
            if (Trace.isOn) {
                Trace.throwing(this, CLASSNAME, "getContents()", e, 2);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "getContents()", objs);
        }
        return objs;
    }

    void bind(String alias, AdminObject obj) throws NamingException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "bind(String,AdminObject)", new Object[]{alias, obj});
        }
        if (!this.active) {
            JMSException e = new JMSException(ConfigEnvironment.getMessage("JMSADM4104"));
            if (Trace.isOn) {
                Trace.throwing(this, CLASSNAME, "bind(String,AdminObject)", e, 1);
            }
            throw e;
        }
        if (((String)this.properties.get(USE_INITIAL_DIR_CONTEXT)).toUpperCase().equals(ICF_CONFIG_TRUE)) {
            BasicAttributes ba = new BasicAttributes();
            ba.put("objectclass", "javaContainer");
            ba.put("cn", alias);
            try {
                String fullAlias = alias;
                if (this.properties.get(NAME_PREFIX) != null && !fullAlias.startsWith((String)this.properties.get(NAME_PREFIX))) {
                    fullAlias = this.properties.get(NAME_PREFIX) + fullAlias;
                }
                ((DirContext)this.cctx).bind(fullAlias, obj.getObject(), (Attributes)ba);
            }
            catch (NamingException e1) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, CLASSNAME, "bind(String,AdminObject)", e1, 1);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, CLASSNAME, "bind(String,AdminObject)", e1, 2);
                }
                throw e1;
            }
        }
        try {
            this.cctx.bind(alias, obj.getObject());
        }
        catch (NamingException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, CLASSNAME, "bind(String,AdminObject)", e, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, CLASSNAME, "bind(String,AdminObject)", e, 3);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "bind(String,AdminObject)");
        }
    }

    void rebind(String alias, AdminObject obj) throws NamingException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "rebind(String,AdminObject)", new Object[]{alias, obj});
        }
        if (!this.active) {
            JMSException e = new JMSException(ConfigEnvironment.getMessage("JMSADM4104"));
        }
        if (((String)this.properties.get(USE_INITIAL_DIR_CONTEXT)).toUpperCase().equals(ICF_CONFIG_TRUE)) {
            BasicAttributes ba = new BasicAttributes();
            ba.put("objectclass", "javaContainer");
            ba.put("cn", alias);
            try {
                String fullAlias = alias;
                if (this.properties.get(NAME_PREFIX) != null && !fullAlias.startsWith((String)this.properties.get(NAME_PREFIX))) {
                    fullAlias = this.properties.get(NAME_PREFIX) + fullAlias;
                }
                ((DirContext)this.cctx).rebind(fullAlias, obj.getObject(), (Attributes)ba);
            }
            catch (NamingException e1) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, CLASSNAME, "rebind(String,AdminObject)", e1, 1);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, CLASSNAME, "rebind(String,AdminObject)", e1, 1);
                }
                throw e1;
            }
        }
        try {
            this.cctx.rebind(alias, obj.getObject());
        }
        catch (NamingException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, CLASSNAME, "rebind(String,AdminObject)", e, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, CLASSNAME, "rebind(String,AdminObject)", e, 2);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "rebind(String,AdminObject)");
        }
    }

    void unbind(String alias) throws NamingException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "unbind(String)", new Object[]{alias});
        }
        if (!this.active) {
            JMSException e = new JMSException(ConfigEnvironment.getMessage("JMSADM4104"));
        }
        try {
            String fullAlias = alias;
            if (this.properties.get(NAME_PREFIX) != null && !fullAlias.startsWith((String)this.properties.get(NAME_PREFIX))) {
                fullAlias = this.properties.get(NAME_PREFIX) + fullAlias;
            }
            this.cctx.unbind(fullAlias);
        }
        catch (NamingException e1) {
            if (Trace.isOn) {
                Trace.catchBlock(this, CLASSNAME, "unbind(String)", e1);
            }
            if (Trace.isOn) {
                Trace.throwing(this, CLASSNAME, "unbind(String)", e1);
            }
            throw e1;
        }
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "unbind(String)");
        }
    }

    void mkContext(String name) throws NamingException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "mkContext(String)", new Object[]{name});
        }
        if (!this.active) {
            JMSException e = new JMSException(ConfigEnvironment.getMessage("JMSADM4104"));
            if (Trace.isOn) {
                Trace.throwing(this, CLASSNAME, "mkContext(String)", e, 1);
            }
            throw e;
        }
        try {
            if (((String)this.properties.get(USE_INITIAL_DIR_CONTEXT)).toUpperCase().equals(ICF_CONFIG_TRUE)) {
                String fullName = name;
                if (fullName.indexOf("=") == -1) {
                    fullName = this.properties.get(NAME_PREFIX) != null ? this.properties.get(NAME_PREFIX) + name : DEFAULT_PREFIX + name;
                }
                try {
                    ((DirContext)this.cctx).createSubcontext(fullName, (Attributes)new BasicAttributes("objectclass", "top"));
                }
                catch (NamingException ne) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, CLASSNAME, "mkContext(String)", ne, 1);
                    }
                    this.cctx.createSubcontext(fullName);
                }
            } else if (((String)this.properties.get(USE_INITIAL_DIR_CONTEXT)).toUpperCase().equals(ICF_CONFIG_FALSE)) {
                this.cctx.createSubcontext(name);
            }
        }
        catch (NamingException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, CLASSNAME, "mkContext(String)", e, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, CLASSNAME, "mkContext(String)", e, 2);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "mkContext(String)");
        }
    }

    void rmContext(String name) throws NamingException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "rmContext(String)", new Object[]{name});
        }
        if (!this.active) {
            JMSException e = new JMSException(ConfigEnvironment.getMessage("JMSADM4104"));
            if (Trace.isOn) {
                Trace.throwing(this, CLASSNAME, "rmContext(String)", e, 1);
            }
            throw e;
        }
        String actualName = name;
        Context test = null;
        try {
            test = (Context)this.cctx.lookup(name);
        }
        catch (ClassCastException e1) {
            if (Trace.isOn) {
                Trace.catchBlock(this, CLASSNAME, "rmContext(String)", e1, 1);
            }
            if (Trace.isOn) {
                Trace.throwing(this, CLASSNAME, "rmContext(String)", e1, 2);
            }
            throw e1;
        }
        catch (NamingException e2) {
            if (Trace.isOn) {
                Trace.catchBlock(this, CLASSNAME, "rmContext(String)", e2, 2);
            }
            if (((String)this.properties.get(USE_INITIAL_DIR_CONTEXT)).toUpperCase().equals(ICF_CONFIG_TRUE)) {
                try {
                    actualName = this.properties.get(NAME_PREFIX) != null ? this.properties.get(NAME_PREFIX) + name : DEFAULT_PREFIX + name;
                    test = (Context)this.cctx.lookup(actualName);
                }
                catch (NamingException e3) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, CLASSNAME, "rmContext(String)", e3, 3);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, CLASSNAME, "rmContext(String)", e3, 3);
                    }
                    throw e3;
                }
            }
            if (Trace.isOn) {
                Trace.throwing(this, CLASSNAME, "rmContext(String)", e2, 4);
            }
            throw e2;
        }
        try {
            this.cctx.destroySubcontext(actualName);
        }
        catch (NamingException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, CLASSNAME, "rmContext(String)", e, 4);
            }
            if (Trace.isOn) {
                Trace.throwing(this, CLASSNAME, "rmContext(String)", e, 5);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "rmContext(String)");
        }
    }

    void chContext(String ctxname) throws NamingException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "chContext(String)", new Object[]{ctxname});
        }
        if (!this.active) {
            JMSException e = new JMSException(ConfigEnvironment.getMessage("JMSADM4104"));
            if (Trace.isOn) {
                Trace.throwing(this, CLASSNAME, "chContext(String)", e, 1);
            }
            throw e;
        }
        if (ctxname.toUpperCase().equals(CTX_INIT)) {
            this.cctx = this.ictx;
            this.cctxString = ConfigEnvironment.getMessage("JMSADM4007");
            this.parentChain = new Vector();
            this.parentChain.addElement(this.cctx);
            this.parentChainString = new Vector();
            this.parentChainString.addElement(ConfigEnvironment.getMessage("JMSADM4007"));
        } else if (ctxname.toUpperCase().equals(CTX_UP)) {
            if (!this.cctx.equals(this.ictx)) {
                this.cctx = (Context)this.parentChain.elementAt(0);
                this.cctxString = (String)this.parentChainString.elementAt(0);
                this.parentChain.removeElementAt(0);
                this.parentChainString.removeElementAt(0);
            }
        } else {
            try {
                if (ctxname.length() == 0 || ctxname.equals(".") || ctxname.equals("..")) {
                    JMSException e = new JMSException("null context");
                    if (Trace.isOn) {
                        Trace.throwing(this, CLASSNAME, "chContext(String)", e, 2);
                    }
                    throw e;
                }
                Context savectx = this.cctx;
                this.cctx = (Context)this.cctx.lookup(ctxname);
                this.parentChain.insertElementAt(savectx, 0);
                this.parentChainString.insertElementAt(ctxname, 0);
            }
            catch (NamingException e1) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, CLASSNAME, "chContext(String)", e1, 1);
                }
                if (((String)this.properties.get(USE_INITIAL_DIR_CONTEXT)).toUpperCase().equals(ICF_CONFIG_TRUE)) {
                    try {
                        String prefix = (String)this.properties.get(NAME_PREFIX);
                        if (prefix == null) {
                            prefix = DEFAULT_PREFIX;
                        }
                        Context savectx = this.cctx;
                        this.cctx = (Context)this.cctx.lookup(prefix + ctxname);
                        this.parentChain.insertElementAt(savectx, 0);
                        this.parentChainString.insertElementAt(prefix + ctxname, 0);
                    }
                    catch (NamingException e2) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, CLASSNAME, "chContext(String)", e2, 2);
                        }
                        if (Trace.isOn) {
                            Trace.throwing(this, CLASSNAME, "chContext(String)", e2, 3);
                        }
                        throw e2;
                    }
                }
                if (Trace.isOn) {
                    Trace.throwing(this, CLASSNAME, "chContext(String)", e1, 4);
                }
                throw e1;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "chContext(String)");
        }
    }

    boolean isActive() {
        if (Trace.isOn) {
            Trace.data(this, CLASSNAME, "isActive()", "getter", this.active);
        }
        return this.active;
    }

    String getCctxString() {
        if (Trace.isOn) {
            Trace.data(this, CLASSNAME, "getCctxString()", "getter", this.cctxString);
        }
        return this.cctxString;
    }

    String getPathString() {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "getPathString()");
        }
        StringBuffer path = new StringBuffer();
        for (int i = this.parentChainString.size() - 1; i >= 0; --i) {
            if (i != this.parentChainString.size() - 1) {
                path.append("/");
            }
            path.append((String)this.parentChainString.elementAt(i));
        }
        String traceRet1 = new String(path);
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "getPathString()", traceRet1);
        }
        return traceRet1;
    }

    Context getIctx() {
        if (Trace.isOn) {
            Trace.data(this, CLASSNAME, "getIctx()", "getter", this.ictx);
        }
        return this.ictx;
    }

    String getICF() {
        if (Trace.isOn) {
            Trace.data(this, CLASSNAME, "getICF()", "getter", this.initialContextFactory);
        }
        return this.initialContextFactory;
    }

    String getPURL() {
        if (Trace.isOn) {
            Trace.data(this, CLASSNAME, "getPURL()", "getter", this.providerURL);
        }
        return this.providerURL;
    }

    int getAuth() {
        if (Trace.isOn) {
            Trace.data(this, CLASSNAME, "getAuth()", "getter", new Integer(this.authentication));
        }
        return this.authentication;
    }

    public void setICFProperties() {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "setICFProperties()");
        }
        String[] defaults_LDAP = new String[]{ICF_CONFIG_TRUE, DEFAULT_PREFIX, null};
        String[] defaults_WEBSPHERE = new String[]{ICF_CONFIG_FALSE, null, ".."};
        String[] defaults_FS = new String[]{ICF_CONFIG_FALSE, null, null};
        String[] current_defaults = null;
        if (this.initialContextFactory.equals("com.sun.jndi.ldap.LdapCtxFactory") || this.initialContextFactory.equals("com.ibm.jndi.LDAPCtxFactory")) {
            current_defaults = defaults_LDAP;
        } else if (this.initialContextFactory.equals("com.sun.jndi.fscontext.RefFSContextFactory")) {
            current_defaults = defaults_FS;
        } else if (this.initialContextFactory.equals("com.ibm.ejs.ns.jndi.CNInitialContextFactory") || this.initialContextFactory.equals("com.ibm.websphere.naming.WsnInitialContextFactory") || this.initialContextFactory.equals("com.ibm.ws.naming.ldap.WsnLdapInitialContextFactory")) {
            current_defaults = defaults_WEBSPHERE;
        } else if (this.initialContextFactory.toUpperCase().indexOf("LDAP") > -1) {
            current_defaults = defaults_LDAP;
        }
        if (current_defaults != null) {
            if (this.properties.get(USE_INITIAL_DIR_CONTEXT) == null) {
                this.properties.put(USE_INITIAL_DIR_CONTEXT, current_defaults[0]);
            }
            if (this.properties.get(NAME_PREFIX) == null && current_defaults[1] != null) {
                this.properties.put(NAME_PREFIX, current_defaults[1]);
            }
            if (this.properties.get(NAME_READABILITY) == null && current_defaults[2] != null) {
                this.properties.put(NAME_READABILITY, current_defaults[2]);
            }
        } else {
            String icfProp;
            if (this.properties.get(USE_INITIAL_DIR_CONTEXT) == null) {
                this.properties.put(USE_INITIAL_DIR_CONTEXT, ICF_CONFIG_FALSE);
            }
            if (this.properties.get(NAME_PREFIX) == null && (icfProp = (String)this.properties.get(USE_INITIAL_DIR_CONTEXT)).toUpperCase().equals(ICF_CONFIG_TRUE)) {
                this.properties.put(NAME_PREFIX, DEFAULT_PREFIX);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, CLASSNAME, "setICFProperties()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getNamePrefix() {
        if (Trace.isOn) {
            Trace.entry(this, CLASSNAME, "getNamePrefix()");
        }
        try {
            String traceRet1 = (String)this.properties.get(NAME_PREFIX);
            if (Trace.isOn) {
                Trace.exit(this, CLASSNAME, "getNamePrefix()", traceRet1, 1);
            }
            String string = traceRet1;
            return string;
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, CLASSNAME, "getNamePrefix()", e);
            }
            if (Trace.isOn) {
                Trace.exit(this, CLASSNAME, "getNamePrefix()", null, 2);
            }
            String string = null;
            return string;
        }
        finally {
            if (Trace.isOn) {
                Trace.finallyBlock(this, CLASSNAME, "getNamePrefix()");
            }
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data(CLASSNAME, "static", "SCCS id", (Object)sccsid);
        }
    }
}

