/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.admin;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.admin.AP;
import com.ibm.mq.jms.admin.BAOException;
import com.ibm.mq.jms.admin.ConfigEnvironment;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.util.Hashtable;
import javax.jms.JMSException;

public class APPRDUR
extends AP {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.mq.jms.admin/src/com/ibm/mq/jms/admin/APPRDUR.java, jmscc.admin, k701, k701-112-140304  1.15.1.1 09/08/17 09:21:32";
    private static final String CLASSNAME = "APPRDUR";
    public static final String LONGNAME = "PROCESSDURATION";
    public static final String SHORTNAME = "PROCDUR";
    public static final String PROCESSING_SHORT = "SHORT";
    public static final String PROCESSING_UNKNOWN = "UNKNOWN";
    public static final String PROCESSING_DEFAULT = "DEFAULT";

    public void setObjectFromProperty(Object obj, Hashtable props) throws BAOException, JMSException {
        block19: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.mq.jms.admin.APPRDUR", "setObjectFromProperty(Object,Hashtable)", new Object[]{obj, props});
            }
            try {
                Object value = APPRDUR.getProperty(SHORTNAME, props);
                if (value == null) break block19;
                int iVal = APPRDUR.objToInt(value);
                if (obj instanceof MQTopicConnectionFactory || obj instanceof MQConnectionFactory) {
                    try {
                        ((MQConnectionFactory)obj).setProcessDuration(iVal);
                        break block19;
                    }
                    catch (JMSException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.mq.jms.admin.APPRDUR", "setObjectFromProperty(Object,Hashtable)", e, 1);
                        }
                        BAOException be = new BAOException(4, SHORTNAME, Integer.toString(iVal));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.mq.jms.admin.APPRDUR", "setObjectFromProperty(Object,Hashtable)", be, 1);
                        }
                        throw be;
                    }
                }
                String detail = "object supplied as an unexpected type " + obj.getClass();
                String key = "JMSADM1016";
                String msg = ConfigEnvironment.getErrorMessage(key, detail);
                JMSException iee = new JMSException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.mq.jms.admin.APPRDUR", "setObjectFromProperty(Object,Hashtable)", iee, 2);
                }
                throw iee;
            }
            catch (BAOException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.mq.jms.admin.APPRDUR", "setObjectFromProperty(Object,Hashtable)", e, 2);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.mq.jms.admin.APPRDUR", "setObjectFromProperty(Object,Hashtable)", e, 3);
                }
                throw e;
            }
            catch (JMSException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.mq.jms.admin.APPRDUR", "setObjectFromProperty(Object,Hashtable)", e, 3);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.mq.jms.admin.APPRDUR", "setObjectFromProperty(Object,Hashtable)", e, 4);
                }
                throw e;
            }
            finally {
                if (Trace.isOn) {
                    Trace.finallyBlock(this, "com.ibm.mq.jms.admin.APPRDUR", "setObjectFromProperty(Object,Hashtable)");
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.admin.APPRDUR", "setObjectFromProperty(Object,Hashtable)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyFromObject(Hashtable props, Object obj) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.admin.APPRDUR", "setPropertyFromObject(Hashtable,Object)", new Object[]{props, obj});
        }
        try {
            if (!(obj instanceof MQTopicConnectionFactory) && !(obj instanceof MQConnectionFactory)) {
                String detail = "object is an unexpected type";
                String key = "JMSADM1016";
                String msg = ConfigEnvironment.getErrorMessage(key, detail);
                JMSException iee = new JMSException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.mq.jms.admin.APPRDUR", "setPropertyFromObject(Hashtable,Object)", iee);
                }
                throw iee;
            }
            int i = ((MQConnectionFactory)obj).getProcessDuration();
            String value = APPRDUR.valToString(i);
            props.put(LONGNAME, value);
        }
        finally {
            if (Trace.isOn) {
                Trace.finallyBlock(this, "com.ibm.mq.jms.admin.APPRDUR", "setPropertyFromObject(Hashtable,Object)");
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.admin.APPRDUR", "setPropertyFromObject(Hashtable,Object)");
        }
    }

    public String longName() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.admin.APPRDUR", "longName()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.admin.APPRDUR", "longName()", LONGNAME);
        }
        return LONGNAME;
    }

    public String shortName() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.admin.APPRDUR", "shortName()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.admin.APPRDUR", "shortName()", SHORTNAME);
        }
        return SHORTNAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static int objToInt(Object value) throws BAOException, JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.admin.APPRDUR", "objToInt(Object)", new Object[]{value});
        }
        try {
            void var1_1;
            int iVal;
            if (value instanceof Integer) {
                iVal = (Integer)value;
            } else if (value instanceof String) {
                String str = (String)value;
                iVal = APPRDUR.stringToVal(str);
            } else {
                String detail = "value supplied as an unexpected object type";
                String key = "JMSADM1016";
                String msg = ConfigEnvironment.getErrorMessage(key, detail);
                JMSException iee = new JMSException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.mq.jms.admin.APPRDUR", "objToInt(Object)", iee);
                }
                throw iee;
            }
            if (Trace.isOn) {
                Trace.exit("com.ibm.mq.jms.admin.APPRDUR", "objToInt(Object)", new Integer((int)var1_1));
            }
            void var2_4 = var1_1;
            return (int)var2_4;
        }
        finally {
            if (Trace.isOn) {
                Trace.finallyBlock("com.ibm.mq.jms.admin.APPRDUR", "objToInt(Object)");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int stringToVal(String s) throws BAOException {
        void var1_2;
        boolean iVal;
        String str;
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.admin.APPRDUR", "stringToVal(String)", new Object[]{s});
        }
        if ((str = s.toUpperCase()).equals(PROCESSING_SHORT)) {
            iVal = true;
        } else if (str.equals(PROCESSING_UNKNOWN)) {
            iVal = false;
        } else if (str.equals(PROCESSING_DEFAULT)) {
            iVal = false;
        } else {
            BAOException traceRet1 = new BAOException(4, SHORTNAME, str);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.mq.jms.admin.APPRDUR", "stringToVal(String)", traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.admin.APPRDUR", "stringToVal(String)", new Integer((int)var1_2));
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String valToString(int i) throws JMSException {
        void var1_1;
        String sVal;
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.admin.APPRDUR", "valToString(int)", new Object[]{new Integer(i)});
        }
        if (i == 0) {
            sVal = PROCESSING_UNKNOWN;
        } else if (i == 1) {
            sVal = PROCESSING_SHORT;
        } else if (i == 0) {
            sVal = PROCESSING_DEFAULT;
        } else {
            String detail = "broker version unexpected value " + i;
            String key = "JMSADM1016";
            String msg = ConfigEnvironment.getErrorMessage(key, detail);
            JMSException iee = new JMSException(msg, key);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.mq.jms.admin.APPRDUR", "valToString(int)", iee);
            }
            throw iee;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.admin.APPRDUR", "valToString(int)", var1_1);
        }
        return var1_1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.admin.APPRDUR", "static", "SCCS id", (Object)sccsid);
        }
    }
}

