/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.admin;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.admin.AP;
import com.ibm.mq.jms.admin.BAOException;
import com.ibm.mq.jms.admin.ConfigEnvironment;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.util.Hashtable;
import javax.jms.JMSException;

public class APFIQ
extends AP {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.mq.jms.admin/src/com/ibm/mq/jms/admin/APFIQ.java, jmscc.admin, k701, k701-112-140304  1.15.1.1 09/08/17 09:17:59";
    public static final String LONGNAME = "FAILIFQUIESCE";
    public static final String SHORTNAME = "FIQ";
    public static final String YES = "YES";
    public static final String NO = "NO";

    public static String valToString(int fiq) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.admin.APFIQ", "valToString(int)", new Object[]{new Integer(fiq)});
        }
        String sVal = fiq == 1 ? YES : NO;
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.admin.APFIQ", "valToString(int)", (Object)sVal);
        }
        return sVal;
    }

    /*
     * WARNING - void declaration
     */
    public static int stringToVal(String s) throws BAOException {
        void var1_2;
        boolean iVal;
        String str;
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.admin.APFIQ", "stringToVal(String)", new Object[]{s});
        }
        if ((str = s.toUpperCase()).equals(NO)) {
            iVal = false;
        } else if (str.equals(YES)) {
            iVal = true;
        } else {
            BAOException traceRet1 = new BAOException(4, SHORTNAME, str);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.mq.jms.admin.APFIQ", "stringToVal(String)", traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.admin.APFIQ", "stringToVal(String)", new Integer((int)var1_2));
        }
        return (int)var1_2;
    }

    public void setObjectFromProperty(Object obj, Hashtable props) throws BAOException, JMSException {
        block20: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.mq.jms.admin.APFIQ", "setObjectFromProperty(Object,Hashtable)", new Object[]{obj, props});
            }
            try {
                Object value = APFIQ.getProperty(SHORTNAME, props);
                int iVal = 0;
                if (value == null) break block20;
                if (value instanceof Integer) {
                    iVal = (Integer)value;
                } else if (value instanceof String) {
                    String str = (String)value;
                    iVal = APFIQ.stringToVal(str);
                } else if (value instanceof Boolean) {
                    boolean bVal = (Boolean)value;
                    iVal = bVal ? 1 : 0;
                } else {
                    String detail = "value supplied as an unexpected object type " + value.getClass();
                    String key = "JMSADM1016";
                    String msg = ConfigEnvironment.getErrorMessage(key, detail);
                    JMSException iee = new JMSException(msg, key);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.mq.jms.admin.APFIQ", "setObjectFromProperty(Object,Hashtable)", iee, 1);
                    }
                    throw iee;
                }
                if (obj instanceof MQConnectionFactory) {
                    ((MQConnectionFactory)obj).setFailIfQuiesce(iVal);
                    break block20;
                }
                if (obj instanceof MQDestination) {
                    ((MQDestination)obj).setFailIfQuiesce(iVal);
                    break block20;
                }
                String detail = "object supplied as an unexpected type" + obj.getClass();
                String key = "JMSADM1016";
                String msg = ConfigEnvironment.getErrorMessage(key, detail);
                JMSException iee = new JMSException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.mq.jms.admin.APFIQ", "setObjectFromProperty(Object,Hashtable)", iee, 2);
                }
                throw iee;
            }
            catch (JMSException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.mq.jms.admin.APFIQ", "setObjectFromProperty(Object,Hashtable)", e);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.mq.jms.admin.APFIQ", "setObjectFromProperty(Object,Hashtable)", e, 3);
                }
                throw e;
            }
            finally {
                if (Trace.isOn) {
                    Trace.finallyBlock(this, "com.ibm.mq.jms.admin.APFIQ", "setObjectFromProperty(Object,Hashtable)");
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.admin.APFIQ", "setObjectFromProperty(Object,Hashtable)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setPropertyFromObject(Hashtable props, Object obj) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.admin.APFIQ", "setPropertyFromObject(Hashtable,Object)", new Object[]{props, obj});
        }
        try {
            void var3_6;
            String sVal;
            if (obj instanceof MQConnectionFactory) {
                int fiq = ((MQConnectionFactory)obj).getFailIfQuiesce();
                sVal = APFIQ.valToString(fiq);
            } else if (obj instanceof MQDestination) {
                int fiq = ((MQDestination)obj).getFailIfQuiesce();
                sVal = APFIQ.valToString(fiq);
            } else {
                String detail = "object is an unexpected type";
                String key = "JMSADM1016";
                String msg = ConfigEnvironment.getErrorMessage(key, detail);
                JMSException iee = new JMSException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.mq.jms.admin.APFIQ", "setPropertyFromObject(Hashtable,Object)", iee);
                }
                throw iee;
            }
            if (var3_6 != null) {
                props.put(LONGNAME, var3_6);
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.finallyBlock(this, "com.ibm.mq.jms.admin.APFIQ", "setPropertyFromObject(Hashtable,Object)");
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.admin.APFIQ", "setPropertyFromObject(Hashtable,Object)");
        }
    }

    public String longName() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.admin.APFIQ", "longName()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.admin.APFIQ", "longName()", LONGNAME);
        }
        return LONGNAME;
    }

    public String shortName() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.admin.APFIQ", "shortName()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.admin.APFIQ", "shortName()", SHORTNAME);
        }
        return SHORTNAME;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.admin.APFIQ", "static", "SCCS id", (Object)sccsid);
        }
    }
}

