/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.admin;

import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.admin.AP;
import com.ibm.mq.jms.admin.BAOException;
import com.ibm.mq.jms.admin.ConfigEnvironment;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.util.Hashtable;
import javax.jms.JMSException;

public class APEXP
extends AP {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.mq.jms.admin/src/com/ibm/mq/jms/admin/APEXP.java, jmscc.admin, k701, k701-112-140304  1.15.1.1 09/08/17 09:17:48";
    public static final String LONGNAME = "EXPIRY";
    public static final String SHORTNAME = "EXP";
    public static final String EXP_APP = "APP";
    public static final String EXP_UNLIMITED = "UNLIM";

    /*
     * WARNING - void declaration
     */
    public void setObjectFromProperty(Object obj, Hashtable props) throws BAOException, JMSException {
        block32: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.mq.jms.admin.APEXP", "setObjectFromProperty(Object,Hashtable)", new Object[]{obj, props});
            }
            try {
                long exp;
                Object value = APEXP.getProperty(SHORTNAME, props);
                if (value == null) break block32;
                if (value instanceof Long) {
                    exp = (Long)value;
                } else if (value instanceof String) {
                    String str = ((String)value).toUpperCase();
                    if (str.equals(EXP_APP)) {
                        exp = -2L;
                    } else if (str.equals(EXP_UNLIMITED)) {
                        exp = 0L;
                    } else {
                        try {
                            exp = Long.parseLong(str);
                        }
                        catch (NumberFormatException e) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.mq.jms.admin.APEXP", "setObjectFromProperty(Object,Hashtable)", e, 1);
                            }
                            BAOException be = new BAOException(4, SHORTNAME, str);
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.mq.jms.admin.APEXP", "setObjectFromProperty(Object,Hashtable)", be, 1);
                            }
                            throw be;
                        }
                    }
                } else {
                    String detail = "value supplied as an unexpected object type " + value.getClass();
                    String key = "JMSADM1016";
                    String msg = ConfigEnvironment.getErrorMessage(key, detail);
                    JMSException iee = new JMSException(msg, key);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.mq.jms.admin.APEXP", "setObjectFromProperty(Object,Hashtable)", iee, 2);
                    }
                    throw iee;
                }
                if (obj instanceof MQDestination) {
                    void var4_6;
                    try {
                        ((MQDestination)obj).setExpiry((long)var4_6);
                        break block32;
                    }
                    catch (JMSException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.mq.jms.admin.APEXP", "setObjectFromProperty(Object,Hashtable)", e, 2);
                        }
                        BAOException be = new BAOException(4, SHORTNAME, Long.toString((long)var4_6));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.mq.jms.admin.APEXP", "setObjectFromProperty(Object,Hashtable)", be, 3);
                        }
                        throw be;
                    }
                }
                String detail = "object supplied as an unexpected type " + obj.getClass();
                String key = "JMSADM1016";
                String msg = ConfigEnvironment.getErrorMessage(key, detail);
                JMSException iee = new JMSException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.mq.jms.admin.APEXP", "setObjectFromProperty(Object,Hashtable)", iee, 4);
                }
                throw iee;
            }
            catch (BAOException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.mq.jms.admin.APEXP", "setObjectFromProperty(Object,Hashtable)", e, 3);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.mq.jms.admin.APEXP", "setObjectFromProperty(Object,Hashtable)", e, 5);
                }
                throw e;
            }
            catch (JMSException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.mq.jms.admin.APEXP", "setObjectFromProperty(Object,Hashtable)", e, 4);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.mq.jms.admin.APEXP", "setObjectFromProperty(Object,Hashtable)", e, 6);
                }
                throw e;
            }
            finally {
                if (Trace.isOn) {
                    Trace.finallyBlock(this, "com.ibm.mq.jms.admin.APEXP", "setObjectFromProperty(Object,Hashtable)");
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.admin.APEXP", "setObjectFromProperty(Object,Hashtable)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyFromObject(Hashtable props, Object obj) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.admin.APEXP", "setPropertyFromObject(Hashtable,Object)", new Object[]{props, obj});
        }
        try {
            if (!(obj instanceof MQDestination)) {
                String detail = "object is an unexpected type";
                String key = "JMSADM1016";
                String msg = ConfigEnvironment.getErrorMessage(key, detail);
                JMSException iee = new JMSException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.mq.jms.admin.APEXP", "setPropertyFromObject(Hashtable,Object)", iee);
                }
                throw iee;
            }
            long exp = ((MQDestination)obj).getExpiry();
            String value = APEXP.valToString(exp);
            props.put(LONGNAME, value);
        }
        finally {
            if (Trace.isOn) {
                Trace.finallyBlock(this, "com.ibm.mq.jms.admin.APEXP", "setPropertyFromObject(Hashtable,Object)");
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.admin.APEXP", "setPropertyFromObject(Hashtable,Object)");
        }
    }

    public String longName() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.admin.APEXP", "longName()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.admin.APEXP", "longName()", LONGNAME);
        }
        return LONGNAME;
    }

    public String shortName() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.admin.APEXP", "shortName()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.admin.APEXP", "shortName()", SHORTNAME);
        }
        return SHORTNAME;
    }

    public static String valToString(long exp) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.admin.APEXP", "valToString(long)", new Object[]{new Long(exp)});
        }
        String s = exp == -2L ? EXP_APP : (exp == 0L ? EXP_UNLIMITED : String.valueOf(exp));
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.admin.APEXP", "valToString(long)", (Object)s);
        }
        return s;
    }

    /*
     * WARNING - void declaration
     */
    public static long stringToVal(String s) throws BAOException {
        void var1_2;
        long exp;
        String str;
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.admin.APEXP", "stringToVal(String)", new Object[]{s});
        }
        if ((str = s.toUpperCase()).equals(EXP_APP)) {
            exp = -2L;
        } else if (str.equals(EXP_UNLIMITED)) {
            exp = 0L;
        } else {
            try {
                exp = Long.parseLong(str);
            }
            catch (NumberFormatException e) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.mq.jms.admin.APEXP", "stringToVal(String)", e);
                }
                BAOException be = new BAOException(4, SHORTNAME, str);
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.mq.jms.admin.APEXP", "stringToVal(String)", be);
                }
                throw be;
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.admin.APEXP", "stringToVal(String)", new Long((long)var1_2));
        }
        return (long)var1_2;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.admin.APEXP", "static", "SCCS id", (Object)sccsid);
        }
    }
}

