/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.admin;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.admin.AP;
import com.ibm.mq.jms.admin.BAOException;
import com.ibm.mq.jms.admin.ConfigEnvironment;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.jms.JMSException;

public class APCNOPT
extends AP {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.mq.jms.admin/src/com/ibm/mq/jms/admin/APCNOPT.java, jmscc.admin, k701, k701-112-140304  1.15.1.1 09/08/17 09:16:49";
    public static final String LONGNAME = "CONNOPT";
    public static final String SHORTNAME = "CNOPT";
    private static final String RESTRICTQM = "RESTRICTQM";
    private static final String RESTRICTQSG = "RESTRICTQSG";
    private static final String SERIALQM = "SERIALQM";
    private static final String SERIALQSG = "SERIALQSG";
    private static final String STANDARD = "STANDARD";
    private static final String FASTPATH = "FASTPATH";
    private static final String SHARED = "SHARED";
    private static final String ISOLATED = "ISOLATED";

    public static String valToString(int mret) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.admin.APCNOPT", "valToString(int)", new Object[]{new Integer(mret)});
        }
        String sVal = "";
        if ((mret & 8) != 0) {
            sVal = sVal + "RESTRICTQM ";
        }
        if ((mret & 0x10) != 0) {
            sVal = sVal + "RESTRICTQSG ";
        }
        if ((mret & 2) != 0) {
            sVal = sVal + "SERIALQM ";
        }
        if ((mret & 4) != 0) {
            sVal = sVal + "SERIALQSG ";
        }
        if ((mret & 1) != 0) {
            sVal = sVal + "FASTPATH ";
        }
        if ((mret & 0x100) != 0) {
            sVal = sVal + "SHARED ";
        }
        if ((mret & 0x200) != 0) {
            sVal = sVal + "ISOLATED ";
        }
        if (sVal.indexOf(FASTPATH) == -1 && sVal.indexOf(SHARED) == -1 && sVal.indexOf(ISOLATED) == -1) {
            sVal = sVal + STANDARD;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.admin.APCNOPT", "valToString(int)", (Object)sVal);
        }
        return sVal;
    }

    public static int stringToVal(String s) throws BAOException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.admin.APCNOPT", "stringToVal(String)", new Object[]{s});
        }
        int iVal = 0;
        StringTokenizer st = new StringTokenizer(s.toUpperCase());
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            if (str.equals(RESTRICTQM)) {
                iVal |= 8;
                continue;
            }
            if (str.equals(RESTRICTQSG)) {
                iVal |= 0x10;
                continue;
            }
            if (str.equals(SERIALQM)) {
                iVal |= 2;
                continue;
            }
            if (str.equals(SERIALQSG)) {
                iVal |= 4;
                continue;
            }
            if (str.equals(STANDARD)) {
                iVal |= 0;
                continue;
            }
            if (str.equals(FASTPATH)) {
                iVal |= 1;
                continue;
            }
            if (str.equals(SHARED)) {
                iVal |= 0x100;
                continue;
            }
            if (str.equals(ISOLATED)) {
                iVal |= 0x200;
                continue;
            }
            BAOException traceRet1 = new BAOException(4, SHORTNAME, str);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.mq.jms.admin.APCNOPT", "stringToVal(String)", traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.admin.APCNOPT", "stringToVal(String)", new Integer(iVal));
        }
        return iVal;
    }

    /*
     * WARNING - void declaration
     */
    public void setObjectFromProperty(Object obj, Hashtable props) throws BAOException, JMSException {
        block24: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.mq.jms.admin.APCNOPT", "setObjectFromProperty(Object,Hashtable)", new Object[]{obj, props});
            }
            try {
                int iVal;
                Object value = APCNOPT.getProperty(SHORTNAME, props);
                if (value == null) break block24;
                if (value instanceof Integer) {
                    iVal = (Integer)value;
                } else if (value instanceof String) {
                    String str = (String)value;
                    iVal = APCNOPT.stringToVal(str);
                } else {
                    String detail = "value supplied as an unexpected object type " + value.getClass();
                    String key = "JMSADM1016";
                    String msg = ConfigEnvironment.getErrorMessage(key, detail);
                    JMSException iee = new JMSException(msg, key);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.mq.jms.admin.APCNOPT", "setObjectFromProperty(Object,Hashtable)", iee, 1);
                    }
                    throw iee;
                }
                if (obj instanceof MQConnectionFactory) {
                    void var4_6;
                    try {
                        ((MQConnectionFactory)obj).setMQConnectionOptions((int)var4_6);
                        break block24;
                    }
                    catch (JMSException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.mq.jms.admin.APCNOPT", "setObjectFromProperty(Object,Hashtable)", e, 1);
                        }
                        BAOException be = new BAOException(4, SHORTNAME, APCNOPT.valToString((int)var4_6));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.mq.jms.admin.APCNOPT", "setObjectFromProperty(Object,Hashtable)", be, 2);
                        }
                        throw be;
                    }
                }
                String detail = "object supplied as an unexpected type " + obj.getClass();
                String key = "JMSADM1016";
                String msg = ConfigEnvironment.getErrorMessage(key, detail);
                JMSException iee = new JMSException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.mq.jms.admin.APCNOPT", "setObjectFromProperty(Object,Hashtable)", iee, 3);
                }
                throw iee;
            }
            catch (BAOException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.mq.jms.admin.APCNOPT", "setObjectFromProperty(Object,Hashtable)", e, 2);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.mq.jms.admin.APCNOPT", "setObjectFromProperty(Object,Hashtable)", e, 4);
                }
                throw e;
            }
            catch (JMSException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.mq.jms.admin.APCNOPT", "setObjectFromProperty(Object,Hashtable)", e, 3);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.mq.jms.admin.APCNOPT", "setObjectFromProperty(Object,Hashtable)", e, 5);
                }
                throw e;
            }
            finally {
                if (Trace.isOn) {
                    Trace.finallyBlock(this, "com.ibm.mq.jms.admin.APCNOPT", "setObjectFromProperty(Object,Hashtable)");
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.admin.APCNOPT", "setObjectFromProperty(Object,Hashtable)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyFromObject(Hashtable props, Object obj) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.admin.APCNOPT", "setPropertyFromObject(Hashtable,Object)", new Object[]{props, obj});
        }
        try {
            if (!(obj instanceof MQConnectionFactory)) {
                String detail = "object is an unexpected type";
                String key = "JMSADM1016";
                String msg = ConfigEnvironment.getErrorMessage(key, detail);
                JMSException iee = new JMSException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.mq.jms.admin.APCNOPT", "setPropertyFromObject(Hashtable,Object)", iee);
                }
                throw iee;
            }
            int mret = ((MQConnectionFactory)obj).getMQConnectionOptions();
            String sVal = APCNOPT.valToString(mret);
            if (sVal != null && sVal != "") {
                props.put(LONGNAME, sVal);
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.finallyBlock(this, "com.ibm.mq.jms.admin.APCNOPT", "setPropertyFromObject(Hashtable,Object)");
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.admin.APCNOPT", "setPropertyFromObject(Hashtable,Object)");
        }
    }

    public String longName() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.admin.APCNOPT", "longName()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.admin.APCNOPT", "longName()", LONGNAME);
        }
        return LONGNAME;
    }

    public String shortName() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.admin.APCNOPT", "shortName()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.admin.APCNOPT", "shortName()", SHORTNAME);
        }
        return SHORTNAME;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.admin.APCNOPT", "static", "SCCS id", (Object)sccsid);
        }
    }
}

