/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicSession;
import com.ibm.mq.jms.MQXASession;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsSession;
import com.ibm.msg.client.jms.JmsTopicSession;
import com.ibm.msg.client.jms.JmsXATopicSession;
import com.ibm.msg.client.jms.internal.JmsXATopicSessionImpl;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XATopicSession;

public class MQXATopicSession
extends MQXASession
implements XATopicSession,
JmsXATopicSession {
    private static final long serialVersionUID = 6705131420655754176L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    MQXATopicSession() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQXATopicSession", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQXATopicSession", "<init>()");
        }
    }

    public TopicSession getTopicSession() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQXATopicSession", "getTopicSession()");
        }
        if (null == this.backingSession) {
            JmsSession js = this.getDelegate();
            JmsXATopicSessionImpl jxtsi = (JmsXATopicSessionImpl)js;
            JmsTopicSession backingDelegate = (JmsTopicSession)jxtsi.getTopicSession();
            this.backingSession = new MQTopicSession();
            this.backingSession.setDelegate(backingDelegate);
        }
        MQTopicSession traceRet1 = (MQTopicSession)this.backingSession;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQXATopicSession", "getTopicSession()", traceRet1);
        }
        return traceRet1;
    }

    public Session getSession() throws JMSException {
        TopicSession traceRet1 = this.getTopicSession();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQXATopicSession", "getSession()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQXATopicSession", "createConsumer(Destination)", new Object[]{destination});
        }
        this.checkConsumerDestinationIsTopic(destination);
        TopicSubscriber consumer = this.getTopicSession().createSubscriber((Topic)((MQTopic)destination));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQXATopicSession", "createConsumer(Destination)", consumer);
        }
        return consumer;
    }

    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQXATopicSession", "createConsumer(Destination,String)", new Object[]{destination, selector});
        }
        this.checkConsumerDestinationIsTopic(destination);
        TopicSubscriber consumer = this.getTopicSession().createSubscriber((Topic)((MQTopic)destination), selector, false);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQXATopicSession", "createConsumer(Destination,String)", consumer);
        }
        return consumer;
    }

    public MessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQXATopicSession", "createConsumer(Destination,String,boolean)", new Object[]{destination, selector, noLocal});
        }
        this.checkConsumerDestinationIsTopic(destination);
        TopicSubscriber consumer = this.getTopicSession().createSubscriber((Topic)((MQTopic)destination), selector, noLocal);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQXATopicSession", "createConsumer(Destination,String,boolean)", consumer);
        }
        return consumer;
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQXATopicSession", "createProducer(Destination)", new Object[]{destination});
        }
        this.checkProducerDestinationIsTopic(destination);
        TopicPublisher producer = this.getTopicSession().createPublisher((Topic)((MQTopic)destination));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQXATopicSession", "createProducer(Destination)", producer);
        }
        return producer;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.MQXATopicSession", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQXATopicSession.java, jmscc.migration.wmq, k701, k701-112-140304  1.29.1.1 09/08/17 09:04:12");
        }
    }
}

