/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQQueueSession;
import com.ibm.mq.jms.MQXASession;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsQueueSession;
import com.ibm.msg.client.jms.JmsSession;
import com.ibm.msg.client.jms.JmsXAQueueSession;
import com.ibm.msg.client.jms.internal.JmsXAQueueSessionImpl;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.XAQueueSession;

public class MQXAQueueSession
extends MQXASession
implements XAQueueSession,
JmsXAQueueSession {
    private static final long serialVersionUID = 7598406145196537989L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    MQXAQueueSession() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQXAQueueSession", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQXAQueueSession", "<init>()");
        }
    }

    public QueueSession getQueueSession() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQXAQueueSession", "getQueueSession()");
        }
        if (null == this.backingSession) {
            JmsSession js = this.getDelegate();
            JmsXAQueueSessionImpl jxqsi = (JmsXAQueueSessionImpl)js;
            JmsQueueSession backingDelegate = (JmsQueueSession)jxqsi.getQueueSession();
            this.backingSession = new MQQueueSession();
            this.backingSession.setDelegate(backingDelegate);
        }
        MQQueueSession traceRet1 = (MQQueueSession)this.backingSession;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQXAQueueSession", "getQueueSession()", traceRet1);
        }
        return traceRet1;
    }

    public Session getSession() throws JMSException {
        QueueSession traceRet1 = this.getQueueSession();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQXAQueueSession", "getSession()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQXAQueueSession", "createConsumer(Destination)", new Object[]{destination});
        }
        this.checkConsumerDestinationIsQueue(destination);
        QueueReceiver consumer = this.getQueueSession().createReceiver((Queue)((MQQueue)destination));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQXAQueueSession", "createConsumer(Destination)", consumer);
        }
        return consumer;
    }

    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQXAQueueSession", "createConsumer(Destination,String)", new Object[]{destination, selector});
        }
        this.checkConsumerDestinationIsQueue(destination);
        QueueReceiver consumer = this.getQueueSession().createReceiver((Queue)((MQQueue)destination), selector);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQXAQueueSession", "createConsumer(Destination,String)", consumer);
        }
        return consumer;
    }

    public MessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQXAQueueSession", "createConsumer(Destination,String,boolean)", new Object[]{destination, selector, noLocal});
        }
        this.checkConsumerDestinationIsQueue(destination);
        QueueReceiver consumer = this.getQueueSession().createReceiver((Queue)((MQQueue)destination), selector);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQXAQueueSession", "createConsumer(Destination,String,boolean)", consumer);
        }
        return consumer;
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQXAQueueSession", "createProducer(Destination)", new Object[]{destination});
        }
        this.checkProducerDestinationIsQueue(destination);
        QueueSender producer = this.getQueueSession().createSender((Queue)((MQQueue)destination));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQXAQueueSession", "createProducer(Destination)", producer);
        }
        return producer;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.MQXAQueueSession", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQXAQueueSession.java, jmscc.migration.wmq, k701, k701-112-140304  1.29.1.1 09/08/17 09:03:25");
        }
    }
}

