/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicPublisher;
import com.ibm.mq.jms.MQTopicSubscriber;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsTopic;
import com.ibm.msg.client.jms.JmsTopicPublisher;
import com.ibm.msg.client.jms.JmsTopicSession;
import com.ibm.msg.client.jms.JmsTopicSubscriber;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class MQTopicSession
extends MQSession
implements TopicSession,
JmsTopicSession {
    private static final long serialVersionUID = -2575226792235452790L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    MQTopicSession() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopicSession", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQTopicSession", "<init>()");
        }
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopicSession", "createPublisher(Topic)", new Object[]{topic});
        }
        JmsTopic theTopic = null;
        if (topic != null) {
            theTopic = (JmsTopic)((MQTopic)topic).validateDestination();
        }
        MQTopicPublisher wrapper = new MQTopicPublisher();
        wrapper.setDelegate((JmsTopicPublisher)((JmsTopicSession)this.commonSess).createPublisher(theTopic));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQTopicSession", "createPublisher(Topic)", wrapper);
        }
        return wrapper;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopicSession", "createSubscriber(Topic)", new Object[]{topic});
        }
        JmsTopic theTopic = null;
        if (topic != null) {
            theTopic = (JmsTopic)((MQTopic)topic).validateDestination();
        }
        MQTopicSubscriber wrapper = new MQTopicSubscriber();
        wrapper.setDelegate((JmsTopicSubscriber)((JmsTopicSession)this.commonSess).createSubscriber(theTopic));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQTopicSession", "createSubscriber(Topic)", wrapper);
        }
        return wrapper;
    }

    public TopicSubscriber createSubscriber(Topic topic, String selector, boolean noLocal) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopicSession", "createSubscriber(Topic,String,boolean)", new Object[]{topic, selector, noLocal});
        }
        JmsTopic theTopic = null;
        if (topic != null) {
            theTopic = (JmsTopic)((MQTopic)topic).validateDestination();
        }
        MQTopicSubscriber wrapper = new MQTopicSubscriber();
        wrapper.setDelegate((JmsTopicSubscriber)((JmsTopicSession)this.commonSess).createSubscriber(theTopic, selector, noLocal));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQTopicSession", "createSubscriber(Topic,String,boolean)", wrapper);
        }
        return wrapper;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopicSession", "createConsumer(Destination)", new Object[]{destination});
        }
        this.checkConsumerDestinationIsTopic(destination);
        TopicSubscriber consumer = this.createSubscriber((MQTopic)destination);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQTopicSession", "createConsumer(Destination)", consumer);
        }
        return consumer;
    }

    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopicSession", "createConsumer(Destination,String)", new Object[]{destination, selector});
        }
        this.checkConsumerDestinationIsTopic(destination);
        TopicSubscriber consumer = this.createSubscriber((MQTopic)destination, selector, false);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQTopicSession", "createConsumer(Destination,String)", consumer);
        }
        return consumer;
    }

    public MessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopicSession", "createConsumer(Destination,String,boolean)", new Object[]{destination, selector, noLocal});
        }
        this.checkConsumerDestinationIsTopic(destination);
        TopicSubscriber consumer = this.createSubscriber((MQTopic)destination, selector, noLocal);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQTopicSession", "createConsumer(Destination,String,boolean)", consumer);
        }
        return consumer;
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopicSession", "createProducer(Destination)", new Object[]{destination});
        }
        this.checkProducerDestinationIsTopic(destination);
        TopicPublisher producer = this.createPublisher((MQTopic)destination);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQTopicSession", "createProducer(Destination)", producer);
        }
        return producer;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.MQTopicSession", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQTopicSession.java, jmscc.migration.wmq, k701, k701-112-140304  1.37.1.1 09/08/17 09:02:18");
        }
    }
}

