/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQTopicConnection;
import com.ibm.mq.jms.MQTopicConnectionFactoryFactory;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsTopicConnectionFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class MQTopicConnectionFactory
extends MQConnectionFactory
implements TopicConnectionFactory,
JmsTopicConnectionFactory,
Referenceable,
Serializable {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final long serialVersionUID = 4166164173764320001L;

    public MQTopicConnectionFactory() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopicConnectionFactory", "<init>()");
        }
        try {
            this.setShortProperty("XMSC_ADMIN_OBJECT_TYPE", (short)18);
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQTopicConnectionFactory", "<init>()", e);
            }
            RuntimeException traceRet1 = new RuntimeException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.mq.jms.MQTopicConnectionFactory", "<init>()", traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQTopicConnectionFactory", "<init>()");
        }
    }

    public TopicConnection createTopicConnection() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopicConnectionFactory", "createTopicConnection()");
        }
        MQTopicConnection wrapper = new MQTopicConnection();
        wrapper.setDelegate(this.createCommonConnection(null, null));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQTopicConnectionFactory", "createTopicConnection()", wrapper);
        }
        return wrapper;
    }

    public TopicConnection createTopicConnection(String userid, String password) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopicConnectionFactory", "createTopicConnection(String,String)", new Object[]{userid, password == null ? password : "********"});
        }
        MQTopicConnection wrapper = new MQTopicConnection();
        wrapper.setDelegate(this.createCommonConnection(userid, password));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQTopicConnectionFactory", "createTopicConnection(String,String)", wrapper);
        }
        return wrapper;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopicConnectionFactory", "readObject(java.io.ObjectInputStream)", new Object[]{in});
        }
        in.defaultReadObject();
        try {
            this.setStringProperty("XMSC_CONNECTION_TYPE_NAME", "com.ibm.msg.client.wmq");
            this.setIntProperty("XMSC_CONNECTION_TYPE", 1);
            this.setShortProperty("XMSC_ADMIN_OBJECT_TYPE", (short)18);
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQTopicConnectionFactory", "readObject(java.io.ObjectInputStream)", e);
            }
            Trace.ffst(this, "readObject", "XF00C001", null, JMSException.class);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQTopicConnectionFactory", "readObject(java.io.ObjectInputStream)");
        }
    }

    public Connection createConnection() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopicConnectionFactory", "createConnection()");
        }
        TopicConnection traceRet1 = this.createTopicConnection();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQTopicConnectionFactory", "createConnection()", traceRet1);
        }
        return traceRet1;
    }

    public Connection createConnection(String userID, String password) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopicConnectionFactory", "createConnection(String,String)", new Object[]{userID, password == null ? password : "********"});
        }
        TopicConnection traceRet1 = this.createTopicConnection(userID, password);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQTopicConnectionFactory", "createConnection(String,String)", traceRet1);
        }
        return traceRet1;
    }

    public Reference getReference() throws NamingException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopicConnectionFactory", "getReference()");
        }
        Reference ref = new Reference(this.getClass().getName(), MQTopicConnectionFactoryFactory.class.getName(), null);
        Reference superClassReference = super.getReference();
        Enumeration<RefAddr> e = superClassReference.getAll();
        while (e.hasMoreElements()) {
            RefAddr currentRefAddr = e.nextElement();
            ref.add(currentRefAddr);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQTopicConnectionFactory", "getReference()", ref);
        }
        return ref;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.MQTopicConnectionFactory", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQTopicConnectionFactory.java, jmscc.migration.wmq, k701, k701-112-140304  1.33.1.1 09/08/17 09:01:45");
        }
    }
}

