/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.MQTopicFactory;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsDestination;
import com.ibm.msg.client.jms.JmsTopic;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class MQTopic
extends MQDestination
implements Topic,
JmsTopic,
Referenceable,
Serializable {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final long serialVersionUID = 3256711370610315851L;
    private static final ObjectStreamField[] serialPersistentFields;

    public MQTopic() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopic", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQTopic", "<init>()");
        }
    }

    protected MQTopic(JmsDestination delegate) {
        super(delegate);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopic", "<init>(JmsDestination)", new Object[]{delegate});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQTopic", "<init>(JmsDestination)");
        }
    }

    public MQTopic(String topicName) throws JMSException {
        super(topicName);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopic", "<init>(String)", new Object[]{topicName});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQTopic", "<init>(String)");
        }
    }

    public String getBaseTopicName() {
        String traceRet1 = this.getName();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQTopic", "getBaseTopicName()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public String getBrokerCCDurSubQueue() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopic", "getBrokerCCDurSubQueue()");
        }
        try {
            String traceRet1 = this.propertyDelegate.getStringProperty("brokerCCDurSubQueue");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQTopic", "getBrokerCCDurSubQueue()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQTopic", "getBrokerCCDurSubQueue()", je);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQTopic", "getBrokerCCDurSubQueue()", null, 2);
            }
            return null;
        }
    }

    public String getBrokerDurSubQueue() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopic", "getBrokerDurSubQueue()");
        }
        try {
            String traceRet1 = this.propertyDelegate.getStringProperty("brokerDurSubQueue");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQTopic", "getBrokerDurSubQueue()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQTopic", "getBrokerDurSubQueue()", je);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQTopic", "getBrokerDurSubQueue()", null, 2);
            }
            return null;
        }
    }

    public String getBrokerPubQueue() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopic", "getBrokerPubQueue()");
        }
        try {
            String traceRet1 = this.propertyDelegate.getStringProperty("XMSC_WMQ_BROKER_PUBQ");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQTopic", "getBrokerPubQueue()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQTopic", "getBrokerPubQueue()", je);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQTopic", "getBrokerPubQueue()", null, 2);
            }
            return null;
        }
    }

    public String getBrokerPubQueueManager() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopic", "getBrokerPubQueueManager()");
        }
        try {
            String traceRet1 = this.propertyDelegate.getStringProperty("XMSC_WMQ_BROKER_PUBQ_QMGR");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQTopic", "getBrokerPubQueueManager()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQTopic", "getBrokerPubQueueManager()", je);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQTopic", "getBrokerPubQueueManager()", null, 2);
            }
            return null;
        }
    }

    public int getBrokerVersion() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopic", "getBrokerVersion()");
        }
        try {
            int traceRet1 = this.propertyDelegate.getIntProperty("brokerVersion");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQTopic", "getBrokerVersion()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQTopic", "getBrokerVersion()", e);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQTopic", "getBrokerVersion()", new Integer(0), 2);
            }
            return 0;
        }
    }

    public int getMulticast() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopic", "getMulticast()");
        }
        try {
            int traceRet1 = this.propertyDelegate.getIntProperty("multicast");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQTopic", "getMulticast()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQTopic", "getMulticast()", je);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQTopic", "getMulticast()", new Integer(0), 2);
            }
            return 0;
        }
    }

    public Reference getReference() throws NamingException {
        Reference superClassReference;
        Reference ref;
        String s;
        block33: {
            block32: {
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                block27: {
                                    block26: {
                                        if (Trace.isOn) {
                                            Trace.entry(this, "com.ibm.mq.jms.MQTopic", "getReference()");
                                        }
                                        s = null;
                                        ref = new Reference(MQTopic.class.getName(), MQTopicFactory.class.getName(), null);
                                        ref.add(new StringRefAddr("VER", String.valueOf(this.getVersion())));
                                        s = this.getDescription();
                                        if (s != null) {
                                            ref.add(new StringRefAddr("DESC", s));
                                        }
                                        ref.add(new StringRefAddr("EXP", String.valueOf(this.getExpiry())));
                                        ref.add(new StringRefAddr("PRI", String.valueOf(this.getPriority())));
                                        ref.add(new StringRefAddr("PER", String.valueOf(this.getPersistence())));
                                        ref.add(new StringRefAddr("CCS", String.valueOf(this.getCCSID())));
                                        ref.add(new StringRefAddr("TC", String.valueOf(this.getTargetClient())));
                                        ref.add(new StringRefAddr("ENC", String.valueOf(this.getEncoding())));
                                        ref.add(new StringRefAddr("FIQ", String.valueOf(this.getFailIfQuiesce())));
                                        try {
                                            ref.add(new StringRefAddr("WCFMT", String.valueOf(this.getWildcardFormat())));
                                        }
                                        catch (JMSException j) {
                                            if (!Trace.isOn) break block26;
                                            Trace.catchBlock(this, "com.ibm.mq.jms.MQTopic", "getReference()", j, 1);
                                        }
                                    }
                                    try {
                                        ref.add(new StringRefAddr("RACP", String.valueOf(this.getReadAheadClosePolicy())));
                                    }
                                    catch (JMSException j) {
                                        if (!Trace.isOn) break block27;
                                        Trace.catchBlock(this, "com.ibm.mq.jms.MQTopic", "getReference()", j, 2);
                                    }
                                }
                                try {
                                    ref.add(new StringRefAddr("RAALD", String.valueOf(this.getReadAheadAllowed())));
                                }
                                catch (JMSException j) {
                                    if (!Trace.isOn) break block28;
                                    Trace.catchBlock(this, "com.ibm.mq.jms.MQTopic", "getReference()", j, 3);
                                }
                            }
                            try {
                                ref.add(new StringRefAddr("PAALD", String.valueOf(this.getPutAsyncAllowed())));
                            }
                            catch (JMSException j) {
                                if (!Trace.isOn) break block29;
                                Trace.catchBlock(this, "com.ibm.mq.jms.MQTopic", "getReference()", j, 4);
                            }
                        }
                        try {
                            ref.add(new StringRefAddr("MBODY", String.valueOf(this.getMessageBodyStyle())));
                        }
                        catch (JMSException j) {
                            if (!Trace.isOn) break block30;
                            Trace.catchBlock(this, "com.ibm.mq.jms.MQTopic", "getReference()", j, 5);
                        }
                    }
                    try {
                        ref.add(new StringRefAddr("MDR", String.valueOf(this.getMQMDReadEnabled())));
                    }
                    catch (JMSException j) {
                        if (!Trace.isOn) break block31;
                        Trace.catchBlock(this, "com.ibm.mq.jms.MQTopic", "getReference()", j, 6);
                    }
                }
                try {
                    ref.add(new StringRefAddr("MDW", String.valueOf(this.getMQMDWriteEnabled())));
                }
                catch (JMSException j) {
                    if (!Trace.isOn) break block32;
                    Trace.catchBlock(this, "com.ibm.mq.jms.MQTopic", "getReference()", j, 7);
                }
            }
            try {
                ref.add(new StringRefAddr("MDCTX", String.valueOf(this.getMQMDMessageContext())));
            }
            catch (JMSException j) {
                if (!Trace.isOn) break block33;
                Trace.catchBlock(this, "com.ibm.mq.jms.MQTopic", "getReference()", j, 8);
            }
        }
        s = this.getBaseTopicName();
        if (s != null) {
            ref.add(new StringRefAddr("TOP", s));
        }
        if ((s = this.getBrokerDurSubQueue()) != null) {
            ref.add(new StringRefAddr("BDSUB", s));
        }
        if ((s = this.getBrokerCCDurSubQueue()) != null) {
            ref.add(new StringRefAddr("CCDSUB", s));
        }
        ref.add(new StringRefAddr("BVER", String.valueOf(this.getBrokerVersion())));
        ref.add(new StringRefAddr("MCAST", String.valueOf(this.getMulticast())));
        s = this.getBrokerPubQueue();
        if (s != null) {
            ref.add(new StringRefAddr("BPUBQ", s));
        }
        if ((s = this.getBrokerPubQueueManager()) != null) {
            ref.add(new StringRefAddr("BQM", s));
        }
        if ((superClassReference = super.getReference()) != null) {
            Enumeration<RefAddr> e = superClassReference.getAll();
            while (e.hasMoreElements()) {
                RefAddr currentRefAddr = e.nextElement();
                ref.add(currentRefAddr);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQTopic", "getReference()", ref);
        }
        return ref;
    }

    public String getTopicName() {
        String result;
        String uri = this.toURI();
        String string = result = uri == null ? "topic://" : uri;
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQTopic", "getTopicName()", "getter", result);
        }
        return result;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block11: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.mq.jms.MQTopic", "readObject(java.io.ObjectInputStream)", new Object[]{in});
            }
            ObjectInputStream.GetField fields = in.readFields();
            try {
                if (!fields.defaulted("baseTopicName")) {
                    this.setBaseTopicName((String)fields.get("baseTopicName", null));
                }
                if (!fields.defaulted("brokerCCDurSubQueue")) {
                    this.setBrokerCCDurSubQueue((String)fields.get("brokerCCDurSubQueue", null));
                }
                if (!fields.defaulted("brokerDurSubQueue")) {
                    this.setBrokerDurSubQueue((String)fields.get("brokerDurSubQueue", null));
                }
                if (!fields.defaulted("brokerPubQueue")) {
                    this.setBrokerPubQueue((String)fields.get("brokerPubQueue", null));
                }
                if (!fields.defaulted("brokerPubQueueManager")) {
                    this.setBrokerPubQueueManager((String)fields.get("brokerPubQueueManager", null));
                }
                if (!fields.defaulted("brokerVersion")) {
                    this.setBrokerVersion(fields.get("brokerVersion", 0));
                }
                if (!fields.defaulted("multicast")) {
                    this.setMulticast(fields.get("multicast", 0));
                }
            }
            catch (JMSException je) {
                if (!Trace.isOn) break block11;
                Trace.catchBlock(this, "com.ibm.mq.jms.MQTopic", "readObject(java.io.ObjectInputStream)", je);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQTopic", "readObject(java.io.ObjectInputStream)");
        }
    }

    public void setBaseTopicName(String tName) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQTopic", "setBaseTopicName(String)", "setter", tName);
        }
        this.propertyDelegate.setStringProperty("XMSC_DESTINATION_NAME", tName);
    }

    public void setBrokerCCDurSubQueue(String queueName) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQTopic", "setBrokerCCDurSubQueue(String)", "setter", queueName);
        }
        this.propertyDelegate.setStringProperty("brokerCCDurSubQueue", queueName);
    }

    public void setBrokerDurSubQueue(String queueName) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQTopic", "setBrokerDurSubQueue(String)", "setter", queueName);
        }
        this.propertyDelegate.setStringProperty("brokerDurSubQueue", queueName);
    }

    public void setBrokerPubQueue(String queueName) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQTopic", "setBrokerPubQueue(String)", "setter", queueName);
        }
        this.propertyDelegate.setStringProperty("XMSC_WMQ_BROKER_PUBQ", queueName);
    }

    public void setBrokerPubQueueManager(String queueManagerName) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQTopic", "setBrokerPubQueueManager(String)", "setter", queueManagerName);
        }
        this.propertyDelegate.setStringProperty("XMSC_WMQ_BROKER_PUBQ_QMGR", queueManagerName);
    }

    public void setBrokerVersion(int version) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQTopic", "setBrokerVersion(int)", "setter", new Integer(version));
        }
        this.propertyDelegate.setIntProperty("brokerVersion", version);
    }

    void setFromReference(Reference ref) throws JMSException {
        Object value;
        RefAddr addr;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopic", "setFromReference(Reference)", new Object[]{ref});
        }
        if ((addr = ref.get("TOP")) != null && (value = addr.getContent()) != null) {
            this.setBaseTopicName((String)value);
        }
        super.setCommonFromReference(ref);
        addr = ref.get("BDSUB");
        if (addr != null && (value = addr.getContent()) != null) {
            this.setBrokerDurSubQueue((String)value);
        }
        if ((addr = ref.get("CCDSUB")) != null && (value = addr.getContent()) != null) {
            this.setBrokerCCDurSubQueue((String)value);
        }
        if ((addr = ref.get("BVER")) != null && (value = addr.getContent()) != null) {
            this.setBrokerVersion(Integer.parseInt((String)value));
        }
        if ((addr = ref.get("MCAST")) != null && (value = addr.getContent()) != null) {
            this.setMulticast(Integer.parseInt((String)value));
        }
        if ((addr = ref.get("BPUBQ")) != null && (value = addr.getContent()) != null) {
            this.setBrokerPubQueue((String)value);
        }
        if ((addr = ref.get("BQM")) != null && (value = addr.getContent()) != null) {
            this.setBrokerPubQueueManager((String)value);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQTopic", "setFromReference(Reference)");
        }
    }

    public void setMulticast(int multicastMode) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQTopic", "setMulticast(int)", "setter", new Integer(multicastMode));
        }
        this.propertyDelegate.setIntProperty("multicast", multicastMode);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQTopic", "writeObject(java.io.ObjectOutputStream)", new Object[]{out});
        }
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("baseTopicName", this.getBaseTopicName());
        fields.put("brokerCCDurSubQueue", this.getBrokerCCDurSubQueue());
        fields.put("brokerDurSubQueue", this.getBrokerDurSubQueue());
        fields.put("brokerPubQueue", this.getBrokerPubQueue());
        fields.put("brokerPubQueueManager", this.getBrokerPubQueueManager());
        fields.put("brokerVersion", this.getBrokerVersion());
        fields.put("multicast", this.getMulticast());
        out.writeFields();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQTopic", "writeObject(java.io.ObjectOutputStream)");
        }
    }

    public String toString() {
        return this.getTopicName();
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.MQTopic", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQTopic.java, jmscc.migration.wmq, k701, k701-112-140304  1.73.1.3 10/02/24 09:35:22");
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("baseTopicName", String.class), new ObjectStreamField("brokerCCDurSubQueue", String.class), new ObjectStreamField("brokerDurSubQueue", String.class), new ObjectStreamField("brokerPubQueue", String.class), new ObjectStreamField("brokerPubQueueManager", String.class), new ObjectStreamField("brokerVersion", Integer.TYPE), new ObjectStreamField("multicast", Integer.TYPE)};
    }
}

