/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSBytesMessage;
import com.ibm.jms.JMSMapMessage;
import com.ibm.jms.JMSMessage;
import com.ibm.jms.JMSObjectMessage;
import com.ibm.jms.JMSStreamMessage;
import com.ibm.jms.JMSTextMessage;
import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.MQMessageConsumer;
import com.ibm.mq.jms.MQMessageProducer;
import com.ibm.mq.jms.MQMessageReference;
import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQQueueBrowser;
import com.ibm.mq.jms.MQQueueReceiver;
import com.ibm.mq.jms.MQQueueSender;
import com.ibm.mq.jms.MQRoot;
import com.ibm.mq.jms.MQTemporaryQueue;
import com.ibm.mq.jms.MQTemporaryTopic;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicPublisher;
import com.ibm.mq.jms.MQTopicSubscriber;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsDestination;
import com.ibm.msg.client.jms.JmsMessageConsumer;
import com.ibm.msg.client.jms.JmsMessageProducer;
import com.ibm.msg.client.jms.JmsMessageReference;
import com.ibm.msg.client.jms.JmsQueue;
import com.ibm.msg.client.jms.JmsQueueBrowser;
import com.ibm.msg.client.jms.JmsSession;
import com.ibm.msg.client.jms.JmsTopic;
import com.ibm.msg.client.jms.JmsTopicSubscriber;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class MQSession
extends MQRoot
implements Session,
JmsSession {
    private static final long serialVersionUID = 1136989430032568493L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    int ackMode;
    protected JmsSession commonSess;
    boolean transacted;

    MQSession() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQSession", "<init>()");
        }
    }

    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "close()");
        }
        this.commonSess.close();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQSession", "close()");
        }
    }

    public void commit() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "commit()");
        }
        this.commonSess.commit();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQSession", "commit()");
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "createBrowser(Queue)", new Object[]{queue});
        }
        MQQueueBrowser wrapper = new MQQueueBrowser();
        JmsQueue wrappedQueue = null;
        if (queue != null) {
            wrappedQueue = (JmsQueue)((MQQueue)queue).validateDestination();
        }
        wrapper.setDelegate((JmsQueueBrowser)this.commonSess.createBrowser(wrappedQueue));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "createBrowser(Queue)", wrapper);
        }
        return wrapper;
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "createBrowser(Queue,String)", new Object[]{queue, messageSelector});
        }
        MQQueueBrowser wrapper = new MQQueueBrowser();
        JmsQueue theQueue = null;
        if (queue != null) {
            theQueue = (JmsQueue)((MQQueue)queue).validateDestination();
        }
        wrapper.setDelegate((JmsQueueBrowser)this.commonSess.createBrowser(theQueue, messageSelector));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "createBrowser(Queue,String)", wrapper);
        }
        return wrapper;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "createBytesMessage()");
        }
        JMSBytesMessage wrapper = new JMSBytesMessage();
        wrapper.setDelegate((Message)this.commonSess.createBytesMessage());
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "createBytesMessage()", wrapper);
        }
        return wrapper;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "createConsumer(Destination)", new Object[]{destination});
        }
        MQMessageConsumer wrapper = destination instanceof Queue ? new MQQueueReceiver() : new MQTopicSubscriber();
        JmsDestination queue = null;
        if (destination != null) {
            queue = (JmsDestination)((MQDestination)destination).validateDestination();
        }
        wrapper.setDelegate((JmsMessageConsumer)this.commonSess.createConsumer(queue));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "createConsumer(Destination)", wrapper);
        }
        return wrapper;
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "createConsumer(Destination,String)", new Object[]{destination, messageSelector});
        }
        MQMessageConsumer wrapper = destination instanceof Queue ? new MQQueueReceiver() : new MQTopicSubscriber();
        JmsDestination queue = null;
        if (destination != null) {
            queue = (JmsDestination)((MQDestination)destination).validateDestination();
        }
        wrapper.setDelegate((JmsMessageConsumer)this.commonSess.createConsumer(queue, messageSelector));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "createConsumer(Destination,String)", wrapper);
        }
        return wrapper;
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "createConsumer(Destination,String,boolean)", new Object[]{destination, messageSelector, noLocal});
        }
        MQMessageConsumer wrapper = destination instanceof Queue ? new MQQueueReceiver() : new MQTopicSubscriber();
        JmsDestination queue = null;
        if (destination != null) {
            queue = (JmsDestination)((MQDestination)destination).validateDestination();
        }
        wrapper.setDelegate((JmsMessageConsumer)this.commonSess.createConsumer(queue, messageSelector, noLocal));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "createConsumer(Destination,String,boolean)", wrapper);
        }
        return wrapper;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "createDurableSubscriber(Topic,String)", new Object[]{topic, name});
        }
        MQTopicSubscriber wrapper = new MQTopicSubscriber();
        JmsTopic theTopic = null;
        if (topic != null) {
            theTopic = (JmsTopic)((MQTopic)topic).validateDestination();
        }
        wrapper.setDelegate((JmsTopicSubscriber)this.commonSess.createDurableSubscriber(theTopic, name));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "createDurableSubscriber(Topic,String)", wrapper);
        }
        return wrapper;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "createDurableSubscriber(Topic,String,String,boolean)", new Object[]{topic, name, selector, noLocal});
        }
        MQTopicSubscriber wrapper = new MQTopicSubscriber();
        JmsTopic theTopic = null;
        if (topic != null) {
            theTopic = (JmsTopic)((MQTopic)topic).validateDestination();
        }
        wrapper.setDelegate((JmsTopicSubscriber)this.commonSess.createDurableSubscriber(theTopic, name, selector, noLocal));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "createDurableSubscriber(Topic,String,String,boolean)", wrapper);
        }
        return wrapper;
    }

    public MapMessage createMapMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "createMapMessage()");
        }
        JMSMapMessage wrapper = new JMSMapMessage();
        wrapper.setDelegate((Message)this.commonSess.createMapMessage());
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "createMapMessage()", wrapper);
        }
        return wrapper;
    }

    public Message createMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "createMessage()");
        }
        JMSMessage wrapper = new JMSMessage();
        wrapper.setDelegate(this.commonSess.createMessage());
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "createMessage()", wrapper);
        }
        return wrapper;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "createObjectMessage()");
        }
        JMSObjectMessage wrapper = new JMSObjectMessage();
        wrapper.setDelegate((Message)this.commonSess.createObjectMessage());
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "createObjectMessage()", wrapper);
        }
        return wrapper;
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "createObjectMessage(Serializable)", new Object[]{object});
        }
        JMSObjectMessage wrapper = new JMSObjectMessage();
        wrapper.setDelegate((Message)this.commonSess.createObjectMessage(object));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "createObjectMessage(Serializable)", wrapper);
        }
        return wrapper;
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "createProducer(Destination)", new Object[]{destination});
        }
        MQMessageProducer wrapper = null != destination && destination instanceof Queue ? new MQQueueSender() : (null != destination && destination instanceof Topic ? new MQTopicPublisher() : new MQMessageProducer());
        if (destination != null) {
            destination = ((MQDestination)destination).validateDestination();
        }
        wrapper.setDelegate((JmsMessageProducer)this.commonSess.createProducer(destination));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "createProducer(Destination)", wrapper);
        }
        return wrapper;
    }

    public Queue createQueue(String queueName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "createQueue(String)", new Object[]{queueName});
        }
        MQQueue wrapper = (MQQueue)((JmsQueue)this.commonSess.createQueue(queueName));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "createQueue(String)", wrapper);
        }
        return wrapper;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "createStreamMessage()");
        }
        JMSStreamMessage wrapper = new JMSStreamMessage();
        wrapper.setDelegate((Message)this.commonSess.createStreamMessage());
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "createStreamMessage()", wrapper);
        }
        return wrapper;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "createTemporaryQueue()");
        }
        TemporaryQueue commonQueue = this.commonSess.createTemporaryQueue();
        MQTemporaryQueue wrapper = new MQTemporaryQueue(commonQueue);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "createTemporaryQueue()", wrapper);
        }
        return wrapper;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "createTemporaryTopic()");
        }
        TemporaryTopic commonTopic = this.commonSess.createTemporaryTopic();
        MQTemporaryTopic wrapper = new MQTemporaryTopic(commonTopic);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "createTemporaryTopic()", wrapper);
        }
        return wrapper;
    }

    public TextMessage createTextMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "createTextMessage()");
        }
        JMSTextMessage wrapper = new JMSTextMessage();
        wrapper.setDelegate((Message)this.commonSess.createTextMessage());
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "createTextMessage()", wrapper);
        }
        return wrapper;
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "createTextMessage(String)", new Object[]{string});
        }
        JMSTextMessage wrapper = new JMSTextMessage();
        wrapper.setDelegate((Message)this.commonSess.createTextMessage(string));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "createTextMessage(String)", wrapper);
        }
        return wrapper;
    }

    public Topic createTopic(String topicName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "createTopic(String)", new Object[]{topicName});
        }
        MQTopic wrapper = (MQTopic)((JmsTopic)this.commonSess.createTopic(topicName));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "createTopic(String)", wrapper);
        }
        return wrapper;
    }

    public int getAcknowledgeMode() throws JMSException {
        int traceRet1 = this.commonSess.getAcknowledgeMode();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQSession", "getAcknowledgeMode()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public MessageListener getMessageListener() throws JMSException {
        FacadeMessageListener wrapper = (FacadeMessageListener)this.commonSess.getMessageListener();
        MessageListener listener = null;
        if (wrapper != null) {
            listener = wrapper.listener;
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQSession", "getMessageListener()", "getter", listener);
        }
        return listener;
    }

    public boolean getTransacted() throws JMSException {
        boolean traceRet1 = this.commonSess.getTransacted();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQSession", "getTransacted()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public void recover() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "recover()");
        }
        this.commonSess.recover();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQSession", "recover()");
        }
    }

    public void rollback() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "rollback()");
        }
        this.commonSess.rollback();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQSession", "rollback()");
        }
    }

    public void run() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "run()");
        }
        this.commonSess.run();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQSession", "run()");
        }
    }

    void setDelegate(JmsSession commonSess) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQSession", "setDelegate(JmsSession)", "setter", commonSess);
        }
        this.commonSess = commonSess;
        this.delegate = commonSess;
    }

    JmsSession getDelegate() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQSession", "getDelegate()", "getter", this.commonSess);
        }
        return this.commonSess;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQSession", "setMessageListener(MessageListener)", "setter", listener);
        }
        FacadeMessageListener wrapper = null;
        if (listener != null) {
            wrapper = new FacadeMessageListener(listener);
        }
        this.commonSess.setMessageListener(wrapper);
    }

    public void unsubscribe(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "unsubscribe(String)", new Object[]{name});
        }
        this.commonSess.unsubscribe(name);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQSession", "unsubscribe(String)");
        }
    }

    public Message consume(byte[] flattenedRef) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "consume(byte [ ])", new Object[]{flattenedRef});
        }
        Message msg = this.commonSess.consume(flattenedRef);
        Message wrappedMsg = MQMessageConsumer.wrapCommmonMessage(msg);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "consume(byte [ ])", wrappedMsg);
        }
        return wrappedMsg;
    }

    public void deliver(List messageReferences) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "deliver(List)", new Object[]{messageReferences});
        }
        if (null == messageReferences || messageReferences.size() == 0) {
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "deliver(List)", 1);
            }
            return;
        }
        ArrayList newList = new ArrayList();
        Iterator it = messageReferences.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof MQMessageReference) {
                o = ((MQMessageReference)o).getDelegate();
            }
            newList.add(o);
        }
        this.commonSess.deliver(newList);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "deliver(List)", 2);
        }
    }

    public JmsMessageReference recreateMessageReference(byte[] flatMR) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "recreateMessageReference(byte [ ])", new Object[]{flatMR});
        }
        JmsMessageReference jmsMr = this.commonSess.recreateMessageReference(flatMR);
        MQMessageReference mqMr = new MQMessageReference(jmsMr);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQSession", "recreateMessageReference(byte [ ])", mqMr);
        }
        return mqMr;
    }

    protected void checkConsumerDestinationIsQueue(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "checkConsumerDestinationIsQueue(Destination)", new Object[]{destination});
        }
        if (destination instanceof MQTopic) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "createConsumer()");
            inserts.put("XMSC_INSERT_TYPE", destination.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.mq.jms.MQSession", "checkConsumerDestinationIsQueue(Destination)", je, 1);
            }
            throw je;
        }
        if (!(destination instanceof MQQueue)) {
            JMSException je2 = (JMSException)((Object)NLSServices.createException("JMSMQ0003", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.mq.jms.MQSession", "checkConsumerDestinationIsQueue(Destination)", je2, 2);
            }
            throw je2;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQSession", "checkConsumerDestinationIsQueue(Destination)");
        }
    }

    protected void checkProducerDestinationIsQueue(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "checkProducerDestinationIsQueue(Destination)", new Object[]{destination});
        }
        if (destination != null && !(destination instanceof MQQueue)) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "createProducer()");
            inserts.put("XMSC_INSERT_TYPE", destination.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.mq.jms.MQSession", "checkProducerDestinationIsQueue(Destination)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQSession", "checkProducerDestinationIsQueue(Destination)");
        }
    }

    protected void checkConsumerDestinationIsTopic(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "checkConsumerDestinationIsTopic(Destination)", new Object[]{destination});
        }
        if (destination instanceof MQQueue) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "createConsumer()");
            inserts.put("XMSC_INSERT_TYPE", destination.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.mq.jms.MQSession", "checkConsumerDestinationIsTopic(Destination)", je, 1);
            }
            throw je;
        }
        if (!(destination instanceof MQTopic)) {
            JMSException traceRet3 = (JMSException)((Object)NLSServices.createException("JMSMQ0003", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.mq.jms.MQSession", "checkConsumerDestinationIsTopic(Destination)", traceRet3, 2);
            }
            throw traceRet3;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQSession", "checkConsumerDestinationIsTopic(Destination)");
        }
    }

    protected void checkProducerDestinationIsTopic(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQSession", "checkProducerDestinationIsTopic(Destination)", new Object[]{destination});
        }
        if (destination != null && !(destination instanceof MQTopic)) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "createProducer()");
            inserts.put("XMSC_INSERT_TYPE", destination.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.mq.jms.MQSession", "checkProducerDestinationIsTopic(Destination)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQSession", "checkProducerDestinationIsTopic(Destination)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.MQSession", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQSession.java, jmscc.migration.wmq, k701, k701-112-140304  1.67.1.1 09/08/17 09:00:41");
        }
    }

    private class FacadeMessageListener
    implements MessageListener {
        private MessageListener listener = null;

        public FacadeMessageListener(MessageListener listener) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.mq.jms.FacadeMessageListener", "<init>(MessageListener)", new Object[]{listener});
            }
            this.listener = listener;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.FacadeMessageListener", "<init>(MessageListener)");
            }
        }

        public void onMessage(Message message) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.mq.jms.FacadeMessageListener", "onMessage(Message)", new Object[]{message});
            }
            JMSMessage wrapper = null;
            if (message instanceof BytesMessage) {
                wrapper = new JMSBytesMessage();
                wrapper.setDelegate(message);
            } else if (message instanceof TextMessage) {
                wrapper = new JMSTextMessage();
                wrapper.setDelegate(message);
            } else if (message instanceof MapMessage) {
                wrapper = new JMSMapMessage();
                wrapper.setDelegate(message);
            } else if (message instanceof StreamMessage) {
                wrapper = new JMSStreamMessage();
                wrapper.setDelegate(message);
            } else if (message instanceof ObjectMessage) {
                wrapper = new JMSObjectMessage();
                wrapper.setDelegate(message);
            } else {
                wrapper = new JMSMessage();
                wrapper.setDelegate(message);
            }
            this.listener.onMessage((Message)wrapper);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.FacadeMessageListener", "onMessage(Message)");
            }
        }
    }
}

