/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQQueueReceiver;
import com.ibm.mq.jms.MQQueueSender;
import com.ibm.mq.jms.MQSession;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsQueue;
import com.ibm.msg.client.jms.JmsQueueReceiver;
import com.ibm.msg.client.jms.JmsQueueSender;
import com.ibm.msg.client.jms.JmsQueueSession;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;

public class MQQueueSession
extends MQSession
implements QueueSession,
JmsQueueSession {
    private static final long serialVersionUID = 1L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    MQQueueSession() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueueSession", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQQueueSession", "<init>()");
        }
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueueSession", "createReceiver(Queue)", new Object[]{queue});
        }
        MQQueueReceiver wrapper = new MQQueueReceiver();
        JmsQueue theQueue = null;
        if (queue != null) {
            theQueue = (JmsQueue)((MQQueue)queue).validateDestination();
        }
        wrapper.setDelegate((JmsQueueReceiver)((JmsQueueSession)this.commonSess).createReceiver(theQueue));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQQueueSession", "createReceiver(Queue)", wrapper);
        }
        return wrapper;
    }

    public QueueReceiver createReceiver(Queue queue, String selector) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueueSession", "createReceiver(Queue,String)", new Object[]{queue, selector});
        }
        MQQueueReceiver wrapper = new MQQueueReceiver();
        JmsQueue theQueue = null;
        if (queue != null) {
            theQueue = (JmsQueue)((MQQueue)queue).validateDestination();
        }
        wrapper.setDelegate((JmsQueueReceiver)((JmsQueueSession)this.commonSess).createReceiver(theQueue, selector));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQQueueSession", "createReceiver(Queue,String)", wrapper);
        }
        return wrapper;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueueSession", "createSender(Queue)", new Object[]{queue});
        }
        MQQueueSender wrapper = new MQQueueSender();
        JmsQueue jmsQueue = null;
        if (queue != null) {
            jmsQueue = (JmsQueue)((MQQueue)queue).validateDestination();
        }
        wrapper.setDelegate((JmsQueueSender)((JmsQueueSession)this.commonSess).createSender(jmsQueue));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQQueueSession", "createSender(Queue)", wrapper);
        }
        return wrapper;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueueSession", "createConsumer(Destination)", new Object[]{destination});
        }
        this.checkConsumerDestinationIsQueue(destination);
        QueueReceiver consumer = this.createReceiver((MQQueue)destination);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQQueueSession", "createConsumer(Destination)", consumer);
        }
        return consumer;
    }

    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueueSession", "createConsumer(Destination,String)", new Object[]{destination, selector});
        }
        this.checkConsumerDestinationIsQueue(destination);
        QueueReceiver consumer = this.createReceiver((MQQueue)destination, selector);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQQueueSession", "createConsumer(Destination,String)", consumer);
        }
        return consumer;
    }

    public MessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueueSession", "createConsumer(Destination,String,boolean)", new Object[]{destination, selector, noLocal});
        }
        this.checkConsumerDestinationIsQueue(destination);
        QueueReceiver consumer = this.createReceiver((MQQueue)destination, selector);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQQueueSession", "createConsumer(Destination,String,boolean)", consumer);
        }
        return consumer;
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueueSession", "createProducer(Destination)", new Object[]{destination});
        }
        this.checkProducerDestinationIsQueue(destination);
        QueueSender producer = this.createSender((MQQueue)destination);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQQueueSession", "createProducer(Destination)", producer);
        }
        return producer;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.MQQueueSession", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQQueueSession.java, jmscc.migration.wmq, k701, k701-112-140304  1.36.1.1 09/08/17 09:00:30");
        }
    }
}

