/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.mq.jms.MQMessageProducer;
import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQTemporaryQueue;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsQueue;
import com.ibm.msg.client.jms.JmsQueueSender;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.TemporaryQueue;

public class MQQueueSender
extends MQMessageProducer
implements QueueSender,
JmsQueueSender {
    private static final long serialVersionUID = -303776029855233556L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    MQQueueSender() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueueSender", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQQueueSender", "<init>()");
        }
    }

    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueueSender", "close()");
        }
        this.commonProducer.close();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQQueueSender", "close()");
        }
    }

    public Queue getQueue() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueueSender", "getQueue()");
        }
        Queue traceRet1 = null;
        Queue dest = ((JmsQueueSender)this.commonProducer).getQueue();
        traceRet1 = dest instanceof TemporaryQueue ? new MQTemporaryQueue((TemporaryQueue)dest) : dest;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQQueueSender", "getQueue()", traceRet1);
        }
        return traceRet1;
    }

    public void send(Queue queue, Message message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueueSender", "send(Queue,Message)", new Object[]{queue, message});
        }
        JmsQueue q = queue == null ? null : (JmsQueue)((MQQueue)queue).validateDestination();
        Message msg = message instanceof JMSMessage ? ((JMSMessage)message).getDelegate() : message;
        this.commonProducer.send(q, msg);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQQueueSender", "send(Queue,Message)");
        }
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueueSender", "send(Queue,Message,int,int,long)", new Object[]{queue, message, new Integer(deliveryMode), new Integer(priority), new Long(timeToLive)});
        }
        JmsQueue q = queue == null ? null : (JmsQueue)((MQQueue)queue).validateDestination();
        Message msg = message instanceof JMSMessage ? ((JMSMessage)message).getDelegate() : message;
        this.commonProducer.send(q, msg, deliveryMode, priority, timeToLive);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQQueueSender", "send(Queue,Message,int,int,long)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.MQQueueSender", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQQueueSender.java, jmscc.migration.wmq, k701, k701-112-140304  1.38.1.1 09/08/17 09:00:17");
        }
    }
}

