/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQQueueConnection;
import com.ibm.mq.jms.MQQueueConnectionFactoryFactory;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsQueueConnectionFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class MQQueueConnectionFactory
extends MQConnectionFactory
implements QueueConnectionFactory,
Referenceable,
Serializable,
JmsQueueConnectionFactory {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final long serialVersionUID = 3763813191978525893L;

    public MQQueueConnectionFactory() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueueConnectionFactory", "<init>()");
        }
        try {
            this.setShortProperty("XMSC_ADMIN_OBJECT_TYPE", (short)17);
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQQueueConnectionFactory", "<init>()", e);
            }
            RuntimeException traceRet1 = new RuntimeException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.mq.jms.MQQueueConnectionFactory", "<init>()", traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQQueueConnectionFactory", "<init>()");
        }
    }

    public QueueConnection createQueueConnection() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueueConnectionFactory", "createQueueConnection()");
        }
        MQQueueConnection wrapper = new MQQueueConnection();
        wrapper.setDelegate(this.createCommonConnection(null, null));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQQueueConnectionFactory", "createQueueConnection()", wrapper);
        }
        return wrapper;
    }

    public QueueConnection createQueueConnection(String userid, String password) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueueConnectionFactory", "createQueueConnection(String,String)", new Object[]{userid, password == null ? password : "********"});
        }
        MQQueueConnection wrapper = new MQQueueConnection();
        wrapper.setDelegate(this.createCommonConnection(userid, password));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQQueueConnectionFactory", "createQueueConnection(String,String)", wrapper);
        }
        return wrapper;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueueConnectionFactory", "readObject(java.io.ObjectInputStream)", new Object[]{in});
        }
        in.defaultReadObject();
        try {
            this.setStringProperty("XMSC_CONNECTION_TYPE_NAME", "com.ibm.msg.client.wmq");
            this.setIntProperty("XMSC_CONNECTION_TYPE", 1);
            this.setShortProperty("XMSC_ADMIN_OBJECT_TYPE", (short)17);
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQQueueConnectionFactory", "readObject(java.io.ObjectInputStream)", e);
            }
            Trace.ffst(this, "readObject", "XF00B001", null, JMSException.class);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQQueueConnectionFactory", "readObject(java.io.ObjectInputStream)");
        }
    }

    public Connection createConnection() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueueConnectionFactory", "createConnection()");
        }
        QueueConnection traceRet1 = this.createQueueConnection();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQQueueConnectionFactory", "createConnection()", traceRet1);
        }
        return traceRet1;
    }

    public Connection createConnection(String userID, String password) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueueConnectionFactory", "createConnection(String,String)", new Object[]{userID, password == null ? password : "********"});
        }
        QueueConnection traceRet1 = this.createQueueConnection(userID, password);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQQueueConnectionFactory", "createConnection(String,String)", traceRet1);
        }
        return traceRet1;
    }

    public Reference getReference() throws NamingException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueueConnectionFactory", "getReference()");
        }
        Reference ref = new Reference(this.getClass().getName(), MQQueueConnectionFactoryFactory.class.getName(), null);
        Reference superClassReference = super.getReference();
        Enumeration<RefAddr> e = superClassReference.getAll();
        while (e.hasMoreElements()) {
            RefAddr currentRefAddr = e.nextElement();
            ref.add(currentRefAddr);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQQueueConnectionFactory", "getReference()", ref);
        }
        return ref;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.MQQueueConnectionFactory", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQQueueConnectionFactory.java, jmscc.migration.wmq, k701, k701-112-140304  1.31.1.1 09/08/17 08:59:30");
        }
    }
}

