/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.MQQueueFactory;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsDestination;
import com.ibm.msg.client.jms.JmsQueue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class MQQueue
extends MQDestination
implements Queue,
JmsQueue,
Referenceable,
Serializable {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final long serialVersionUID = 8412792851006107464L;
    private static final ObjectStreamField[] serialPersistentFields;

    public MQQueue() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueue", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQQueue", "<init>()");
        }
    }

    protected MQQueue(JmsDestination delegate) {
        super(delegate);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueue", "<init>(JmsDestination)", new Object[]{delegate});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQQueue", "<init>(JmsDestination)");
        }
    }

    public MQQueue(String queueName) throws JMSException {
        super(queueName);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueue", "<init>(String)", new Object[]{queueName});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQQueue", "<init>(String)");
        }
    }

    public MQQueue(String queueManagerName, String queueName) throws JMSException {
        super(queueName);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueue", "<init>(String,String)", new Object[]{queueManagerName, queueName});
        }
        try {
            this.setBaseQueueManagerName(queueManagerName);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQQueue", "<init>(String,String)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.mq.jms.MQQueue", "<init>(String,String)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQQueue", "<init>(String,String)");
        }
    }

    public String getBaseQueueManagerName() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueue", "getBaseQueueManagerName()");
        }
        try {
            String traceRet1 = this.propertyDelegate.getStringProperty("XMSC_WMQ_QUEUE_MANAGER");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQQueue", "getBaseQueueManagerName()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQQueue", "getBaseQueueManagerName()", je);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQQueue", "getBaseQueueManagerName()", null, 2);
            }
            return null;
        }
    }

    public String getBaseQueueName() {
        String traceRet1 = this.getName();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQQueue", "getBaseQueueName()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public String getQueueName() {
        String result;
        String uri = this.toURI();
        String string = result = uri == null ? "queue:///" : uri;
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQQueue", "getQueueName()", "getter", result);
        }
        return result;
    }

    public Reference getReference() throws NamingException {
        Reference superClassReference;
        Reference ref;
        String s;
        block30: {
            block29: {
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    block23: {
                                        if (Trace.isOn) {
                                            Trace.entry(this, "com.ibm.mq.jms.MQQueue", "getReference()");
                                        }
                                        s = null;
                                        ref = new Reference(MQQueue.class.getName(), MQQueueFactory.class.getName(), null);
                                        ref.add(new StringRefAddr("VER", String.valueOf(this.getVersion())));
                                        s = this.getDescription();
                                        if (s != null) {
                                            ref.add(new StringRefAddr("DESC", s));
                                        }
                                        ref.add(new StringRefAddr("EXP", String.valueOf(this.getExpiry())));
                                        ref.add(new StringRefAddr("PRI", String.valueOf(this.getPriority())));
                                        ref.add(new StringRefAddr("PER", String.valueOf(this.getPersistence())));
                                        ref.add(new StringRefAddr("CCS", String.valueOf(this.getCCSID())));
                                        ref.add(new StringRefAddr("TC", String.valueOf(this.getTargetClient())));
                                        ref.add(new StringRefAddr("ENC", String.valueOf(this.getEncoding())));
                                        ref.add(new StringRefAddr("FIQ", String.valueOf(this.getFailIfQuiesce())));
                                        try {
                                            ref.add(new StringRefAddr("WCFMT", String.valueOf(this.getWildcardFormat())));
                                        }
                                        catch (JMSException j) {
                                            if (!Trace.isOn) break block23;
                                            Trace.catchBlock(this, "com.ibm.mq.jms.MQQueue", "getReference()", j, 1);
                                        }
                                    }
                                    try {
                                        ref.add(new StringRefAddr("MBODY", String.valueOf(this.getMessageBodyStyle())));
                                    }
                                    catch (JMSException j) {
                                        if (!Trace.isOn) break block24;
                                        Trace.catchBlock(this, "com.ibm.mq.jms.MQQueue", "getReference()", j, 2);
                                    }
                                }
                                try {
                                    ref.add(new StringRefAddr("MDR", String.valueOf(this.getMQMDReadEnabled())));
                                }
                                catch (JMSException j) {
                                    if (!Trace.isOn) break block25;
                                    Trace.catchBlock(this, "com.ibm.mq.jms.MQQueue", "getReference()", j, 3);
                                }
                            }
                            try {
                                ref.add(new StringRefAddr("MDW", String.valueOf(this.getMQMDWriteEnabled())));
                            }
                            catch (JMSException j) {
                                if (!Trace.isOn) break block26;
                                Trace.catchBlock(this, "com.ibm.mq.jms.MQQueue", "getReference()", j, 4);
                            }
                        }
                        try {
                            ref.add(new StringRefAddr("MDCTX", String.valueOf(this.getMQMDMessageContext())));
                        }
                        catch (JMSException j) {
                            if (!Trace.isOn) break block27;
                            Trace.catchBlock(this, "com.ibm.mq.jms.MQQueue", "getReference()", j, 5);
                        }
                    }
                    try {
                        ref.add(new StringRefAddr("RACP", String.valueOf(this.getReadAheadClosePolicy())));
                    }
                    catch (JMSException j) {
                        if (!Trace.isOn) break block28;
                        Trace.catchBlock(this, "com.ibm.mq.jms.MQQueue", "getReference()", j, 6);
                    }
                }
                try {
                    ref.add(new StringRefAddr("RAALD", String.valueOf(this.getReadAheadAllowed())));
                }
                catch (JMSException j) {
                    if (!Trace.isOn) break block29;
                    Trace.catchBlock(this, "com.ibm.mq.jms.MQQueue", "getReference()", j, 7);
                }
            }
            try {
                ref.add(new StringRefAddr("PAALD", String.valueOf(this.getPutAsyncAllowed())));
            }
            catch (JMSException j) {
                if (!Trace.isOn) break block30;
                Trace.catchBlock(this, "com.ibm.mq.jms.MQQueue", "getReference()", j, 8);
            }
        }
        s = this.getBaseQueueName();
        if (s != null) {
            ref.add(new StringRefAddr("QU", s));
        }
        if ((s = this.getBaseQueueManagerName()) != null) {
            ref.add(new StringRefAddr("QMGR", s));
        }
        if ((superClassReference = super.getReference()) != null) {
            Enumeration<RefAddr> e = superClassReference.getAll();
            while (e.hasMoreElements()) {
                RefAddr currentRefAddr = e.nextElement();
                ref.add(currentRefAddr);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQQueue", "getReference()", ref);
        }
        return ref;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block6: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.mq.jms.MQQueue", "readObject(java.io.ObjectInputStream)", new Object[]{in});
            }
            ObjectInputStream.GetField fields = in.readFields();
            try {
                if (!fields.defaulted("baseQueueManagerName")) {
                    this.setBaseQueueManagerName((String)fields.get("baseQueueManagerName", null));
                }
                if (!fields.defaulted("baseQueueName")) {
                    this.setBaseQueueName((String)fields.get("baseQueueName", null));
                }
            }
            catch (JMSException je) {
                if (!Trace.isOn) break block6;
                Trace.catchBlock(this, "com.ibm.mq.jms.MQQueue", "readObject(java.io.ObjectInputStream)", je);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQQueue", "readObject(java.io.ObjectInputStream)");
        }
    }

    public void setBaseQueueManagerName(String qmName) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQQueue", "setBaseQueueManagerName(String)", "setter", qmName);
        }
        this.propertyDelegate.setStringProperty("XMSC_WMQ_QUEUE_MANAGER", qmName);
    }

    public void setBaseQueueName(String qName) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQQueue", "setBaseQueueName(String)", "setter", qName);
        }
        this.propertyDelegate.setStringProperty("XMSC_DESTINATION_NAME", qName);
    }

    void setFromReference(Reference ref) throws JMSException {
        Object value;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueue", "setFromReference(Reference)", new Object[]{ref});
        }
        super.setCommonFromReference(ref);
        RefAddr addr = ref.get("QMGR");
        if (addr != null) {
            String qmgr = (String)addr.getContent();
            if (qmgr == null) {
                qmgr = "";
            }
            this.setBaseQueueManagerName(qmgr);
        }
        if ((addr = ref.get("QU")) != null && (value = addr.getContent()) != null) {
            this.setBaseQueueName((String)value);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQQueue", "setFromReference(Reference)");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQQueue", "writeObject(java.io.ObjectOutputStream)", new Object[]{out});
        }
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("baseQueueManagerName", this.getBaseQueueManagerName());
        fields.put("baseQueueName", this.getBaseQueueName());
        out.writeFields();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQQueue", "writeObject(java.io.ObjectOutputStream)");
        }
    }

    public String toString() {
        String traceRet1 = this.getQueueName();
        return traceRet1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.MQQueue", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQQueue.java, jmscc.migration.wmq, k701, k701-112-140304  1.75.1.1 09/08/17 08:59:00");
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("baseQueueManagerName", String.class), new ObjectStreamField("baseQueueName", String.class)};
    }
}

