/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.MQRoot;
import com.ibm.mq.jms.MQTemporaryQueue;
import com.ibm.mq.jms.MQTemporaryTopic;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsDestination;
import com.ibm.msg.client.jms.JmsMessageProducer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;

public class MQMessageProducer
extends MQRoot
implements MessageProducer,
JmsMessageProducer {
    private static final long serialVersionUID = 5533585627918234225L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected JmsMessageProducer commonProducer;

    MQMessageProducer() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQMessageProducer", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQMessageProducer", "<init>()");
        }
    }

    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQMessageProducer", "close()");
        }
        this.commonProducer.close();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQMessageProducer", "close()");
        }
    }

    public int getDeliveryMode() throws JMSException {
        int traceRet1 = this.commonProducer.getDeliveryMode();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQMessageProducer", "getDeliveryMode()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public Destination getDestination() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQMessageProducer", "getDestination()");
        }
        Destination traceRet1 = null;
        Destination dest = this.commonProducer.getDestination();
        traceRet1 = dest instanceof TemporaryQueue ? new MQTemporaryQueue((TemporaryQueue)dest) : (dest instanceof TemporaryTopic ? new MQTemporaryTopic((TemporaryTopic)dest) : dest);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQMessageProducer", "getDestination()", traceRet1);
        }
        return traceRet1;
    }

    public boolean getDisableMessageID() throws JMSException {
        boolean traceRet1 = this.commonProducer.getDisableMessageID();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQMessageProducer", "getDisableMessageID()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        boolean traceRet1 = this.commonProducer.getDisableMessageTimestamp();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQMessageProducer", "getDisableMessageTimestamp()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public int getPriority() throws JMSException {
        int traceRet1 = this.commonProducer.getPriority();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQMessageProducer", "getPriority()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public long getTimeToLive() throws JMSException {
        long traceRet1 = this.commonProducer.getTimeToLive();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQMessageProducer", "getTimeToLive()", "getter", new Long(traceRet1));
        }
        return traceRet1;
    }

    public void send(Destination destination, Message message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQMessageProducer", "send(Destination,Message)", new Object[]{destination, message});
        }
        JmsDestination dest = destination == null ? null : (JmsDestination)((MQDestination)destination).validateDestination();
        Message msg = message;
        if (message instanceof JMSMessage) {
            msg = ((JMSMessage)message).getDelegate();
        }
        this.commonProducer.send(dest, msg);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQMessageProducer", "send(Destination,Message)");
        }
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQMessageProducer", "send(Destination,Message,int,int,long)", new Object[]{destination, message, new Integer(deliveryMode), new Integer(priority), new Long(timeToLive)});
        }
        JmsDestination dest = destination == null ? null : (JmsDestination)((MQDestination)destination).validateDestination();
        Message msg = message;
        if (message instanceof JMSMessage) {
            msg = ((JMSMessage)message).getDelegate();
        }
        this.commonProducer.send(dest, msg, deliveryMode, priority, timeToLive);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQMessageProducer", "send(Destination,Message,int,int,long)");
        }
    }

    public void send(Message message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQMessageProducer", "send(Message)", new Object[]{message});
        }
        Message msg = message;
        if (message instanceof JMSMessage) {
            msg = ((JMSMessage)message).getDelegate();
        }
        this.commonProducer.send(msg);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQMessageProducer", "send(Message)");
        }
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQMessageProducer", "send(Message,int,int,long)", new Object[]{message, new Integer(deliveryMode), new Integer(priority), new Long(timeToLive)});
        }
        Message msg = message;
        if (message instanceof JMSMessage) {
            msg = ((JMSMessage)message).getDelegate();
        }
        this.commonProducer.send(msg, deliveryMode, priority, timeToLive);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQMessageProducer", "send(Message,int,int,long)");
        }
    }

    void setDelegate(JmsMessageProducer commonProducer) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQMessageProducer", "setDelegate(JmsMessageProducer)", "setter", commonProducer);
        }
        this.commonProducer = commonProducer;
        this.delegate = commonProducer;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQMessageProducer", "setDeliveryMode(int)", "setter", new Integer(deliveryMode));
        }
        this.commonProducer.setDeliveryMode(deliveryMode);
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQMessageProducer", "setDisableMessageID(boolean)", "setter", value);
        }
        this.commonProducer.setDisableMessageID(value);
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQMessageProducer", "setDisableMessageTimestamp(boolean)", "setter", value);
        }
        this.commonProducer.setDisableMessageTimestamp(value);
    }

    public void setPriority(int priority) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQMessageProducer", "setPriority(int)", "setter", new Integer(priority));
        }
        this.commonProducer.setPriority(priority);
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQMessageProducer", "setTimeToLive(long)", "setter", new Long(timeToLive));
        }
        this.commonProducer.setTimeToLive(timeToLive);
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.MQMessageProducer", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQMessageProducer.java, jmscc.migration.wmq, k701, k701-112-140304  1.35.1.2 10/02/22 13:51:45");
        }
    }
}

