/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSBytesMessage;
import com.ibm.jms.JMSMapMessage;
import com.ibm.jms.JMSMessage;
import com.ibm.jms.JMSObjectMessage;
import com.ibm.jms.JMSStreamMessage;
import com.ibm.jms.JMSTextMessage;
import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQRoot;
import com.ibm.mq.jms.MQTopic;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsMessageConsumer;
import com.ibm.msg.client.jms.JmsQueue;
import com.ibm.msg.client.jms.JmsQueueReceiver;
import com.ibm.msg.client.jms.JmsTopicSubscriber;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public class MQMessageConsumer
extends MQRoot
implements MessageConsumer,
JmsMessageConsumer {
    static final long serialVersionUID = 1357803352856448348L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected JmsMessageConsumer commonConsumer;

    MQMessageConsumer() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQMessageConsumer", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQMessageConsumer", "<init>()");
        }
    }

    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQMessageConsumer", "close()");
        }
        this.commonConsumer.close();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQMessageConsumer", "close()");
        }
    }

    public Destination getDestination() throws JMSException {
        MQDestination wrapper = null;
        if (this.commonConsumer instanceof JmsTopicSubscriber) {
            wrapper = (MQTopic)((JmsTopicSubscriber)this.commonConsumer).getTopic();
        } else if (this.commonConsumer instanceof JmsQueueReceiver) {
            wrapper = (MQQueue)((JmsQueue)((JmsQueueReceiver)this.commonConsumer).getQueue());
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQMessageConsumer", "getDestination()", "getter", wrapper);
        }
        return wrapper;
    }

    public MessageListener getMessageListener() throws JMSException {
        FacadeMessageListener wrapper;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQMessageConsumer", "getMessageListener()");
        }
        if ((wrapper = (FacadeMessageListener)this.commonConsumer.getMessageListener()) == null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQMessageConsumer", "getMessageListener()", null, 1);
            }
            return null;
        }
        MessageListener listener = wrapper.listener;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQMessageConsumer", "getMessageListener()", listener, 2);
        }
        return listener;
    }

    public String getMessageSelector() throws JMSException {
        String traceRet1 = this.commonConsumer.getMessageSelector();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQMessageConsumer", "getMessageSelector()", "getter", traceRet1);
        }
        return traceRet1;
    }

    static Message wrapCommmonMessage(Message message) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQMessageConsumer", "wrapCommmonMessage(Message)", new Object[]{message});
        }
        JMSMessage wrapper = null;
        if (message instanceof BytesMessage) {
            wrapper = new JMSBytesMessage();
        } else if (message instanceof MapMessage) {
            wrapper = new JMSMapMessage();
        } else if (message instanceof StreamMessage) {
            wrapper = new JMSStreamMessage();
        } else if (message instanceof ObjectMessage) {
            wrapper = new JMSObjectMessage();
        } else if (message instanceof TextMessage) {
            wrapper = new JMSTextMessage();
        } else if (message != null) {
            wrapper = new JMSMessage();
        }
        if (wrapper != null) {
            wrapper.setDelegate(message);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQMessageConsumer", "wrapCommmonMessage(Message)", wrapper);
        }
        return wrapper;
    }

    public Message receive() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQMessageConsumer", "receive()");
        }
        Message commonMessage = this.commonConsumer.receive();
        Message traceRet1 = MQMessageConsumer.wrapCommmonMessage(commonMessage);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQMessageConsumer", "receive()", traceRet1);
        }
        return traceRet1;
    }

    public Message receive(long timeout) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQMessageConsumer", "receive(long)", new Object[]{new Long(timeout)});
        }
        Message commonMessage = this.commonConsumer.receive(timeout);
        Message traceRet1 = MQMessageConsumer.wrapCommmonMessage(commonMessage);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQMessageConsumer", "receive(long)", traceRet1);
        }
        return traceRet1;
    }

    public Message receiveNoWait() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQMessageConsumer", "receiveNoWait()");
        }
        Message commonMessage = this.commonConsumer.receiveNoWait();
        Message traceRet1 = MQMessageConsumer.wrapCommmonMessage(commonMessage);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQMessageConsumer", "receiveNoWait()", traceRet1);
        }
        return traceRet1;
    }

    void setDelegate(JmsMessageConsumer commonConsumer) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQMessageConsumer", "setDelegate(JmsMessageConsumer)", "setter", commonConsumer);
        }
        this.commonConsumer = commonConsumer;
        this.delegate = commonConsumer;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQMessageConsumer", "setMessageListener(MessageListener)", new Object[]{listener});
        }
        FacadeMessageListener wrapper = null;
        if (listener != null) {
            wrapper = new FacadeMessageListener(listener);
        }
        this.commonConsumer.setMessageListener(wrapper);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQMessageConsumer", "setMessageListener(MessageListener)");
        }
    }

    public boolean getNoLocal() throws JMSException {
        boolean traceRet1 = this.commonConsumer.getNoLocal();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQMessageConsumer", "getNoLocal()", "getter", traceRet1);
        }
        return traceRet1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.MQMessageConsumer", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQMessageConsumer.java, jmscc.migration.wmq, k701, k701-112-140304  1.34.1.1 09/08/17 08:58:35");
        }
    }

    private class FacadeMessageListener
    implements MessageListener {
        private MessageListener listener = null;

        public FacadeMessageListener(MessageListener listener) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.mq.jms.FacadeMessageListener", "<init>(MessageListener)", new Object[]{listener});
            }
            this.listener = listener;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.FacadeMessageListener", "<init>(MessageListener)");
            }
        }

        public void onMessage(Message message) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.mq.jms.FacadeMessageListener", "onMessage(Message)", new Object[]{message});
            }
            JMSMessage wrapper = null;
            if (message instanceof BytesMessage) {
                wrapper = new JMSBytesMessage();
                wrapper.setDelegate(message);
            } else if (message instanceof TextMessage) {
                wrapper = new JMSTextMessage();
                wrapper.setDelegate(message);
            } else if (message instanceof MapMessage) {
                wrapper = new JMSMapMessage();
                wrapper.setDelegate(message);
            } else if (message instanceof StreamMessage) {
                wrapper = new JMSStreamMessage();
                wrapper.setDelegate(message);
            } else if (message instanceof ObjectMessage) {
                wrapper = new JMSObjectMessage();
                wrapper.setDelegate(message);
            } else {
                wrapper = new JMSMessage();
                wrapper.setDelegate(message);
            }
            this.listener.onMessage((Message)wrapper);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.FacadeMessageListener", "onMessage(Message)");
            }
        }
    }
}

