/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQJMSASIVT;
import com.ibm.mq.jms.MQJMSIVT;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.services.Version;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.directory.InitialDirContext;

public class MQJMSPSIVT {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQJMSPSIVT.java, jmscc.migration.wmq, k701, k701-112-140304 1.33.1.1 09/08/17 08:51:26";
    public static final String CLASSNAME = "MQJMSPSIVT";
    public static String QMGR;
    public static String TOPIC;
    public static String STREAM;
    public static final String tcfLookup = "ivtTCF";
    public static final String tLookup = "ivtT";
    public static boolean client;
    public static String hostname;
    public static String port;
    public static String channel;
    public static String ccsid;
    public static String bqm;
    public static String version;
    private static PrintWriter pw;

    public static void main(String[] args) throws UnsupportedEncodingException {
        String msg;
        int systemrc;
        int ccsidNumber;
        int portNumber;
        String url;
        String icf;
        boolean useJNDI;
        InitialDirContext ctx;
        MQTopicConnectionFactory factory;
        TopicConnection connection;
        TopicSession session;
        Topic topic;
        String outString;
        block103: {
            if (Trace.isOn) {
                Trace.entry("com.ibm.mq.jms.MQJMSPSIVT", "main(String [ ])", new Object[]{args});
            }
            outString = null;
            topic = null;
            session = null;
            connection = null;
            factory = null;
            ctx = null;
            useJNDI = true;
            boolean enableTrace = false;
            icf = "com.sun.jndi.ldap.LdapCtxFactory";
            url = null;
            portNumber = 0;
            ccsidNumber = 0;
            systemrc = 0;
            NLSServices.addCatalogue("com.ibm.mq.jms.resources.JMSMQ_MessageResourceBundle", "JMSMQ");
            String encoding = System.getProperty("console.encoding");
            pw = NLSServices.isWindowsLatinCodepage() && encoding != null ? new PrintWriter(new OutputStreamWriter((OutputStream)System.out, encoding)) : new PrintWriter(new OutputStreamWriter(System.out));
            MQJMSASIVT.setupWatcherThread(pw);
            try {
                Class.forName("javax.jms.Message");
            }
            catch (ClassNotFoundException e) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.mq.jms.MQJMSPSIVT", "main(String [ ])", e, 1);
                }
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "javax.jms.Message missing", null);
                    Trace.traceData(CLASSNAME, "classpath check failed with " + e, null);
                    Trace.exit(CLASSNAME, "main", (Object)null);
                }
                System.err.println(NLSServices.getMessage("JMSMQ5037", "javax.jms.Message"));
            }
            String pv = "7";
            Version.Component[] comp = Version.getComponents("MPI", "com.ibm.msg.client.wmq");
            if (comp.length > 0) {
                pv = comp[0].getVersionString() + " " + comp[0].getImplementationInfo().get("CMVC");
            }
            pw.println();
            pw.println(NLSServices.getMessage("JMSMQ1003"));
            pw.println(NLSServices.getMessage("JMSMQ1002", pv));
            pw.println(NLSServices.getMessage("JMSMQ5039") + "\n");
            MQJMSIVT.runFrom(pw);
            pw.flush();
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].toLowerCase();
                if (arg.equals("-nojndi")) {
                    useJNDI = false;
                    continue;
                }
                if (arg.equals("-m")) {
                    if (i + 1 < args.length) {
                        QMGR = args[++i];
                        continue;
                    }
                    msg = NLSServices.getMessage("JMSMQ5036", "-m");
                    pw.println(msg);
                    pw.flush();
                    continue;
                }
                if (arg.equals("-t")) {
                    enableTrace = true;
                    Trace.setOn(true);
                    continue;
                }
                if (arg.equals("-url")) {
                    if (i + 1 < args.length) {
                        url = args[++i];
                        continue;
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5001"));
                    pw.flush();
                    continue;
                }
                if (arg.equals("-icf")) {
                    if (i + 1 < args.length) {
                        icf = args[++i];
                        continue;
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5002"));
                    pw.flush();
                    continue;
                }
                if (arg.equals("-client")) {
                    client = true;
                    continue;
                }
                if (arg.equals("-host")) {
                    if (i + 1 < args.length) {
                        hostname = args[++i];
                        continue;
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5036", "-host"));
                    pw.flush();
                    continue;
                }
                if (arg.equals("-port")) {
                    if (i + 1 < args.length) {
                        port = args[++i];
                        continue;
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5036", "-port"));
                    pw.flush();
                    continue;
                }
                if (arg.equals("-channel")) {
                    if (i + 1 < args.length) {
                        channel = args[++i];
                        continue;
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5036", "-channel"));
                    pw.flush();
                    continue;
                }
                if (arg.equals("-bqm")) {
                    if (i + 1 < args.length) {
                        bqm = args[++i];
                        continue;
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5036", "-bqm"));
                    pw.flush();
                    continue;
                }
                if (arg.equals("-ccsid")) {
                    if (i + 1 < args.length) {
                        ccsid = args[++i];
                        continue;
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5036", "-ccsid"));
                    pw.flush();
                    continue;
                }
                if (arg.equals("-v")) {
                    if (i + 1 < args.length) {
                        version = args[++i];
                        continue;
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5036", "-v"));
                    pw.flush();
                    continue;
                }
                msg = NLSServices.getMessage("JMSMQ5003", arg);
                pw.println(msg);
                pw.flush();
            }
            if (useJNDI) {
                if (url == null) {
                    MQJMSPSIVT.displayUsage();
                    System.exit(-1);
                }
                if (client || QMGR != null || hostname != null || port != null || channel != null || bqm != null || version != null) {
                    MQJMSPSIVT.displayUsage();
                    System.exit(-1);
                }
            } else if (!client) {
                if (hostname != null || port != null || channel != null) {
                    MQJMSPSIVT.displayUsage();
                    System.exit(-1);
                }
            } else if (QMGR == null || hostname == null) {
                MQJMSPSIVT.displayUsage();
                System.exit(-1);
            }
            if (!client && !useJNDI && QMGR == null) {
                QMGR = "";
            }
            if (!useJNDI && bqm == null) {
                bqm = QMGR;
            }
            if (client) {
                try {
                    portNumber = port == null ? 1414 : Integer.parseInt(port);
                }
                catch (NumberFormatException nfe) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.mq.jms.MQJMSPSIVT", "main(String [ ])", nfe, 2);
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5064"));
                    pw.flush();
                    System.exit(-1);
                }
                if (channel == null) {
                    channel = "SYSTEM.DEF.SVRCONN";
                }
                if (ccsid != null && ccsid.length() > 0) {
                    try {
                        ccsidNumber = Integer.parseInt(ccsid);
                    }
                    catch (NumberFormatException nfe) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.mq.jms.MQJMSPSIVT", "main(String [ ])", nfe, 3);
                        }
                        pw.println(NLSServices.getMessage("JMSMQ1046", ccsid));
                        pw.flush();
                        System.exit(-1);
                    }
                }
            }
            try {
                String msg2;
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "checking classpath", null);
                }
                try {
                    Class.forName("javax.naming.InitialContext");
                }
                catch (ClassNotFoundException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.mq.jms.MQJMSPSIVT", "main(String [ ])", e, 4);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "javax.naming.InitialContext missing", null);
                    }
                    msg2 = NLSServices.getMessage("JMSMQ5037", "jndi.jar");
                    System.err.println(msg2);
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.mq.jms.MQJMSPSIVT", "main(String [ ])", e, 1);
                    }
                    throw e;
                }
                if (!useJNDI) break block103;
                try {
                    Class.forName(icf);
                }
                catch (ClassNotFoundException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.mq.jms.MQJMSPSIVT", "main(String [ ])", e, 5);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "jndi provider for '" + icf + "' missing", null);
                    }
                    msg2 = NLSServices.getMessage("JMSMQ5038", icf);
                    System.err.println(msg2);
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.mq.jms.MQJMSPSIVT", "main(String [ ])", e, 2);
                    }
                    throw e;
                }
            }
            catch (ClassNotFoundException e) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.mq.jms.MQJMSPSIVT", "main(String [ ])", e, 6);
                }
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "classpath check failed with " + e, null);
                    Trace.exit(CLASSNAME, "main");
                }
                System.err.println(e);
                System.exit(-1);
            }
        }
        if (useJNDI) {
            if (url == null) {
                pw.println(NLSServices.getMessage("JMSMQ5004"));
                pw.flush();
                System.exit(-1);
            } else {
                pw.println(NLSServices.getMessage("JMSMQ5005"));
                pw.flush();
                Hashtable<String, String> environment = new Hashtable<String, String>();
                environment.put("java.naming.factory.initial", icf);
                environment.put("java.naming.provider.url", url);
                environment.put("java.naming.referral", "throw");
                try {
                    ctx = new InitialDirContext(environment);
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.mq.jms.MQJMSPSIVT", "main(String [ ])", e, 7);
                    }
                    msg = NLSServices.getMessage("JMSMQ5006");
                    pw.println(msg);
                    pw.println(e);
                    pw.flush();
                    System.exit(-1);
                }
                pw.println(NLSServices.getMessage("JMSMQ5040"));
                pw.flush();
                try {
                    factory = (TopicConnectionFactory)ctx.lookup(tcfLookup);
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.mq.jms.MQJMSPSIVT", "main(String [ ])", e, 8);
                    }
                    try {
                        factory = (TopicConnectionFactory)ctx.lookup("cn=ivtTCF");
                    }
                    catch (Exception e2) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.mq.jms.MQJMSPSIVT", "main(String [ ])", e2, 9);
                        }
                        pw.println(NLSServices.getMessage("JMSMQ5041"));
                        pw.println(e2);
                        pw.flush();
                        System.exit(-1);
                    }
                }
                pw.println(NLSServices.getMessage("JMSMQ5042"));
                pw.flush();
                try {
                    topic = (Topic)ctx.lookup(tLookup);
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.mq.jms.MQJMSPSIVT", "main(String [ ])", e, 10);
                    }
                    try {
                        topic = (Topic)ctx.lookup("cn=ivtT");
                    }
                    catch (Exception e2) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.mq.jms.MQJMSPSIVT", "main(String [ ])", e2, 11);
                        }
                        pw.println(NLSServices.getMessage("JMSMQ5043"));
                        pw.println(e2);
                        pw.flush();
                        System.exit(-1);
                    }
                }
            }
        }
        outString = "A simple text message from the MQJMSPSIVT program";
        try {
            if (!useJNDI) {
                pw.println(NLSServices.getMessage("JMSMQ5044"));
                pw.flush();
                factory = new MQTopicConnectionFactory();
                try {
                    factory.setQueueManager(QMGR);
                    factory.setBrokerQueueManager(bqm);
                    factory.setSubscriptionStore(2);
                    if (null != version) {
                        factory.setStringProperty("XMSC_WMQ_PROVIDER_VERSION", version);
                    }
                    if (client) {
                        factory.setTransportType(1);
                        factory.setHostName(hostname);
                        factory.setPort(portNumber);
                        factory.setChannel(channel);
                        if (ccsid != null) {
                            factory.setCCSID(ccsidNumber);
                        }
                    }
                }
                catch (JMSException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.mq.jms.MQJMSPSIVT", "main(String [ ])", e, 12);
                    }
                    systemrc = 2;
                    pw.println(NLSServices.getMessage("JMSMQ5045"));
                    pw.println((Object)e);
                    pw.flush();
                    System.exit(-1);
                }
            }
            pw.println(NLSServices.getMessage("JMSMQ5010"));
            pw.flush();
            connection = factory.createTopicConnection();
            connection.start();
            pw.println(NLSServices.getMessage("JMSMQ5011"));
            pw.flush();
            boolean transacted = false;
            session = connection.createTopicSession(transacted, 1);
            if (!useJNDI) {
                pw.println(NLSServices.getMessage("JMSMQ5046"));
                pw.flush();
                try {
                    topic = session.createTopic(TOPIC);
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.mq.jms.MQJMSPSIVT", "main(String [ ])", je, 13);
                    }
                    systemrc = 2;
                    pw.println(NLSServices.getMessage("JMSMQ5047"));
                    pw.println((Object)je);
                    pw.flush();
                    System.exit(-1);
                }
            }
            pw.println(NLSServices.getMessage("JMSMQ5048"));
            pw.flush();
            TopicPublisher tPub = session.createPublisher(topic);
            pw.println(NLSServices.getMessage("JMSMQ5049"));
            pw.flush();
            TopicSubscriber tSub = session.createSubscriber(topic);
            pw.println(NLSServices.getMessage("JMSMQ5017"));
            pw.flush();
            TextMessage outMessage = session.createTextMessage();
            pw.println(NLSServices.getMessage("JMSMQ5050"));
            pw.flush();
            outMessage.setText(outString);
            pw.println(NLSServices.getMessage("JMSMQ5051", topic.getTopicName()));
            tPub.publish((Message)outMessage);
            pw.flush();
            pw.println(NLSServices.getMessage("JMSMQ5052"));
            pw.flush();
            Message inMessage = tSub.receive(5000L);
            if (inMessage == null) {
                pw.println(NLSServices.getMessage("JMSMQ5054"));
                pw.flush();
                pw.println(NLSServices.getMessage("JMSMQ5055"));
                pw.flush();
                JMSException traceRet1 = new JMSException(NLSServices.getMessage("JMSMQ5021"));
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.mq.jms.MQJMSPSIVT", "main(String [ ])", traceRet1, 3);
                }
                throw traceRet1;
            }
            pw.println("\n" + NLSServices.getMessage("JMSMQ5022") + ": " + inMessage);
            pw.flush();
            if (inMessage instanceof TextMessage) {
                String replyString = ((TextMessage)inMessage).getText();
                if (replyString.equals(outString)) {
                    pw.println(NLSServices.getMessage("JMSMQ5023"));
                    pw.flush();
                } else {
                    pw.println(NLSServices.getMessage("JMSMQ5024"));
                    pw.println(NLSServices.getMessage("JMSMQ5025") + " = '" + outString + "'");
                    pw.println(NLSServices.getMessage("JMSMQ5026") + " = '" + replyString + "'");
                    pw.flush();
                }
            } else {
                pw.println(NLSServices.getMessage("JMSMQ5027"));
                pw.flush();
            }
            pw.println(NLSServices.getMessage("JMSMQ5056"));
            pw.flush();
            tSub.close();
            pw.println(NLSServices.getMessage("JMSMQ5057"));
            pw.flush();
            tPub.close();
            pw.println(NLSServices.getMessage("JMSMQ5031"));
            pw.flush();
            session.close();
            session = null;
            pw.println(NLSServices.getMessage("JMSMQ5032"));
            pw.flush();
            connection.close();
            connection = null;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.mq.jms.MQJMSPSIVT", "main(String [ ])", je, 14);
            }
            pw.println(NLSServices.getMessage("JMSMQ5034"));
            MQJMSIVT.handleException((Exception)((Object)je), pw);
            pw.flush();
            systemrc = 2;
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.mq.jms.MQJMSPSIVT", "main(String [ ])", e, 15);
            }
            pw.println(NLSServices.getMessage("JMSMQ5034"));
            e.printStackTrace(pw);
            pw.flush();
            systemrc = 3;
        }
        pw.println(NLSServices.getMessage("JMSMQ5059") + "\n");
        pw.flush();
        System.exit(systemrc);
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQJMSPSIVT", "main(String [ ])");
        }
    }

    private static void displayUsage() {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQJMSPSIVT", "displayUsage()");
        }
        pw.println(NLSServices.getMessage("JMSMQ5069"));
        pw.println("    " + NLSServices.getMessage("JMSMQ5070"));
        pw.println("    " + NLSServices.getMessage("JMSMQ5071"));
        pw.println("    " + NLSServices.getMessage("JMSMQ5072"));
        pw.flush();
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQJMSPSIVT", "displayUsage()");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.MQJMSPSIVT", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQJMSPSIVT.java, jmscc.migration.wmq, k701, k701-112-140304  1.33.1.1 09/08/17 08:51:26");
        }
        QMGR = null;
        TOPIC = "MQJMS/PSIVT/Information";
        STREAM = "SYSTEM.BROKER.DEFAULT.STREAM";
        client = false;
        hostname = null;
        port = null;
        channel = null;
        ccsid = null;
        bqm = null;
        version = null;
        pw = null;
    }
}

