/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.services.Version;
import java.util.Map;

public class MQJMSLevel {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int DEFAULT_FIELDS = 15;
    protected static int fields;
    private static final String NAME_TITLE = "Name:        ";
    private static final String VERSION_TITLE = "Version:     ";
    private static final String BUILDTYPE_TITLE = "Build Type:  ";
    private static final String CMVCLEVEL_TITLE = "CMVC Level:  ";
    static final String sccsid = "@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQJMSLevel.java, jmscc.migration.wmq, k701, k701-112-140304 1.19.1.2 09/09/01 10:28:49";
    protected static final String[] TITLES;
    protected static boolean withTitles;
    protected static boolean quiet;

    protected MQJMSLevel() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQJMSLevel", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQJMSLevel", "<init>()");
        }
    }

    public static void main(String[] args) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQJMSLevel", "main(String [ ])", new Object[]{args});
        }
        MQJMSLevel.parseCommandLine(args);
        MQJMSLevel.printMQVERInfo();
        System.exit(0);
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQJMSLevel", "main(String [ ])");
        }
    }

    protected static final void parseCommandLine(String[] args) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQJMSLevel", "parseCommandLine(String [ ])", new Object[]{args});
        }
        if (args.length == 0) {
            fields = 15;
        } else {
            boolean fDefined = false;
            for (int i = 0; i < args.length; ++i) {
                String thisArg = args[i];
                if (!thisArg.startsWith("-")) continue;
                if (thisArg.charAt(1) == 'b') {
                    withTitles = false;
                    continue;
                }
                if (thisArg.charAt(1) == 'f') {
                    fDefined = true;
                    String num = null;
                    num = thisArg.length() > 2 ? thisArg.substring(2) : args[i + 1];
                    try {
                        fields = Integer.parseInt(num);
                    }
                    catch (NumberFormatException nfe) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.mq.jms.MQJMSLevel", "parseCommandLine(String [ ])", nfe);
                        }
                        fields = 15;
                    }
                    continue;
                }
                if (thisArg.charAt(1) != 'q') continue;
                quiet = true;
            }
            if (!fDefined) {
                fields = 15;
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQJMSLevel", "parseCommandLine(String [ ])");
        }
    }

    protected static void printMQVERInfo() {
        Version.Component[] components;
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQJMSLevel", "printMQVERInfo()");
        }
        if ((components = Version.getComponents()) != null && components.length > 0) {
            for (int c = 0; c < components.length; ++c) {
                int i = 0;
                int k = 1;
                while (i < 4) {
                    if ((fields & k) != 0) {
                        if (withTitles) {
                            System.out.print(TITLES[i]);
                        }
                        System.out.println(MQJMSLevel.queryValue(i, components[c]));
                    }
                    ++i;
                    k *= 2;
                }
                System.out.println("");
            }
        } else {
            System.out.println(NLSServices.getMessage("JMSMQ1115"));
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQJMSLevel", "printMQVERInfo()");
        }
    }

    protected static String queryValue(int id, Version.Component component) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQJMSLevel", "queryValue(int,Component)", new Object[]{new Integer(id), component});
        }
        switch (id) {
            case 0: {
                String traceRet1 = component.getTitle();
                if (Trace.isOn) {
                    Trace.exit("com.ibm.mq.jms.MQJMSLevel", "queryValue(int,Component)", (Object)traceRet1, 1);
                }
                return traceRet1;
            }
            case 1: {
                String traceRet2 = component.getVersionString();
                if (Trace.isOn) {
                    Trace.exit("com.ibm.mq.jms.MQJMSLevel", "queryValue(int,Component)", (Object)traceRet2, 2);
                }
                return traceRet2;
            }
            case 2: {
                Map info = component.getImplementationInfo(quiet);
                if (info != null) {
                    String cmvcLevel = (String)info.get("CMVC");
                    String mqjbndLevel = (String)info.get("mqjbnd level");
                    StringBuffer returnStr = new StringBuffer();
                    if (cmvcLevel != null) {
                        returnStr.append(cmvcLevel);
                    }
                    if (mqjbndLevel != null) {
                        returnStr.append(" mqjbnd=").append(mqjbndLevel);
                    }
                    String traceRet3 = returnStr.toString();
                    if (Trace.isOn) {
                        Trace.exit("com.ibm.mq.jms.MQJMSLevel", "queryValue(int,Component)", (Object)traceRet3, 3);
                    }
                    return traceRet3;
                }
                if (Trace.isOn) {
                    Trace.exit("com.ibm.mq.jms.MQJMSLevel", "queryValue(int,Component)", (Object)"missing build level", 4);
                }
                return "missing build level";
            }
            case 3: {
                if (Trace.isOn) {
                    Trace.exit("com.ibm.mq.jms.MQJMSLevel", "queryValue(int,Component)", (Object)"Production", 5);
                }
                return "Production";
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQJMSLevel", "queryValue(int,Component)", (Object)"missing package data", 6);
        }
        return "missing package data";
    }

    public static void traceBuildInfo() {
        Version.Component[] components;
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQJMSLevel", "traceBuildInfo()");
        }
        if (Trace.isOn && (components = Version.getComponents()) != null) {
            for (int c = 0; c < components.length; ++c) {
                String title = MQJMSLevel.queryValue(0, components[c]);
                String version = MQJMSLevel.queryValue(1, components[c]);
                String cmvcLevel = MQJMSLevel.queryValue(2, components[c]);
                String buildType = MQJMSLevel.queryValue(3, components[c]);
                Trace.traceData("*** BuildInfo ***", title + " (" + version + ")", null);
                Trace.traceData("*** BuildInfo ***", cmvcLevel + " (" + buildType + ")", null);
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQJMSLevel", "traceBuildInfo()");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.MQJMSLevel", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQJMSLevel.java, jmscc.migration.wmq, k701, k701-112-140304  1.19.1.2 09/09/01 10:28:49");
        }
        fields = 15;
        TITLES = new String[]{NAME_TITLE, VERSION_TITLE, CMVCLEVEL_TITLE, BUILDTYPE_TITLE};
        withTitles = true;
        quiet = false;
    }
}

