/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQException;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jms.MQJMSASIVT;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsExceptionDetail;
import com.ibm.msg.client.services.Version;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.directory.InitialDirContext;

public class MQJMSIVT {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQJMSIVT.java, jmscc.migration.wmq, k701, k701-112-140304 1.36.1.1 09/08/17 08:51:18";
    public static final String CLASSNAME = "MQJMSIVT";
    public static String QMGR;
    public static final String QUEUE = "SYSTEM.DEFAULT.LOCAL.QUEUE";
    public static final String qcfLookup = "ivtQCF";
    public static final String qLookup = "ivtQ";
    public static boolean client;
    public static String hostname;
    public static String port;
    public static String channel;
    public static String ccsid;
    public static String version;
    private static PrintWriter pw;
    static int titleSize;
    private static String lineSeparator;

    public static void main(String[] args) throws UnsupportedEncodingException {
        int systemrc;
        block138: {
            String msg;
            int ccsidNumber;
            int portNumber;
            String url;
            String icf;
            boolean useJNDI;
            Context ctx;
            MQQueueConnectionFactory factory;
            QueueConnection connection;
            QueueSession session;
            Queue ioQueue;
            String outString;
            block137: {
                if (Trace.isOn) {
                    Trace.entry("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])", new Object[]{args});
                }
                NLSServices.addCatalogue("com.ibm.mq.jms.resources.JMSMQ_MessageResourceBundle", "JMSMQ");
                systemrc = 0;
                String encProp = "console.encoding";
                PropertyStore.register(encProp, "");
                String encoding = PropertyStore.getStringProperty(encProp);
                pw = NLSServices.isWindowsLatinCodepage() && encoding != "" && encoding != null ? new PrintWriter(new OutputStreamWriter((OutputStream)System.out, encoding)) : new PrintWriter(new OutputStreamWriter(System.out));
                MQJMSASIVT.setupWatcherThread(pw);
                outString = null;
                ioQueue = null;
                session = null;
                connection = null;
                factory = null;
                ctx = null;
                useJNDI = true;
                boolean enableTrace = false;
                icf = "com.sun.jndi.ldap.LdapCtxFactory";
                url = null;
                portNumber = 0;
                ccsidNumber = 0;
                try {
                    Class.forName("javax.jms.Message");
                }
                catch (ClassNotFoundException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])", e, 1);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "javax.jms.Message missing", null);
                        Trace.traceData(CLASSNAME, "classpath check failed with " + e, null);
                        Trace.exit(CLASSNAME, "main", (Object)null);
                    }
                    System.err.println(NLSServices.getMessage("JMSMQ5037", "javax.jms.Message"));
                }
                String pv = "7";
                Version.Component[] comp = Version.getComponents("MPI", "com.ibm.msg.client.wmq");
                if (comp.length > 0) {
                    pv = comp[0].getVersionString() + " " + comp[0].getImplementationInfo().get("CMVC");
                }
                pw.println();
                pw.println(NLSServices.getMessage("JMSMQ1003"));
                pw.println(NLSServices.getMessage("JMSMQ1002", pv));
                pw.println(NLSServices.getMessage("JMSMQ5000") + "\n");
                MQJMSIVT.runFrom(pw);
                pw.flush();
                for (int i = 0; i < args.length; ++i) {
                    String arg = args[i].toLowerCase();
                    if (arg.equals("-nojndi")) {
                        useJNDI = false;
                        continue;
                    }
                    if (arg.equals("-m")) {
                        if (i + 1 < args.length) {
                            QMGR = args[++i];
                            continue;
                        }
                        msg = NLSServices.getMessage("JMSMQ5036", "-m");
                        pw.println(msg);
                        pw.flush();
                        continue;
                    }
                    if (arg.equals("-t")) {
                        Trace.setOn(true);
                        enableTrace = true;
                        continue;
                    }
                    if (arg.equals("-url")) {
                        if (i + 1 < args.length) {
                            url = args[++i];
                            continue;
                        }
                        pw.println(NLSServices.getMessage("JMSMQ5001"));
                        pw.flush();
                        continue;
                    }
                    if (arg.equals("-icf")) {
                        if (i + 1 < args.length) {
                            icf = args[++i];
                            continue;
                        }
                        pw.println(NLSServices.getMessage("JMSMQ5002"));
                        pw.flush();
                        continue;
                    }
                    if (arg.equals("-client")) {
                        client = true;
                        continue;
                    }
                    if (arg.equals("-host")) {
                        if (i + 1 < args.length) {
                            hostname = args[++i];
                            continue;
                        }
                        pw.println(NLSServices.getMessage("JMSMQ5036", "-host"));
                        pw.flush();
                        continue;
                    }
                    if (arg.equals("-port")) {
                        if (i + 1 < args.length) {
                            port = args[++i];
                            continue;
                        }
                        pw.println(NLSServices.getMessage("JMSMQ5036", "-port"));
                        continue;
                    }
                    if (arg.equals("-channel")) {
                        if (i + 1 < args.length) {
                            channel = args[++i];
                            continue;
                        }
                        pw.println(NLSServices.getMessage("JMSMQ5036", "-channel"));
                        pw.flush();
                        continue;
                    }
                    if (arg.equals("-ccsid")) {
                        if (i + 1 < args.length) {
                            ccsid = args[++i];
                            continue;
                        }
                        pw.println(NLSServices.getMessage("JMSMQ5036", "-ccsid"));
                        pw.flush();
                        continue;
                    }
                    if (arg.equals("-v")) {
                        if (i + 1 < args.length) {
                            version = args[++i];
                            continue;
                        }
                        pw.println(NLSServices.getMessage("JMSMQ5036", "-v"));
                        pw.flush();
                        continue;
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5003", arg));
                    pw.flush();
                }
                if (enableTrace && Trace.isOn) {
                    Trace.entry(CLASSNAME, "main");
                    Trace.traceData(CLASSNAME, "Trace started from main by -t flag", null);
                }
                if (useJNDI) {
                    if (url == null) {
                        MQJMSIVT.displayUsage();
                        System.exit(-1);
                    }
                    if (client || QMGR != null || hostname != null || port != null || channel != null || version != null) {
                        MQJMSIVT.displayUsage();
                        System.exit(-1);
                    }
                } else if (!client) {
                    if (hostname != null || port != null || channel != null) {
                        MQJMSIVT.displayUsage();
                        System.exit(-1);
                    }
                } else if (QMGR == null || hostname == null) {
                    MQJMSIVT.displayUsage();
                    System.exit(-1);
                }
                if (!client && !useJNDI && QMGR == null) {
                    QMGR = "";
                }
                if (client) {
                    try {
                        portNumber = port == null ? 1414 : Integer.parseInt(port);
                    }
                    catch (NumberFormatException nfe) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])", nfe, 2);
                        }
                        pw.println(NLSServices.getMessage("JMSMQ5064"));
                        pw.flush();
                        System.exit(-1);
                    }
                    if (channel == null) {
                        channel = "SYSTEM.DEF.SVRCONN";
                    }
                    if (ccsid != null && ccsid.length() > 0) {
                        try {
                            ccsidNumber = Integer.parseInt(ccsid);
                        }
                        catch (NumberFormatException nfe) {
                            if (Trace.isOn) {
                                Trace.catchBlock("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])", nfe, 3);
                            }
                            pw.println(NLSServices.getMessage("JMSMQ1046", ccsid));
                            pw.flush();
                            System.exit(-1);
                        }
                    }
                }
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Using following parameters:", null);
                    if (useJNDI) {
                        Trace.traceData(CLASSNAME, "Using JNDI", null);
                        Trace.traceData(CLASSNAME, "InitialContextFactory: '" + icf + "'", null);
                        Trace.traceData(CLASSNAME, "ProviderURL: '" + url + "'", null);
                    } else {
                        Trace.traceData(CLASSNAME, "Not using JNDI", null);
                        if (client) {
                            Trace.traceData(CLASSNAME, "Using CLIENT connection", null);
                            Trace.traceData(CLASSNAME, "Queue Manager: '" + QMGR + "'", null);
                            Trace.traceData(CLASSNAME, "HostName: '" + hostname + "'", null);
                            Trace.traceData(CLASSNAME, "Port: " + portNumber, null);
                            Trace.traceData(CLASSNAME, "Channel: '" + channel + "'", null);
                            Trace.traceData(CLASSNAME, "Ccsid: '" + ccsid + "'", null);
                        } else {
                            Trace.traceData(CLASSNAME, "Using BINDINGS connection", null);
                            Trace.traceData(CLASSNAME, "Queue Manager: '" + QMGR + "'", null);
                        }
                        Trace.traceData(CLASSNAME, "Provider version: " + version == null ? "not set" : version, null);
                    }
                }
                try {
                    String msg2;
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "checking classpath", null);
                    }
                    try {
                        Class.forName("javax.jms.Message");
                    }
                    catch (ClassNotFoundException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])", e, 4);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "javax.jms.Message missing", null);
                        }
                        msg2 = NLSServices.getMessage("JMSMQ5037", "javax.jms.jar");
                        System.err.println(msg2);
                        pw.flush();
                        if (Trace.isOn) {
                            Trace.throwing("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])", e, 1);
                        }
                        throw e;
                    }
                    try {
                        Class.forName("javax.naming.InitialContext");
                    }
                    catch (ClassNotFoundException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])", e, 5);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "javax.naming.InitialContext missing", null);
                        }
                        msg2 = NLSServices.getMessage("JMSMQ5037", "jndi.jar");
                        System.err.println(msg2);
                        pw.flush();
                        if (Trace.isOn) {
                            Trace.throwing("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])", e, 2);
                        }
                        throw e;
                    }
                    if (!useJNDI) break block137;
                    try {
                        Class.forName(icf);
                    }
                    catch (ClassNotFoundException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])", e, 6);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "jndi provider for '" + icf + "' missing", null);
                        }
                        msg2 = NLSServices.getMessage("JMSMQ5038", icf);
                        System.err.println(msg2);
                        pw.flush();
                        if (Trace.isOn) {
                            Trace.throwing("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])", e, 3);
                        }
                        throw e;
                    }
                }
                catch (ClassNotFoundException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])", e, 7);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "classpath check failed with " + e, null);
                        Trace.exit(CLASSNAME, "main");
                    }
                    System.err.println(e);
                    pw.flush();
                    System.exit(-1);
                }
            }
            if (useJNDI) {
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "User has opted for JNDI lookup", null);
                }
                if (url == null) {
                    pw.println(NLSServices.getMessage("JMSMQ5004"));
                    pw.flush();
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "User has not specified a URL for JNDI lookup", null);
                        Trace.traceData(CLASSNAME, "Exiting via System.exit(-1)", null);
                        Trace.exit(CLASSNAME, "main");
                    }
                    System.exit(-1);
                } else {
                    pw.println(NLSServices.getMessage("JMSMQ5005"));
                    pw.flush();
                    Hashtable<String, String> env = new Hashtable<String, String>();
                    env.put("java.naming.factory.initial", icf);
                    env.put("java.naming.provider.url", url);
                    env.put("java.naming.referral", "throw");
                    try {
                        ctx = new InitialDirContext(env);
                    }
                    catch (Exception e) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])", e, 8);
                        }
                        msg = NLSServices.getMessage("JMSMQ5006");
                        pw.println(msg);
                        pw.println(e);
                        pw.flush();
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "Initial context creation failed!", null);
                            Trace.traceData(CLASSNAME, "main", (Object)e);
                            Trace.traceData(CLASSNAME, "Exiting via System.exit(-1)", null);
                            Trace.exit(CLASSNAME, "main");
                        }
                        pw.flush();
                        System.exit(-1);
                    }
                }
            } else if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "User is bypassing JNDI lookup", null);
            }
            pw.println();
            outString = "A simple text message from the MQJMSIVT program";
            if (!useJNDI) {
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Creating a QCF ourselves", null);
                }
                pw.println(NLSServices.getMessage("JMSMQ5007"));
                pw.flush();
                factory = new MQQueueConnectionFactory();
                try {
                    factory.setQueueManager(QMGR);
                    if (null != version) {
                        factory.setStringProperty("XMSC_WMQ_PROVIDER_VERSION", version);
                    }
                    if (client) {
                        factory.setTransportType(1);
                        factory.setHostName(hostname);
                        factory.setPort(portNumber);
                        factory.setChannel(channel);
                        if (ccsid != null) {
                            factory.setCCSID(ccsidNumber);
                        }
                    }
                }
                catch (JMSException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])", e, 9);
                    }
                    systemrc = 2;
                    pw.println(NLSServices.getMessage("JMSMQ5115"));
                    pw.println((Object)e);
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "Could not set properties in QCF", null);
                        Trace.traceData(CLASSNAME, "main", (Object)e);
                        Trace.traceData(CLASSNAME, "Exiting via System.exit(-1)", null);
                        Trace.exit(CLASSNAME, "main");
                    }
                    pw.flush();
                    System.exit(-1);
                }
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "QCF created OK", null);
                }
            } else {
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Obtaining a QCF from JNDI (lookup key is ivtQCF)", null);
                }
                pw.println(NLSServices.getMessage("JMSMQ5008"));
                pw.flush();
                try {
                    factory = (QueueConnectionFactory)ctx.lookup(qcfLookup);
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])", e, 10);
                    }
                    try {
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "Normal lookup failed with the following exception: ", null);
                            Trace.traceData(CLASSNAME, "main", (Object)e);
                            Trace.traceData(CLASSNAME, "Now trying with cn= prefix", null);
                        }
                        factory = (QueueConnectionFactory)ctx.lookup("cn=ivtQCF");
                    }
                    catch (Exception e2) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])", e2, 11);
                        }
                        pw.println(NLSServices.getMessage("JMSMQ5009"));
                        pw.println(e2);
                        pw.flush();
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "Extended lookup failed with the following exception: ", null);
                            Trace.traceData(CLASSNAME, "main", (Object)e2);
                            Trace.traceData(CLASSNAME, "Exiting via System.exit(-1)", null);
                            Trace.exit(CLASSNAME, "main");
                        }
                        System.exit(-1);
                    }
                }
            }
            pw.println(NLSServices.getMessage("JMSMQ5010"));
            pw.flush();
            try {
                Message inMessage;
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Creating connection", null);
                }
                connection = factory.createQueueConnection();
                connection.start();
                pw.println(NLSServices.getMessage("JMSMQ5011"));
                pw.flush();
                boolean transacted = false;
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Creating session", null);
                }
                session = connection.createQueueSession(transacted, 1);
                if (!useJNDI) {
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "Creating a Q ourselves", null);
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5012"));
                    pw.flush();
                    ioQueue = session.createQueue(QUEUE);
                } else {
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "Obtaining a Q from JNDI (lookup key is ivtQ)", null);
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5013"));
                    pw.flush();
                    try {
                        ioQueue = (Queue)ctx.lookup(qLookup);
                    }
                    catch (Exception e) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])", e, 12);
                        }
                        try {
                            if (Trace.isOn) {
                                Trace.traceData(CLASSNAME, "Normal lookup failed with the following exception: ", null);
                                Trace.traceData(CLASSNAME, "main", (Object)e);
                                Trace.traceData(CLASSNAME, "Now trying with cn= prefix", null);
                            }
                            ioQueue = (Queue)ctx.lookup("cn=ivtQ");
                        }
                        catch (Exception e2) {
                            if (Trace.isOn) {
                                Trace.catchBlock("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])", e2, 13);
                            }
                            pw.println(NLSServices.getMessage("JMSMQ5014"));
                            pw.println(e2);
                            if (Trace.isOn) {
                                Trace.traceData(CLASSNAME, "Extended lookup failed with the following exception: ", null);
                                Trace.traceData(CLASSNAME, "main", (Object)e2);
                                Trace.traceData(CLASSNAME, "Exiting via System.exit(-1)", null);
                                Trace.exit(CLASSNAME, "main");
                            }
                            pw.flush();
                            System.exit(-1);
                        }
                    }
                }
                pw.println(NLSServices.getMessage("JMSMQ5015"));
                pw.flush();
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Creating a sender", null);
                }
                QueueSender queueSender = session.createSender(ioQueue);
                pw.println(NLSServices.getMessage("JMSMQ5016"));
                pw.flush();
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Creating a receiver", null);
                }
                QueueReceiver queueReceiver = session.createReceiver(ioQueue);
                pw.println(NLSServices.getMessage("JMSMQ5017"));
                pw.flush();
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Creating a message", null);
                }
                TextMessage outMessage = session.createTextMessage();
                outMessage.setText(outString);
                pw.println(NLSServices.getMessage("JMSMQ5018", QUEUE));
                pw.flush();
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Sending the message", null);
                }
                queueSender.send((Message)outMessage);
                pw.println(NLSServices.getMessage("JMSMQ5019"));
                pw.flush();
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Receiving the message", null);
                }
                if ((inMessage = queueReceiver.receive(1000L)) == null) {
                    pw.println(NLSServices.getMessage("JMSMQ5020"));
                    pw.flush();
                    JMSException traceRet1 = new JMSException(NLSServices.getMessage("JMSMQ5021"));
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])", traceRet1, 4);
                    }
                    throw traceRet1;
                }
                pw.println("\n" + NLSServices.getMessage("JMSMQ5022") + " " + inMessage);
                pw.flush();
                if (inMessage instanceof TextMessage) {
                    String replyString;
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "Retrived message is a TextMessage; now checking for equality with the sent message", null);
                    }
                    if ((replyString = ((TextMessage)inMessage).getText()).equals(outString)) {
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "Messages are equal. Great!", null);
                        }
                        pw.println(NLSServices.getMessage("JMSMQ5023"));
                        pw.flush();
                    } else {
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "ERROR! Messages differ!", null);
                            Trace.traceData(CLASSNAME, "Original=" + outString, null);
                            Trace.traceData(CLASSNAME, "Reply=" + replyString, null);
                        }
                        pw.println(NLSServices.getMessage("JMSMQ5024"));
                        pw.println(NLSServices.getMessage("JMSMQ5025") + " = '" + outString + "'");
                        pw.println(NLSServices.getMessage("JMSMQ5026") + " = '" + replyString + "'");
                        pw.flush();
                    }
                } else {
                    pw.println(NLSServices.getMessage("JMSMQ5027"));
                    pw.flush();
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "The retrieved message was not a TextMessage", null);
                    }
                    JMSException traceRet2 = new JMSException(NLSServices.getMessage("JMSMQ5028"));
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])", traceRet2, 5);
                    }
                    throw traceRet2;
                }
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Closing down queues, session and connection", null);
                }
                pw.println(NLSServices.getMessage("JMSMQ5029"));
                pw.flush();
                queueReceiver.close();
                pw.println(NLSServices.getMessage("JMSMQ5030"));
                pw.flush();
                queueSender.close();
                pw.println(NLSServices.getMessage("JMSMQ5031"));
                pw.flush();
                session.close();
                session = null;
                pw.println(NLSServices.getMessage("JMSMQ5032"));
                pw.flush();
                connection.close();
                connection = null;
                pw.println(NLSServices.getMessage("JMSMQ5033"));
                pw.flush();
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])", e, 14);
                }
                systemrc = 3;
                pw.println(NLSServices.getMessage("JMSMQ5034"));
                MQJMSIVT.handleException(e, pw);
                if (!Trace.isOn) break block138;
                Trace.traceData(CLASSNAME, "The following exception was caught: ", null);
                Trace.traceData(CLASSNAME, "main", (Object)e);
            }
        }
        pw.println(NLSServices.getMessage("JMSMQ5035"));
        pw.flush();
        if (Trace.isOn) {
            Trace.traceData(CLASSNAME, "IVT finished", null);
            Trace.exit(CLASSNAME, "main");
        }
        System.exit(systemrc);
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQJMSIVT", "main(String [ ])");
        }
    }

    private static void displayUsage() {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQJMSIVT", "displayUsage()");
        }
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "displayUsage");
        }
        pw.println(NLSServices.getMessage("JMSMQ5065"));
        pw.println(NLSServices.getMessage("JMSMQ5066"));
        pw.println(NLSServices.getMessage("JMSMQ5067"));
        pw.println(NLSServices.getMessage("JMSMQ5068"));
        pw.flush();
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQJMSIVT", "displayUsage()");
        }
    }

    private static String padTitle(String text) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQJMSIVT", "padTitle(String)", new Object[]{text});
        }
        StringBuffer buffer = new StringBuffer(titleSize);
        int textLength = text.trim().length();
        int padding = titleSize - textLength;
        for (int count = 0; count < padding; ++count) {
            buffer.append(" ");
        }
        buffer.append(text.trim()).append(" : ");
        String traceRet1 = buffer.toString();
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQJMSIVT", "padTitle(String)", (Object)traceRet1);
        }
        return traceRet1;
    }

    public static void handleException(Exception exception, PrintWriter stream) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQJMSIVT", "handleException(final Exception,PrintWriter)", new Object[]{exception, stream});
        }
        int causeIndex = 0;
        Throwable loopException = exception;
        while (loopException != null) {
            if (causeIndex == 0) {
                stream.println(MQJMSIVT.padTitle(NLSServices.getMessage("JMSMQ5100")) + loopException.getMessage());
            } else {
                stream.println(MQJMSIVT.padTitle(NLSServices.getMessage("JMSMQ5103", Integer.toString(causeIndex))) + loopException.getMessage());
            }
            stream.println(MQJMSIVT.padTitle(NLSServices.getMessage("JMSMQ5101")) + loopException.getClass());
            if (loopException instanceof MQException) {
                MQException mqException = (MQException)loopException;
                stream.println(MQJMSIVT.padTitle(NLSServices.getMessage("JMSMQ5107")) + mqException.completionCode);
                stream.println(MQJMSIVT.padTitle(NLSServices.getMessage("JMSMQ5108")) + mqException.reasonCode);
            } else if (loopException instanceof JmqiException) {
                JmqiException jmqiException = (JmqiException)loopException;
                stream.println(MQJMSIVT.padTitle(NLSServices.getMessage("JMSMQ5107")) + jmqiException.getCompCode());
                stream.println(MQJMSIVT.padTitle(NLSServices.getMessage("JMSMQ5108")) + jmqiException.getReason());
                String logMessage = jmqiException.getWmqLogMessage();
                logMessage = logMessage == null ? "" : logMessage;
                logMessage = logMessage.replaceAll(lineSeparator, lineSeparator + MQJMSIVT.padTitle(""));
                stream.println(MQJMSIVT.padTitle(NLSServices.getMessage("JMSMQ5109")) + logMessage);
                stream.println(MQJMSIVT.padTitle(NLSServices.getMessage("JMSMQ5109")) + jmqiException.getWmqMsgExplanation());
                stream.println(MQJMSIVT.padTitle(NLSServices.getMessage("JMSMQ5111")) + jmqiException.getWmqMsgSeverity());
                stream.println(MQJMSIVT.padTitle(NLSServices.getMessage("JMSMQ5112")) + jmqiException.getWmqMsgSummary());
                String userResponse = jmqiException.getWmqMsgUserResponse();
                userResponse = userResponse == null ? "" : userResponse;
                userResponse = userResponse.replaceAll(lineSeparator, lineSeparator + MQJMSIVT.padTitle(""));
                stream.println(MQJMSIVT.padTitle(NLSServices.getMessage("JMSMQ5113")) + userResponse);
            } else if (loopException instanceof JmsExceptionDetail) {
                JmsExceptionDetail de = (JmsExceptionDetail)((Object)loopException);
                stream.println(MQJMSIVT.padTitle(NLSServices.getMessage("JMSMQ5104")) + ((JMSException)loopException).getErrorCode());
                stream.println(MQJMSIVT.padTitle(NLSServices.getMessage("JMSMQ5105")) + de.getExplanation());
                stream.println(MQJMSIVT.padTitle(NLSServices.getMessage("JMSMQ5106")) + de.getUserAction());
                Iterator keys = de.getKeys();
                if (keys != null) {
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        stream.println(MQJMSIVT.padTitle(key) + de.getValue(key));
                    }
                }
            }
            MQJMSIVT.dumpStackTrace(loopException, stream);
            loopException = loopException.getCause();
            ++causeIndex;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQJMSIVT", "handleException(final Exception,PrintWriter)");
        }
    }

    private static void dumpStackTrace(Throwable e, PrintWriter stream) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQJMSIVT", "dumpStackTrace(final Throwable,PrintWriter)", new Object[]{e, stream});
        }
        StackTraceElement[] stack = e.getStackTrace();
        for (int count = 0; count < stack.length; ++count) {
            String prefix = count == 0 ? NLSServices.getMessage("JMSMQ5102") : "";
            String className = stack[count].getClassName();
            String methodName = stack[count].getMethodName();
            String fileName = stack[count].getFileName();
            int line = stack[count].getLineNumber();
            stream.println(MQJMSIVT.padTitle(prefix) + className + "." + methodName + "(" + fileName + ":" + line + ")");
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQJMSIVT", "dumpStackTrace(final Throwable,PrintWriter)");
        }
    }

    public static void runFrom(PrintWriter stream) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQJMSIVT", "runFrom(PrintWriter)", new Object[]{stream});
        }
        Class c = MQJMSIVT.class;
        String resourceName = c.getName().replace('.', '/') + ".class";
        URL url = c.getClassLoader().getResource(resourceName);
        String protocol = url.getProtocol();
        String outputStr = url.toString();
        if (protocol.equalsIgnoreCase("jar")) {
            String path = url.getPath();
            outputStr = path.substring(0, path.indexOf("!"));
        }
        stream.println(NLSServices.getMessage("JMSMQ5114", c.getName(), outputStr));
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQJMSIVT", "runFrom(PrintWriter)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.MQJMSIVT", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQJMSIVT.java, jmscc.migration.wmq, k701, k701-112-140304  1.36.1.1 09/08/17 08:51:18");
        }
        QMGR = null;
        client = false;
        hostname = null;
        port = null;
        channel = null;
        ccsid = null;
        version = null;
        pw = null;
        titleSize = 30;
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQJMSIVT", "static()");
        }
        lineSeparator = PropertyStore.line_separator;
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQJMSIVT", "static()");
        }
    }
}

