/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQJMSIVT;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.services.Version;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.directory.InitialDirContext;

public class MQJMSASIVT {
    public static String ccsid;
    public static String channel;
    public static final String CLASSNAME = "MQJMSASIVT";
    public static boolean client;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static String hostname;
    private static Message inMessage;
    public static String port;
    private static PrintWriter pw;
    public static final String qcfLookup = "ivtQCF";
    public static final String qLookup = "ivtQ";
    public static String QMGR;
    public static final String QUEUE = "SYSTEM.DEFAULT.LOCAL.QUEUE";
    static final String sccsid = "@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQJMSASIVT.java, jmscc.migration.wmq, k701, k701-112-140304 1.22.1.1 09/08/17 08:08:00";
    private static Object threadWaitLock;
    public static String version;
    private static int waitTime;
    private static boolean msgListenerFired;
    private static Object watcherLock;
    private static int watcherTimeout;
    private static boolean done;

    private static void displayUsage() {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQJMSASIVT", "displayUsage()");
        }
        pw.println(NLSServices.getMessage("JMSMQ5065"));
        pw.println(NLSServices.getMessage("JMSMQ5066"));
        pw.println(NLSServices.getMessage("JMSMQ5067"));
        pw.println(NLSServices.getMessage("JMSMQ5068"));
        pw.flush();
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQJMSASIVT", "displayUsage()");
        }
    }

    private static void writeJavaCore() {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQJMSASIVT", "writeJavaCore()");
        }
        try {
            Class<?> dumpClass = Class.forName("com.ibm.jvm.Dump");
            Method dumpMethod = dumpClass.getMethod("JavaDump", null);
            dumpMethod.invoke(null, null);
        }
        catch (Exception e1) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.mq.jms.MQJMSASIVT", "writeJavaCore()", e1);
            }
            e1.printStackTrace(pw);
            pw.flush();
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQJMSASIVT", "writeJavaCore()");
        }
    }

    public static void setupWatcherThread(PrintWriter pwriter) {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.MQJMSASIVT", "setupWatcherThread(PrintWriter)", "setter", (Object)pwriter);
        }
        pw = pwriter;
        MQJMSASIVT.setupWatcherThread();
    }

    private static void setupWatcherThread() {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQJMSASIVT", "setupWatcherThread()");
        }
        Thread watcher = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.mq.jms.MQJMSASIVT", "run()");
                }
                pw.println("[watcher]started");
                pw.flush();
                Object object = watcherLock;
                synchronized (object) {
                    try {
                        watcherLock.wait(watcherTimeout);
                        pw.println("[watcher]timeout/notififed");
                        pw.flush();
                        if (!done) {
                            pw.println("[watcher]write javacore");
                            pw.flush();
                            MQJMSASIVT.writeJavaCore();
                        }
                    }
                    catch (InterruptedException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.mq.jms.null", "run()", e);
                        }
                        pw.println("[watcher]interrupted");
                        pw.flush();
                    }
                }
                pw.println("[watcher]ended");
                pw.flush();
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.mq.jms.null", "run()");
                }
            }
        });
        watcher.setDaemon(true);
        watcher.start();
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQJMSASIVT", "setupWatcherThread()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws UnsupportedEncodingException {
        String msg;
        int ccsidNumber;
        int portNumber;
        String url;
        String icf;
        boolean useJNDI;
        Context ctx;
        MQQueueConnectionFactory factory;
        QueueConnection connection;
        QueueSession asyncSession;
        QueueSession syncSession;
        Queue ioQueue;
        String outString;
        int systemrc;
        block149: {
            if (Trace.isOn) {
                Trace.entry("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", new Object[]{args});
            }
            NLSServices.addCatalogue("com.ibm.mq.jms.resources.JMSMQ_MessageResourceBundle", "JMSMQ");
            systemrc = 0;
            String encProp = "console.encoding";
            PropertyStore.register(encProp, "");
            String encoding = PropertyStore.getStringProperty(encProp);
            pw = NLSServices.isWindowsLatinCodepage() && encoding != "" && encoding != null ? new PrintWriter(new OutputStreamWriter((OutputStream)System.out, encoding)) : new PrintWriter(new OutputStreamWriter(System.out));
            MQJMSASIVT.setupWatcherThread();
            outString = null;
            ioQueue = null;
            syncSession = null;
            asyncSession = null;
            connection = null;
            factory = null;
            ctx = null;
            useJNDI = true;
            boolean enableTrace = false;
            icf = "com.sun.jndi.ldap.LdapCtxFactory";
            url = null;
            portNumber = 0;
            ccsidNumber = 0;
            try {
                Class.forName("javax.jms.Message");
            }
            catch (ClassNotFoundException e) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", e, 1);
                }
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "javax.jms.Message missing", null);
                    Trace.traceData(CLASSNAME, "classpath check failed with " + e, null);
                    Trace.exit(CLASSNAME, "main", (Object)null);
                }
                System.err.println(NLSServices.getMessage("JMSMQ5037", "javax.jms.Message"));
            }
            String pv = "7";
            Version.Component[] comp = Version.getComponents("MPI", "com.ibm.msg.client.wmq");
            if (comp.length > 0) {
                pv = comp[0].getVersionString() + " " + comp[0].getImplementationInfo().get("CMVC");
            }
            pw.println();
            pw.println(NLSServices.getMessage("JMSMQ1003"));
            pw.println(NLSServices.getMessage("JMSMQ1002", pv));
            pw.println(NLSServices.getMessage("JMSMQ5000") + "\n");
            pw.flush();
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].toLowerCase();
                if (arg.equals("-nojndi")) {
                    useJNDI = false;
                    continue;
                }
                if (arg.equals("-m")) {
                    if (i + 1 < args.length) {
                        QMGR = args[++i];
                        continue;
                    }
                    msg = NLSServices.getMessage("JMSMQ5036", "-m");
                    pw.println(msg);
                    pw.flush();
                    continue;
                }
                if (arg.equals("-t")) {
                    Trace.setOn(true);
                    enableTrace = true;
                    continue;
                }
                if (arg.equals("-url")) {
                    if (i + 1 < args.length) {
                        url = args[++i];
                        continue;
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5001"));
                    pw.flush();
                    continue;
                }
                if (arg.equals("-icf")) {
                    if (i + 1 < args.length) {
                        icf = args[++i];
                        continue;
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5002"));
                    pw.flush();
                    continue;
                }
                if (arg.equals("-client")) {
                    client = true;
                    continue;
                }
                if (arg.equals("-host")) {
                    if (i + 1 < args.length) {
                        hostname = args[++i];
                        continue;
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5036", "-host"));
                    pw.flush();
                    continue;
                }
                if (arg.equals("-port")) {
                    if (i + 1 < args.length) {
                        port = args[++i];
                        continue;
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5036", "-port"));
                    continue;
                }
                if (arg.equals("-channel")) {
                    if (i + 1 < args.length) {
                        channel = args[++i];
                        continue;
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5036", "-channel"));
                    pw.flush();
                    continue;
                }
                if (arg.equals("-ccsid")) {
                    if (i + 1 < args.length) {
                        ccsid = args[++i];
                        continue;
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5036", "-ccsid"));
                    pw.flush();
                    continue;
                }
                if (arg.equals("-v")) {
                    if (i + 1 < args.length) {
                        version = args[++i];
                        continue;
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5036", "-v"));
                    pw.flush();
                    continue;
                }
                pw.println(NLSServices.getMessage("JMSMQ5003", arg));
                pw.flush();
            }
            if (enableTrace && Trace.isOn) {
                Trace.entry(CLASSNAME, "main");
                Trace.traceData(CLASSNAME, "Trace started from main by -t flag", null);
            }
            if (useJNDI) {
                if (url == null) {
                    MQJMSASIVT.displayUsage();
                    System.exit(-1);
                }
                if (client || QMGR != null || hostname != null || port != null || channel != null || version != null) {
                    MQJMSASIVT.displayUsage();
                    System.exit(-1);
                }
            } else if (!client) {
                if (hostname != null || port != null || channel != null) {
                    MQJMSASIVT.displayUsage();
                    System.exit(-1);
                }
            } else if (QMGR == null || hostname == null) {
                MQJMSASIVT.displayUsage();
                System.exit(-1);
            }
            if (!client && !useJNDI && QMGR == null) {
                QMGR = "";
            }
            if (client) {
                try {
                    portNumber = port == null ? 1414 : Integer.parseInt(port);
                }
                catch (NumberFormatException nfe) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", nfe, 2);
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5064"));
                    pw.flush();
                    System.exit(-1);
                }
                if (channel == null) {
                    channel = "SYSTEM.DEF.SVRCONN";
                }
                if (ccsid != null && ccsid.length() > 0) {
                    try {
                        ccsidNumber = Integer.parseInt(ccsid);
                    }
                    catch (NumberFormatException nfe) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", nfe, 3);
                        }
                        pw.println(NLSServices.getMessage("JMSMQ1046", ccsid));
                        pw.flush();
                        System.exit(-1);
                    }
                }
            }
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Using following parameters:", null);
                if (useJNDI) {
                    Trace.traceData(CLASSNAME, "Using JNDI", null);
                    Trace.traceData(CLASSNAME, "InitialContextFactory: '" + icf + "'", null);
                    Trace.traceData(CLASSNAME, "ProviderURL: '" + url + "'", null);
                } else {
                    Trace.traceData(CLASSNAME, "Not using JNDI", null);
                    if (client) {
                        Trace.traceData(CLASSNAME, "Using CLIENT connection", null);
                        Trace.traceData(CLASSNAME, "Queue Manager: '" + QMGR + "'", null);
                        Trace.traceData(CLASSNAME, "HostName: '" + hostname + "'", null);
                        Trace.traceData(CLASSNAME, "Port: " + portNumber, null);
                        Trace.traceData(CLASSNAME, "Channel: '" + channel + "'", null);
                        Trace.traceData(CLASSNAME, "Ccsid: '" + ccsid + "'", null);
                    } else {
                        Trace.traceData(CLASSNAME, "Using BINDINGS connection", null);
                        Trace.traceData(CLASSNAME, "Queue Manager: '" + QMGR + "'", null);
                    }
                    Trace.traceData(CLASSNAME, "Provider version: " + version == null ? "not set" : version, null);
                }
            }
            try {
                String msg2;
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "checking classpath", null);
                }
                try {
                    Class.forName("javax.jms.Message");
                }
                catch (ClassNotFoundException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", e, 4);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "javax.jms.Message missing", null);
                    }
                    msg2 = NLSServices.getMessage("JMSMQ5037", "javax.jms.jar");
                    System.err.println(msg2);
                    pw.flush();
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", e, 1);
                    }
                    throw e;
                }
                try {
                    Class.forName("javax.naming.InitialContext");
                }
                catch (ClassNotFoundException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", e, 5);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "javax.naming.InitialContext missing", null);
                    }
                    msg2 = NLSServices.getMessage("JMSMQ5037", "jndi.jar");
                    System.err.println(msg2);
                    pw.flush();
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", e, 2);
                    }
                    throw e;
                }
                if (!useJNDI) break block149;
                try {
                    Class.forName(icf);
                }
                catch (ClassNotFoundException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", e, 6);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "jndi provider for '" + icf + "' missing", null);
                    }
                    msg2 = NLSServices.getMessage("JMSMQ5038", icf);
                    System.err.println(msg2);
                    pw.flush();
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", e, 3);
                    }
                    throw e;
                }
            }
            catch (ClassNotFoundException e) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", e, 7);
                }
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "classpath check failed with " + e, null);
                    Trace.exit(CLASSNAME, "main");
                }
                System.err.println(e);
                pw.flush();
                System.exit(-1);
            }
        }
        if (useJNDI) {
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "User has opted for JNDI lookup", null);
            }
            if (url == null) {
                pw.println(NLSServices.getMessage("JMSMQ5004"));
                pw.flush();
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "User has not specified a URL for JNDI lookup", null);
                    Trace.traceData(CLASSNAME, "Exiting via System.exit(-1)", null);
                    Trace.exit(CLASSNAME, "main");
                }
                System.exit(-1);
            } else {
                pw.println(NLSServices.getMessage("JMSMQ5005"));
                pw.flush();
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", icf);
                env.put("java.naming.provider.url", url);
                env.put("java.naming.referral", "throw");
                try {
                    ctx = new InitialDirContext(env);
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", e, 8);
                    }
                    msg = NLSServices.getMessage("JMSMQ5006");
                    pw.println(msg);
                    pw.println(e);
                    pw.flush();
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "Initial context creation failed!", null);
                        Trace.traceData(CLASSNAME, "main", (Object)e);
                        Trace.traceData(CLASSNAME, "Exiting via System.exit(-1)", null);
                        Trace.exit(CLASSNAME, "main");
                    }
                    pw.flush();
                    System.exit(-1);
                }
            }
        } else if (Trace.isOn) {
            Trace.traceData(CLASSNAME, "User is bypassing JNDI lookup", null);
        }
        pw.println();
        outString = "A simple text message from the MQJMSIVT program";
        if (!useJNDI) {
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Creating a QCF ourselves", null);
            }
            pw.println(NLSServices.getMessage("JMSMQ5007"));
            pw.flush();
            factory = new MQQueueConnectionFactory();
            try {
                factory.setQueueManager(QMGR);
                if (null != version) {
                    factory.setStringProperty("XMSC_WMQ_PROVIDER_VERSION", version);
                }
                if (client) {
                    factory.setTransportType(1);
                    factory.setHostName(hostname);
                    factory.setPort(portNumber);
                    factory.setChannel(channel);
                    if (ccsid != null) {
                        factory.setCCSID(ccsidNumber);
                    }
                }
            }
            catch (JMSException e) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", e, 9);
                }
                systemrc = 2;
                pw.println(NLSServices.getMessage("JMSMQ5115"));
                pw.println((Object)e);
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Could not set properties in QCF", null);
                    Trace.traceData(CLASSNAME, "main", (Object)e);
                    Trace.traceData(CLASSNAME, "Exiting via System.exit(-1)", null);
                    Trace.exit(CLASSNAME, "main");
                }
                pw.flush();
                System.exit(-1);
            }
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "QCF created OK", null);
            }
        } else {
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Obtaining a QCF from JNDI (lookup key is ivtQCF)", null);
            }
            pw.println(NLSServices.getMessage("JMSMQ5008"));
            pw.flush();
            try {
                factory = (QueueConnectionFactory)ctx.lookup(qcfLookup);
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", e, 10);
                }
                try {
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "Normal lookup failed with the following exception: ", null);
                        Trace.traceData(CLASSNAME, "main", (Object)e);
                        Trace.traceData(CLASSNAME, "Now trying with cn= prefix", null);
                    }
                    factory = (QueueConnectionFactory)ctx.lookup("cn=ivtQCF");
                }
                catch (Exception e2) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", e2, 11);
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5009"));
                    pw.println(e2);
                    pw.flush();
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "Extended lookup failed with the following exception: ", null);
                        Trace.traceData(CLASSNAME, "main", (Object)e2);
                        Trace.traceData(CLASSNAME, "Exiting via System.exit(-1)", null);
                        Trace.exit(CLASSNAME, "main");
                    }
                    System.exit(-1);
                }
            }
        }
        pw.println(NLSServices.getMessage("JMSMQ5010"));
        pw.flush();
        try {
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Creating connection", null);
            }
            connection = factory.createQueueConnection();
            pw.println(NLSServices.getMessage("JMSMQ5073"));
            pw.flush();
            boolean transacted = false;
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Creating sync session", null);
            }
            syncSession = connection.createQueueSession(transacted, 1);
            pw.println(NLSServices.getMessage("JMSMQ5074"));
            pw.flush();
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Creating async session", null);
            }
            asyncSession = connection.createQueueSession(transacted, 1);
            if (!useJNDI) {
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Creating a Q ourselves", null);
                }
                pw.println(NLSServices.getMessage("JMSMQ5012"));
                pw.flush();
                ioQueue = syncSession.createQueue(QUEUE);
            } else {
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Obtaining a Q from JNDI (lookup key is ivtQ)", null);
                }
                pw.println(NLSServices.getMessage("JMSMQ5013"));
                pw.flush();
                try {
                    ioQueue = (Queue)ctx.lookup(qLookup);
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", e, 12);
                    }
                    try {
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "Normal lookup failed with the following exception: ", null);
                            Trace.traceData(CLASSNAME, "main", (Object)e);
                            Trace.traceData(CLASSNAME, "Now trying with cn= prefix", null);
                        }
                        ioQueue = (Queue)ctx.lookup("cn=ivtQ");
                    }
                    catch (Exception e2) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", e2, 13);
                        }
                        pw.println(NLSServices.getMessage("JMSMQ5014"));
                        pw.println(e2);
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "Extended lookup failed with the following exception: ", null);
                            Trace.traceData(CLASSNAME, "main", (Object)e2);
                            Trace.traceData(CLASSNAME, "Exiting via System.exit(-1)", null);
                            Trace.exit(CLASSNAME, "main");
                        }
                        pw.flush();
                        System.exit(-1);
                    }
                }
            }
            pw.println(NLSServices.getMessage("JMSMQ5015"));
            pw.flush();
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Creating a sender", null);
            }
            QueueSender queueSender = syncSession.createSender(ioQueue);
            pw.println(NLSServices.getMessage("JMSMQ5016"));
            pw.flush();
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Creating a receiver", null);
            }
            QueueReceiver queueReceiver = asyncSession.createReceiver(ioQueue);
            pw.println(NLSServices.getMessage("JMSMQ5077"));
            pw.flush();
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Setting message listener", null);
            }
            queueReceiver.setMessageListener(new MessageListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onMessage(Message arg0) {
                    if (Trace.isOn) {
                        Trace.entry(this, "com.ibm.mq.jms.MQJMSASIVT", "onMessage(Message)", new Object[]{arg0});
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5076"));
                    pw.flush();
                    if (Trace.isOn) {
                        Trace.traceData(MQJMSASIVT.CLASSNAME, "Receiving the message", null);
                    }
                    Object object = threadWaitLock;
                    synchronized (object) {
                        msgListenerFired = true;
                        inMessage = arg0;
                        threadWaitLock.notify();
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.mq.jms.null", "onMessage(Message)");
                    }
                }
            });
            pw.println(NLSServices.getMessage("JMSMQ5075"));
            pw.flush();
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Starting the connection", null);
            }
            connection.start();
            pw.println(NLSServices.getMessage("JMSMQ5017"));
            pw.flush();
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Creating a message", null);
            }
            TextMessage outMessage = syncSession.createTextMessage();
            outMessage.setText(outString);
            pw.println(NLSServices.getMessage("JMSMQ5018", QUEUE));
            pw.flush();
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Sending the message", null);
            }
            queueSender.send((Message)outMessage);
            Object object = threadWaitLock;
            synchronized (object) {
                int retryCount = 0;
                int RETRY_LIMIT = 5;
                while (!msgListenerFired && retryCount++ < 5) {
                    try {
                        threadWaitLock.wait(waitTime / 5);
                    }
                    catch (InterruptedException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", e, 14);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "Waiting for responce, thread was interupted", (Object)e);
                        }
                        inMessage = null;
                    }
                }
            }
            if (inMessage == null) {
                pw.println(NLSServices.getMessage("JMSMQ5020"));
                pw.flush();
                JMSException traceRet1 = new JMSException(NLSServices.getMessage("JMSMQ5021"));
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", traceRet1, 4);
                }
                throw traceRet1;
            }
            pw.println("\n" + NLSServices.getMessage("JMSMQ5022") + " " + inMessage);
            pw.flush();
            if (inMessage instanceof TextMessage) {
                String replyString;
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Retrived message is a TextMessage; now checking for equality with the sent message", null);
                }
                if ((replyString = ((TextMessage)inMessage).getText()).equals(outString)) {
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "Messages are equal. Great!", null);
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5023"));
                    pw.flush();
                } else {
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "ERROR! Messages differ!", null);
                        Trace.traceData(CLASSNAME, "Original=" + outString, null);
                        Trace.traceData(CLASSNAME, "Reply=" + replyString, null);
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5024"));
                    pw.println(NLSServices.getMessage("JMSMQ5025") + " = '" + outString + "'");
                    pw.println(NLSServices.getMessage("JMSMQ5026") + " = '" + replyString + "'");
                    pw.flush();
                }
            } else {
                pw.println(NLSServices.getMessage("JMSMQ5027"));
                pw.flush();
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "The retrieved message was not a TextMessage", null);
                }
                JMSException traceRet2 = new JMSException(NLSServices.getMessage("JMSMQ5028"));
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", traceRet2, 5);
                }
                throw traceRet2;
            }
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Closing down queues, session and connection", null);
            }
            pw.println(NLSServices.getMessage("JMSMQ5029"));
            pw.flush();
            queueReceiver.close();
            pw.println(NLSServices.getMessage("JMSMQ5030"));
            pw.flush();
            queueSender.close();
            pw.println(NLSServices.getMessage("JMSMQ5031"));
            pw.flush();
            syncSession.close();
            asyncSession.close();
            syncSession = null;
            asyncSession = null;
            pw.println(NLSServices.getMessage("JMSMQ5032"));
            pw.flush();
            connection.close();
            connection = null;
            pw.println(NLSServices.getMessage("JMSMQ5033"));
            pw.flush();
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", je, 15);
            }
            systemrc = 2;
            pw.println(NLSServices.getMessage("JMSMQ5034"));
            MQJMSIVT.handleException((Exception)((Object)je), pw);
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])", e, 16);
            }
            systemrc = 3;
            pw.println(NLSServices.getMessage("JMSMQ5034"));
            MQJMSIVT.handleException(e, pw);
        }
        pw.println(NLSServices.getMessage("JMSMQ5035"));
        pw.flush();
        if (Trace.isOn) {
            Trace.traceData(CLASSNAME, "IVT finished", null);
            Trace.exit(CLASSNAME, "main");
        }
        System.exit(systemrc);
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQJMSASIVT", "main(String [ ])");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.MQJMSASIVT", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQJMSASIVT.java, jmscc.migration.wmq, k701, k701-112-140304  1.22.1.1 09/08/17 08:08:00");
        }
        ccsid = null;
        channel = null;
        client = false;
        hostname = null;
        inMessage = null;
        port = null;
        pw = null;
        QMGR = null;
        threadWaitLock = new Object();
        version = null;
        waitTime = 5000;
        msgListenerFired = false;
        watcherLock = new Object();
        watcherTimeout = 600000;
        done = false;
    }
}

