/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSDestination;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQTemporaryQueue;
import com.ibm.mq.jms.MQTemporaryTopic;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsDestination;
import com.ibm.msg.client.jms.admin.JmsJndiDestinationImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class MQDestination
extends JmsJndiDestinationImpl
implements Destination,
JMSDestination,
Serializable {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final long serialVersionUID = -648906405979968516L;
    private static final ObjectStreamField[] serialPersistentFields;
    protected transient JmsDestination propertyDelegate = this;
    private transient boolean versionChangeAllowed = false;
    protected static transient String connectionType;

    MQDestination() {
        super(connectionType);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQDestination", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQDestination", "<init>()");
        }
    }

    protected MQDestination(JmsDestination delegate) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQDestination", "<init>(JmsDestination)", new Object[]{delegate});
        }
        this.propertyDelegate = delegate;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQDestination", "<init>(JmsDestination)");
        }
    }

    public MQDestination(String name) throws JMSException {
        super(connectionType, name);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQDestination", "<init>(String)", new Object[]{name});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQDestination", "<init>(String)");
        }
    }

    protected void setupProviderDestination() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQDestination", "setupProviderDestination()");
        }
        try {
            this.setProviderDestination();
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQDestination", "setupProviderDestination()", e);
            }
            HashMap<String, JMSException> info = new HashMap<String, JMSException>();
            info.put("exception", e);
            Trace.ffst(this, "setupProviderDestination()", "XF008001", info, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQDestination", "setupProviderDestination()");
        }
    }

    protected String findCorrectField(String field) {
        String[][] fieldNames = new String[][]{{"cCSID", "delegate", "property", "stringFromDestination", "reference"}, {"CCSID", null, null, null, null}};
        for (int i = 0; i < fieldNames[0].length; ++i) {
            if (!field.equals(fieldNames[0][i])) continue;
            return fieldNames[1][i];
        }
        return field;
    }

    protected String findCorrectMethod(String method) {
        String[][] methodNames = new String[][]{{"setSslSocketFactory", "setSslResetCount", "setSslPeerName", "setSslFipsRequired", "setSslCipherSuite", "setSslCertStores_string", "setSslCertStores_coll", "setConnOptions", "setCcdtUrl"}, {"setSSLSocketFactory", "setSSLResetCount", "setSSLPeerName", "setSSLFipsRequired", "setSSLCipherSuite", "setSSLCertStores", "setSSLCertStores", "setMQConnectionOptions", "setCCDTURL"}};
        for (int i = 0; i < methodNames[0].length; ++i) {
            if (!method.equals(methodNames[0][i])) continue;
            return methodNames[1][i];
        }
        return method;
    }

    public int getCCSID() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQDestination", "getCCSID()");
        }
        try {
            int traceRet1 = this.propertyDelegate.getIntProperty("CCSID");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getCCSID()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQDestination", "getCCSID()", je);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getCCSID()", new Integer(0), 2);
            }
            return 0;
        }
    }

    public int getReceiveCCSID() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQDestination", "getReceiveCCSID()");
        }
        int traceRet1 = this.propertyDelegate.getIntProperty("receiveCCSID");
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getReceiveCCSID()", new Integer(traceRet1), 1);
        }
        return traceRet1;
    }

    public int getReceiveConversion() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQDestination", "getReceiveConversion()");
        }
        int traceRet1 = this.propertyDelegate.getIntProperty("receiveConversion");
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getReceiveConversion()", new Integer(traceRet1), 1);
        }
        return traceRet1;
    }

    public String getDescription() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQDestination", "getDescription()");
        }
        try {
            String traceRet1 = this.propertyDelegate.getStringProperty("destDescription");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getDescription()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQDestination", "getDescription()", je);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getDescription()", null, 2);
            }
            return null;
        }
    }

    public int getEncoding() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQDestination", "getEncoding()");
        }
        try {
            int traceRet1 = this.propertyDelegate.getIntProperty("encoding");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getEncoding()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQDestination", "getEncoding()", je);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getEncoding()", new Integer(0), 2);
            }
            return 0;
        }
    }

    public long getExpiry() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQDestination", "getExpiry()");
        }
        try {
            long traceRet1 = this.propertyDelegate.getLongProperty("timeToLive");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getExpiry()", new Long(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQDestination", "getExpiry()", je);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getExpiry()", new Long(0L), 2);
            }
            return 0L;
        }
    }

    public int getFailIfQuiesce() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQDestination", "getFailIfQuiesce()");
        }
        try {
            int traceRet1 = this.propertyDelegate.getIntProperty("failIfQuiesce");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getFailIfQuiesce()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQDestination", "getFailIfQuiesce()", je);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getFailIfQuiesce()", new Integer(0), 2);
            }
            return 0;
        }
    }

    public int getMQMDMessageContext() throws JMSException {
        int messageContext = this.propertyDelegate.getIntProperty("mdMessageContext");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "getMQMDMessageContext()", "getter", new Integer(messageContext));
        }
        return messageContext;
    }

    public boolean getMQMDWriteEnabled() throws JMSException {
        boolean writeEnabled = this.propertyDelegate.getBooleanProperty("mdWriteEnabled");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "getMQMDWriteEnabled()", "getter", writeEnabled);
        }
        return writeEnabled;
    }

    public boolean getMQMDReadEnabled() throws JMSException {
        boolean readEnabled = this.propertyDelegate.getBooleanProperty("mdReadEnabled");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "getMQMDReadEnabled()", "getter", readEnabled);
        }
        return readEnabled;
    }

    public int getMessageBodyStyle() throws JMSException {
        int bodyStyle = this.propertyDelegate.getIntProperty("messageBody");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "getMessageBodyStyle()", "getter", new Integer(bodyStyle));
        }
        return bodyStyle;
    }

    public int getPersistence() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQDestination", "getPersistence()");
        }
        try {
            int traceRet1 = this.propertyDelegate.getIntProperty("deliveryMode");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getPersistence()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQDestination", "getPersistence()", je);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getPersistence()", new Integer(0), 2);
            }
            return 0;
        }
    }

    public int getPriority() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQDestination", "getPriority()");
        }
        try {
            int traceRet1 = this.propertyDelegate.getIntProperty("priority");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getPriority()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQDestination", "getPriority()", je);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getPriority()", new Integer(0), 2);
            }
            return 0;
        }
    }

    public String getProperty(String name) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQDestination", "getProperty(String)", new Object[]{name});
        }
        if (name == null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getProperty(String)", null, 1);
            }
            return null;
        }
        try {
            if (!this.propertyExists(name)) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getProperty(String)", null, 2);
                }
                return null;
            }
            String value = this.getStringProperty(name);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getProperty(String)", value, 3);
            }
            return value;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQDestination", "getProperty(String)", je);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getProperty(String)", null, 4);
            }
            return null;
        }
    }

    public int getPutAsyncAllowed() throws JMSException {
        int traceRet1 = this.propertyDelegate.getIntProperty("putAsyncAllowed");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "getPutAsyncAllowed()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getReadAheadAllowed() throws JMSException {
        int traceRet1 = this.propertyDelegate.getIntProperty("readAheadAllowed");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "getReadAheadAllowed()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getReadAheadClosePolicy() throws JMSException {
        int traceRet1 = this.propertyDelegate.getIntProperty("readAheadClosePolicy");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "getReadAheadClosePolicy()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public Reference getReference() throws NamingException {
        Reference ref;
        block4: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.mq.jms.MQDestination", "getReference()");
            }
            ref = new Reference(MQDestination.class.getName(), null, null);
            try {
                ref.add(new StringRefAddr("RTOST", String.valueOf(this.getReplyToStyle())));
                ref.add(new StringRefAddr("RCCS", String.valueOf(this.getReceiveCCSID())));
                ref.add(new StringRefAddr("RCNV", String.valueOf(this.getReceiveConversion())));
            }
            catch (JMSException e) {
                if (!Trace.isOn) break block4;
                Trace.catchBlock(this, "com.ibm.mq.jms.MQDestination", "getReference()", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQDestination", "getReference()", ref);
        }
        return ref;
    }

    public String getStringFromDestination() {
        String traceRet1 = this.toURI();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "getStringFromDestination()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public int getTargetClient() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQDestination", "getTargetClient()");
        }
        try {
            int traceRet1 = this.propertyDelegate.getIntProperty("targetClient");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getTargetClient()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQDestination", "getTargetClient()", je);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getTargetClient()", new Integer(0), 2);
            }
            return 0;
        }
    }

    public int getVersion() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQDestination", "getVersion()");
        }
        try {
            int traceRet1 = this.propertyDelegate.getIntProperty("version");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getVersion()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQDestination", "getVersion()", je);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "getVersion()", new Integer(0), 2);
            }
            return 0;
        }
    }

    public int getWildcardFormat() throws JMSException {
        int traceRet1 = this.propertyDelegate.getIntProperty("wildcardFormat");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "getWildcardFormat()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block28: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.mq.jms.MQDestination", "readObject(java.io.ObjectInputStream)", new Object[]{in});
            }
            this.propertyDelegate = this;
            this.versionChangeAllowed = false;
            connectionType = "com.ibm.msg.client.wmq";
            this.setConnectionTypeName(connectionType);
            try {
                if (this.getProviderDestination() == null) {
                    this.setDefaultProperties();
                }
            }
            catch (JMSException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.mq.jms.MQDestination", "readObject(java.io.ObjectInputStream)", e, 1);
                }
                HashMap<String, JMSException> info = new HashMap<String, JMSException>();
                info.put("exception", e);
                Trace.ffst(this, "readObject(ObjectInputStream)", "XF008002", info, JMSException.class);
            }
            ObjectInputStream.GetField fields = in.readFields();
            try {
                if (!fields.defaulted("CCSID")) {
                    this.setCCSID(fields.get("CCSID", 0));
                }
                if (!fields.defaulted("receiveCCSID")) {
                    this.setReceiveCCSID(fields.get("receiveCCSID", 0));
                }
                if (!fields.defaulted("receiveConversion")) {
                    this.setReceiveConversion(fields.get("receiveConversion", 0));
                }
                if (!fields.defaulted("description")) {
                    this.setDescription((String)fields.get("description", null));
                }
                if (!fields.defaulted("encoding")) {
                    this.setEncoding(fields.get("encoding", 0));
                }
                if (!fields.defaulted("expiry")) {
                    this.setExpiry(fields.get("expiry", 0L));
                }
                if (!fields.defaulted("failIfQuiesce")) {
                    this.setFailIfQuiesce(fields.get("failIfQuiesce", 0));
                }
                if (!fields.defaulted("messageBodyStyle")) {
                    this.setMessageBodyStyle(fields.get("messageBodyStyle", 0));
                }
                if (!fields.defaulted("MQMDMessageContext")) {
                    this.setMQMDMessageContext(fields.get("MQMDMessageContext", 0));
                }
                if (!fields.defaulted("MQMDReadEnabled")) {
                    this.setMQMDReadEnabled(fields.get("MQMDReadEnabled", false));
                }
                if (!fields.defaulted("MQMDWriteEnabled")) {
                    this.setMQMDWriteEnabled(fields.get("MQMDWriteEnabled", false));
                }
                if (!fields.defaulted("persistence")) {
                    this.setPersistence(fields.get("persistence", 0));
                }
                if (!fields.defaulted("priority")) {
                    this.setPriority(fields.get("priority", 0));
                }
                if (!fields.defaulted("putAsyncAllowed")) {
                    this.setPutAsyncAllowed(fields.get("putAsyncAllowed", 0));
                }
                if (!fields.defaulted("readAheadAllowed")) {
                    this.setReadAheadAllowed(fields.get("readAheadAllowed", 0));
                }
                if (!fields.defaulted("readAheadClosePolicy")) {
                    this.setReadAheadClosePolicy(fields.get("readAheadClosePolicy", 0));
                }
                if (!fields.defaulted("targetClient")) {
                    this.setTargetClient(fields.get("targetClient", 0));
                }
                if (!fields.defaulted("version")) {
                    this.versionChangeAllowed = true;
                    this.setVersion(fields.get("version", 0));
                    this.versionChangeAllowed = false;
                }
                if (!fields.defaulted("wildcardFormat")) {
                    this.setWildcardFormat(fields.get("wildcardFormat", 0));
                }
                if (!fields.defaulted("replyToStyle")) {
                    this.setReplyToStyle(fields.get("replyToStyle", 0));
                }
            }
            catch (JMSException je) {
                if (!Trace.isOn) break block28;
                Trace.catchBlock(this, "com.ibm.mq.jms.MQDestination", "readObject(java.io.ObjectInputStream)", je, 2);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQDestination", "readObject(java.io.ObjectInputStream)");
        }
    }

    public void setCCSID(int ccsid) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "setCCSID(int)", "setter", new Integer(ccsid));
        }
        this.propertyDelegate.setIntProperty("CCSID", ccsid);
    }

    public void setReceiveCCSID(int ccsid) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "setReceiveCCSID(int)", "setter", new Integer(ccsid));
        }
        this.propertyDelegate.setIntProperty("receiveCCSID", ccsid);
    }

    public void setReceiveConversion(int rcnvc) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "setReceiveConversion(int)", "setter", new Integer(rcnvc));
        }
        this.propertyDelegate.setIntProperty("receiveConversion", rcnvc);
    }

    void setCommonFromReference(Reference ref) throws JMSException {
        Object value;
        RefAddr addr;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQDestination", "setCommonFromReference(Reference)", new Object[]{ref});
        }
        if ((addr = ref.get("VER")) != null && (value = addr.getContent()) != null) {
            this.versionChangeAllowed = true;
            int storedVersion = Integer.parseInt((String)value);
            this.setVersion(storedVersion);
            this.versionChangeAllowed = false;
        }
        if ((addr = ref.get("DESC")) != null && (value = addr.getContent()) != null) {
            this.setDescription((String)value);
        }
        if ((addr = ref.get("CCS")) != null && (value = addr.getContent()) != null) {
            this.setCCSID(Integer.parseInt((String)value));
        }
        if ((addr = ref.get("RCCS")) != null && (value = addr.getContent()) != null) {
            this.setReceiveCCSID(Integer.parseInt((String)value));
        }
        if ((addr = ref.get("RCNV")) != null && (value = addr.getContent()) != null) {
            this.setReceiveConversion(Integer.parseInt((String)value));
        }
        if ((addr = ref.get("EXP")) != null && (value = addr.getContent()) != null) {
            this.setExpiry(Long.parseLong((String)value));
        }
        if ((addr = ref.get("PRI")) != null && (value = addr.getContent()) != null) {
            this.setPriority(Integer.parseInt((String)value));
        }
        if ((addr = ref.get("PER")) != null && (value = addr.getContent()) != null) {
            this.setPersistence(Integer.parseInt((String)value));
        }
        if ((addr = ref.get("TC")) != null && (value = addr.getContent()) != null) {
            this.setTargetClient(Integer.parseInt((String)value));
        }
        if ((addr = ref.get("ENC")) != null && (value = addr.getContent()) != null) {
            this.setEncoding(Integer.parseInt((String)value));
        }
        if ((addr = ref.get("FIQ")) != null && (value = addr.getContent()) != null) {
            this.setFailIfQuiesce(Integer.parseInt((String)value));
        }
        if ((addr = ref.get("WCFMT")) != null && (value = addr.getContent()) != null) {
            this.setWildcardFormat(Integer.parseInt((String)value));
        }
        if ((addr = ref.get("RACP")) != null && (value = addr.getContent()) != null) {
            this.setReadAheadClosePolicy(Integer.parseInt((String)value));
        }
        if ((addr = ref.get("RAALD")) != null && (value = addr.getContent()) != null) {
            this.setReadAheadAllowed(Integer.parseInt((String)value));
        }
        if ((addr = ref.get("PAALD")) != null && (value = addr.getContent()) != null) {
            this.setPutAsyncAllowed(Integer.parseInt((String)value));
        }
        if ((addr = ref.get("MBODY")) != null && (value = addr.getContent()) != null) {
            this.setMessageBodyStyle(Integer.parseInt((String)value));
        }
        if ((addr = ref.get("MDR")) != null && (value = addr.getContent()) != null) {
            this.setMQMDReadEnabled(Boolean.valueOf((String)value));
        }
        if ((addr = ref.get("MDW")) != null && (value = addr.getContent()) != null) {
            this.setMQMDWriteEnabled(Boolean.valueOf((String)value));
        }
        if ((addr = ref.get("MDCTX")) != null && (value = addr.getContent()) != null) {
            this.setMQMDMessageContext(Integer.parseInt((String)value));
        }
        if ((addr = ref.get("RTOST")) != null && (value = addr.getContent()) != null) {
            this.setReplyToStyle(Integer.parseInt((String)value));
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQDestination", "setCommonFromReference(Reference)");
        }
    }

    public void setDescription(String description) {
        block4: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.mq.jms.MQDestination", "setDescription(String)", new Object[]{description});
            }
            try {
                this.propertyDelegate.setStringProperty("destDescription", description);
            }
            catch (JMSException je) {
                if (!Trace.isOn) break block4;
                Trace.catchBlock(this, "com.ibm.mq.jms.MQDestination", "setDescription(String)", je);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQDestination", "setDescription(String)");
        }
    }

    public void setEncoding(int encoding) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "setEncoding(int)", "setter", new Integer(encoding));
        }
        this.propertyDelegate.setIntProperty("encoding", encoding);
    }

    public void setExpiry(long expiry) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "setExpiry(long)", "setter", new Long(expiry));
        }
        this.propertyDelegate.setLongProperty("timeToLive", expiry);
    }

    public void setFailIfQuiesce(int fiq) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "setFailIfQuiesce(int)", "setter", new Integer(fiq));
        }
        this.propertyDelegate.setIntProperty("failIfQuiesce", fiq);
    }

    public void setMQMDMessageContext(int messageContext) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "setMQMDMessageContext(int)", "setter", new Integer(messageContext));
        }
        this.propertyDelegate.setIntProperty("mdMessageContext", messageContext);
    }

    public void setMQMDWriteEnabled(boolean writeEnabled) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "setMQMDWriteEnabled(boolean)", "setter", writeEnabled);
        }
        this.propertyDelegate.setBooleanProperty("mdWriteEnabled", writeEnabled);
    }

    public void setMQMDReadEnabled(boolean readEnabled) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "setMQMDReadEnabled(boolean)", "setter", readEnabled);
        }
        this.propertyDelegate.setBooleanProperty("mdReadEnabled", readEnabled);
    }

    public void setMessageBodyStyle(int bodyStyle) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "setMessageBodyStyle(int)", "setter", new Integer(bodyStyle));
        }
        this.propertyDelegate.setIntProperty("messageBody", bodyStyle);
    }

    public void setPersistence(int persistence) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "setPersistence(int)", "setter", new Integer(persistence));
        }
        this.propertyDelegate.setIntProperty("deliveryMode", persistence);
    }

    public void setPriority(int priority) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "setPriority(int)", "setter", new Integer(priority));
        }
        this.propertyDelegate.setIntProperty("priority", priority);
    }

    public void setProperty(String name, String value) {
        block5: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.mq.jms.MQDestination", "setProperty(String,String)", new Object[]{name, value});
            }
            try {
                if (name != null && value != null) {
                    this.setStringProperty(name, value);
                }
            }
            catch (JMSException je) {
                if (!Trace.isOn) break block5;
                Trace.catchBlock(this, "com.ibm.mq.jms.MQDestination", "setProperty(String,String)", je);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQDestination", "setProperty(String,String)");
        }
    }

    public void setPutAsyncAllowed(int paa) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "setPutAsyncAllowed(int)", "setter", new Integer(paa));
        }
        this.propertyDelegate.setIntProperty("putAsyncAllowed", paa);
    }

    public void setReadAheadAllowed(int raa) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "setReadAheadAllowed(int)", "setter", new Integer(raa));
        }
        this.propertyDelegate.setIntProperty("readAheadAllowed", raa);
    }

    public void setReadAheadClosePolicy(int racp) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "setReadAheadClosePolicy(int)", "setter", new Integer(racp));
        }
        this.propertyDelegate.setIntProperty("readAheadClosePolicy", racp);
    }

    public void setTargetClient(int targetClient) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "setTargetClient(int)", "setter", new Integer(targetClient));
        }
        this.propertyDelegate.setIntProperty("targetClient", targetClient);
    }

    public void setVersion(int version) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQDestination", "setVersion(int)", new Object[]{new Integer(version)});
        }
        if (!this.versionChangeAllowed) {
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ0012", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.mq.jms.MQDestination", "setVersion(int)", je);
            }
            throw je;
        }
        this.propertyDelegate.setIntProperty("version", version);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQDestination", "setVersion(int)");
        }
    }

    public void setWildcardFormat(int format) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQDestination", "setWildcardFormat(int)", new Object[]{new Integer(format)});
        }
        this.propertyDelegate.setIntProperty("wildcardFormat", format);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQDestination", "setWildcardFormat(int)");
        }
    }

    public void setReplyToStyle(int style) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "setReplyToStyle(int)", "setter", new Integer(style));
        }
        this.propertyDelegate.setIntProperty("XMSC_WMQ_REPLYTO_STYLE", style);
    }

    public int getReplyToStyle() throws JMSException {
        int traceRet1 = this.propertyDelegate.getIntProperty("XMSC_WMQ_REPLYTO_STYLE");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQDestination", "getReplyToStyle()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    protected Destination validateDestination() throws JMSException {
        String name;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQDestination", "validateDestination()");
        }
        if ((name = this.getName()) == null || name.trim().equals("")) {
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1113", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.mq.jms.MQDestination", "validateDestination()", je);
            }
            throw je;
        }
        if (this instanceof MQTemporaryQueue) {
            TemporaryQueue traceRet1 = ((MQTemporaryQueue)this).getCommonTemporaryQueue();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "validateDestination()", traceRet1, 1);
            }
            return traceRet1;
        }
        if (this instanceof MQTemporaryTopic) {
            TemporaryTopic traceRet2 = ((MQTemporaryTopic)this).getCommonTemporaryTopic();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.mq.jms.MQDestination", "validateDestination()", traceRet2, 2);
            }
            return traceRet2;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQDestination", "validateDestination()", this, 3);
        }
        return this;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        block4: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.mq.jms.MQDestination", "writeObject(java.io.ObjectOutputStream)", new Object[]{out});
            }
            ObjectOutputStream.PutField fields = out.putFields();
            try {
                fields.put("CCSID", this.getCCSID());
                fields.put("receiveCCSID", this.getReceiveCCSID());
                fields.put("receiveConversion", this.getReceiveConversion());
                fields.put("description", this.getDescription());
                fields.put("encoding", this.getEncoding());
                fields.put("expiry", this.getExpiry());
                fields.put("failIfQuiesce", this.getFailIfQuiesce());
                fields.put("messageBodyStyle", this.getMessageBodyStyle());
                fields.put("MQMDMessageContext", this.getMQMDMessageContext());
                fields.put("MQMDReadEnabled", this.getMQMDReadEnabled());
                fields.put("MQMDWriteEnabled", this.getMQMDWriteEnabled());
                fields.put("persistence", this.getPersistence());
                fields.put("priority", this.getPriority());
                fields.put("putAsyncAllowed", this.getPutAsyncAllowed());
                fields.put("readAheadAllowed", this.getReadAheadAllowed());
                fields.put("readAheadClosePolicy", this.getReadAheadClosePolicy());
                fields.put("targetClient", this.getTargetClient());
                fields.put("version", this.getVersion());
                fields.put("wildcardFormat", this.getWildcardFormat());
                fields.put("replyToStyle", this.getReplyToStyle());
            }
            catch (JMSException je) {
                if (!Trace.isOn) break block4;
                Trace.catchBlock(this, "com.ibm.mq.jms.MQDestination", "writeObject(java.io.ObjectOutputStream)", je);
            }
        }
        out.writeFields();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQDestination", "writeObject(java.io.ObjectOutputStream)");
        }
    }

    protected static Destination proxyValidateDestination(Destination dest) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQDestination", "proxyValidateDestination(Destination)", new Object[]{dest});
        }
        if (dest instanceof MQDestination) {
            Destination traceRet1 = ((MQDestination)dest).validateDestination();
            if (Trace.isOn) {
                Trace.exit("com.ibm.mq.jms.MQDestination", "proxyValidateDestination(Destination)", traceRet1, 1);
            }
            return traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQDestination", "proxyValidateDestination(Destination)", dest, 2);
        }
        return dest;
    }

    protected static MQTemporaryTopic proxyCreateTemporaryTopic(TemporaryTopic tempTopic) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQDestination", "proxyCreateTemporaryTopic(TemporaryTopic)", new Object[]{tempTopic});
        }
        MQTemporaryTopic traceRet1 = new MQTemporaryTopic(tempTopic);
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQDestination", "proxyCreateTemporaryTopic(TemporaryTopic)", traceRet1);
        }
        return traceRet1;
    }

    protected static MQTemporaryQueue proxyCreateTemporaryQueue(TemporaryQueue tempQueue) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQDestination", "proxyCreateTemporaryQueue(TemporaryQueue)", new Object[]{tempQueue});
        }
        MQTemporaryQueue traceRet1 = new MQTemporaryQueue(tempQueue);
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQDestination", "proxyCreateTemporaryQueue(TemporaryQueue)", traceRet1);
        }
        return traceRet1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.MQDestination", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQDestination.java, jmscc.migration.wmq, k701, k701-112-140304  1.107.1.6 12/06/07 19:49:15");
        }
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQDestination", "static()");
        }
        MQConnectionFactory.checkTracing();
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQDestination", "static()");
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("receiveCCSID", Integer.TYPE), new ObjectStreamField("receiveConversion", Integer.TYPE), new ObjectStreamField("CCSID", Integer.TYPE), new ObjectStreamField("deliveryMode", Integer.TYPE), new ObjectStreamField("description", String.class), new ObjectStreamField("encoding", Integer.TYPE), new ObjectStreamField("expiry", Long.TYPE), new ObjectStreamField("failIfQuiesce", Integer.TYPE), new ObjectStreamField("messageBodyStyle", Integer.TYPE), new ObjectStreamField("MQMDMessageContext", Integer.TYPE), new ObjectStreamField("MQMDReadEnabled", Boolean.TYPE), new ObjectStreamField("MQMDWriteEnabled", Boolean.TYPE), new ObjectStreamField("persistence", Integer.TYPE), new ObjectStreamField("priority", Integer.TYPE), new ObjectStreamField("putAsyncAllowed", Integer.TYPE), new ObjectStreamField("readAheadAllowed", Integer.TYPE), new ObjectStreamField("readAheadClosePolicy", Integer.TYPE), new ObjectStreamField("targetClient", Integer.TYPE), new ObjectStreamField("timeToLive", Long.TYPE), new ObjectStreamField("version", Integer.TYPE), new ObjectStreamField("wildcardFormat", Integer.TYPE), new ObjectStreamField("replyToStyle", Integer.TYPE)};
        connectionType = "com.ibm.msg.client.wmq";
    }
}

