/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQRoot;
import com.ibm.msg.client.commonservices.Log.Log;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsConnectionMetaData;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;

public class MQConnectionMetaData
extends MQRoot
implements ConnectionMetaData,
JmsConnectionMetaData {
    protected JmsConnectionMetaData commonMetaData = null;
    private static final long serialVersionUID = -2654952703987040469L;
    private static int connectionType;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public MQConnectionMetaData() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnectionMetaData", "<init>()");
        }
        connectionType = 0;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQConnectionMetaData", "<init>()");
        }
    }

    public MQConnectionMetaData(int conntype) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnectionMetaData", "<init>(int)", new Object[]{new Integer(conntype)});
        }
        connectionType = conntype;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQConnectionMetaData", "<init>(int)");
        }
    }

    protected MQConnectionMetaData(JmsConnectionMetaData metaData) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnectionMetaData", "<init>(JmsConnectionMetaData)", new Object[]{metaData});
        }
        this.setDelegate(metaData);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQConnectionMetaData", "<init>(JmsConnectionMetaData)");
        }
    }

    public int getJMSMajorVersion() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnectionMetaData", "getJMSMajorVersion()");
        }
        int v = 1;
        try {
            if (this.commonMetaData != null) {
                v = this.commonMetaData.getJMSMajorVersion();
            } else {
                Log.log(this, "getJMSMajorVersion()", "JMSMQ1121", null);
            }
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionMetaData", "getJMSMajorVersion()", e);
            }
            HashMap<String, JMSException> data = new HashMap<String, JMSException>();
            data.put("exception", e);
            Trace.ffst(this, "getJMSMajorVersion()", "XF00A001", data, null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionMetaData", "getJMSMajorVersion()", new Integer(v));
        }
        return v;
    }

    public int getJMSMinorVersion() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnectionMetaData", "getJMSMinorVersion()");
        }
        int v = 1;
        try {
            if (this.commonMetaData != null) {
                v = this.commonMetaData.getJMSMinorVersion();
            } else {
                Log.log(this, "getJMSMinorVersion()", "JMSMQ1121", null);
            }
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionMetaData", "getJMSMinorVersion()", e);
            }
            HashMap<String, JMSException> data = new HashMap<String, JMSException>();
            data.put("exception", e);
            Trace.ffst(this, "getJMSMinorVersion()", "XF00A002", data, null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionMetaData", "getJMSMinorVersion()", new Integer(v));
        }
        return v;
    }

    public String getJMSProviderName() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnectionMetaData", "getJMSProviderName()");
        }
        String v = "IBM WebSphere MQ";
        try {
            if (this.commonMetaData != null) {
                v = this.commonMetaData.getJMSProviderName();
            } else {
                Log.log(this, "getJMSProviderName()", "JMSMQ1121", null);
            }
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionMetaData", "getJMSProviderName()", e);
            }
            HashMap<String, JMSException> data = new HashMap<String, JMSException>();
            data.put("exception", e);
            Trace.ffst(this, "getJMSProviderName()", "XF00A003", data, null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionMetaData", "getJMSProviderName()", v);
        }
        return v;
    }

    public String getJMSVersion() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnectionMetaData", "getJMSVersion()");
        }
        String v = "1.1";
        try {
            if (this.commonMetaData != null) {
                v = this.commonMetaData.getJMSVersion();
            } else {
                Log.log(this, "getJMSVersion()", "JMSMQ1121", null);
            }
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionMetaData", "getJMSVersion()", e);
            }
            HashMap<String, JMSException> data = new HashMap<String, JMSException>();
            data.put("exception", e);
            Trace.ffst(this, "getJMSVersion()", "XF00A004", data, null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionMetaData", "getJMSVersion()", v);
        }
        return v;
    }

    public Enumeration getJMSXPropertyNames() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnectionMetaData", "getJMSXPropertyNames()");
        }
        Enumeration v = null;
        try {
            if (this.commonMetaData != null) {
                v = this.commonMetaData.getJMSXPropertyNames();
            } else {
                Log.log(this, "getJMSXPropertyNames()", "JMSMQ1121", null);
            }
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionMetaData", "getJMSXPropertyNames()", e);
            }
            HashMap<String, JMSException> data = new HashMap<String, JMSException>();
            data.put("exception", e);
            Trace.ffst(this, "getJMSXPropertyNames()", "XF00A005", data, null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionMetaData", "getJMSXPropertyNames()", v);
        }
        return v;
    }

    public int getProviderMajorVersion() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnectionMetaData", "getProviderMajorVersion()");
        }
        int v = 7;
        try {
            if (this.commonMetaData != null) {
                v = this.commonMetaData.getProviderMajorVersion();
            } else {
                Log.log(this, "getProviderMajorVersion()", "JMSMQ1121", null);
            }
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionMetaData", "getProviderMajorVersion()", e);
            }
            HashMap<String, JMSException> data = new HashMap<String, JMSException>();
            data.put("exception", e);
            Trace.ffst(this, "getProviderMajorVersion()", "XF00A006", data, null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionMetaData", "getProviderMajorVersion()", new Integer(v));
        }
        return v;
    }

    public int getProviderMinorVersion() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnectionMetaData", "getProviderMinorVersion()");
        }
        int v = 0;
        try {
            if (this.commonMetaData != null) {
                v = this.commonMetaData.getProviderMinorVersion();
            } else {
                Log.log(this, "getProviderMinorVersion()", "JMSMQ1121", null);
            }
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionMetaData", "getProviderMinorVersion()", e);
            }
            HashMap<String, JMSException> data = new HashMap<String, JMSException>();
            data.put("exception", e);
            Trace.ffst(this, "getProviderMinorVersion()", "XF00A007", data, null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionMetaData", "getProviderMinorVersion()", new Integer(v));
        }
        return v;
    }

    public String getProviderVersion() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnectionMetaData", "getProviderVersion()");
        }
        String v = "7.0";
        try {
            if (this.commonMetaData != null) {
                v = this.commonMetaData.getProviderVersion();
            } else {
                Log.log(this, "getProviderVersion()", "JMSMQ1121", null);
            }
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionMetaData", "getProviderVersion()", e);
            }
            HashMap<String, JMSException> data = new HashMap<String, JMSException>();
            data.put("exception", e);
            Trace.ffst(this, "getProviderVersion()", "XF00A008", data, null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionMetaData", "getProviderVersion()", v);
        }
        return v;
    }

    public String toString() {
        String s = "IBM WebSpher MQ 7.0";
        if (this.commonMetaData != null) {
            s = this.commonMetaData.toString();
        } else {
            Log.log(this, "getProviderVersion()", "JMSMQ1121", null);
        }
        return s;
    }

    void setDelegate(JmsConnectionMetaData metaData) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnectionMetaData", "setDelegate(JmsConnectionMetaData)", new Object[]{metaData});
        }
        this.commonMetaData = metaData;
        this.delegate = this.commonMetaData;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQConnectionMetaData", "setDelegate(JmsConnectionMetaData)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.MQConnectionMetaData", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQConnectionMetaData.java, jmscc.migration.wmq, k701, k701-112-140304  1.29.1.3 12/06/07 18:38:36");
        }
        connectionType = 0;
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.MQConnectionMetaData", "static()");
        }
        NLSServices.addCatalogue("com.ibm.mq.jms.resources.JMSMQ_MessageResourceBundle", "JMSMQ");
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.MQConnectionMetaData", "static()");
        }
    }
}

