/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jmqi.JmqiUtils;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQConnectionFactoryFactory;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.MQXAConnectionFactory;
import com.ibm.mq.jms.MQXAQueueConnectionFactory;
import com.ibm.mq.jms.MQXATopicConnectionFactory;
import com.ibm.msg.client.commonservices.Log.Log;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.jms.JmsConnection;
import com.ibm.msg.client.jms.JmsFactoryFactory;
import com.ibm.msg.client.jms.admin.JmsJndiConnectionFactoryImpl;
import com.ibm.msg.client.services.Trace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.XATopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class MQConnectionFactory
extends JmsJndiConnectionFactoryImpl {
    private static final long serialVersionUID = 1357803352856448349L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid2 = "@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQConnectionFactory.java, jmscc.migration.wmq, k701, k701-112-140304 1.176.1.12 10/07/23 11:08:52";
    private static final ObjectStreamField[] serialPersistentFields;
    protected boolean mselSet;
    protected boolean bverSet;
    protected boolean portSet;
    private transient boolean versionChangeAllowed = false;
    protected transient String connectionType = "com.ibm.msg.client.wmq";
    private static final String nullString = "IamANullString";

    public MQConnectionFactory() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "<init>()");
        }
        this.initialiseMQConnectionFactory();
        try {
            this.setIntProperty("XMSC_WMQ_CONNECTION_MODE", 0);
            this.setIntProperty("XMSC_WMQ_CONNECT_OPTIONS", 0);
            if (this instanceof MQXAConnectionFactory || this instanceof MQXATopicConnectionFactory || this instanceof MQXAQueueConnectionFactory) {
                this.setProviderFactory(true);
            } else {
                this.setProviderFactory(false);
            }
        }
        catch (JMSException e) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "<init>()", e);
            }
            com.ibm.msg.client.commonservices.trace.Trace.ffst(this, "readObject()", "XF001001", null, null);
        }
        this.setDefaultProperties();
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "<init>()");
        }
    }

    private void setDefaultProperties() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setDefaultProperties()");
        }
        this.portSet = false;
        this.bverSet = false;
        this.mselSet = false;
        try {
            this.settingDefaults = true;
            this.setAsyncExceptions(-1);
            this.setBrokerCCSubQueue("SYSTEM.JMS.ND.CC.SUBSCRIBER.QUEUE");
            this.setBrokerControlQueue("SYSTEM.BROKER.CONTROL.QUEUE");
            this.setBrokerPubQueue("SYSTEM.BROKER.DEFAULT.STREAM");
            this.setBrokerQueueManager("");
            this.setBrokerSubQueue("SYSTEM.JMS.ND.SUBSCRIBER.QUEUE");
            this.setBrokerVersion(-1);
            this.setCleanupInterval(3600000L);
            this.bverSet = false;
            this.setCCDTURL(null);
            this.setCCSID(819);
            this.setChannel("SYSTEM.DEF.SVRCONN");
            this.setCleanupLevel(1);
            this.setClientID(null);
            this.setConnectionNameListInternal("localhost(1414)");
            this.setClientReconnectOptions(0);
            this.setClientReconnectTimeout(1800);
            this.setCloneSupport(0);
            this.setMQConnectionOptions(0);
            byte[] connTag = new byte[128];
            for (int i = 0; i < connTag.length; ++i) {
                connTag[i] = 0;
            }
            this.setConnTag(connTag);
            this.setDescription(null);
            this.setDirectAuth(0);
            this.setFailIfQuiesce(1);
            this.setHdrCompList((Collection)null);
            PropertyStore.register("com.ibm.mq.localAddress", "");
            this.setLocalAddress(PropertyStore.getStringProperty("com.ibm.mq.localAddress"));
            this.setMapNameStyle(true);
            this.setMaxBufferSize(1000);
            this.setMessageRetention(1);
            this.setMessageSelection(0);
            this.mselSet = false;
            this.setMsgBatchSize(10);
            this.setMsgCompList((Collection)null);
            this.setMulticast(0);
            this.setOptimisticPublication(false);
            this.setOutcomeNotification(true);
            this.setPollingInterval(5000);
            this.portSet = false;
            this.setProcessDuration(0);
            this.setProviderVersion("unspecified");
            this.setProxyHostName(null);
            this.setProxyPort(443);
            this.setPubAckInterval(25);
            this.setQueueManager("");
            this.setReceiveExit(null);
            this.setReceiveExitInit(null);
            this.setReceiveIsolation(0);
            this.setRescanInterval(5000);
            this.setSecurityExit(null);
            this.setSecurityExitInit(null);
            this.setSendExit(null);
            this.setSendExitInit(null);
            this.setSendCheckCount(0);
            this.setShareConvAllowed(1);
            this.setSparseSubscriptions(false);
            this.setSSLCertStores((Collection)null);
            this.setSSLCipherSuite(null);
            this.setSSLFipsRequired(false);
            this.setSSLPeerName(null);
            this.setSSLResetCount(0);
            this.setSSLSocketFactory(null);
            this.setStatusRefreshInterval(60000);
            this.setSubscriptionStore(1);
            this.setSyncpointAllGets(false);
            this.setTargetClientMatching(true);
            this.setTemporaryModel("SYSTEM.DEFAULT.MODEL.QUEUE");
            this.setTempQPrefix("");
            this.setTempTopicPrefix("");
            this.setTransportType(0);
            this.setUseConnectionPooling(true);
            this.versionChangeAllowed = true;
            this.setVersion(7);
            this.versionChangeAllowed = false;
            this.setWildcardFormat(0);
            this.settingDefaults = false;
        }
        catch (JMSException e) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setDefaultProperties()", e);
            }
            e.printStackTrace();
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setDefaultProperties()");
        }
    }

    protected String findCorrectField(String field) {
        String[][] fieldNames = new String[][]{{"cCDTURL", "clientID", "hdrCompListAsString", "mQConnectionOptions", "msgCompListAsString", "sSLCertStores", "sSLCertStoresAsString", "sSLCipherSuite", "sSLFipsRequired", "sSLPeerName", "sSLSocketFactory", "sSLResetCount", "cCSID", "reference"}, {"ccdtUrl", "clientId", null, "connOptions", null, "sslCertStores_coll", "sslCertStores_string", "sslCipherSuite", "sslFipsRequired", "sslPeerName", "sslSocketFactory", "sslResetCount", "CCSID", null}};
        for (int i = 0; i < fieldNames[0].length; ++i) {
            if (!field.equals(fieldNames[0][i])) continue;
            return fieldNames[1][i];
        }
        return field;
    }

    protected String findCorrectMethod(String method) {
        String[][] methodNames = new String[][]{{"setSslSocketFactory", "setSslResetCount", "setSslPeerName", "setSslFipsRequired", "setSslCipherSuite", "setSslCertStores_string", "setSslCertStores_coll", "setConnOptions", "setCcdtUrl"}, {"setSSLSocketFactory", "setSSLResetCount", "setSSLPeerName", "setSSLFipsRequired", "setSSLCipherSuite", "setSSLCertStores", "setSSLCertStores", "setMQConnectionOptions", "setCCDTURL"}};
        for (int i = 0; i < methodNames[0].length; ++i) {
            if (!method.equals(methodNames[0][i])) continue;
            return methodNames[1][i];
        }
        return method;
    }

    public String getBrokerCCSubQueue() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getBrokerCCSubQueue()");
        }
        if (this instanceof MQQueueConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getBrokerCCSubQueue()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getBrokerCCSubQueue()", je);
            }
            throw je;
        }
        String traceRet1 = super.getStringProperty("XMSC_WMQ_BROKER_CC_SUBQ");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getBrokerCCSubQueue()", traceRet1);
        }
        return traceRet1;
    }

    public String getBrokerControlQueue() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getBrokerControlQueue()");
        }
        if (this instanceof MQQueueConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getBrokerControlQueue()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getBrokerControlQueue()", je);
            }
            throw je;
        }
        String traceRet1 = super.getStringProperty("XMSC_WMQ_BROKER_CONTROLQ");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getBrokerControlQueue()", traceRet1);
        }
        return traceRet1;
    }

    public String getBrokerPubQueue() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getBrokerPubQueue()");
        }
        if (this instanceof MQQueueConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getBrokerPubQueue()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getBrokerPubQueue()", je);
            }
            throw je;
        }
        String traceRet1 = super.getStringProperty("XMSC_WMQ_BROKER_PUBQ");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getBrokerPubQueue()", traceRet1);
        }
        return traceRet1;
    }

    public String getBrokerQueueManager() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getBrokerQueueManager()");
        }
        if (this instanceof MQQueueConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getBrokerQueueManager()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getBrokerQueueManager()", je);
            }
            throw je;
        }
        String traceRet1 = super.getStringProperty("XMSC_WMQ_BROKER_QMGR");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getBrokerQueueManager()", traceRet1);
        }
        return traceRet1;
    }

    public String getBrokerSubQueue() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getBrokerSubQueue()");
        }
        if (this instanceof MQQueueConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getBrokerSubQueue()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getBrokerSubQueue()", je);
            }
            throw je;
        }
        String traceRet1 = super.getStringProperty("XMSC_WMQ_BROKER_SUBQ");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getBrokerSubQueue()", traceRet1);
        }
        return traceRet1;
    }

    public int getBrokerVersion() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getBrokerVersion()");
        }
        if (this instanceof MQQueueConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getBrokerVersion()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getBrokerVersion()", je);
            }
            throw je;
        }
        int traceRet1 = super.getIntProperty("brokerVersion");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getBrokerVersion()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public URL getCCDTURL() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getCCDTURL()");
        }
        try {
            String value = super.getStringProperty("XMSC_WMQ_CCDTURL");
            URL traceRet1 = value != null ? new URL(value) : null;
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getCCDTURL()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getCCDTURL()", je, 1);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getCCDTURL()", null, 2);
            }
            return null;
        }
        catch (MalformedURLException e) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getCCDTURL()", e, 2);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getCCDTURL()", null, 3);
            }
            return null;
        }
    }

    public int getCCSID() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getCCSID()");
        }
        try {
            int traceRet1 = super.getIntProperty("XMSC_WMQ_QMGR_CCSID");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getCCSID()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getCCSID()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getCCSID()", new Integer(0), 2);
            }
            return 0;
        }
    }

    public String getChannel() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getChannel()");
        }
        try {
            String traceRet1 = super.getStringProperty("XMSC_WMQ_CHANNEL");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getChannel()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getChannel()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getChannel()", null, 2);
            }
            return null;
        }
    }

    public long getCleanupInterval() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getCleanupInterval()");
        }
        if (this instanceof MQQueueConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getCleanupInterval()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getCleanupInterval()", je);
            }
            throw je;
        }
        long traceRet1 = super.getLongProperty("XMSC_WMQ_CLEANUP_INTERVAL");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getCleanupInterval()", new Long(traceRet1));
        }
        return traceRet1;
    }

    public int getCleanupLevel() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getCleanupLevel()");
        }
        if (this instanceof MQQueueConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getCleanupLevel()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getCleanupLevel()", je);
            }
            throw je;
        }
        int traceRet1 = super.getIntProperty("XMSC_WMQ_CLEANUP_LEVEL");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getCleanupLevel()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public String getClientID() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getClientID()");
        }
        try {
            String traceRet1 = super.getStringProperty("XMSC_CLIENT_ID");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getClientID()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getClientID()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getClientID()", null, 2);
            }
            return null;
        }
    }

    public String getClientId() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getClientId()");
        }
        try {
            String traceRet1 = super.getStringProperty("XMSC_CLIENT_ID");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getClientId()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getClientId()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getClientId()", null, 2);
            }
            return null;
        }
    }

    public int getCloneSupport() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getCloneSupport()");
        }
        if (this instanceof MQQueueConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getCloneSupport()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getCloneSupport()", je);
            }
            throw je;
        }
        int traceRet1 = super.getIntProperty("XMSC_WMQ_CLONE_SUPPORT");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getCloneSupport()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public byte[] getConnTag() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getConnTag()");
        }
        try {
            byte[] traceRet1 = super.getBytesProperty("XMSC_WMQ_CONNECTION_TAG");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getConnTag()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getConnTag()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getConnTag()", null, 2);
            }
            return null;
        }
    }

    public String getDescription() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getDescription()");
        }
        try {
            String traceRet1 = super.getStringProperty("XMSC_WMQ_CF_DESCRIPTION");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getDescription()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getDescription()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getDescription()", null, 2);
            }
            return null;
        }
    }

    public int getDirectAuth() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getDirectAuth()");
        }
        if (this instanceof MQQueueConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getDirectAuth()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getDirectAuth()", je);
            }
            throw je;
        }
        int traceRet1 = super.getIntProperty("XMSC_RTT_DIRECT_AUTH");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getDirectAuth()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getFailIfQuiesce() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getFailIfQuiesce()");
        }
        try {
            int traceRet1 = super.getIntProperty("failIfQuiesce");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getFailIfQuiesce()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getFailIfQuiesce()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getFailIfQuiesce()", new Integer(0), 2);
            }
            return 0;
        }
    }

    public Collection getHdrCompList() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getHdrCompList()");
        }
        try {
            Vector<Object> value = super.getObjectProperty("XMSC_WMQ_HEADER_COMP");
            if (value instanceof String) {
                StringTokenizer st = new StringTokenizer((String)((Object)value));
                Vector<Object> c = new Vector<Object>();
                while (st.hasMoreTokens()) {
                    String tk = st.nextToken();
                    if (tk.equals("NONE")) {
                        c.add(new Integer(0));
                        continue;
                    }
                    if (tk.equals("SYSTEM")) {
                        c.add(new Integer(8));
                        continue;
                    }
                    c.add(tk);
                }
                value = c;
            }
            Collection traceRet1 = value;
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getHdrCompList()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getHdrCompList()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getHdrCompList()", null, 2);
            }
            return null;
        }
    }

    public String getHdrCompListAsString() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getHdrCompListAsString()");
        }
        String compString = null;
        Collection hdrCompList = this.getHdrCompList();
        if (hdrCompList != null) {
            compString = "";
            Iterator it = hdrCompList.iterator();
            if (it != null) {
                Integer compressor = new Integer(0);
                while (it.hasNext()) {
                    compressor = (Integer)it.next();
                    switch (compressor) {
                        case 0: {
                            compString = compString + "NONE ";
                            break;
                        }
                        case 8: {
                            compString = compString + "SYSTEM ";
                        }
                    }
                }
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getHdrCompListAsString()", compString);
        }
        return compString;
    }

    public String getHostName() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getHostName()");
        }
        try {
            String traceRet1 = super.getStringProperty("XMSC_WMQ_HOST_NAME");
            if (traceRet1.equals(nullString)) {
                traceRet1 = null;
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getHostName()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getHostName()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getHostName()", null, 2);
            }
            return null;
        }
    }

    public String getLocalAddress() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getLocalAddress()");
        }
        try {
            String traceRet1 = super.getStringProperty("XMSC_WMQ_LOCAL_ADDRESS");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getLocalAddress()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getLocalAddress()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getLocalAddress()", null, 2);
            }
            return null;
        }
    }

    public boolean getMapNameStyle() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getMapNameStyle()");
        }
        try {
            boolean traceRet1 = super.getBooleanProperty("XMSC_WMQ_MAP_NAME_STYLE");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getMapNameStyle()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getMapNameStyle()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getMapNameStyle()", false, 2);
            }
            return false;
        }
    }

    public int getMaxBufferSize() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getMaxBufferSize()");
        }
        if (this instanceof MQQueueConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getMaxBufferSize()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getMaxBufferSize()", je);
            }
            throw je;
        }
        int traceRet1 = super.getIntProperty("XMSC_WMQ_MAX_BUFFER_SIZE");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getMaxBufferSize()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getMessageRetention() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getMessageRetention()");
        }
        if (this instanceof MQTopicConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getMessageRetention()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getMessageRetention()", je);
            }
            throw je;
        }
        int traceRet1 = super.getIntProperty("XMSC_WMQ_MESSAGE_RETENTION");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getMessageRetention()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getMessageSelection() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getMessageSelection()");
        }
        if (this instanceof MQQueueConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getMessageSelection()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getMessageSelection()", je);
            }
            throw je;
        }
        int traceRet1 = super.getIntProperty("XMSC_WMQ_MESSAGE_SELECTION");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getMessageSelection()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getMQConnectionOptions() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getMQConnectionOptions()");
        }
        try {
            int traceRet1 = super.getIntProperty("XMSC_WMQ_CONNECT_OPTIONS");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getMQConnectionOptions()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getMQConnectionOptions()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getMQConnectionOptions()", new Integer(0), 2);
            }
            return 0;
        }
    }

    public int getMsgBatchSize() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getMsgBatchSize()");
        }
        try {
            int traceRet1 = super.getIntProperty("XMSC_WMQ_MSG_BATCH_SIZE");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getMsgBatchSize()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getMsgBatchSize()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getMsgBatchSize()", new Integer(0), 2);
            }
            return 0;
        }
    }

    public Collection getMsgCompList() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getMsgCompList()");
        }
        try {
            Vector<Integer> value = super.getObjectProperty("XMSC_WMQ_MSG_COMP");
            if (value instanceof String) {
                StringTokenizer st = new StringTokenizer((String)((Object)value));
                Vector<Integer> c = new Vector<Integer>();
                while (st.hasMoreTokens()) {
                    String tk = st.nextToken();
                    if (tk.equals("NONE")) {
                        c.add(new Integer(0));
                        continue;
                    }
                    if (tk.equals("RLE")) {
                        c.add(new Integer(1));
                        continue;
                    }
                    if (tk.equals("ZLIBFAST")) {
                        c.add(new Integer(2));
                        continue;
                    }
                    if (tk.equals("ZLIBHIGH")) {
                        c.add(new Integer(4));
                        continue;
                    }
                    if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                        com.ibm.msg.client.commonservices.trace.Trace.traceData(this, "Compressor value is not supported", null);
                    }
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("XMSC_INSERT_VALUE", tk);
                    info.put("XMSC_INSERT_NAME", "Compressor value");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1006", info));
                    if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                        com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getMsgCompList()", je);
                    }
                    throw je;
                }
                value = c;
            }
            Collection traceRet1 = value;
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getMsgCompList()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getMsgCompList()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getMsgCompList()", null, 2);
            }
            return null;
        }
    }

    public String getMsgCompListAsString() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getMsgCompListAsString()");
        }
        String compString = null;
        Collection msgCompList = this.getMsgCompList();
        if (msgCompList != null) {
            compString = "";
            Iterator it = msgCompList.iterator();
            Integer compressor = new Integer(0);
            if (it != null) {
                while (it.hasNext()) {
                    compressor = (Integer)it.next();
                    switch (compressor) {
                        case 0: {
                            compString = compString + "NONE ";
                            break;
                        }
                        case 1: {
                            compString = compString + "RLE ";
                            break;
                        }
                        case 2: {
                            compString = compString + "ZLIBFAST ";
                            break;
                        }
                        case 4: {
                            compString = compString + "ZLIBHIGH ";
                        }
                    }
                }
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getMsgCompListAsString()", compString);
        }
        return compString;
    }

    public int getMulticast() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getMulticast()");
        }
        if (this instanceof MQQueueConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getMulticast()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getMulticast()", je);
            }
            throw je;
        }
        int traceRet1 = super.getIntProperty("multicast");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getMulticast()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public boolean getOptimisticPublication() throws JMSException {
        boolean traceRet1 = super.getBooleanProperty("XMSC_WMQ_OPT_PUB");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "getOptimisticPublication()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public boolean getOutcomeNotification() throws JMSException {
        boolean traceRet1 = super.getBooleanProperty("XMSC_WMQ_OUTCOME_NOTIFICATION");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "getOutcomeNotification()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public int getPollingInterval() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getPollingInterval()");
        }
        try {
            int traceRet1 = super.getIntProperty("XMSC_WMQ_POLLING_INTERVAL");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getPollingInterval()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getPollingInterval()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getPollingInterval()", new Integer(0), 2);
            }
            return 0;
        }
    }

    public int getPort() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getPort()");
        }
        try {
            int traceRet1 = super.getIntProperty("XMSC_WMQ_PORT");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getPort()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getPort()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getPort()", new Integer(0), 2);
            }
            return 0;
        }
    }

    public int getProcessDuration() throws JMSException {
        int traceRet1 = super.getIntProperty("XMSC_WMQ_PROCESS_DURATION");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "getProcessDuration()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public String getProviderVersion() throws JMSException {
        String traceRet1 = super.getStringProperty("XMSC_WMQ_PROVIDER_VERSION");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "getProviderVersion()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public String getProxyHostName() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getProxyHostName()");
        }
        if (this instanceof MQQueueConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getProxyHostName()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getProxyHostName()", je);
            }
            throw je;
        }
        String traceRet1 = super.getStringProperty("XMSC_RTT_PROXY_HOSTNAME");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getProxyHostName()", traceRet1);
        }
        return traceRet1;
    }

    public int getProxyPort() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getProxyPort()");
        }
        if (this instanceof MQQueueConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getProxyPort()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getProxyPort()", je);
            }
            throw je;
        }
        int traceRet1 = super.getIntProperty("XMSC_RTT_PROXY_PORT");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getProxyPort()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getPubAckInterval() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getPubAckInterval()");
        }
        if (this instanceof MQQueueConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getPubAckInterval()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getPubAckInterval()", je);
            }
            throw je;
        }
        int traceRet1 = super.getIntProperty("XMSC_WMQ_PUB_ACK_INTERVAL");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getPubAckInterval()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public String getQueueManager() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getQueueManager()");
        }
        try {
            String traceRet1 = super.getStringProperty("XMSC_WMQ_QUEUE_MANAGER");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getQueueManager()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getQueueManager()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getQueueManager()", null, 2);
            }
            return null;
        }
    }

    public String getReceiveExit() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getReceiveExit()");
        }
        try {
            String traceRet1 = super.getStringProperty("XMSC_WMQ_RECEIVE_EXIT");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getReceiveExit()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getReceiveExit()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getReceiveExit()", null, 2);
            }
            return null;
        }
    }

    public String getReceiveExitInit() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getReceiveExitInit()");
        }
        try {
            String traceRet1 = super.getStringProperty("XMSC_WMQ_RECEIVE_EXIT_INIT");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getReceiveExitInit()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getReceiveExitInit()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getReceiveExitInit()", null, 2);
            }
            return null;
        }
    }

    public int getReceiveIsolation() throws JMSException {
        int traceRet1 = super.getIntProperty("XMSC_WMQ_RECEIVE_ISOLATION");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "getReceiveIsolation()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public Reference getReference() throws NamingException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getReference()");
        }
        Reference ref = new Reference(this.getClass().getName(), MQConnectionFactoryFactory.class.getName(), null);
        this.populateReference(ref);
        Reference superClassReference = super.getReference();
        Enumeration<RefAddr> e = superClassReference.getAll();
        while (e.hasMoreElements()) {
            RefAddr currentRefAddr = e.nextElement();
            ref.add(currentRefAddr);
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getReference()", ref);
        }
        return ref;
    }

    public int getRescanInterval() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getRescanInterval()");
        }
        try {
            int traceRet1 = super.getIntProperty("XMSC_WMQ_RESCAN_INTERVAL");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getRescanInterval()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getRescanInterval()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getRescanInterval()", new Integer(0), 2);
            }
            return 0;
        }
    }

    public String getSecurityExit() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getSecurityExit()");
        }
        try {
            String traceRet1 = super.getStringProperty("XMSC_WMQ_SECURITY_EXIT");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSecurityExit()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getSecurityExit()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSecurityExit()", null, 2);
            }
            return null;
        }
    }

    public String getSecurityExitInit() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getSecurityExitInit()");
        }
        try {
            String traceRet1 = super.getStringProperty("XMSC_WMQ_SECURITY_EXIT_INIT");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSecurityExitInit()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getSecurityExitInit()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSecurityExitInit()", null, 2);
            }
            return null;
        }
    }

    public int getSendCheckCount() throws JMSException {
        int traceRet1 = super.getIntProperty("XMSC_WMQ_SEND_CHECK_COUNT");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "getSendCheckCount()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public String getSendExit() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getSendExit()");
        }
        try {
            String traceRet1 = super.getStringProperty("XMSC_WMQ_SEND_EXIT");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSendExit()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getSendExit()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSendExit()", null, 2);
            }
            return null;
        }
    }

    public String getSendExitInit() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getSendExitInit()");
        }
        try {
            String traceRet1 = super.getStringProperty("XMSC_WMQ_SEND_EXIT_INIT");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSendExitInit()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getSendExitInit()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSendExitInit()", null, 2);
            }
            return null;
        }
    }

    public int getShareConvAllowed() throws JMSException {
        int traceRet1 = super.getIntProperty("XMSC_WMQ_SHARE_CONV_ALLOWED");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "getShareConvAllowed()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public boolean getSparseSubscriptions() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getSparseSubscriptions()");
        }
        if (this instanceof MQQueueConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getSparseSubscriptions()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getSparseSubscriptions()", je);
            }
            throw je;
        }
        boolean traceRet1 = super.getBooleanProperty("XMSC_WMQ_SPARSE_SUBSCRIPTIONS");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getSparseSubscriptions()", traceRet1);
        }
        return traceRet1;
    }

    public Collection getSSLCertStores() throws JMSException {
        Object sslCertStores_coll;
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLCertStores()");
        }
        if ((sslCertStores_coll = super.getObjectProperty("XMSC_WMQ_SSL_CERT_STORES_COL")) != null) {
            Collection traceRet1 = (Collection)sslCertStores_coll;
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLCertStores()", traceRet1, 1);
            }
            return traceRet1;
        }
        if (super.getObjectProperty("XMSC_WMQ_SSL_CERT_STORES_STR") == null) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLCertStores()", null, 2);
            }
            return null;
        }
        String sslCertStores_string = super.getStringProperty("XMSC_WMQ_SSL_CERT_STORES_STR");
        if (sslCertStores_string != null && !sslCertStores_string.trim().equals("")) {
            try {
                sslCertStores_coll = JmqiUtils.getCertStoreCollectionFromSpaceSeperatedString((String)sslCertStores_string);
            }
            catch (Exception e) {
                if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                    com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLCertStores()", e);
                }
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("XMSC_INSERT_VALUE", sslCertStores_string);
                info.put("XMSC_INSERT_PROPERTY", "XMSC_WMQ_SSL_CERT_STORES_STR");
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1006", info));
                je.setLinkedException(e);
                if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                    com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLCertStores()", je);
                }
                throw je;
            }
        }
        Collection traceRet4 = (Collection)sslCertStores_coll;
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLCertStores()", traceRet4, 3);
        }
        return traceRet4;
    }

    public String getSSLCertStoresAsString() throws JMSException {
        String sslCertStores_string;
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLCertStoresAsString()");
        }
        if ((sslCertStores_string = super.getStringProperty("XMSC_WMQ_SSL_CERT_STORES_STR")) == null && super.getObjectProperty("XMSC_WMQ_SSL_CERT_STORES_COL") != null) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("XMSC_INSERT_NAME", "getSSLCertStoresAsString");
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ0000", info));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLCertStoresAsString()", je);
            }
            throw je;
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLCertStoresAsString()", sslCertStores_string);
        }
        return sslCertStores_string;
    }

    public String getSSLCipherSuite() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLCipherSuite()");
        }
        try {
            String traceRet1 = super.getStringProperty("XMSC_WMQ_SSL_CIPHER_SUITE");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLCipherSuite()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLCipherSuite()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLCipherSuite()", null, 2);
            }
            return null;
        }
    }

    public boolean getSSLFipsRequired() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLFipsRequired()");
        }
        try {
            boolean traceRet1 = super.getBooleanProperty("XMSC_WMQ_SSL_FIPS_REQUIRED");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLFipsRequired()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLFipsRequired()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLFipsRequired()", false, 2);
            }
            return false;
        }
    }

    public String getSSLPeerName() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLPeerName()");
        }
        try {
            String traceRet1 = super.getStringProperty("XMSC_WMQ_SSL_PEER_NAME");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLPeerName()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLPeerName()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLPeerName()", null, 2);
            }
            return null;
        }
    }

    public int getSSLResetCount() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLResetCount()");
        }
        try {
            int traceRet1 = super.getIntProperty("XMSC_WMQ_SSL_KEY_RESETCOUNT");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLResetCount()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLResetCount()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLResetCount()", new Integer(0), 2);
            }
            return 0;
        }
    }

    public Object getSSLSocketFactory() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLSocketFactory()");
        }
        try {
            Object traceRet1 = super.getObjectProperty("XMSC_WMQ_SSL_SOCKET_FACTORY");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLSocketFactory()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLSocketFactory()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSSLSocketFactory()", null, 2);
            }
            return null;
        }
    }

    public int getStatusRefreshInterval() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getStatusRefreshInterval()");
        }
        if (this instanceof MQQueueConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getStatusRefreshInterval()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getStatusRefreshInterval()", je);
            }
            throw je;
        }
        int traceRet1 = super.getIntProperty("XMSC_WMQ_STATUS_REFRESH_INTERVAL");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getStatusRefreshInterval()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getSubscriptionStore() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getSubscriptionStore()");
        }
        if (this instanceof MQQueueConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getSubscriptionStore()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getSubscriptionStore()", je);
            }
            throw je;
        }
        int traceRet1 = super.getIntProperty("XMSC_WMQ_SUBSCRIPTION_STORE");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getSubscriptionStore()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public boolean getSyncpointAllGets() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getSyncpointAllGets()");
        }
        try {
            boolean sag = super.getBooleanProperty("XMSC_WMQ_SYNCPOINT_ALL_GETS");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSyncpointAllGets()", sag, 1);
            }
            return sag;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getSyncpointAllGets()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getSyncpointAllGets()", false, 2);
            }
            return false;
        }
    }

    public boolean getTargetClientMatching() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getTargetClientMatching()");
        }
        try {
            boolean traceRet1 = super.getBooleanProperty("XMSC_WMQ_TARGET_CLIENT_MATCHING");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getTargetClientMatching()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getTargetClientMatching()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getTargetClientMatching()", false, 2);
            }
            return false;
        }
    }

    public String getTemporaryModel() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getTemporaryModel()");
        }
        if (this instanceof MQTopicConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getTemporaryModel()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getTemporaryModel()", je);
            }
            throw je;
        }
        String traceRet1 = super.getStringProperty("XMSC_WMQ_TEMPORARY_MODEL");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getTemporaryModel()", traceRet1);
        }
        return traceRet1;
    }

    public String getTempTopicPrefix() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getTempTopicPrefix()");
        }
        if (this instanceof MQQueueConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getTempTopicPrefix()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getTempTopicPrefix()", je);
            }
            throw je;
        }
        String traceRet1 = super.getStringProperty("XMSC_WMQ_TEMP_TOPIC_PREFIX");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getTempTopicPrefix()", traceRet1);
        }
        return traceRet1;
    }

    public String getTempQPrefix() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getTempQPrefix()");
        }
        if (this instanceof MQTopicConnectionFactory) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getTempQPrefix()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "getTempQPrefix()", je);
            }
            throw je;
        }
        String traceRet1 = super.getStringProperty("XMSC_WMQ_TEMP_Q_PREFIX");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "getTempQPrefix()", traceRet1);
        }
        return traceRet1;
    }

    public int getTransportType() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getTransportType()");
        }
        try {
            int traceRet1 = super.getIntProperty("XMSC_WMQ_CONNECTION_MODE");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getTransportType()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getTransportType()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getTransportType()", new Integer(0), 2);
            }
            return 0;
        }
    }

    public boolean getUseConnectionPooling() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getUseConnectionPooling()");
        }
        try {
            boolean traceRet1 = super.getBooleanProperty("XMSC_WMQ_USE_CONNECTION_POOLING");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getUseConnectionPooling()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getUseConnectionPooling()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getUseConnectionPooling()", false, 2);
            }
            return false;
        }
    }

    public int getVersion() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getVersion()");
        }
        try {
            int traceRet1 = super.getIntProperty("version");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getVersion()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getVersion()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getVersion()", new Integer(0), 2);
            }
            return 0;
        }
    }

    public int getWildcardFormat() throws JMSException {
        int traceRet1 = super.getIntProperty("wildcardFormat");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "getWildcardFormat()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getAsyncExceptions() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "getAsyncExceptions()");
        }
        try {
            int traceRet1 = super.getIntProperty("XMSC_ASYNC_EXCEPTIONS");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getAsyncExceptions()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "getAsyncExceptions()", je);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "getAsyncExceptions()", new Integer(0), 2);
            }
            return 0;
        }
    }

    protected void populateReference(Reference ref) throws OperationNotSupportedException {
        block18: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "populateReference(Reference)", new Object[]{ref});
            }
            String s = null;
            try {
                this.updateReference(ref);
                if (!(this instanceof MQTopicConnectionFactory)) {
                    s = this.getTemporaryModel();
                    if (s != null) {
                        ref.add(new StringRefAddr("TM", s));
                    }
                    if ((s = this.getTempQPrefix()) != null) {
                        ref.add(new StringRefAddr("TQPFX", s));
                    }
                    ref.add(new StringRefAddr("MRET", String.valueOf(this.getMessageRetention())));
                }
                if (!(this instanceof MQQueueConnectionFactory)) {
                    s = this.getBrokerControlQueue();
                    if (s != null) {
                        ref.add(new StringRefAddr("BCON", s));
                    }
                    if ((s = this.getBrokerPubQueue()) != null) {
                        ref.add(new StringRefAddr("BPUB", s));
                    }
                    if ((s = this.getBrokerSubQueue()) != null) {
                        ref.add(new StringRefAddr("BSUB", s));
                    }
                    if ((s = this.getBrokerCCSubQueue()) != null) {
                        ref.add(new StringRefAddr("CCSUB", s));
                    }
                    if ((s = this.getBrokerQueueManager()) != null) {
                        ref.add(new StringRefAddr("BQM", s));
                    }
                    if ((s = this.getProxyHostName()) != null) {
                        ref.add(new StringRefAddr("PHOST", s));
                    }
                    if ((s = this.getTempTopicPrefix()) != null) {
                        ref.add(new StringRefAddr("TTP", s));
                    }
                    ref.add(new StringRefAddr("MSEL", String.valueOf(this.getMessageSelection())));
                    ref.add(new StringRefAddr("PAI", String.valueOf(this.getPubAckInterval())));
                    ref.add(new StringRefAddr("SRI", String.valueOf(this.getStatusRefreshInterval())));
                    ref.add(new StringRefAddr("SUBST", String.valueOf(this.getSubscriptionStore())));
                    ref.add(new StringRefAddr("CL", String.valueOf(this.getCleanupLevel())));
                    ref.add(new StringRefAddr("CLINT", String.valueOf(this.getCleanupInterval())));
                    ref.add(new StringRefAddr("CLS", String.valueOf(this.getCloneSupport())));
                    ref.add(new StringRefAddr("SSUBS", String.valueOf(this.getSparseSubscriptions())));
                    ref.add(new StringRefAddr("MCAST", String.valueOf(this.getMulticast())));
                    ref.add(new StringRefAddr("PPORT", String.valueOf(this.getProxyPort())));
                    ref.add(new StringRefAddr("DAUTH", String.valueOf(this.getDirectAuth())));
                    ref.add(new StringRefAddr("MBSZ", String.valueOf(this.getMaxBufferSize())));
                    if (!(this instanceof XATopicConnectionFactory)) {
                        ref.add(new StringRefAddr("RCVISOL", String.valueOf(this.getReceiveIsolation())));
                        ref.add(new StringRefAddr("PROCDUR", String.valueOf(this.getProcessDuration())));
                        ref.add(new StringRefAddr("NOTIFY", String.valueOf(this.getOutcomeNotification())));
                    }
                    ref.add(new StringRefAddr("OPTPUB", String.valueOf(this.getOptimisticPublication())));
                    ref.add(new StringRefAddr("CCDTURL", String.valueOf(this.getCCDTURL())));
                    int brokerVersion = this.getBrokerVersion();
                    if (brokerVersion == -1) {
                        ref.add(new StringRefAddr("BVER", String.valueOf(0)));
                        ref.add(new StringRefAddr("BVERU", String.valueOf(true)));
                    } else {
                        ref.add(new StringRefAddr("BVER", String.valueOf(brokerVersion)));
                        ref.add(new StringRefAddr("BVERU", String.valueOf(false)));
                    }
                }
            }
            catch (JMSException e) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block18;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "populateReference(Reference)", e);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "populateReference(Reference)");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block87: {
            block86: {
                if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                    com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "readObject(java.io.ObjectInputStream)", new Object[]{in});
                }
                this.versionChangeAllowed = false;
                this.connectionType = "com.ibm.msg.client.wmq";
                this.setDefaultProperties();
                this.initialiseMQConnectionFactory();
                try {
                    if (this instanceof MQXAConnectionFactory || this instanceof MQXATopicConnectionFactory || this instanceof MQXAQueueConnectionFactory) {
                        this.setProviderFactory(true);
                    } else {
                        this.setProviderFactory(false);
                    }
                }
                catch (JMSException j) {
                    if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block86;
                    com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "readObject(java.io.ObjectInputStream)", j, 2);
                }
            }
            ObjectInputStream.GetField fields = in.readFields();
            try {
                int port;
                String host;
                if (!fields.defaulted("asyncExceptions")) {
                    this.setAsyncExceptions(fields.get("asyncExceptions", 0));
                }
                if (!fields.defaulted("bverSet")) {
                    this.bverSet = fields.get("bverSet", false);
                }
                if (!fields.defaulted("ccdtUrl")) {
                    this.setCCDTURL((URL)fields.get("ccdtUrl", null));
                }
                if (!fields.defaulted("CCSID")) {
                    this.setCCSID(fields.get("CCSID", 0));
                }
                if (!fields.defaulted("channel")) {
                    this.setChannel((String)fields.get("channel", null));
                }
                if (!fields.defaulted("clientId")) {
                    this.setClientID((String)fields.get("clientId", null));
                }
                if (!fields.defaulted("connectionNameList")) {
                    this.setConnectionNameListInternal((String)fields.get("connectionNameList", null));
                }
                if (!fields.defaulted("clientReconnectOptions")) {
                    this.setClientReconnectOptions(fields.get("clientReconnectOptions", 0));
                }
                if (!fields.defaulted("clientReconnectTimeout")) {
                    this.setClientReconnectTimeout(fields.get("clientReconnectTimeout", 0));
                }
                if (!fields.defaulted("connOptions")) {
                    this.setMQConnectionOptions(fields.get("connOptions", 0));
                }
                if (!fields.defaulted("connTag")) {
                    this.setConnTag((byte[])fields.get("connTag", null));
                }
                if (!fields.defaulted("description")) {
                    this.setDescription((String)fields.get("description", null));
                }
                if (!fields.defaulted("failIfQuiesce")) {
                    this.setFailIfQuiesce(fields.get("failIfQuiesce", 0));
                }
                if (!fields.defaulted("hdrCompList")) {
                    this.setHdrCompList((Collection)fields.get("hdrCompList", null));
                }
                boolean hostIsDefault = true;
                boolean portIsDefault = true;
                if (!fields.defaulted("hostName") && (host = (String)fields.get("hostName", null)) != null && !host.equalsIgnoreCase("localhost")) {
                    hostIsDefault = false;
                }
                if (!fields.defaulted("localAddress")) {
                    this.setLocalAddress((String)fields.get("localAddress", null));
                }
                if (!fields.defaulted("mapNameStyle")) {
                    this.setMapNameStyle(fields.get("mapNameStyle", false));
                }
                if (!fields.defaulted("msgBatchSize")) {
                    this.setMsgBatchSize(fields.get("msgBatchSize", 0));
                }
                if (!fields.defaulted("msgCompList")) {
                    this.setMsgCompList((Collection)fields.get("msgCompList", null));
                }
                if (!fields.defaulted("mselSet")) {
                    this.mselSet = fields.get("mselSet", false);
                }
                if (!fields.defaulted("optimisticPublication")) {
                    this.setOptimisticPublication(fields.get("optimisticPublication", false));
                }
                if (!fields.defaulted("outcomeNotification")) {
                    this.setOutcomeNotification(fields.get("outcomeNotification", false));
                }
                if (!fields.defaulted("pollingInterval")) {
                    this.setPollingInterval(fields.get("pollingInterval", 0));
                }
                if (!fields.defaulted("port") && (port = fields.get("port", 0)) != 1414 && port != 1506) {
                    portIsDefault = false;
                }
                if (!hostIsDefault || !portIsDefault) {
                    this.setHostName((String)fields.get("hostName", null));
                    this.setPort(fields.get("port", 0));
                }
                if (!fields.defaulted("portSet")) {
                    this.portSet = fields.get("portSet", false);
                }
                if (!fields.defaulted("processDuration")) {
                    this.setProcessDuration(fields.get("processDuration", 0));
                }
                if (!fields.defaulted("providerVersion")) {
                    this.setProviderVersion((String)fields.get("providerVersion", null));
                }
                if (!fields.defaulted("queueManager")) {
                    this.setQueueManager((String)fields.get("queueManager", null));
                }
                if (!fields.defaulted("receiveExit")) {
                    this.setReceiveExit((String)fields.get("receiveExit", null));
                }
                if (!fields.defaulted("receiveExitInit")) {
                    this.setReceiveExitInit((String)fields.get("receiveExitInit", null));
                }
                if (!fields.defaulted("receiveIsolation")) {
                    this.setReceiveIsolation(fields.get("receiveIsolation", 0));
                }
                if (!fields.defaulted("rescanInterval")) {
                    this.setRescanInterval(fields.get("rescanInterval", 0));
                }
                if (!fields.defaulted("securityExit")) {
                    this.setSecurityExit((String)fields.get("securityExit", null));
                }
                if (!fields.defaulted("securityExitInit")) {
                    this.setSecurityExitInit((String)fields.get("securityExitInit", null));
                }
                if (!fields.defaulted("sendExit")) {
                    this.setSendExit((String)fields.get("sendExit", null));
                }
                if (!fields.defaulted("sendExitInit")) {
                    this.setSendExitInit((String)fields.get("sendExitInit", null));
                }
                if (!fields.defaulted("sendCheckCount")) {
                    this.setSendCheckCount(fields.get("sendCheckCount", 0));
                }
                if (!fields.defaulted("shareConvAllowed")) {
                    this.setShareConvAllowed(fields.get("shareConvAllowed", 0));
                }
                if (!fields.defaulted("sslCertStores_coll")) {
                    this.setSSLCertStores((Collection)fields.get("sslCertStores_coll", null));
                }
                if (!fields.defaulted("sslCertStores_string")) {
                    this.setSSLCertStores((String)fields.get("sslCertStores_string", null));
                }
                if (!fields.defaulted("sslCipherSuite")) {
                    this.setSSLCipherSuite((String)fields.get("sslCipherSuite", null));
                }
                if (!fields.defaulted("sslFipsRequired")) {
                    this.setSSLFipsRequired(fields.get("sslFipsRequired", false));
                }
                if (!fields.defaulted("sslPeerName")) {
                    this.setSSLPeerName((String)fields.get("sslPeerName", null));
                }
                if (!fields.defaulted("sslResetCount")) {
                    this.setSSLResetCount(fields.get("sslResetCount", 0));
                }
                if (!fields.defaulted("sslSocketFactory")) {
                    this.setSSLSocketFactory(fields.get("sslSocketFactory", null));
                }
                if (!fields.defaulted("syncpointAllGets")) {
                    this.setSyncpointAllGets(fields.get("syncpointAllGets", false));
                }
                if (!fields.defaulted("targetClientMatching")) {
                    this.setTargetClientMatching(fields.get("targetClientMatching", false));
                }
                if (!fields.defaulted("transportType")) {
                    this.setTransportType(fields.get("transportType", 0));
                }
                if (!fields.defaulted("useConnectionPooling")) {
                    this.setUseConnectionPooling(fields.get("useConnectionPooling", false));
                }
                if (!fields.defaulted("version")) {
                    this.versionChangeAllowed = true;
                    this.setVersion(fields.get("version", 0));
                    this.versionChangeAllowed = false;
                }
                if (!fields.defaulted("wildcardFormat")) {
                    this.setWildcardFormat(fields.get("wildcardFormat", 0));
                }
                if (!(this instanceof MQTopicConnectionFactory)) {
                    if (!fields.defaulted("messageRetention")) {
                        this.setMessageRetention(fields.get("messageRetention", 0));
                    }
                    if (!fields.defaulted("temporaryModel")) {
                        this.setTemporaryModel((String)fields.get("temporaryModel", null));
                    }
                    if (!fields.defaulted("tempQPrefix")) {
                        this.setTempQPrefix((String)fields.get("tempQPrefix", null));
                    }
                }
                if (!(this instanceof MQQueueConnectionFactory)) {
                    boolean bverUnspecified;
                    if (!fields.defaulted("brokerCCSubQueue")) {
                        this.setBrokerCCSubQueue((String)fields.get("brokerCCSubQueue", null));
                    }
                    if (!fields.defaulted("brokerControlQueue")) {
                        this.setBrokerControlQueue((String)fields.get("brokerControlQueue", null));
                    }
                    if (!fields.defaulted("brokerPubQueue")) {
                        this.setBrokerPubQueue((String)fields.get("brokerPubQueue", null));
                    }
                    if (!fields.defaulted("brokerQueueManager")) {
                        this.setBrokerQueueManager((String)fields.get("brokerQueueManager", null));
                    }
                    if (!fields.defaulted("brokerSubQueue")) {
                        this.setBrokerSubQueue((String)fields.get("brokerSubQueue", null));
                    }
                    if (!fields.defaulted("brokerVersion")) {
                        this.setBrokerVersion(fields.get("brokerVersion", 0));
                    }
                    if (!fields.defaulted("brokerVersionUnspecified") && (bverUnspecified = fields.get("brokerVersionUnspecified", false))) {
                        this.setBrokerVersion(-1);
                    }
                    if (!fields.defaulted("cleanupInterval")) {
                        this.setCleanupInterval(fields.get("cleanupInterval", 0L));
                    }
                    if (!fields.defaulted("cleanupLevel")) {
                        this.setCleanupLevel(fields.get("cleanupLevel", 0));
                    }
                    if (!fields.defaulted("cloneSupport")) {
                        this.setCloneSupport(fields.get("cloneSupport", 0));
                    }
                    if (!fields.defaulted("directAuth")) {
                        this.setDirectAuth(fields.get("directAuth", 0));
                    }
                    if (!fields.defaulted("maxBufferSize")) {
                        this.setMaxBufferSize(fields.get("maxBufferSize", 0));
                    }
                    if (!fields.defaulted("messageSelection")) {
                        this.setMessageSelection(fields.get("messageSelection", 0));
                    }
                    if (!fields.defaulted("multicast")) {
                        this.setMulticast(fields.get("multicast", 0));
                    }
                    if (!fields.defaulted("proxyHostName")) {
                        this.setProxyHostName((String)fields.get("proxyHostName", null));
                    }
                    if (!fields.defaulted("proxyPort")) {
                        this.setProxyPort(fields.get("proxyPort", 0));
                    }
                    if (!fields.defaulted("pubAckInterval")) {
                        this.setPubAckInterval(fields.get("pubAckInterval", 0));
                    }
                    if (!fields.defaulted("sparseSubscriptions")) {
                        this.setSparseSubscriptions(fields.get("sparseSubscriptions", false));
                    }
                    if (!fields.defaulted("statusRefreshInterval")) {
                        this.setStatusRefreshInterval(fields.get("statusRefreshInterval", 0));
                    }
                    if (!fields.defaulted("subscriptionStore")) {
                        this.setSubscriptionStore(fields.get("subscriptionStore", 0));
                    }
                    if (!fields.defaulted("tempTopicPrefix")) {
                        this.setTempTopicPrefix((String)fields.get("tempTopicPrefix", null));
                    }
                }
            }
            catch (JMSException je) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block87;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "readObject(java.io.ObjectInputStream)", je, 1);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "readObject(java.io.ObjectInputStream)");
        }
    }

    protected void initialiseMQConnectionFactory() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "initialiseMQConnectionFactory()");
        }
        try {
            this.setStringProperty("XMSC_CONNECTION_TYPE_NAME", this.connectionType);
            this.setIntProperty("XMSC_CONNECTION_TYPE", 1);
        }
        catch (JMSException e) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "initialiseMQConnectionFactory()", e, 1);
            }
            com.ibm.msg.client.commonservices.trace.Trace.ffst(this, "readObject()", "XF001002", null, null);
        }
        try {
            JmsFactoryFactory.getInstance(this.connectionType);
            this.setShortProperty("XMSC_ADMIN_OBJECT_TYPE", (short)20);
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "initialiseMQConnectionFactory()", je, 2);
            }
            com.ibm.msg.client.commonservices.trace.Trace.ffst(this, "readObject()", "XF001003", null, null);
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "initialiseMQConnectionFactory()");
        }
    }

    public void setBrokerCCSubQueue(String queueName) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setBrokerCCSubQueue(String)", "setter", queueName);
        }
        super.setStringProperty("XMSC_WMQ_BROKER_CC_SUBQ", queueName);
    }

    public void setBrokerControlQueue(String queueName) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setBrokerControlQueue(String)", "setter", queueName);
        }
        super.setStringProperty("XMSC_WMQ_BROKER_CONTROLQ", queueName);
    }

    public void setBrokerPubQueue(String queueName) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setBrokerPubQueue(String)", "setter", queueName);
        }
        super.setStringProperty("XMSC_WMQ_BROKER_PUBQ", queueName);
    }

    public void setBrokerQueueManager(String queueManagerName) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setBrokerQueueManager(String)", "setter", queueManagerName);
        }
        super.setStringProperty("XMSC_WMQ_BROKER_QMGR", queueManagerName);
    }

    public void setBrokerSubQueue(String queueName) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setBrokerSubQueue(String)", "setter", queueName);
        }
        super.setStringProperty("XMSC_WMQ_BROKER_SUBQ", queueName);
    }

    public void setBrokerVersion(int version) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setBrokerVersion(int)", new Object[]{new Integer(version)});
        }
        super.setIntProperty("brokerVersion", version);
        if (!this.mselSet) {
            if (version == 0 || version == -1) {
                this.setMessageSelection(0);
            } else if (version == 1) {
                this.setMessageSelection(1);
            }
            this.mselSet = false;
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setBrokerVersion(int)");
        }
    }

    public void setCCDTURL(URL url) {
        block4: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setCCDTURL(URL)", new Object[]{url});
            }
            try {
                super.setStringProperty("XMSC_WMQ_CCDTURL", url == null ? null : url.toString());
            }
            catch (JMSException je) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block4;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setCCDTURL(URL)", je);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setCCDTURL(URL)");
        }
    }

    public void setCCSID(int ccsid) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setCCSID(int)", "setter", new Integer(ccsid));
        }
        super.setIntProperty("XMSC_WMQ_QMGR_CCSID", ccsid);
    }

    public void setChannel(String channelName) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setChannel(String)", "setter", channelName);
        }
        super.setStringProperty("XMSC_WMQ_CHANNEL", channelName);
    }

    public void setCleanupInterval(long interval) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setCleanupInterval(long)", "setter", new Long(interval));
        }
        super.setLongProperty("XMSC_WMQ_CLEANUP_INTERVAL", interval);
    }

    public void setCleanupLevel(int level) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setCleanupLevel(int)", "setter", new Integer(level));
        }
        super.setIntProperty("XMSC_WMQ_CLEANUP_LEVEL", level);
    }

    public void setClientID(String id) {
        block4: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setClientID(String)", new Object[]{id});
            }
            try {
                super.setStringProperty("XMSC_CLIENT_ID", id);
            }
            catch (JMSException je) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block4;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setClientID(String)", je);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setClientID(String)");
        }
    }

    public void setClientId(String id) {
        block4: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setClientId(String)", new Object[]{id});
            }
            try {
                super.setStringProperty("XMSC_CLIENT_ID", id);
            }
            catch (JMSException je) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block4;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setClientId(String)", je);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setClientId(String)");
        }
    }

    public void setCloneSupport(int type) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setCloneSupport(int)", "setter", new Integer(type));
        }
        super.setIntProperty("XMSC_WMQ_CLONE_SUPPORT", type);
    }

    void setCommonFromReference(Reference ref) throws JMSException {
        block61: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setCommonFromReference(Reference)", new Object[]{ref});
            }
            Object value = null;
            try {
                int i;
                RefAddr addr = ref.get("VER");
                if (addr != null && (value = addr.getContent()) != null) {
                    Integer.parseInt((String)value);
                }
                if ((addr = ref.get("DESC")) != null && (value = addr.getContent()) != null) {
                    this.setDescription((String)value);
                }
                if ((addr = ref.get("TRAN")) != null && (value = addr.getContent()) != null) {
                    this.setTransportType(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("CID")) != null && (value = addr.getContent()) != null) {
                    this.setClientId((String)value);
                }
                if ((addr = ref.get("QMGR")) != null) {
                    String qmgr = (String)addr.getContent();
                    if (qmgr == null) {
                        qmgr = "";
                    }
                    this.setQueueManager(qmgr);
                }
                if ((addr = ref.get("CRSHOSTS")) != null && (value = addr.getContent()) != null && !value.equals("")) {
                    this.setConnectionNameListInternal((String)value);
                }
                boolean hostIsDefault = true;
                boolean portIsDefault = true;
                addr = ref.get("HOST");
                if (addr != null && (value = addr.getContent()) != null && !((String)value).equalsIgnoreCase("localhost")) {
                    hostIsDefault = false;
                }
                addr = ref.get("PORT");
                String port = null;
                if (addr != null && (port = (String)addr.getContent()) != null && !port.equalsIgnoreCase("1414") && !port.equalsIgnoreCase("1506")) {
                    portIsDefault = false;
                }
                if (!hostIsDefault || !portIsDefault) {
                    this.setHostName((String)value);
                    if (port != null) {
                        this.setPort(Integer.parseInt(port));
                    }
                }
                if ((addr = ref.get("CHAN")) != null && (value = addr.getContent()) != null) {
                    this.setChannel((String)value);
                }
                if ((addr = ref.get("CCS")) != null && (value = addr.getContent()) != null) {
                    this.setCCSID(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("MNS")) != null && (value = addr.getContent()) != null) {
                    this.setMapNameStyle(Boolean.valueOf((String)value));
                }
                if ((addr = ref.get("PVER")) != null && (value = addr.getContent()) != null) {
                    this.setProviderVersion((String)value);
                }
                if ((addr = ref.get("RCX")) != null && (value = addr.getContent()) != null) {
                    this.setReceiveExit((String)value);
                }
                if ((addr = ref.get("RCXI")) != null && (value = addr.getContent()) != null) {
                    this.setReceiveExitInit((String)value);
                }
                if ((addr = ref.get("SCX")) != null && (value = addr.getContent()) != null) {
                    this.setSecurityExit((String)value);
                }
                if ((addr = ref.get("SCXI")) != null && (value = addr.getContent()) != null) {
                    this.setSecurityExitInit((String)value);
                }
                if ((addr = ref.get("SDX")) != null && (value = addr.getContent()) != null) {
                    this.setSendExit((String)value);
                }
                if ((addr = ref.get("SCC")) != null && (value = addr.getContent()) != null) {
                    this.setSendCheckCount(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("SDXI")) != null && (value = addr.getContent()) != null) {
                    this.setSendExitInit((String)value);
                }
                if ((addr = ref.get("SCALD")) != null && (value = addr.getContent()) != null) {
                    this.setShareConvAllowed(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("SCPHS")) != null && (value = addr.getContent()) != null) {
                    this.setSSLCipherSuite((String)value);
                }
                if ((addr = ref.get("SPEER")) != null && (value = addr.getContent()) != null) {
                    this.setSSLPeerName((String)value);
                }
                if ((addr = ref.get("SCRL")) != null && (value = addr.getContent()) != null) {
                    this.setSSLCertStores((String)value);
                }
                if ((addr = ref.get("SRC")) != null && (value = addr.getContent()) != null) {
                    this.setSSLResetCount(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("SFIPS")) != null && (value = addr.getContent()) != null) {
                    this.setSSLFipsRequired(Boolean.valueOf((String)value));
                }
                if ((addr = ref.get("HC")) != null && (value = addr.getContent()) != null) {
                    this.setHdrCompList((String)value);
                }
                if ((addr = ref.get("MC")) != null && (value = addr.getContent()) != null) {
                    this.setMsgCompList((String)value);
                }
                if ((addr = ref.get("WCFMT")) != null && (value = addr.getContent()) != null) {
                    this.setWildcardFormat(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("CT")) != null && (value = addr.getContent()) != null) {
                    this.setConnTag(((String)value).getBytes());
                }
                if ((addr = ref.get("CTO")) != null && (value = addr.getContent()) != null && (i = Integer.parseInt((String)value)) != 0) {
                    this.setMQConnectionOptions(i);
                }
                if ((addr = ref.get("TCM")) != null && (value = addr.getContent()) != null) {
                    this.setTargetClientMatching(Boolean.valueOf((String)value));
                }
                if ((addr = ref.get("SPAG")) != null && (value = addr.getContent()) != null) {
                    this.setSyncpointAllGets(Boolean.valueOf((String)value));
                }
                if ((addr = ref.get("UCP")) != null && (value = addr.getContent()) != null) {
                    this.setUseConnectionPooling(Boolean.valueOf((String)value));
                }
                if ((addr = ref.get("PINT")) != null && (value = addr.getContent()) != null) {
                    this.setPollingInterval(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("AEX")) != null && (value = addr.getContent()) != null) {
                    this.setAsyncExceptions(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("RINT")) != null && (value = addr.getContent()) != null) {
                    this.setRescanInterval(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("MBS")) != null && (value = addr.getContent()) != null) {
                    this.setMsgBatchSize(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("FIQ")) != null && (value = addr.getContent()) != null) {
                    this.setFailIfQuiesce(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("LA")) != null) {
                    String localadd = (String)addr.getContent();
                    if (localadd == null) {
                        localadd = "";
                    }
                    this.setLocalAddress(localadd);
                }
                if ((addr = ref.get("RCVISOL")) != null && (value = addr.getContent()) != null) {
                    this.setReceiveIsolation(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("NOTIFY")) != null && (value = addr.getContent()) != null) {
                    this.setOutcomeNotification(Boolean.valueOf((String)value));
                }
                if ((addr = ref.get("PROCDUR")) != null && (value = addr.getContent()) != null) {
                    this.setProcessDuration(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("OPTPUB")) != null && (value = addr.getContent()) != null) {
                    this.setOptimisticPublication(Boolean.valueOf((String)value));
                }
                if ((addr = ref.get("CROPT")) != null && (value = addr.getContent()) != null) {
                    this.setClientReconnectOptions(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("CRT")) != null && (value = addr.getContent()) != null) {
                    this.setClientReconnectTimeout(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("CCDTURL")) == null) break block61;
                try {
                    String content = addr.getContent().toString();
                    if (content == null || content.equals("null")) {
                        this.setCCDTURL(null);
                    } else {
                        this.setCCDTURL(new URL(content));
                    }
                }
                catch (MalformedURLException mue) {
                    if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                        com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setCommonFromReference(Reference)", mue, 1);
                    }
                    HashMap<String, Object> inserts = new HashMap<String, Object>();
                    inserts.put("XMSC_INSERT_PROPERTY", "XMSC_WMQ_CCDTURL");
                    inserts.put("XMSC_INSERT_VALUE", addr.getContent());
                    JMSException je = (JMSException)((Object)NLSServices.createException("MQJMS1006", inserts));
                    je.setLinkedException((Exception)mue);
                    if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                        com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "setCommonFromReference(Reference)", je, 1);
                    }
                    throw je;
                }
            }
            catch (JMSException e) {
                if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                    com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setCommonFromReference(Reference)", e, 2);
                }
                if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                    com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "setCommonFromReference(Reference)", e, 2);
                }
                throw e;
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setCommonFromReference(Reference)");
        }
    }

    public void setConnTag(byte[] cTag) {
        block4: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setConnTag(byte [ ])", new Object[]{cTag});
            }
            try {
                super.setBytesProperty("XMSC_WMQ_CONNECTION_TAG", cTag);
            }
            catch (JMSException je) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block4;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setConnTag(byte [ ])", je);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setConnTag(byte [ ])");
        }
    }

    public void setDescription(String desc) {
        block4: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setDescription(String)", new Object[]{desc});
            }
            try {
                super.setStringProperty("XMSC_WMQ_CF_DESCRIPTION", desc);
            }
            catch (JMSException je) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block4;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setDescription(String)", je);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setDescription(String)");
        }
    }

    public void setDirectAuth(int authority) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setDirectAuth(int)", "setter", new Integer(authority));
        }
        super.setIntProperty("XMSC_RTT_DIRECT_AUTH", authority);
    }

    public void setFailIfQuiesce(int fiq) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setFailIfQuiesce(int)", "setter", new Integer(fiq));
        }
        super.setIntProperty("failIfQuiesce", fiq);
    }

    void setFromReference(Reference ref) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setFromReference(Reference)", new Object[]{ref});
        }
        try {
            Object value;
            RefAddr addr;
            this.setCommonFromReference(ref);
            if (!(this instanceof MQTopicConnectionFactory)) {
                addr = ref.get("TM");
                if (addr != null && (value = addr.getContent()) != null) {
                    this.setTemporaryModel((String)value);
                }
                if ((addr = ref.get("TQPFX")) != null && (value = addr.getContent()) != null) {
                    this.setTempQPrefix((String)value);
                }
                if ((addr = ref.get("MRET")) != null && (value = addr.getContent()) != null) {
                    this.setMessageRetention(Integer.parseInt((String)value));
                }
            }
            if (!(this instanceof MQQueueConnectionFactory)) {
                addr = ref.get("BCON");
                if (addr != null && (value = addr.getContent()) != null) {
                    this.setBrokerControlQueue((String)value);
                }
                if ((addr = ref.get("BPUB")) != null && (value = addr.getContent()) != null) {
                    this.setBrokerPubQueue((String)value);
                }
                if ((addr = ref.get("BSUB")) != null && (value = addr.getContent()) != null) {
                    this.setBrokerSubQueue((String)value);
                }
                if ((addr = ref.get("CCSUB")) != null && (value = addr.getContent()) != null) {
                    this.setBrokerCCSubQueue((String)value);
                }
                if ((addr = ref.get("BQM")) != null) {
                    String bqmgr = (String)addr.getContent();
                    if (bqmgr == null) {
                        bqmgr = "";
                    }
                    this.setBrokerQueueManager(bqmgr);
                }
                if ((addr = ref.get("PHOST")) != null && (value = addr.getContent()) != null) {
                    this.setProxyHostName((String)value);
                }
                if ((addr = ref.get("MSEL")) != null && (value = addr.getContent()) != null) {
                    this.setMessageSelection(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("PAI")) != null && (value = addr.getContent()) != null) {
                    this.setPubAckInterval(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("SRI")) != null && (value = addr.getContent()) != null) {
                    this.setStatusRefreshInterval(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("SUBST")) != null && (value = addr.getContent()) != null) {
                    this.setSubscriptionStore(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("TTP")) != null && (value = addr.getContent()) != null) {
                    this.setTempTopicPrefix((String)value);
                }
                if ((addr = ref.get("CL")) != null && (value = addr.getContent()) != null) {
                    this.setCleanupLevel(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("CLINT")) != null && (value = addr.getContent()) != null) {
                    this.setCleanupInterval(Long.parseLong((String)value));
                }
                if ((addr = ref.get("CLS")) != null && (value = addr.getContent()) != null) {
                    this.setCloneSupport(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("SSUBS")) != null && (value = addr.getContent()) != null) {
                    this.setSparseSubscriptions(Boolean.valueOf((String)value));
                }
                if ((addr = ref.get("MCAST")) != null && (value = addr.getContent()) != null) {
                    this.setMulticast(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("PPORT")) != null && (value = addr.getContent()) != null) {
                    this.setProxyPort(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("DAUTH")) != null && (value = addr.getContent()) != null) {
                    this.setDirectAuth(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("MBSZ")) != null && (value = addr.getContent()) != null) {
                    this.setMaxBufferSize(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("RCVISOL")) != null && (value = addr.getContent()) != null) {
                    this.setReceiveIsolation(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("PROCDUR")) != null && (value = addr.getContent()) != null) {
                    this.setProcessDuration(Integer.parseInt((String)value));
                }
                if ((addr = ref.get("NOTIFY")) != null && (value = addr.getContent()) != null) {
                    this.setOutcomeNotification(Boolean.valueOf((String)value));
                }
                if ((addr = ref.get("OPTPUB")) != null && (value = addr.getContent()) != null) {
                    this.setOptimisticPublication(Boolean.valueOf((String)value));
                }
                Object brokerVersion = null;
                Object brokerVersionUnspecified = null;
                addr = ref.get("BVER");
                if (addr != null) {
                    brokerVersion = addr.getContent();
                }
                if ((addr = ref.get("BVERU")) != null) {
                    brokerVersionUnspecified = addr.getContent();
                }
                if (brokerVersion != null) {
                    int bVerInt = Integer.parseInt((String)brokerVersion);
                    if (brokerVersionUnspecified != null) {
                        boolean bVerUnsetBool = Boolean.valueOf((String)brokerVersionUnspecified);
                        if (bVerUnsetBool) {
                            this.setBrokerVersion(-1);
                        } else {
                            this.setBrokerVersion(bVerInt);
                        }
                    } else {
                        this.setBrokerVersion(bVerInt);
                    }
                }
            }
        }
        catch (JMSException e) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setFromReference(Reference)", e);
            }
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "setFromReference(Reference)", e);
            }
            throw e;
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setFromReference(Reference)");
        }
    }

    public void setHdrCompList(Collection compList) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setHdrCompList(Collection)", "setter", compList);
        }
        if (compList == null || compList.size() == 0) {
            Vector<Integer> defaultHdrCompList = new Vector<Integer>();
            defaultHdrCompList.add(new Integer(0));
            super.setObjectProperty("XMSC_WMQ_HEADER_COMP", defaultHdrCompList);
        } else {
            super.setObjectProperty("XMSC_WMQ_HEADER_COMP", compList);
        }
    }

    public void setHdrCompList(String compList) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setHdrCompList(String)", new Object[]{compList});
        }
        if (compList != null) {
            StringTokenizer st = new StringTokenizer(compList);
            Vector<Object> c = new Vector<Object>();
            while (st.hasMoreTokens()) {
                String tk = st.nextToken();
                if (tk.equals("NONE")) {
                    c.add(new Integer(0));
                    continue;
                }
                if (tk.equals("SYSTEM")) {
                    c.add(new Integer(8));
                    continue;
                }
                c.add(tk);
            }
            this.setHdrCompList(c);
        } else {
            this.setHdrCompList((Collection)null);
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setHdrCompList(String)");
        }
    }

    public void setHostName(String hostname) {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setHostName(String)", new Object[]{hostname});
        }
        try {
            super.setStringProperty("XMSC_WMQ_HOST_NAME", hostname != null ? hostname : nullString);
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setHostName(String)", je);
            }
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_PROPERTY", "hostname");
            inserts.put("XMSC_INSERT_VALUE", hostname);
            Log.log("MQConnectionFactory", "setHostName", "JMSMQ1006", inserts);
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setHostName(String)");
        }
    }

    public void setLocalAddress(String address) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setLocalAddress(String)", "setter", address);
        }
        super.setStringProperty("XMSC_WMQ_LOCAL_ADDRESS", address);
    }

    public void setMapNameStyle(boolean style) {
        block4: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setMapNameStyle(boolean)", new Object[]{style});
            }
            try {
                super.setBooleanProperty("XMSC_WMQ_MAP_NAME_STYLE", style);
            }
            catch (JMSException je) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block4;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setMapNameStyle(boolean)", je);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setMapNameStyle(boolean)");
        }
    }

    public void setMaxBufferSize(int size) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setMaxBufferSize(int)", "setter", new Integer(size));
        }
        super.setIntProperty("XMSC_WMQ_MAX_BUFFER_SIZE", size);
    }

    public void setMessageRetention(int mRet) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setMessageRetention(int)", "setter", new Integer(mRet));
        }
        super.setIntProperty("XMSC_WMQ_MESSAGE_RETENTION", mRet);
    }

    public void setMessageSelection(int selection) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setMessageSelection(int)", "setter", new Integer(selection));
        }
        super.setIntProperty("XMSC_WMQ_MESSAGE_SELECTION", selection);
    }

    public void setMQConnectionOptions(int cTagOpt) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setMQConnectionOptions(int)", "setter", new Integer(cTagOpt));
        }
        super.setIntProperty("XMSC_WMQ_CONNECT_OPTIONS", cTagOpt);
    }

    public void setMsgBatchSize(int size) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setMsgBatchSize(int)", "setter", new Integer(size));
        }
        super.setIntProperty("XMSC_WMQ_MSG_BATCH_SIZE", size);
    }

    public void setMsgCompList(Collection compList) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setMsgCompList(Collection)", "setter", compList);
        }
        if (compList == null || compList.size() == 0) {
            Vector<Integer> defaultMsgCompList = new Vector<Integer>();
            defaultMsgCompList.add(new Integer(0));
            super.setObjectProperty("XMSC_WMQ_MSG_COMP", defaultMsgCompList);
        } else {
            super.setObjectProperty("XMSC_WMQ_MSG_COMP", compList);
        }
    }

    public void setMsgCompList(String compList) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setMsgCompList(String)", new Object[]{compList});
        }
        if (compList != null) {
            StringTokenizer st = new StringTokenizer(compList);
            Vector<Integer> c = new Vector<Integer>();
            while (st.hasMoreTokens()) {
                String tk = st.nextToken();
                if (tk.equals("NONE")) {
                    c.add(new Integer(0));
                    continue;
                }
                if (tk.equals("RLE")) {
                    c.add(new Integer(1));
                    continue;
                }
                if (tk.equals("ZLIBFAST")) {
                    c.add(new Integer(2));
                    continue;
                }
                if (tk.equals("ZLIBHIGH")) {
                    c.add(new Integer(4));
                    continue;
                }
                if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                    com.ibm.msg.client.commonservices.trace.Trace.traceData(this, "Compressor value is not supported", null);
                }
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("XMSC_INSERT_VALUE", tk);
                info.put("XMSC_INSERT_NAME", "Compressor value");
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1006", info));
                if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                    com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "setMsgCompList(String)", je);
                }
                throw je;
            }
            super.setObjectProperty("XMSC_WMQ_MSG_COMP", c);
        } else {
            super.setObjectProperty("XMSC_WMQ_MSG_COMP", null);
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setMsgCompList(String)");
        }
    }

    public void setMulticast(int multicast) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setMulticast(int)", "setter", new Integer(multicast));
        }
        super.setIntProperty("multicast", multicast);
    }

    public void setOptimisticPublication(boolean newVal) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setOptimisticPublication(boolean)", "setter", newVal);
        }
        super.setBooleanProperty("XMSC_WMQ_OPT_PUB", newVal);
    }

    public void setOutcomeNotification(boolean newVal) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setOutcomeNotification(boolean)", "setter", newVal);
        }
        super.setBooleanProperty("XMSC_WMQ_OUTCOME_NOTIFICATION", newVal);
    }

    public void setPollingInterval(int interval) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setPollingInterval(int)", "setter", new Integer(interval));
        }
        super.setIntProperty("XMSC_WMQ_POLLING_INTERVAL", interval);
    }

    public void setPort(int port) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setPort(int)", new Object[]{new Integer(port)});
        }
        super.setIntProperty("XMSC_WMQ_PORT", port);
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setPort(int)");
        }
    }

    public void setProcessDuration(int newVal) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setProcessDuration(int)", "setter", new Integer(newVal));
        }
        super.setIntProperty("XMSC_WMQ_PROCESS_DURATION", newVal);
    }

    public void setProviderVersion(String version) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setProviderVersion(String)", "setter", version);
        }
        super.setStringProperty("XMSC_WMQ_PROVIDER_VERSION", version);
    }

    public void setProxyHostName(String hostName) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setProxyHostName(String)", "setter", hostName);
        }
        super.setStringProperty("XMSC_RTT_PROXY_HOSTNAME", hostName);
    }

    public void setProxyPort(int proxyPort) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setProxyPort(int)", "setter", new Integer(proxyPort));
        }
        super.setIntProperty("XMSC_RTT_PROXY_PORT", proxyPort);
    }

    public void setPubAckInterval(int interval) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setPubAckInterval(int)", "setter", new Integer(interval));
        }
        super.setIntProperty("XMSC_WMQ_PUB_ACK_INTERVAL", interval);
    }

    public void setQueueManager(String queueManagerName) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setQueueManager(String)", "setter", queueManagerName);
        }
        super.setStringProperty("XMSC_WMQ_QUEUE_MANAGER", queueManagerName);
    }

    public void setReceiveExit(String receiveExit) {
        block4: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setReceiveExit(String)", new Object[]{receiveExit});
            }
            try {
                super.setStringProperty("XMSC_WMQ_RECEIVE_EXIT", receiveExit);
            }
            catch (JMSException je) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block4;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setReceiveExit(String)", je);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setReceiveExit(String)");
        }
    }

    public void setReceiveExitInit(String data) {
        block4: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setReceiveExitInit(String)", new Object[]{data});
            }
            try {
                super.setStringProperty("XMSC_WMQ_RECEIVE_EXIT_INIT", data);
            }
            catch (JMSException e) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block4;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setReceiveExitInit(String)", e);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setReceiveExitInit(String)");
        }
    }

    public void setReceiveIsolation(int newVal) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setReceiveIsolation(int)", "setter", new Integer(newVal));
        }
        super.setIntProperty("XMSC_WMQ_RECEIVE_ISOLATION", newVal);
    }

    public void setRescanInterval(int interval) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setRescanInterval(int)", "setter", new Integer(interval));
        }
        super.setIntProperty("XMSC_WMQ_RESCAN_INTERVAL", interval);
    }

    public void setSecurityExit(String securityExit) {
        block4: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setSecurityExit(String)", new Object[]{securityExit});
            }
            try {
                super.setStringProperty("XMSC_WMQ_SECURITY_EXIT", securityExit);
            }
            catch (JMSException je) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block4;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setSecurityExit(String)", je);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setSecurityExit(String)");
        }
    }

    public void setSecurityExitInit(String data) {
        block4: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setSecurityExitInit(String)", new Object[]{data});
            }
            try {
                super.setStringProperty("XMSC_WMQ_SECURITY_EXIT_INIT", data);
            }
            catch (JMSException je) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block4;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setSecurityExitInit(String)", je);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setSecurityExitInit(String)");
        }
    }

    public void setSendCheckCount(int interval) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setSendCheckCount(int)", "setter", new Integer(interval));
        }
        super.setIntProperty("XMSC_WMQ_SEND_CHECK_COUNT", interval);
    }

    public void setSendExit(String sendExit) {
        block4: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setSendExit(String)", new Object[]{sendExit});
            }
            try {
                super.setStringProperty("XMSC_WMQ_SEND_EXIT", sendExit);
            }
            catch (JMSException je) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block4;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setSendExit(String)", je);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setSendExit(String)");
        }
    }

    public void setSendExitInit(String data) {
        block4: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setSendExitInit(String)", new Object[]{data});
            }
            try {
                super.setStringProperty("XMSC_WMQ_SEND_EXIT_INIT", data);
            }
            catch (JMSException je) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block4;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setSendExitInit(String)", je);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setSendExitInit(String)");
        }
    }

    public void setShareConvAllowed(int shared) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setShareConvAllowed(int)", "setter", new Integer(shared));
        }
        super.setIntProperty("XMSC_WMQ_SHARE_CONV_ALLOWED", shared);
    }

    public void setSparseSubscriptions(boolean sparse) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setSparseSubscriptions(boolean)", "setter", sparse);
        }
        super.setBooleanProperty("XMSC_WMQ_SPARSE_SUBSCRIPTIONS", sparse);
    }

    public void setSSLCertStores(Collection stores) {
        block4: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setSSLCertStores(java.util.Collection)", new Object[]{stores});
            }
            try {
                super.setObjectProperty("XMSC_WMQ_SSL_CERT_STORES_COL", stores);
                super.setStringProperty("XMSC_WMQ_SSL_CERT_STORES_STR", null);
            }
            catch (JMSException je) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block4;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setSSLCertStores(java.util.Collection)", je);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setSSLCertStores(java.util.Collection)");
        }
    }

    public void setSSLCertStores(String stores) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setSSLCertStores(String)", "setter", stores);
        }
        super.setStringProperty("XMSC_WMQ_SSL_CERT_STORES_STR", stores);
        super.setObjectProperty("XMSC_WMQ_SSL_CERT_STORES_COL", null);
    }

    public void setSSLCipherSuite(String cipherSuite) {
        block4: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setSSLCipherSuite(String)", new Object[]{cipherSuite});
            }
            try {
                super.setStringProperty("XMSC_WMQ_SSL_CIPHER_SUITE", cipherSuite);
            }
            catch (JMSException je) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block4;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setSSLCipherSuite(String)", je);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setSSLCipherSuite(String)");
        }
    }

    public void setSSLFipsRequired(boolean required) {
        block4: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setSSLFipsRequired(boolean)", new Object[]{required});
            }
            try {
                super.setBooleanProperty("XMSC_WMQ_SSL_FIPS_REQUIRED", required);
            }
            catch (JMSException je) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block4;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setSSLFipsRequired(boolean)", je);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setSSLFipsRequired(boolean)");
        }
    }

    public void setSSLPeerName(String peerName) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setSSLPeerName(String)", "setter", peerName);
        }
        super.setObjectProperty("XMSC_WMQ_SSL_PEER_NAME", peerName);
    }

    public void setSSLResetCount(int bytes) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setSSLResetCount(int)", "setter", new Integer(bytes));
        }
        super.setIntProperty("XMSC_WMQ_SSL_KEY_RESETCOUNT", bytes);
    }

    public void setSSLSocketFactory(Object sf) {
        block4: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setSSLSocketFactory(Object)", new Object[]{sf});
            }
            try {
                super.setObjectProperty("XMSC_WMQ_SSL_SOCKET_FACTORY", sf);
            }
            catch (JMSException je) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block4;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setSSLSocketFactory(Object)", je);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setSSLSocketFactory(Object)");
        }
    }

    public void setStatusRefreshInterval(int interval) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setStatusRefreshInterval(int)", "setter", new Integer(interval));
        }
        super.setIntProperty("XMSC_WMQ_STATUS_REFRESH_INTERVAL", interval);
    }

    public void setSubscriptionStore(int flag) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setSubscriptionStore(int)", "setter", new Integer(flag));
        }
        super.setIntProperty("XMSC_WMQ_SUBSCRIPTION_STORE", flag);
    }

    public void setSyncpointAllGets(boolean flag) {
        block8: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setSyncpointAllGets(boolean)", new Object[]{flag});
            }
            if (flag) {
                try {
                    super.setBooleanProperty("XMSC_WMQ_SYNCPOINT_ALL_GETS", true);
                }
                catch (JMSException je) {
                    if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                        com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setSyncpointAllGets(boolean)", je, 1);
                    }
                    break block8;
                }
            }
            try {
                super.setBooleanProperty("XMSC_WMQ_SYNCPOINT_ALL_GETS", false);
            }
            catch (JMSException je) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block8;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setSyncpointAllGets(boolean)", je, 2);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setSyncpointAllGets(boolean)");
        }
    }

    public void setTargetClientMatching(boolean matchClient) {
        block4: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setTargetClientMatching(boolean)", new Object[]{matchClient});
            }
            try {
                super.setBooleanProperty("XMSC_WMQ_TARGET_CLIENT_MATCHING", matchClient);
            }
            catch (JMSException je) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block4;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setTargetClientMatching(boolean)", je);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setTargetClientMatching(boolean)");
        }
    }

    public void setTemporaryModel(String queueName) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setTemporaryModel(String)", "setter", queueName);
        }
        super.setStringProperty("XMSC_WMQ_TEMPORARY_MODEL", queueName);
    }

    public void setTempTopicPrefix(String prefix) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setTempTopicPrefix(String)", "setter", prefix);
        }
        super.setStringProperty("XMSC_WMQ_TEMP_TOPIC_PREFIX", prefix);
    }

    public void setTempQPrefix(String newTempQPrefix) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setTempQPrefix(java.lang.String)", "setter", newTempQPrefix);
        }
        super.setStringProperty("XMSC_WMQ_TEMP_Q_PREFIX", newTempQPrefix);
    }

    public void setTransportType(int type) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setTransportType(int)", new Object[]{new Integer(type)});
        }
        this.setIntProperty("XMSC_WMQ_CONNECTION_MODE", type);
        switch (type) {
            case 0: 
            case 1: {
                if (!this.portSet) {
                    this.setPort(1414);
                    this.portSet = false;
                }
                if (this instanceof MQQueueConnectionFactory || this.bverSet) break;
                this.setBrokerVersion(-1);
                this.bverSet = false;
                break;
            }
            case 2: 
            case 4: {
                if (!this.portSet) {
                    this.setPort(1506);
                    this.portSet = false;
                }
                if (this instanceof MQQueueConnectionFactory || this.bverSet) break;
                this.setBrokerVersion(1);
                this.bverSet = false;
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setTransportType(int)");
        }
    }

    public void setUseConnectionPooling(boolean usePooling) {
        block4: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setUseConnectionPooling(boolean)", new Object[]{usePooling});
            }
            try {
                super.setBooleanProperty("XMSC_WMQ_USE_CONNECTION_POOLING", usePooling);
            }
            catch (JMSException je) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block4;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "setUseConnectionPooling(boolean)", je);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setUseConnectionPooling(boolean)");
        }
    }

    public void setVersion(int version) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setVersion(int)", new Object[]{new Integer(version)});
        }
        if (!this.versionChangeAllowed) {
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ0012", null));
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "setVersion(int)", je);
            }
            throw je;
        }
        super.setIntProperty("version", version);
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setVersion(int)");
        }
    }

    public void setWildcardFormat(int format) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "setWildcardFormat(int)", new Object[]{new Integer(format)});
        }
        super.setIntProperty("wildcardFormat", format);
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "setWildcardFormat(int)");
        }
    }

    public void setAsyncExceptions(int flags) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setAsyncExceptions(int)", "setter", new Integer(flags));
        }
        super.setIntProperty("XMSC_ASYNC_EXCEPTIONS", flags);
    }

    void updateReference(Reference ref) throws OperationNotSupportedException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "updateReference(Reference)", new Object[]{ref});
        }
        try {
            String s = null;
            ref.add(new StringRefAddr("VER", String.valueOf(this.getVersion())));
            s = this.getDescription();
            if (s != null) {
                ref.add(new StringRefAddr("DESC", s));
            }
            ref.add(new StringRefAddr("TRAN", String.valueOf(this.getTransportType())));
            s = this.getClientID();
            if (s != null) {
                ref.add(new StringRefAddr("CID", s));
            }
            if ((s = this.getQueueManager()) != null) {
                ref.add(new StringRefAddr("QMGR", s));
            }
            if ((s = this.getHostName()) != null) {
                ref.add(new StringRefAddr("HOST", s));
            }
            ref.add(new StringRefAddr("PORT", String.valueOf(this.getPort())));
            s = this.getChannel();
            if (s != null) {
                ref.add(new StringRefAddr("CHAN", s));
            }
            ref.add(new StringRefAddr("CCS", String.valueOf(this.getCCSID())));
            ref.add(new StringRefAddr("MNS", String.valueOf(this.getMapNameStyle())));
            s = this.getReceiveExit();
            if (s != null) {
                ref.add(new StringRefAddr("RCX", s));
            }
            if ((s = this.getReceiveExitInit()) != null) {
                ref.add(new StringRefAddr("RCXI", s));
            }
            if ((s = this.getSecurityExit()) != null) {
                ref.add(new StringRefAddr("SCX", s));
            }
            if ((s = this.getSecurityExitInit()) != null) {
                ref.add(new StringRefAddr("SCXI", s));
            }
            if ((s = this.getSendExit()) != null) {
                ref.add(new StringRefAddr("SDX", s));
            }
            if ((s = this.getSendExitInit()) != null) {
                ref.add(new StringRefAddr("SDXI", s));
            }
            if ((s = this.getSSLCipherSuite()) != null) {
                ref.add(new StringRefAddr("SCPHS", s));
            }
            if ((s = this.getSSLPeerName()) != null) {
                ref.add(new StringRefAddr("SPEER", s));
            }
            if ((s = this.getSSLCertStoresAsString()) != null) {
                ref.add(new StringRefAddr("SCRL", s));
            }
            if ((s = this.getHdrCompListAsString()) != null) {
                ref.add(new StringRefAddr("HC", s));
            }
            if ((s = this.getMsgCompListAsString()) != null) {
                ref.add(new StringRefAddr("MC", s));
            }
            if ((s = new String(this.getConnTag())) != null) {
                ref.add(new StringRefAddr("CT", s));
            }
            ref.add(new StringRefAddr("CTO", String.valueOf(this.getMQConnectionOptions())));
            if (this.getSSLSocketFactory() != null) {
                OperationNotSupportedException traceRet2 = new OperationNotSupportedException("MQJMS_Messages.MQJMS_E_MQCF_NOT_SERIALIZABLE, SSLSocketFactory");
                if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                    com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "updateReference(Reference)", traceRet2, 1);
                }
                throw traceRet2;
            }
            ref.add(new StringRefAddr("SCC", String.valueOf(this.getSendCheckCount())));
            ref.add(new StringRefAddr("SCALD", String.valueOf(this.getShareConvAllowed())));
            ref.add(new StringRefAddr("SRC", String.valueOf(this.getSSLResetCount())));
            ref.add(new StringRefAddr("SFIPS", String.valueOf(this.getSSLFipsRequired())));
            ref.add(new StringRefAddr("SPAG", String.valueOf(this.getSyncpointAllGets())));
            ref.add(new StringRefAddr("UCP", String.valueOf(this.getUseConnectionPooling())));
            ref.add(new StringRefAddr("PINT", String.valueOf(this.getPollingInterval())));
            ref.add(new StringRefAddr("PVER", this.getProviderVersion()));
            ref.add(new StringRefAddr("WCFMT", String.valueOf(this.getWildcardFormat())));
            ref.add(new StringRefAddr("MBS", String.valueOf(this.getMsgBatchSize())));
            ref.add(new StringRefAddr("FIQ", String.valueOf(this.getFailIfQuiesce())));
            ref.add(new StringRefAddr("LA", this.getLocalAddress()));
            ref.add(new StringRefAddr("RINT", String.valueOf(this.getRescanInterval())));
            ref.add(new StringRefAddr("TCM", String.valueOf(this.getTargetClientMatching())));
            ref.add(new StringRefAddr("AEX", String.valueOf(this.getAsyncExceptions())));
            if (this.getCCDTURL() != null) {
                ref.add(new StringRefAddr("CCDTURL", String.valueOf(this.getCCDTURL())));
            }
            ref.add(new StringRefAddr("CROPT", String.valueOf(this.getClientReconnectOptions())));
            ref.add(new StringRefAddr("CRT", String.valueOf(this.getClientReconnectTimeout())));
            ref.add(new StringRefAddr("CRSHOSTS", this.getConnectionNameList()));
        }
        catch (JMSException je) {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "updateReference(Reference)", je);
            }
            OperationNotSupportedException traceRet1 = new OperationNotSupportedException("MQJMS_E_MQCF_NOT_SERIALIZABLE, SSLCertStores");
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.throwing(this, "com.ibm.mq.jms.MQConnectionFactory", "updateReference(Reference)", traceRet1, 2);
            }
            throw traceRet1;
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "updateReference(Reference)");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        block8: {
            if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
                com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "writeObject(java.io.ObjectOutputStream)", new Object[]{out});
            }
            ObjectOutputStream.PutField fields = out.putFields();
            try {
                fields.put("asyncExceptions", this.getAsyncExceptions());
                fields.put("bverSet", this.bverSet);
                fields.put("ccdtUrl", this.getCCDTURL());
                fields.put("CCSID", this.getCCSID());
                fields.put("channel", this.getChannel());
                fields.put("clientId", this.getClientID());
                fields.put("clientReconnectOptions", this.getClientReconnectOptions());
                fields.put("connectionNameList", this.getConnectionNameList());
                fields.put("clientReconnectTimeout", this.getClientReconnectTimeout());
                fields.put("connOptions", this.getMQConnectionOptions());
                fields.put("connTag", this.getConnTag());
                fields.put("description", this.getDescription());
                fields.put("failIfQuiesce", this.getFailIfQuiesce());
                fields.put("hdrCompList", this.getHdrCompList());
                fields.put("hostName", this.getHostName());
                fields.put("localAddress", this.getLocalAddress());
                fields.put("mapNameStyle", this.getMapNameStyle());
                fields.put("msgBatchSize", this.getMsgBatchSize());
                fields.put("msgCompList", this.getMsgCompList());
                fields.put("mselSet", this.mselSet);
                fields.put("optimisticPublication", this.getOptimisticPublication());
                fields.put("outcomeNotification", this.getOutcomeNotification());
                fields.put("pollingInterval", this.getPollingInterval());
                fields.put("port", this.getPort());
                fields.put("portSet", this.portSet);
                fields.put("processDuration", this.getProcessDuration());
                fields.put("providerVersion", this.getProviderVersion());
                fields.put("queueManager", this.getQueueManager());
                fields.put("receiveExit", this.getReceiveExit());
                fields.put("receiveExitInit", this.getReceiveExitInit());
                fields.put("receiveIsolation", this.getReceiveIsolation());
                fields.put("rescanInterval", this.getRescanInterval());
                fields.put("securityExit", this.getSecurityExit());
                fields.put("securityExitInit", this.getSecurityExitInit());
                fields.put("sendExit", this.getSendExit());
                fields.put("sendExitInit", this.getSendExitInit());
                fields.put("sendCheckCount", this.getSendCheckCount());
                fields.put("shareConvAllowed", this.getShareConvAllowed());
                fields.put("sslCertStores_coll", this.getSSLCertStores());
                fields.put("sslCertStores_string", this.getSSLCertStoresAsString());
                fields.put("sslCipherSuite", this.getSSLCipherSuite());
                fields.put("sslFipsRequired", this.getSSLFipsRequired());
                fields.put("sslPeerName", this.getSSLPeerName());
                fields.put("sslResetCount", this.getSSLResetCount());
                fields.put("sslSocketFactory", this.getSSLSocketFactory());
                fields.put("syncpointAllGets", this.getSyncpointAllGets());
                fields.put("targetClientMatching", this.getTargetClientMatching());
                fields.put("transportType", this.getTransportType());
                fields.put("useConnectionPooling", this.getUseConnectionPooling());
                fields.put("version", this.getVersion());
                fields.put("wildcardFormat", this.getWildcardFormat());
                if (!(this instanceof MQTopicConnectionFactory)) {
                    fields.put("messageRetention", this.getMessageRetention());
                    fields.put("temporaryModel", this.getTemporaryModel());
                    fields.put("tempQPrefix", this.getTempQPrefix());
                }
                if (!(this instanceof MQQueueConnectionFactory)) {
                    fields.put("brokerCCSubQueue", this.getBrokerCCSubQueue());
                    fields.put("brokerControlQueue", this.getBrokerControlQueue());
                    fields.put("brokerPubQueue", this.getBrokerPubQueue());
                    fields.put("brokerQueueManager", this.getBrokerQueueManager());
                    fields.put("brokerSubQueue", this.getBrokerSubQueue());
                    fields.put("cleanupInterval", this.getCleanupInterval());
                    fields.put("cleanupLevel", this.getCleanupLevel());
                    fields.put("cloneSupport", this.getCloneSupport());
                    fields.put("directAuth", this.getDirectAuth());
                    fields.put("maxBufferSize", this.getMaxBufferSize());
                    fields.put("messageSelection", this.getMessageSelection());
                    fields.put("multicast", this.getMulticast());
                    fields.put("proxyHostName", this.getProxyHostName());
                    fields.put("proxyPort", this.getProxyPort());
                    fields.put("pubAckInterval", this.getPubAckInterval());
                    fields.put("sparseSubscriptions", this.getSparseSubscriptions());
                    fields.put("statusRefreshInterval", this.getStatusRefreshInterval());
                    fields.put("subscriptionStore", this.getSubscriptionStore());
                    fields.put("tempTopicPrefix", this.getTempTopicPrefix());
                    int brokerVersion = this.getBrokerVersion();
                    if (brokerVersion == -1) {
                        fields.put("brokerVersion", 0);
                        fields.put("brokerVersionUnspecified", true);
                    } else {
                        fields.put("brokerVersion", brokerVersion);
                        fields.put("brokerVersionUnspecified", false);
                    }
                }
            }
            catch (JMSException je) {
                if (!com.ibm.msg.client.commonservices.trace.Trace.isOn) break block8;
                com.ibm.msg.client.commonservices.trace.Trace.catchBlock(this, "com.ibm.mq.jms.MQConnectionFactory", "writeObject(java.io.ObjectOutputStream)", je);
            }
        }
        out.writeFields();
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit(this, "com.ibm.mq.jms.MQConnectionFactory", "writeObject(java.io.ObjectOutputStream)");
        }
    }

    protected JmsConnection createCommonConnection(String userID, String password) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "createCommonConnection(String,String)", new Object[]{userID, password == null ? password : "********"});
        }
        JmsConnection traceRet1 = (JmsConnection)super.createConnection(userID, password);
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "createCommonConnection(String,String)", traceRet1);
        }
        return traceRet1;
    }

    public Connection createConnection() throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "createConnection()");
        }
        MQConnection wrapper = new MQConnection();
        wrapper.setDelegate(this.createCommonConnection(null, null));
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "createConnection()", wrapper);
        }
        return wrapper;
    }

    public Connection createConnection(String userID, String password) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry(this, "com.ibm.mq.jms.MQConnectionFactory", "createConnection(String,String)", new Object[]{userID, password == null ? password : "********"});
        }
        MQConnection wrapper = new MQConnection();
        wrapper.setDelegate(this.createCommonConnection(userID, password));
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit((Object)this, "com.ibm.mq.jms.MQConnectionFactory", "createConnection(String,String)", wrapper);
        }
        return wrapper;
    }

    static void checkTracing() {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry("com.ibm.mq.jms.MQConnectionFactory", "checkTracing()");
        }
        String traceLevelProperty = "MQJMS_TRACE_LEVEL";
        PropertyStore.register(traceLevelProperty, "");
        String traceLevel = PropertyStore.getStringProperty(traceLevelProperty);
        String traceDirProperty = "MQJMS_TRACE_DIR";
        PropertyStore.register(traceDirProperty, "");
        String traceDir = PropertyStore.getStringProperty(traceDirProperty);
        if (traceDir != "") {
            if (!traceDir.endsWith("/") && !traceDir.endsWith("\\")) {
                traceDir = traceDir + "/";
            }
            String fqFilename = traceDir + "mqjms_%PID%.trc";
            PropertyStore.set("com.ibm.msg.client.commonservices.trace.outputName", fqFilename);
        }
        if (traceLevel != null) {
            if ((traceLevel = traceLevel.toLowerCase()).equals("on") || traceLevel.equals("base")) {
                Trace.setStatus(true);
            } else if (traceLevel.equals("off")) {
                Trace.setStatus(false);
            }
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit("com.ibm.mq.jms.MQConnectionFactory", "checkTracing()");
        }
    }

    public int getClientReconnectOptions() throws JMSException {
        int traceRet1 = super.getIntProperty("XMSC_WMQ_CLIENT_RECONNECT_OPTIONS");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "getClientReconnectOptions()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setClientReconnectOptions(int options) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setClientReconnectOptions(int)", "setter", new Integer(options));
        }
        super.setIntProperty("XMSC_WMQ_CLIENT_RECONNECT_OPTIONS", options);
    }

    public String getConnectionNameList() throws JMSException {
        String traceRet1 = super.getStringProperty("XMSC_WMQ_CONNECTION_NAME_LIST");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "getConnectionNameList()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public void setConnectionNameList(String hosts) throws JMSException {
        this.setConnectionNameListInternal(hosts);
        this.portSet = true;
    }

    private void setConnectionNameListInternal(String hosts) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setConnectionNameList(String)", "setter", hosts);
        }
        super.setStringProperty("XMSC_WMQ_CONNECTION_NAME_LIST", hosts);
    }

    public int getClientReconnectTimeout() throws JMSException {
        int traceRet1 = super.getIntProperty("XMSC_WMQ_CLIENT_RECONNECT_TIMEOUT");
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "getClientReconnectTimeout()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setClientReconnectTimeout(int timeout) throws JMSException {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data(this, "com.ibm.mq.jms.MQConnectionFactory", "setClientReconnectTimeout(int)", "setter", new Integer(timeout));
        }
        super.setIntProperty("XMSC_WMQ_CLIENT_RECONNECT_TIMEOUT", timeout);
    }

    static {
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.data("com.ibm.mq.jms.MQConnectionFactory", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQConnectionFactory.java, jmscc.migration.wmq, k701, k701-112-140304  1.176.1.12 10/07/23 11:08:52");
        }
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.entry("com.ibm.mq.jms.MQConnectionFactory", "static()");
        }
        MQConnectionFactory.checkTracing();
        NLSServices.addCatalogue("com.ibm.mq.jms.resources.JMSMQ_MessageResourceBundle", "JMSMQ", MQConnectionFactory.class);
        if (com.ibm.msg.client.commonservices.trace.Trace.isOn) {
            com.ibm.msg.client.commonservices.trace.Trace.exit("com.ibm.mq.jms.MQConnectionFactory", "static()");
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("asyncExceptions", Integer.TYPE), new ObjectStreamField("brokerCCSubQueue", String.class), new ObjectStreamField("brokerControlQueue", String.class), new ObjectStreamField("brokerPubQueue", String.class), new ObjectStreamField("brokerQueueManager", String.class), new ObjectStreamField("brokerSubQueue", String.class), new ObjectStreamField("brokerVersion", Integer.TYPE), new ObjectStreamField("brokerVersionUnspecified", Boolean.TYPE), new ObjectStreamField("bverSet", Boolean.TYPE), new ObjectStreamField("ccdtUrl", URL.class), new ObjectStreamField("CCSID", Integer.TYPE), new ObjectStreamField("channel", String.class), new ObjectStreamField("cleanupInterval", Long.TYPE), new ObjectStreamField("cleanupLevel", Integer.TYPE), new ObjectStreamField("clientId", String.class), new ObjectStreamField("clientReconnectOptions", Integer.TYPE), new ObjectStreamField("clientReconnectTimeout", Integer.TYPE), new ObjectStreamField("cloneSupport", Integer.TYPE), new ObjectStreamField("connectionNameList", String.class), new ObjectStreamField("connOptions", Integer.TYPE), new ObjectStreamField("connTag", [B.class), new ObjectStreamField("description", String.class), new ObjectStreamField("directAuth", Integer.TYPE), new ObjectStreamField("failIfQuiesce", Integer.TYPE), new ObjectStreamField("hdrCompList", Collection.class), new ObjectStreamField("hostName", String.class), new ObjectStreamField("localAddress", String.class), new ObjectStreamField("mapNameStyle", Boolean.TYPE), new ObjectStreamField("maxBufferSize", Integer.TYPE), new ObjectStreamField("msgBatchSize", Integer.TYPE), new ObjectStreamField("msgCompList", Collection.class), new ObjectStreamField("messageRetention", Integer.TYPE), new ObjectStreamField("messageSelection", Integer.TYPE), new ObjectStreamField("mselSet", Boolean.TYPE), new ObjectStreamField("multicast", Integer.TYPE), new ObjectStreamField("optimisticPublication", Boolean.TYPE), new ObjectStreamField("outcomeNotification", Boolean.TYPE), new ObjectStreamField("pollingInterval", Integer.TYPE), new ObjectStreamField("port", Integer.TYPE), new ObjectStreamField("portSet", Boolean.TYPE), new ObjectStreamField("processDuration", Integer.TYPE), new ObjectStreamField("providerVersion", String.class), new ObjectStreamField("proxyHostName", String.class), new ObjectStreamField("proxyPort", Integer.TYPE), new ObjectStreamField("pubAckInterval", Integer.TYPE), new ObjectStreamField("queueManager", String.class), new ObjectStreamField("receiveExit", String.class), new ObjectStreamField("receiveExitInit", String.class), new ObjectStreamField("receiveIsolation", Integer.TYPE), new ObjectStreamField("rescanInterval", Integer.TYPE), new ObjectStreamField("securityExit", String.class), new ObjectStreamField("securityExitInit", String.class), new ObjectStreamField("sendExit", String.class), new ObjectStreamField("sendExitInit", String.class), new ObjectStreamField("sendCheckCount", Integer.TYPE), new ObjectStreamField("shareConvAllowed", Integer.TYPE), new ObjectStreamField("sparseSubscriptions", Boolean.TYPE), new ObjectStreamField("sslCertStores_coll", Collection.class), new ObjectStreamField("sslCertStores_string", String.class), new ObjectStreamField("sslCipherSuite", String.class), new ObjectStreamField("sslFipsRequired", Boolean.TYPE), new ObjectStreamField("sslPeerName", String.class), new ObjectStreamField("sslResetCount", Integer.TYPE), new ObjectStreamField("sslSocketFactory", Object.class), new ObjectStreamField("statusRefreshInterval", Integer.TYPE), new ObjectStreamField("subscriptionStore", Integer.TYPE), new ObjectStreamField("syncpointAllGets", Boolean.TYPE), new ObjectStreamField("targetClientMatching", Boolean.TYPE), new ObjectStreamField("temporaryModel", String.class), new ObjectStreamField("tempQPrefix", String.class), new ObjectStreamField("tempTopicPrefix", String.class), new ObjectStreamField("transportType", Integer.TYPE), new ObjectStreamField("useConnectionPooling", Boolean.TYPE), new ObjectStreamField("version", Integer.TYPE), new ObjectStreamField("wildcardFormat", Integer.TYPE)};
    }
}

