/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.ConnectionBrowser;
import com.ibm.mq.jms.MQConnectionBrowser;
import com.ibm.mq.jms.MQConnectionConsumer;
import com.ibm.mq.jms.MQConnectionMetaData;
import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.MQMessageReferenceHandler;
import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQRoot;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MessageReferenceHandler;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsConnection;
import com.ibm.msg.client.jms.JmsConnectionBrowser;
import com.ibm.msg.client.jms.JmsConnectionConsumer;
import com.ibm.msg.client.jms.JmsConnectionMetaData;
import com.ibm.msg.client.jms.JmsDestination;
import com.ibm.msg.client.jms.JmsMessageReferenceHandler;
import com.ibm.msg.client.jms.JmsQueue;
import com.ibm.msg.client.jms.JmsSession;
import com.ibm.msg.client.jms.JmsTopic;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;

public class MQConnection
extends MQRoot
implements Connection,
JmsConnection {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final long serialVersionUID = 1357803352856448348L;
    protected JmsConnection commonConn;

    MQConnection() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnection", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQConnection", "<init>()");
        }
    }

    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnection", "close()");
        }
        this.commonConn.close();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQConnection", "close()");
        }
    }

    public ConnectionBrowser createConnectionBrowser(Queue queue, String selector, MessageReferenceHandler mrh, int quantityHint) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnection", "createConnectionBrowser(Queue,String,MessageReferenceHandler,int)", new Object[]{queue, selector, mrh, new Integer(quantityHint)});
        }
        JmsQueue dest = queue == null ? null : (JmsQueue)((MQQueue)queue).validateDestination();
        MQMessageReferenceHandler mqMessageReferenceHandler = null;
        if (mrh != null) {
            mqMessageReferenceHandler = new MQMessageReferenceHandler(mrh);
        }
        JmsConnectionBrowser jmsConnectionBrowser = this.commonConn.createConnectionBrowser(dest, selector, mqMessageReferenceHandler, quantityHint);
        MQConnectionBrowser wrapper = new MQConnectionBrowser();
        wrapper.setDelegate(jmsConnectionBrowser);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQConnection", "createConnectionBrowser(Queue,String,MessageReferenceHandler,int)", wrapper);
        }
        return wrapper;
    }

    public ConnectionBrowser createConnectionBrowser(Topic topic, String selector, MessageReferenceHandler mrh, int quantityHint) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnection", "createConnectionBrowser(Topic,String,MessageReferenceHandler,int)", new Object[]{topic, selector, mrh, new Integer(quantityHint)});
        }
        JmsTopic dest = topic == null ? null : (JmsTopic)((MQTopic)topic).validateDestination();
        MQMessageReferenceHandler mqMessageReferenceHandler = null;
        if (mrh != null) {
            mqMessageReferenceHandler = new MQMessageReferenceHandler(mrh);
        }
        JmsConnectionBrowser jmsConnectionBrowser = this.commonConn.createConnectionBrowser(dest, selector, mqMessageReferenceHandler, quantityHint);
        MQConnectionBrowser wrapper = new MQConnectionBrowser();
        wrapper.setDelegate(jmsConnectionBrowser);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQConnection", "createConnectionBrowser(Topic,String,MessageReferenceHandler,int)", wrapper);
        }
        return wrapper;
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String selector, ServerSessionPool ssp, int maxMessages) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnection", "createConnectionConsumer(Destination,String,ServerSessionPool,int)", new Object[]{destination, selector, ssp, new Integer(maxMessages)});
        }
        JmsDestination dest = destination == null ? null : (JmsDestination)((MQDestination)destination).validateDestination();
        MQConnectionConsumer wrapper = new MQConnectionConsumer();
        ConnectionConsumer cc = this.commonConn.createConnectionConsumer(dest, selector, ssp, maxMessages);
        wrapper.setDelegate((JmsConnectionConsumer)cc);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQConnection", "createConnectionConsumer(Destination,String,ServerSessionPool,int)", wrapper);
        }
        return wrapper;
    }

    public ConnectionBrowser createDurableConnectionBrowser(Topic topic, String subName, String selector, MessageReferenceHandler mrh, int quantityHint, boolean noLocal) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnection", "createDurableConnectionBrowser(Topic,String,String,MessageReferenceHandler,int,boolean)", new Object[]{topic, subName, selector, mrh, new Integer(quantityHint), noLocal});
        }
        JmsTopic jmsTopic = topic == null ? null : (JmsTopic)((MQTopic)topic).validateDestination();
        MQMessageReferenceHandler mqMessageReferenceHandler = null;
        if (mrh != null) {
            mqMessageReferenceHandler = new MQMessageReferenceHandler(mrh);
        }
        JmsConnectionBrowser jmsConnectionBrowser = this.commonConn.createDurableConnectionBrowser(jmsTopic, subName, selector, mqMessageReferenceHandler, quantityHint, noLocal);
        MQConnectionBrowser wrapper = new MQConnectionBrowser();
        wrapper.setDelegate(jmsConnectionBrowser);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQConnection", "createDurableConnectionBrowser(Topic,String,String,MessageReferenceHandler,int,boolean)", wrapper);
        }
        return wrapper;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subName, String selector, ServerSessionPool ssp, int maxMessageCount) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnection", "createDurableConnectionConsumer(Topic,String,String,ServerSessionPool,int)", new Object[]{topic, subName, selector, ssp, new Integer(maxMessageCount)});
        }
        JmsTopic jmsTopic = topic == null ? null : (JmsTopic)((MQTopic)topic).validateDestination();
        MQConnectionConsumer wrapper = new MQConnectionConsumer();
        ConnectionConsumer cc = this.commonConn.createDurableConnectionConsumer(jmsTopic, subName, selector, ssp, maxMessageCount);
        wrapper.setDelegate((JmsConnectionConsumer)cc);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQConnection", "createDurableConnectionConsumer(Topic,String,String,ServerSessionPool,int)", wrapper);
        }
        return wrapper;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnection", "createSession(boolean,int)", new Object[]{transacted, new Integer(acknowledgeMode)});
        }
        MQSession wrapper = new MQSession();
        wrapper.setDelegate((JmsSession)this.commonConn.createSession(transacted, acknowledgeMode));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQConnection", "createSession(boolean,int)", wrapper);
        }
        return wrapper;
    }

    public String getClientID() throws JMSException {
        String traceRet1 = this.commonConn.getClientID();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQConnection", "getClientID()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        ExceptionListener traceRet1 = this.commonConn.getExceptionListener();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQConnection", "getExceptionListener()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        MQConnectionMetaData metaData = new MQConnectionMetaData((JmsConnectionMetaData)this.commonConn.getMetaData());
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQConnection", "getMetaData()", "getter", metaData);
        }
        return metaData;
    }

    public void setClientID(String clientID) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQConnection", "setClientID(String)", "setter", clientID);
        }
        this.commonConn.setClientID(clientID);
    }

    void setDelegate(JmsConnection commonConn) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQConnection", "setDelegate(JmsConnection)", "setter", commonConn);
        }
        this.commonConn = commonConn;
        this.delegate = commonConn;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQConnection", "setExceptionListener(ExceptionListener)", "setter", listener);
        }
        this.commonConn.setExceptionListener(listener);
    }

    public void start() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnection", "start()");
        }
        this.commonConn.start();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQConnection", "start()");
        }
    }

    public void stop() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnection", "stop()");
        }
        this.commonConn.stop();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.MQConnection", "stop()");
        }
    }

    public JmsConnectionBrowser createConnectionBrowser(JmsDestination destination, String selector, JmsMessageReferenceHandler messageRefHandler, int quantityHint) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnection", "createConnectionBrowser(JmsDestination,String,JmsMessageReferenceHandler,int)", new Object[]{destination, selector, messageRefHandler, new Integer(quantityHint)});
        }
        JmsConnectionBrowser jmsConnectionBrowser = this.commonConn.createConnectionBrowser(destination, selector, messageRefHandler, quantityHint);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQConnection", "createConnectionBrowser(JmsDestination,String,JmsMessageReferenceHandler,int)", jmsConnectionBrowser);
        }
        return jmsConnectionBrowser;
    }

    public JmsConnectionBrowser createDurableConnectionBrowser(JmsTopic topic, String subName, String selector, JmsMessageReferenceHandler messageRefHandler, int quantityHint, boolean noLocal) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.MQConnection", "createDurableConnectionBrowser(JmsTopic,String,String,JmsMessageReferenceHandler,int,boolean)", new Object[]{topic, subName, selector, messageRefHandler, new Integer(quantityHint), noLocal});
        }
        JmsConnectionBrowser jmsConnectionBrowser = this.commonConn.createDurableConnectionBrowser(topic, subName, selector, messageRefHandler, quantityHint, noLocal);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.MQConnection", "createDurableConnectionBrowser(JmsTopic,String,String,JmsMessageReferenceHandler,int,boolean)", jmsConnectionBrowser);
        }
        return jmsConnectionBrowser;
    }

    public int getReceiveIsolation() throws JMSException {
        int traceRet1 = this.getIntProperty("XMSC_WMQ_RECEIVE_ISOLATION");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQConnection", "getReceiveIsolation()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public boolean getOutcomeNotification() throws JMSException {
        boolean traceRet1 = this.getBooleanProperty("XMSC_WMQ_OUTCOME_NOTIFICATION");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQConnection", "getOutcomeNotification()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public int getProcessDuration() throws JMSException {
        int traceRet1 = this.getIntProperty("XMSC_WMQ_PROCESS_DURATION");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQConnection", "getProcessDuration()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public boolean getOptimisticPublication() throws JMSException {
        boolean traceRet1 = this.getBooleanProperty("XMSC_WMQ_OPT_PUB");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.MQConnection", "getOptimisticPublication()", "getter", traceRet1);
        }
        return traceRet1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.MQConnection", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/MQConnection.java, jmscc.migration.wmq, k701, k701-112-140304  1.44.1.3 10/10/29 14:16:52");
        }
    }
}

