/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQConnectionMetaData;
import com.ibm.msg.client.commonservices.cssystem.CSSystem;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.internal.JmsConnectionImpl;
import com.ibm.msg.client.provider.ProviderConnection;
import com.ibm.msg.client.provider.ProviderExceptionListener;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;

public class Cleanup
extends MQConnectionFactory
implements Runnable {
    private static final long serialVersionUID = -3271226297625651418L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Object cleanup;
    private ExceptionListener exceptionListener;
    private PrintWriter printWriter;
    private static Method cleanupInternalMethod;
    private static Method cleanupLevelMethod;
    private static Method isRunningMethod;
    private static Method setExceptionListenerMethod;
    private static Method stopMethod;
    private static Class cleanupClass;
    private static Method cleanupMethod;
    private static Method runMethod;
    private static Method setPrintWriterMethod;

    public Cleanup() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.Cleanup", "<init>()");
        }
        this.exceptionListener = null;
        try {
            this.cleanup = cleanupClass.newInstance();
            long cleanupInternal = this.getCleanupInterval();
            cleanupInternalMethod.invoke(this.cleanup, new Long(cleanupInternal));
            int cleanupLevel = this.getCleanupLevel();
            cleanupLevelMethod.invoke(this.cleanup, new Integer(cleanupLevel));
        }
        catch (Exception je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.Cleanup", "<init>()", je);
            }
            HashMap<String, Exception> data = new HashMap<String, Exception>();
            data.put("exception", je);
            Trace.ffst("com.ibm.mq.jms.Cleanup", "<linit>", "XF009002", data, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.Cleanup", "<init>()");
        }
    }

    public Cleanup(MQConnectionFactory mqcf) throws JMSException {
        this();
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.Cleanup", "<init>(MQConnectionFactory)", new Object[]{mqcf});
        }
        if (mqcf == null) {
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.mq.jms.Cleanup", "<init>(MQConnectionFactory)", 1);
            }
            return;
        }
        Enumeration props = mqcf.getPropertyNames();
        while (props.hasMoreElements()) {
            String name = (String)props.nextElement();
            this.setObjectProperty(name, mqcf.getObjectProperty(name));
        }
        if (this.getQueueManager() == null || this.getQueueManager().trim().equals("")) {
            String resolvedQMName;
            block16: {
                MQConnection mqc;
                block15: {
                    resolvedQMName = null;
                    mqc = null;
                    try {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Cleanup - QueueManager has null or empty name. Need to resolve it", null);
                        }
                        mqc = (MQConnection)this.createConnection();
                        resolvedQMName = mqc.getStringProperty("XMSC_WMQ_RESOLVED_QUEUE_MANAGER");
                    }
                    catch (JMSException je) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.mq.jms.Cleanup", "<init>(MQConnectionFactory)", je, 1);
                        }
                        if (!Trace.isOn) break block15;
                        Trace.traceData(this, "Cleanup - Error creating queue manager", null);
                    }
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Cleanup - Got resolved QueueManager name = '" + resolvedQMName + "'", null);
                }
                resolvedQMName = resolvedQMName == null ? "" : resolvedQMName.trim();
                if (Trace.isOn) {
                    Trace.traceData(this, "Cleanup - Close the queue manager and connection", null);
                }
                try {
                    mqc.close();
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.mq.jms.Cleanup", "<init>(MQConnectionFactory)", je, 2);
                    }
                    if (!Trace.isOn) break block16;
                    Trace.traceData(this, "Cleanup - Error closing queue manager", null);
                }
            }
            this.setQueueManager(resolvedQMName);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.Cleanup", "<init>(MQConnectionFactory)", 2);
        }
    }

    public void setCleanupInterval(long interval) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.Cleanup", "setCleanupInterval(long)", new Object[]{new Long(interval)});
        }
        super.setCleanupInterval(interval);
        if (this.cleanup != null) {
            try {
                cleanupInternalMethod.invoke(this.cleanup, new Long(interval));
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.mq.jms.Cleanup", "setCleanupInterval(long)", e);
                }
                HashMap<String, Exception> data = new HashMap<String, Exception>();
                data.put("exception", e);
                Trace.ffst("com.ibm.mq.jms.Cleanup", "setCleanupInternal()", "XF009003", data, null);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.Cleanup", "setCleanupInterval(long)");
        }
    }

    public long getCleanupInterval() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.Cleanup", "getCleanupInterval()");
        }
        long traceRet1 = 0L;
        try {
            traceRet1 = super.getCleanupInterval();
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.Cleanup", "getCleanupInterval()", je);
            }
            HashMap<String, JMSException> data = new HashMap<String, JMSException>();
            data.put("exception", je);
            Trace.ffst("com.ibm.mq.jms.Cleanup", "getCleanupInterval()", "XF009004", data, null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.Cleanup", "getCleanupInterval()", new Long(traceRet1));
        }
        return traceRet1;
    }

    public void setCleanupLevel(int level) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.Cleanup", "setCleanupLevel(int)", new Object[]{new Integer(level)});
        }
        if (level == -1) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_PROPERTY", "cleanupLevel");
            inserts.put("XMSC_INSERT_VALUE", String.valueOf(level));
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1006", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.mq.jms.Cleanup", "setCleanupLevel(int)", je);
            }
            throw je;
        }
        super.setCleanupLevel(level);
        if (this.cleanup != null) {
            try {
                cleanupLevelMethod.invoke(this.cleanup, new Integer(level));
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.mq.jms.Cleanup", "setCleanupLevel(int)", e);
                }
                HashMap<String, Exception> data = new HashMap<String, Exception>();
                data.put("exception", e);
                Trace.ffst("com.ibm.mq.jms.Cleanup", "setCleanupLevel(int level)", "XF009005", data, null);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.Cleanup", "setCleanupLevel(int)");
        }
    }

    public int getCleanupLevel() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.Cleanup", "getCleanupLevel()");
        }
        int traceRet1 = 0;
        try {
            traceRet1 = super.getCleanupLevel();
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.Cleanup", "getCleanupLevel()", je);
            }
            HashMap<String, JMSException> data = new HashMap<String, JMSException>();
            data.put("exception", je);
            Trace.ffst("com.ibm.mq.jms.Cleanup", "getCleanupLevel()", "XF009006", data, null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.Cleanup", "getCleanupLevel()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String msg;
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.Cleanup", "main(String [ ])", new Object[]{args});
        }
        boolean client = false;
        String qmgrName = "";
        int r = 0;
        int level = 0;
        boolean trace = false;
        String host = null;
        int port = 0;
        String channel = null;
        String errparam = null;
        String encProp = "console.encoding";
        PropertyStore.register(encProp, "");
        String encoding = PropertyStore.getStringProperty(encProp);
        PrintWriter pw1 = NLSServices.isWindowsLatinCodepage() && encoding != "" && encoding != null ? new PrintWriter(new OutputStreamWriter((OutputStream)System.out, encoding)) : new PrintWriter(new OutputStreamWriter(System.out));
        final PrintWriter pw = pw1;
        MQConnectionMetaData CMD = new MQConnectionMetaData();
        String pv = CMD.getProviderVersion();
        pw.println();
        pw.println(NLSServices.getMessage("JMSMQ1003"));
        pw.println(NLSServices.getMessage("JMSMQ1002", pv));
        pw.println(NLSServices.getMessage("JMSMQ5079"));
        pw.println();
        pw.flush();
        try {
            for (int i = 0; i < args.length; ++i) {
                String a = args[i].toLowerCase();
                errparam = args[i];
                if (a.equals("-client")) {
                    client = true;
                    continue;
                }
                if (a.equals("safe")) {
                    level = 1;
                    continue;
                }
                if (a.equals("strong")) {
                    level = 2;
                    continue;
                }
                if (a.equals("force")) {
                    level = 3;
                    continue;
                }
                if (a.equals("nondur")) {
                    level = 4;
                    continue;
                }
                if (a.equals("-m")) {
                    qmgrName = args[++i];
                    continue;
                }
                if (a.equals("-r")) {
                    r = Integer.parseInt(args[++i]);
                    continue;
                }
                if (a.equals("-host")) {
                    host = args[++i];
                    continue;
                }
                if (a.equals("-port")) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if (a.equals("-channel")) {
                    channel = args[++i];
                    continue;
                }
                if (a.equals("-t")) {
                    trace = true;
                    continue;
                }
                IllegalArgumentException traceRet2 = new IllegalArgumentException();
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.mq.jms.Cleanup", "main(String [ ])", traceRet2);
                }
                throw traceRet2;
            }
        }
        catch (NumberFormatException nfe) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.mq.jms.Cleanup", "main(String [ ])", nfe, 1);
            }
            String msg2 = NLSServices.getMessage("JMSMQ5092", errparam);
            pw.println(msg2);
            Cleanup.displayUsage(pw);
            pw.flush();
            if (Trace.isOn) {
                Trace.exit("com.ibm.mq.jms.Cleanup", "main(String [ ])", 1);
            }
            return;
        }
        catch (IllegalArgumentException iae) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.mq.jms.Cleanup", "main(String [ ])", iae, 2);
            }
            String msg3 = NLSServices.getMessage("JMSMQ5093", errparam);
            pw.println(msg3);
            Cleanup.displayUsage(pw);
            pw.flush();
            if (Trace.isOn) {
                Trace.exit("com.ibm.mq.jms.Cleanup", "main(String [ ])", 2);
            }
            return;
        }
        catch (IndexOutOfBoundsException ioobe) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.mq.jms.Cleanup", "main(String [ ])", ioobe, 3);
            }
            String msg4 = NLSServices.getMessage("JMSMQ5094", errparam);
            pw.println(msg4);
            Cleanup.displayUsage(pw);
            pw.flush();
            if (Trace.isOn) {
                Trace.exit("com.ibm.mq.jms.Cleanup", "main(String [ ])", 3);
            }
            return;
        }
        if (level == 0) {
            msg = NLSServices.getMessage("JMSMQ5090");
            pw.println(msg);
            Cleanup.displayUsage(pw);
            pw.flush();
            if (Trace.isOn) {
                Trace.exit("com.ibm.mq.jms.Cleanup", "main(String [ ])", 4);
            }
            return;
        }
        if (client && host == null) {
            msg = NLSServices.getMessage("JMSMQ5091");
            pw.println(msg);
            Cleanup.displayUsage(pw);
            pw.flush();
            if (Trace.isOn) {
                Trace.exit("com.ibm.mq.jms.Cleanup", "main(String [ ])", 5);
            }
            return;
        }
        if (!(client || host == null && port == 0 && channel == null)) {
            msg = NLSServices.getMessage("JMSMQ5078");
            pw.println(msg);
            Cleanup.displayUsage(pw);
            pw.flush();
            if (Trace.isOn) {
                Trace.exit("com.ibm.mq.jms.Cleanup", "main(String [ ])", 6);
            }
            return;
        }
        if (port < 0) {
            msg = NLSServices.getMessage("JMSMQ1006", "-port", String.valueOf(port));
            pw.println(msg);
            pw.println();
            pw.flush();
            if (Trace.isOn) {
                Trace.exit("com.ibm.mq.jms.Cleanup", "main(String [ ])", 7);
            }
            return;
        }
        if (r < 0) {
            msg = NLSServices.getMessage("JMSMQ1006", "-r", String.valueOf(r));
            pw.println(msg);
            pw.println();
            pw.flush();
            if (Trace.isOn) {
                Trace.exit("com.ibm.mq.jms.Cleanup", "main(String [ ])", 8);
            }
            return;
        }
        if ((level == 3 || level == 4) && r > 0) {
            msg = NLSServices.getMessage("JMSMQ3043");
            pw.println(msg);
            pw.println();
            pw.flush();
            if (Trace.isOn) {
                Trace.exit("com.ibm.mq.jms.Cleanup", "main(String [ ])", 9);
            }
            return;
        }
        if (client) {
            if (port == 0) {
                port = 1414;
            }
            if (channel == null) {
                channel = "SYSTEM.DEF.SVRCONN";
            }
        }
        if (trace) {
            Trace.setOn(true);
            Trace.traceData("Cleanup", "Trace started from main by -t flag", null);
        }
        Cleanup c = new Cleanup();
        try {
            c.setQueueManager(qmgrName);
            if (client) {
                c.setTransportType(1);
                c.setHostName(host);
                c.setChannel(channel);
                c.setPort(port);
            } else {
                c.setTransportType(0);
            }
            c.setCleanupInterval(r * 60000);
            c.setCleanupLevel(level);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.mq.jms.Cleanup", "main(String [ ])", je, 4);
            }
            pw.println(je.getMessage());
            Cleanup.displayUsage(pw);
        }
        if (r > 0) {
            c.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException e) {
                    if (Trace.isOn) {
                        Trace.entry(this, "com.ibm.mq.jms.Cleanup", "onException(JMSException)", new Object[]{e});
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5085"));
                    pw.println((Object)e);
                    if (e.getLinkedException() != null) {
                        pw.println(NLSServices.getMessage("JMSMQ5086"));
                        pw.println(e.getLinkedException());
                        pw.flush();
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.mq.jms.null", "onException(JMSException)");
                    }
                }
            });
            c.setPrintWriter(pw1);
            try {
                c.cleanup(true);
            }
            catch (JMSException e) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.mq.jms.Cleanup", "main(String [ ])", e, 6);
                }
                pw.println(NLSServices.getMessage("JMSMQ5085"));
                pw.println((Object)e);
                if (e.getLinkedException() != null) {
                    pw.println(NLSServices.getMessage("JMSMQ5086"));
                    pw.println(e.getLinkedException());
                }
                pw.println();
                pw.flush();
            }
        } else {
            block55: {
                try {
                    c.cleanup(false);
                    pw.println(NLSServices.getMessage("JMSMQ5084"));
                }
                catch (JMSException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.mq.jms.Cleanup", "main(String [ ])", e, 5);
                    }
                    pw.println(NLSServices.getMessage("JMSMQ5085"));
                    pw.println((Object)e);
                    if (e.getLinkedException() == null) break block55;
                    pw.println(NLSServices.getMessage("JMSMQ5086"));
                    pw.println(e.getLinkedException());
                }
            }
            pw.println();
            pw.flush();
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.Cleanup", "main(String [ ])", 10);
        }
    }

    private static void displayUsage(PrintWriter pw) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.Cleanup", "displayUsage(PrintWriter)", new Object[]{pw});
        }
        pw.println(NLSServices.getMessage("JMSMQ5080"));
        pw.println(NLSServices.getMessage("JMSMQ5081"));
        pw.println(NLSServices.getMessage("JMSMQ5082"));
        pw.println(NLSServices.getMessage("JMSMQ5083"));
        pw.println();
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.Cleanup", "displayUsage(PrintWriter)");
        }
    }

    public void run() {
        block5: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.mq.jms.Cleanup", "run()");
            }
            try {
                this.cleanup(true);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.mq.jms.Cleanup", "run()", je);
                }
                if (!Trace.isOn) break block5;
                Trace.traceData(this, "Ignoring exceptionl, will be passed back by exception listener", (Object)je);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.Cleanup", "run()");
        }
    }

    public void stop() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.Cleanup", "stop()");
        }
        try {
            stopMethod.invoke(this.cleanup, null);
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.Cleanup", "stop()", e);
            }
            HashMap<String, Exception> data = new HashMap<String, Exception>();
            data.put("exception", e);
            Trace.ffst("com.ibm.mq.jms.Cleanup", "stop", "XF009007", data, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.Cleanup", "stop()");
        }
    }

    public void setExceptionListener(ExceptionListener el) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.Cleanup", "setExceptionListener(ExceptionListener)", new Object[]{el});
        }
        this.exceptionListener = el;
        if (this.cleanup != null) {
            try {
                if (el == null) {
                    setExceptionListenerMethod.invoke(this.cleanup, null);
                } else {
                    setExceptionListenerMethod.invoke(this.cleanup, new ProviderExceptionListener(){

                        public void onException(JMSException e, boolean connectionBroken) {
                            ExceptionListener e2;
                            if (Trace.isOn) {
                                Trace.entry(this, "com.ibm.mq.jms.Cleanup", "onException(JMSException,boolean)", new Object[]{e, connectionBroken});
                            }
                            if ((e2 = Cleanup.this.exceptionListener) != null) {
                                e2.onException(e);
                            }
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.mq.jms.null", "onException(JMSException,boolean)");
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.mq.jms.Cleanup", "setExceptionListener(ExceptionListener)", e);
                }
                HashMap<String, Exception> data = new HashMap<String, Exception>();
                data.put("exception", e);
                Trace.ffst("com.ibm.mq.jms.Cleanup", "<clinit>", "XF009008", data, null);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.Cleanup", "setExceptionListener(ExceptionListener)");
        }
    }

    public ExceptionListener getExceptionListener() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.mq.jms.Cleanup", "getExceptionListener()", "getter", this.exceptionListener);
        }
        return this.exceptionListener;
    }

    public void setPrintWriter(PrintWriter pw) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.Cleanup", "setPrintWriter(PrintWriter)", new Object[]{pw});
        }
        this.printWriter = pw;
        if (this.cleanup != null) {
            try {
                if (pw == null) {
                    setPrintWriterMethod.invoke(this.cleanup, null);
                } else {
                    setPrintWriterMethod.invoke(this.cleanup, this.printWriter);
                }
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.mq.jms.Cleanup", "setPrintWriter(PrintWriter)", e);
                }
                HashMap<String, Exception> data = new HashMap<String, Exception>();
                data.put("exception", e);
                Trace.ffst("com.ibm.mq.jms.Cleanup", "setPrintWriter(PrintWriter)", "XF00900C", data, null);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.Cleanup", "setPrintWriter(PrintWriter)");
        }
    }

    public boolean isRunning() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.Cleanup", "isRunning()");
        }
        boolean traceRet1 = false;
        try {
            Object returnValue = isRunningMethod.invoke(this.cleanup, null);
            if (returnValue instanceof Boolean) {
                traceRet1 = (Boolean)returnValue;
            }
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.mq.jms.Cleanup", "isRunning()", e);
            }
            HashMap<String, Exception> data = new HashMap<String, Exception>();
            data.put("exception", e);
            Trace.ffst(this, "isRunning", "XF009009", data, null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.mq.jms.Cleanup", "isRunning()", traceRet1);
        }
        return traceRet1;
    }

    public void cleanup() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.mq.jms.Cleanup", "cleanup()");
        }
        this.cleanup(false);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.Cleanup", "cleanup()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void cleanup(boolean runAtRegularIntervals) throws JMSException {
        block39: {
            MQConnection mqc;
            block38: {
                block37: {
                    if (Trace.isOn) {
                        Trace.entry(this, "com.ibm.mq.jms.Cleanup", "cleanup(boolean)", new Object[]{new Boolean(runAtRegularIntervals)});
                    }
                    mqc = null;
                    String providerVersion = this.getProviderVersion();
                    if (providerVersion.equalsIgnoreCase("unspecified")) {
                        this.setProviderVersion("6");
                    } else {
                        int providerVersionNum = 0;
                        String[] providerVerElements = providerVersion.split("\\.");
                        try {
                            providerVersionNum = Integer.parseInt(providerVerElements[0]);
                        }
                        catch (Exception e) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.mq.jms.Cleanup", "cleanup(boolean)", e, 1);
                            }
                            HashMap<String, Exception> ffstData = new HashMap<String, Exception>();
                            ffstData.put("Exception", e);
                            Trace.ffst(this, "cleanup(boolean)", "XF00900A", ffstData, JMSException.class);
                        }
                        if (providerVersionNum > 6) {
                            HashMap<String, String> inserts = new HashMap<String, String>();
                            inserts.put("XMSC_WMQ_PROVIDER_VERSION", String.valueOf(providerVersion));
                            JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1120", inserts));
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.mq.jms.Cleanup", "cleanup(boolean)", je, 1);
                            }
                            throw je;
                        }
                    }
                    mqc = (MQConnection)this.createConnection();
                    ProviderConnection mqv6c = null;
                    mqv6c = ((JmsConnectionImpl)mqc.commonConn).getProviderConnection();
                    if (runAtRegularIntervals) {
                        if (Trace.isOn) {
                            Trace.data(this, "com.ibm.mq.jms.Cleanup", "cleanup(boolean)", "Performing Cleanup at regular intervals.", null);
                        }
                        runMethod.invoke(this.cleanup, mqv6c);
                        break block37;
                    }
                    cleanupMethod.invoke(this.cleanup, mqv6c);
                }
                Object var9_12 = null;
                if (!Trace.isOn) break block38;
                Trace.finallyBlock(this, "com.ibm.mq.jms.Cleanup", "cleanup(boolean)");
            }
            try {
                if (mqc != null) {
                    mqc.close();
                    if (Trace.isOn) {
                        Trace.traceData(this, "Disconnected", null);
                    }
                }
                break block39;
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.mq.jms.Cleanup", "cleanup(boolean)", je, 4);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Ignoring exception from mqc.close()", null);
                }
                break block39;
            }
            {
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.mq.jms.Cleanup", "cleanup(boolean)", je, 2);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "Exception raised during connect or cleanup", (Object)je);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.mq.jms.Cleanup", "cleanup(boolean)", je, 2);
                    }
                    throw je;
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.mq.jms.Cleanup", "cleanup(boolean)", e, 3);
                    }
                    HashMap<String, Exception> data = new HashMap<String, Exception>();
                    data.put("exception", e);
                    Trace.ffst(this, "cleanup", "XF00900B", data, null);
                    Object var9_13 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.mq.jms.Cleanup", "cleanup(boolean)");
                    }
                    try {
                        if (mqc != null) {
                            mqc.close();
                            if (Trace.isOn) {
                                Trace.traceData(this, "Disconnected", null);
                            }
                        }
                        break block39;
                    }
                    catch (JMSException je) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.mq.jms.Cleanup", "cleanup(boolean)", je, 4);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "Ignoring exception from mqc.close()", null);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block40: {
                    Object var9_14 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.mq.jms.Cleanup", "cleanup(boolean)");
                    }
                    try {
                        if (mqc != null) {
                            mqc.close();
                            if (Trace.isOn) {
                                Trace.traceData(this, "Disconnected", null);
                            }
                        }
                    }
                    catch (JMSException je) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.mq.jms.Cleanup", "cleanup(boolean)", je, 4);
                        }
                        if (!Trace.isOn) break block40;
                        Trace.traceData(this, "Ignoring exception from mqc.close()", null);
                    }
                }
                throw throwable;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.mq.jms.Cleanup", "cleanup(boolean)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.mq.jms.Cleanup", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/mq/jms/Cleanup.java, jmscc.migration.wmq, k701, k701-112-140304  1.27.1.6 13/07/30 09:36:26");
        }
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.Cleanup", "static()");
        }
        try {
            cleanupClass = CSSystem.dynamicLoadClass("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", Cleanup.class);
            cleanupInternalMethod = cleanupClass.getMethod("setCleanupInterval", Long.TYPE);
            cleanupLevelMethod = cleanupClass.getMethod("setCleanupLevel", Integer.TYPE);
            isRunningMethod = cleanupClass.getMethod("isRunning", null);
            setExceptionListenerMethod = cleanupClass.getMethod("setExceptionListener", ProviderExceptionListener.class);
            stopMethod = cleanupClass.getMethod("stop", null);
            Class mqConnection = CSSystem.dynamicLoadClass("com.ibm.msg.client.wmq.v6.jms.internal.MQConnection", Cleanup.class);
            cleanupMethod = cleanupClass.getMethod("cleanup", mqConnection);
            runMethod = cleanupClass.getMethod("run", mqConnection);
            setPrintWriterMethod = cleanupClass.getMethod("setPrintWriter", PrintWriter.class);
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.mq.jms.Cleanup", "static()", e);
            }
            HashMap<String, Exception> data = new HashMap<String, Exception>();
            data.put("exception", e);
            Trace.ffst("com.ibm.mq.jms.Cleanup", "<clinit>", "XF009001", data, null);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.mq.jms.Cleanup", "static()");
        }
    }
}

