/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.internal.JmsMessageImpl;
import com.ibm.msg.client.jms.internal.JmsTextMessageImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class JMSTextMessage
extends JMSMessage
implements TextMessage {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.mq.jms/src/com/ibm/jms/JMSTextMessage.java, jmscc.migration.wmq, k701, k701-112-140304 1.26.1.3 10/07/16 14:55:11";
    static final long serialVersionUID = -7013263043146565366L;
    private static final ObjectStreamField[] serialPersistentFields;

    public JMSTextMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSTextMessage", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSTextMessage", "<init>()");
        }
    }

    public String getText() throws JMSException {
        String traceRet1 = ((TextMessage)this.delegateMsg).getText();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSTextMessage", "getText()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public void setText(String messageText) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSTextMessage", "setText(String)", "setter", messageText);
        }
        ((TextMessage)this.delegateMsg).setText(messageText);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block10: {
            block9: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.jms.JMSTextMessage", "readObject(java.io.ObjectInputStream)", new Object[]{in});
                }
                try {
                    String connectionType = "com.ibm.msg.client.wmq";
                    Message tempMsg = null;
                    if (this.delegateMsg != null) {
                        tempMsg = this.delegateMsg;
                    }
                    this.delegateMsg = new JmsTextMessageImpl(connectionType);
                    if (tempMsg != null) {
                        ((JmsMessageImpl)tempMsg).copyProperties(this.delegateMsg);
                    }
                }
                catch (JMSException e) {
                    if (!Trace.isOn) break block9;
                    Trace.catchBlock(this, "com.ibm.jms.JMSTextMessage", "readObject(java.io.ObjectInputStream)", e, 1);
                }
            }
            ObjectInputStream.GetField fields = in.readFields();
            try {
                String text;
                if (!fields.defaulted("messageText") && (text = (String)fields.get("messageText", null)) != null) {
                    this.setText(text);
                }
            }
            catch (JMSException je) {
                if (!Trace.isOn) break block10;
                Trace.catchBlock(this, "com.ibm.jms.JMSTextMessage", "readObject(java.io.ObjectInputStream)", je, 2);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSTextMessage", "readObject(java.io.ObjectInputStream)");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        block4: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.jms.JMSTextMessage", "writeObject(java.io.ObjectOutputStream)", new Object[]{out});
            }
            ObjectOutputStream.PutField fields = out.putFields();
            try {
                fields.put("messageText", this.getText());
            }
            catch (JMSException je) {
                if (!Trace.isOn) break block4;
                Trace.catchBlock(this, "com.ibm.jms.JMSTextMessage", "writeObject(java.io.ObjectOutputStream)", je);
            }
        }
        out.writeFields();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSTextMessage", "writeObject(java.io.ObjectOutputStream)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.jms.JMSTextMessage", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/jms/JMSTextMessage.java, jmscc.migration.wmq, k701, k701-112-140304  1.26.1.3 10/07/16 14:55:11");
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("messageText", String.class)};
    }
}

