/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.internal.JmsMessageImpl;
import com.ibm.msg.client.jms.internal.JmsStreamMessageImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.StreamMessage;

public class JMSStreamMessage
extends JMSMessage
implements StreamMessage {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.mq.jms/src/com/ibm/jms/JMSStreamMessage.java, jmscc.migration.wmq, k701, k701-112-140304 1.27.1.3 10/07/16 14:55:09";
    static final long serialVersionUID = -3015681339377486635L;
    private static final char[] BIN2HEX;
    private static final String STREAM_BODY_NAME = "stream";
    private static final String STREAM_ELT_NAME = "elt";
    private static final ObjectStreamField[] serialPersistentFields;

    public JMSStreamMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "<init>()");
        }
    }

    public boolean readBoolean() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "readBoolean()");
        }
        boolean traceRet1 = ((StreamMessage)this.delegateMsg).readBoolean();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSStreamMessage", "readBoolean()", traceRet1);
        }
        return traceRet1;
    }

    public byte readByte() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "readByte()");
        }
        byte traceRet1 = ((StreamMessage)this.delegateMsg).readByte();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSStreamMessage", "readByte()", new Byte(traceRet1));
        }
        return traceRet1;
    }

    public int readBytes(byte[] value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "readBytes(byte [ ])", new Object[]{value});
        }
        int traceRet1 = ((StreamMessage)this.delegateMsg).readBytes(value);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSStreamMessage", "readBytes(byte [ ])", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public char readChar() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "readChar()");
        }
        char traceRet1 = ((StreamMessage)this.delegateMsg).readChar();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSStreamMessage", "readChar()", new Character(traceRet1));
        }
        return traceRet1;
    }

    public double readDouble() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "readDouble()");
        }
        double traceRet1 = ((StreamMessage)this.delegateMsg).readDouble();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSStreamMessage", "readDouble()", new Double(traceRet1));
        }
        return traceRet1;
    }

    public float readFloat() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "readFloat()");
        }
        float traceRet1 = ((StreamMessage)this.delegateMsg).readFloat();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSStreamMessage", "readFloat()", new Float(traceRet1));
        }
        return traceRet1;
    }

    public int readInt() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "readInt()");
        }
        int traceRet1 = ((StreamMessage)this.delegateMsg).readInt();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSStreamMessage", "readInt()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public long readLong() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "readLong()");
        }
        long traceRet1 = ((StreamMessage)this.delegateMsg).readLong();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSStreamMessage", "readLong()", new Long(traceRet1));
        }
        return traceRet1;
    }

    public Object readObject() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "readObject()");
        }
        Object traceRet1 = ((StreamMessage)this.delegateMsg).readObject();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSStreamMessage", "readObject()", traceRet1);
        }
        return traceRet1;
    }

    public short readShort() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "readShort()");
        }
        short traceRet1 = ((StreamMessage)this.delegateMsg).readShort();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSStreamMessage", "readShort()", new Short(traceRet1));
        }
        return traceRet1;
    }

    public String readString() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "readString()");
        }
        String traceRet1 = ((StreamMessage)this.delegateMsg).readString();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSStreamMessage", "readString()", traceRet1);
        }
        return traceRet1;
    }

    public void reset() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "reset()");
        }
        ((StreamMessage)this.delegateMsg).reset();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "reset()");
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "writeBoolean(boolean)", new Object[]{value});
        }
        ((StreamMessage)this.delegateMsg).writeBoolean(value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "writeBoolean(boolean)");
        }
    }

    public void writeByte(byte value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "writeByte(byte)", new Object[]{new Byte(value)});
        }
        ((StreamMessage)this.delegateMsg).writeByte(value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "writeByte(byte)");
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "writeBytes(byte [ ])", new Object[]{value});
        }
        ((StreamMessage)this.delegateMsg).writeBytes(value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "writeBytes(byte [ ])");
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "writeBytes(byte [ ],int,int)", new Object[]{value, new Integer(offset), new Integer(length)});
        }
        ((StreamMessage)this.delegateMsg).writeBytes(value, offset, length);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "writeBytes(byte [ ],int,int)");
        }
    }

    public void writeChar(char value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "writeChar(char)", new Object[]{new Character(value)});
        }
        ((StreamMessage)this.delegateMsg).writeChar(value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "writeChar(char)");
        }
    }

    public void writeDouble(double value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "writeDouble(double)", new Object[]{new Double(value)});
        }
        ((StreamMessage)this.delegateMsg).writeDouble(value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "writeDouble(double)");
        }
    }

    public void writeFloat(float value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "writeFloat(float)", new Object[]{new Float(value)});
        }
        ((StreamMessage)this.delegateMsg).writeFloat(value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "writeFloat(float)");
        }
    }

    public void writeInt(int value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "writeInt(int)", new Object[]{new Integer(value)});
        }
        ((StreamMessage)this.delegateMsg).writeInt(value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "writeInt(int)");
        }
    }

    public void writeLong(long value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "writeLong(long)", new Object[]{new Long(value)});
        }
        ((StreamMessage)this.delegateMsg).writeLong(value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "writeLong(long)");
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "writeObject(Object)", new Object[]{value});
        }
        ((StreamMessage)this.delegateMsg).writeObject(value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "writeObject(Object)");
        }
    }

    public void writeShort(short value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "writeShort(short)", new Object[]{new Short(value)});
        }
        ((StreamMessage)this.delegateMsg).writeShort(value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "writeShort(short)");
        }
    }

    public void writeString(String value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "writeString(String)", new Object[]{value});
        }
        ((StreamMessage)this.delegateMsg).writeString(value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "writeString(String)");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block15: {
            block14: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "readObject(java.io.ObjectInputStream)", new Object[]{in});
                }
                try {
                    String connectionType = "com.ibm.msg.client.wmq";
                    Message tempMsg = null;
                    if (this.delegateMsg != null) {
                        tempMsg = this.delegateMsg;
                    }
                    this.delegateMsg = new JmsStreamMessageImpl(connectionType);
                    if (tempMsg != null) {
                        ((JmsMessageImpl)tempMsg).copyProperties(this.delegateMsg);
                    }
                }
                catch (JMSException e) {
                    if (!Trace.isOn) break block14;
                    Trace.catchBlock(this, "com.ibm.jms.JMSStreamMessage", "readObject(java.io.ObjectInputStream)", e, 1);
                }
            }
            ObjectInputStream.GetField fields = in.readFields();
            try {
                String unbuffered = null;
                StringBuffer buffer = null;
                if (!fields.defaulted("streamBody")) {
                    unbuffered = (String)fields.get("streamBody", null);
                }
                if (!fields.defaulted("dataWritten")) {
                    buffer = (StringBuffer)fields.get("dataWritten", null);
                }
                if (buffer != null) {
                    unbuffered = buffer.toString();
                }
                if (unbuffered != null) {
                    StringTokenizer st = new StringTokenizer(unbuffered, "<>");
                    boolean processing = true;
                    while (processing) {
                        Object obj = this.readField(st);
                        if (obj == null) {
                            processing = false;
                            continue;
                        }
                        this.writeObject(obj);
                    }
                }
            }
            catch (JMSException je) {
                if (!Trace.isOn) break block15;
                Trace.catchBlock(this, "com.ibm.jms.JMSStreamMessage", "readObject(java.io.ObjectInputStream)", je, 2);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "readObject(java.io.ObjectInputStream)");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        block9: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "writeObject(java.io.ObjectOutputStream)", new Object[]{out});
            }
            ObjectOutputStream.PutField fields = out.putFields();
            try {
                this.reset();
                StringBuffer buffer = new StringBuffer();
                String unbuffered = "";
                try {
                    while (true) {
                        Object element = ((JmsStreamMessageImpl)this.delegateMsg).getNextField("writeObject");
                        this.formatElement(STREAM_ELT_NAME, element, buffer);
                    }
                }
                catch (MessageEOFException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.jms.JMSStreamMessage", "writeObject(java.io.ObjectOutputStream)", e, 1);
                    }
                    if (buffer.length() > 0) {
                        unbuffered = buffer.toString();
                    }
                    fields.put("dataWritten", buffer);
                    fields.put("streamBody", unbuffered);
                }
            }
            catch (JMSException je) {
                if (!Trace.isOn) break block9;
                Trace.catchBlock(this, "com.ibm.jms.JMSStreamMessage", "writeObject(java.io.ObjectOutputStream)", je, 2);
            }
        }
        out.writeFields();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "writeObject(java.io.ObjectOutputStream)");
        }
    }

    private void formatElement(String name, Object value, StringBuffer buffer) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "formatElement(String,Object,StringBuffer)", new Object[]{name, value, buffer});
        }
        boolean written = false;
        buffer.append("<");
        buffer.append(name);
        if (value instanceof String) {
            buffer.append(">");
            this.backReference(buffer, (String)value);
            written = true;
        } else if (value instanceof Integer) {
            buffer.append(" dt='i4'>");
        } else if (value instanceof Short) {
            buffer.append(" dt='i2'>");
        } else if (value instanceof Byte) {
            buffer.append(" dt='i1'>");
        } else if (value instanceof Long) {
            buffer.append(" dt='i8'>");
        } else if (value instanceof Float) {
            buffer.append(" dt='r4'>");
        } else if (value instanceof Double) {
            buffer.append(" dt='r8'>");
        } else if (value instanceof byte[]) {
            buffer.append(" dt='bin.hex'>");
            this.binToHex((byte[])value, 0, ((byte[])value).length, buffer);
            written = true;
        } else if (value instanceof Boolean) {
            buffer.append(" dt='boolean'>");
            value = ((Boolean)value).booleanValue() ? "1" : "0";
        } else if (value instanceof Character) {
            buffer.append(" dt='char'>");
            this.backReference(buffer, ((Character)value).toString());
            written = true;
        } else if (value == null) {
            buffer.append(" xsi:nil='true'>");
            buffer.append("</");
            buffer.append(name);
            buffer.append(">");
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.jms.JMSStreamMessage", "formatElement(String,Object,StringBuffer)", 1);
            }
            return;
        }
        if (!written) {
            buffer.append(value.toString());
        }
        buffer.append("</");
        buffer.append(name);
        buffer.append(">");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSStreamMessage", "formatElement(String,Object,StringBuffer)", 2);
        }
    }

    private void backReference(StringBuffer sb, String string) {
        int i;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "backReference(StringBuffer,String)", new Object[]{sb, string});
        }
        int specialCharCount = 0;
        for (i = 0; i < string.length(); ++i) {
            char x = string.charAt(i);
            if (!(x == '&' | x == '\"' | x == '\'' | x == '<' | x == '>')) continue;
            ++specialCharCount;
        }
        for (i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if ('<' == ch) {
                sb.append("&lt;");
                continue;
            }
            if ('>' == ch) {
                sb.append("&gt;");
                continue;
            }
            if ('&' == ch) {
                sb.append("&amp;");
                continue;
            }
            if ('\"' == ch) {
                sb.append("&quot;");
                continue;
            }
            if ('\'' == ch) {
                sb.append("&apos;");
                continue;
            }
            if ('\ud800' <= ch && ch < '\udc00') {
                int next = string.charAt(++i);
                next = (ch - 55296 << 10) + next - 56320 + 65536;
                sb.append("&#x");
                sb.append(Integer.toHexString(next));
                sb.append(";");
                continue;
            }
            sb.append(ch);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "backReference(StringBuffer,String)");
        }
    }

    private int binToHex(byte[] bin, int start, int length, StringBuffer hex) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "binToHex(byte [ ],int,int,StringBuffer)", new Object[]{bin, new Integer(start), new Integer(length), hex});
        }
        int sum = 0;
        for (int i = start; i < start + length; ++i) {
            int binByte = bin[i];
            if (binByte < 0) {
                binByte += 256;
            }
            sum += binByte;
            hex.append(BIN2HEX[binByte / 16]);
            hex.append(BIN2HEX[binByte % 16]);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSStreamMessage", "binToHex(byte [ ],int,int,StringBuffer)", new Integer(sum));
        }
        return sum;
    }

    private Object readField(StringTokenizer st) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "readField(StringTokenizer)", new Object[]{st});
        }
        try {
            String type;
            String name = st.nextToken();
            if (name.equals("/stream")) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "readField(StringTokenizer)", null, 1);
                }
                return null;
            }
            int nullIndex = 0;
            boolean shortForm = false;
            if (name.charAt(name.length() - 1) == '/') {
                shortForm = true;
            }
            if ((nullIndex = name.indexOf(" xsi:nil")) != -1) {
                int spaceIndex = 0;
                spaceIndex = name.indexOf(" ");
                name = name.substring(0, spaceIndex);
                if (!shortForm) {
                    String token = st.nextToken();
                    if (token.charAt(0) != '/') {
                        token = st.nextToken();
                    }
                    if (token.charAt(0) != '/') {
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "readField(StringTokenizer)", null, 2);
                        }
                        return null;
                    }
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "readField(StringTokenizer)", null, 3);
                }
                return null;
            }
            int index = name.indexOf(" dt=");
            if (index != -1) {
                type = name.substring(index + 4);
                name = name.substring(0, index);
            } else {
                type = "'string'";
            }
            if (shortForm) {
                Object currentField = this.deformatElement(type, "");
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "readField(StringTokenizer)", currentField, 4);
                }
                return currentField;
            }
            String value = st.nextToken();
            if (value.charAt(0) == '/') {
                Object currentField = this.deformatElement(type, "");
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "readField(StringTokenizer)", currentField, 5);
                }
                return currentField;
            }
            String token = st.nextToken();
            if (token.charAt(0) != '/') {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "readField(StringTokenizer)", null, 6);
                }
                return null;
            }
            Object currentField = this.deformatElement(type, value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "readField(StringTokenizer)", currentField, 7);
            }
            return currentField;
        }
        catch (NoSuchElementException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.jms.JMSStreamMessage", "readField(StringTokenizer)", ex);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "readField(StringTokenizer)", null, 8);
            }
            return null;
        }
    }

    private Object deformatElement(String datatype, String value) {
        char openingQuote;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "deformatElement(String,String)", new Object[]{datatype, value});
        }
        if (Trace.isOn) {
            if (value == null) {
                Trace.data(this, "valcheck1", (Object)("type is " + datatype + " value is " + value));
            } else if (value.length() <= 50) {
                Trace.data(this, "valcheck2", (Object)("type is " + datatype + " value is " + value));
            } else {
                Trace.data(this, "valcheck3", (Object)("type is " + datatype + " value starts " + value.substring(0, 50)));
            }
        }
        if ((openingQuote = datatype.charAt(0)) != '\'' && openingQuote != '\"') {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "deformatElement(String,String)", null, 1);
            }
            return null;
        }
        String type = datatype.substring(1, datatype.indexOf(openingQuote, 1));
        if (type.equals("string")) {
            if (value == null) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "deformatElement(String,String)", null, 2);
                }
                return null;
            }
            String traceRet1 = this.expandRefs(value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "deformatElement(String,String)", traceRet1, 3);
            }
            return traceRet1;
        }
        if (type.equals("i4")) {
            Integer traceRet2 = new Integer(value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "deformatElement(String,String)", traceRet2, 4);
            }
            return traceRet2;
        }
        if (type.equals("i2")) {
            Short traceRet3 = new Short(value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "deformatElement(String,String)", traceRet3, 5);
            }
            return traceRet3;
        }
        if (type.equals("i8")) {
            Long traceRet4 = new Long(value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "deformatElement(String,String)", traceRet4, 6);
            }
            return traceRet4;
        }
        if (type.equals("i1")) {
            Byte traceRet5 = new Byte(value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "deformatElement(String,String)", traceRet5, 7);
            }
            return traceRet5;
        }
        if (type.equals("r4")) {
            Float traceRet6 = new Float(value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "deformatElement(String,String)", traceRet6, 8);
            }
            return traceRet6;
        }
        if (type.equals("r8")) {
            Double traceRet7 = new Double(value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "deformatElement(String,String)", traceRet7, 9);
            }
            return traceRet7;
        }
        if (type.equals("bin.hex")) {
            if (value.length() == 0) {
                byte[] traceRet8 = new byte[]{};
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "deformatElement(String,String)", traceRet8, 10);
                }
                return traceRet8;
            }
            byte[] traceRet9 = this.hexToBin(value, 0);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "deformatElement(String,String)", traceRet9, 11);
            }
            return traceRet9;
        }
        if (type.equals("boolean")) {
            if (value.equals("1")) {
                Boolean traceRet10 = new Boolean(true);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "deformatElement(String,String)", traceRet10, 12);
                }
                return traceRet10;
            }
            if (value.equals("0")) {
                Boolean traceRet11 = new Boolean(false);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "deformatElement(String,String)", traceRet11, 13);
                }
                return traceRet11;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "deformatElement(String,String)", null, 14);
            }
            return null;
        }
        if (type.equals("char")) {
            Character traceRet12 = new Character(this.expandRefs(value).charAt(0));
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "deformatElement(String,String)", traceRet12, 15);
            }
            return traceRet12;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "deformatElement(String,String)", null, 16);
        }
        return null;
    }

    private String expandRefs(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "expandRefs(String)", new Object[]{string});
        }
        if (string.length() == 0) {
            String traceRet1 = "";
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "expandRefs(String)", traceRet1, 1);
            }
            return traceRet1;
        }
        StringBuffer sb = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if ('&' == ch) {
                String entity = string.substring(i + 1, i + 4);
                if (entity.equals("lt;")) {
                    sb.append('<');
                    i += 3;
                    continue;
                }
                if (entity.equals("gt;")) {
                    sb.append('>');
                    i += 3;
                    continue;
                }
                if (string.substring(i + 1, i + 5).equals("amp;")) {
                    sb.append("&");
                    i += 4;
                    continue;
                }
                if (string.substring(i + 1, i + 6).equals("apos;")) {
                    sb.append("'");
                    i += 5;
                    continue;
                }
                if (string.substring(i + 1, i + 6).equals("quot;")) {
                    sb.append('\"');
                    i += 5;
                    continue;
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "expandRefs(String)", null, 2);
                }
                return null;
            }
            sb.append(ch);
        }
        String traceRet2 = sb.toString();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "expandRefs(String)", traceRet2, 3);
        }
        return traceRet2;
    }

    private byte[] hexToBin(String hex, int start) {
        int length;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSStreamMessage", "hexToBin(String,int)", new Object[]{hex, new Integer(start)});
        }
        if ((length = hex.length() - start) == 0) {
            byte[] traceRet1 = new byte[]{};
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "hexToBin(String,int)", traceRet1, 1);
            }
            return traceRet1;
        }
        if (length < 0 || length % 2 != 0) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "hexToBin(String,int)", null, 2);
            }
            return null;
        }
        byte[] retval = new byte[length /= 2];
        for (int i = 0; i < length; ++i) {
            int digit1 = Character.digit(hex.charAt(2 * i + start), 16) << 4;
            int digit2 = Character.digit(hex.charAt(2 * i + start + 1), 16);
            if (digit1 < 0 || digit2 < 0) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "hexToBin(String,int)", null, 3);
                }
                return null;
            }
            retval[i] = (byte)(digit1 + digit2);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSStreamMessage", "hexToBin(String,int)", retval, 4);
        }
        return retval;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.jms.JMSStreamMessage", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/jms/JMSStreamMessage.java, jmscc.migration.wmq, k701, k701-112-140304  1.27.1.3 10/07/16 14:55:09");
        }
        BIN2HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("dataWritten", StringBuffer.class), new ObjectStreamField("streamBody", String.class)};
    }
}

