/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.internal.JmsMessageImpl;
import com.ibm.msg.client.jms.internal.JmsObjectMessageImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;

public class JMSObjectMessage
extends JMSMessage
implements ObjectMessage {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.mq.jms/src/com/ibm/jms/JMSObjectMessage.java, jmscc.migration.wmq, k701, k701-112-140304 1.25.1.4 10/12/06 11:23:11";
    static final long serialVersionUID = -9160649637541619341L;
    private static final ObjectStreamField[] serialPersistentFields;

    public JMSObjectMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSObjectMessage", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSObjectMessage", "<init>()");
        }
    }

    public Serializable getObject() throws JMSException {
        Serializable traceRet1 = ((ObjectMessage)this.delegateMsg).getObject();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSObjectMessage", "getObject()", "getter", traceRet1);
        }
        return traceRet1;
    }

    private void setObjectAsBytes(byte[] bytes) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSObjectMessage", "setObjectAsBytes(byte[])", "setter", bytes);
        }
        if (this.delegateMsg instanceof JmsObjectMessageImpl) {
            ((JmsObjectMessageImpl)this.delegateMsg).setObjectAsBytes(bytes);
        } else if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSObjectMessage", "setObjectAsBytes(byte[])", "Could not set Object as delegateMessage is not correct type", this.delegateMsg.getClass().getName());
        }
    }

    public void setObject(Serializable object) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSObjectMessage", "setObject(Serializable)", "setter", object);
        }
        ((ObjectMessage)this.delegateMsg).setObject(object);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block10: {
            block9: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.jms.JMSObjectMessage", "readObject(java.io.ObjectInputStream)", new Object[]{in});
                }
                try {
                    String connectionType = "com.ibm.msg.client.wmq";
                    Message tempMsg = null;
                    if (this.delegateMsg != null) {
                        tempMsg = this.delegateMsg;
                    }
                    this.delegateMsg = new JmsObjectMessageImpl(connectionType);
                    if (tempMsg != null) {
                        ((JmsMessageImpl)tempMsg).copyProperties(this.delegateMsg);
                    }
                }
                catch (JMSException e) {
                    if (!Trace.isOn) break block9;
                    Trace.catchBlock(this, "com.ibm.jms.JMSObjectMessage", "readObject(java.io.ObjectInputStream)", e, 1);
                }
            }
            ObjectInputStream.GetField fields = in.readFields();
            try {
                byte[] messageBytes;
                if (!fields.defaulted("messageBytes") && (messageBytes = (byte[])fields.get("messageBytes", null)) != null) {
                    this.setObjectAsBytes(messageBytes);
                }
            }
            catch (JMSException je) {
                if (!Trace.isOn) break block10;
                Trace.catchBlock(this, "com.ibm.jms.JMSObjectMessage", "readObject(java.io.ObjectInputStream)", je, 2);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSObjectMessage", "readObject(java.io.ObjectInputStream)");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        block4: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.jms.JMSObjectMessage", "writeObject(java.io.ObjectOutputStream)", new Object[]{out});
            }
            ObjectOutputStream.PutField fields = out.putFields();
            try {
                ByteArrayOutputStream serialisedObject = new ByteArrayOutputStream();
                ObjectOutputStream objOut = new ObjectOutputStream(serialisedObject);
                objOut.writeObject(this.getObject());
                fields.put("messageBytes", serialisedObject.toByteArray());
            }
            catch (JMSException je) {
                if (!Trace.isOn) break block4;
                Trace.catchBlock(this, "com.ibm.jms.JMSObjectMessage", "writeObject(java.io.ObjectOutputStream)", je);
            }
        }
        out.writeFields();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSObjectMessage", "writeObject(java.io.ObjectOutputStream)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.jms.JMSObjectMessage", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/jms/JMSObjectMessage.java, jmscc.migration.wmq, k701, k701-112-140304  1.25.1.4 10/12/06 11:23:11");
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("messageBytes", [B.class)};
    }
}

