/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jms;

import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.MQTemporaryQueue;
import com.ibm.mq.jms.MQTemporaryTopic;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.internal.JmsMessageImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;

public class JMSMessage
implements Message,
Serializable {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final long serialVersionUID = -4436266789041169376L;
    private static final ObjectStreamField[] serialPersistentFields;
    protected transient Message delegateMsg;
    public static final String ENCODING_PROPERTY = "JMS_IBM_Encoding";
    public static final String CHARSET_PROPERTY = "JMS_IBM_Character_Set";
    private static final String NULL_MARKER = "__JMSMessage$$NULL_MARKER";

    public JMSMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSMessage", "<init>()");
        }
    }

    public void acknowledge() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "acknowledge()");
        }
        this.delegateMsg.acknowledge();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSMessage", "acknowledge()");
        }
    }

    public void clearBody() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "clearBody()");
        }
        this.delegateMsg.clearBody();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSMessage", "clearBody()");
        }
    }

    public void clearProperties() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "clearProperties()");
        }
        this.delegateMsg.clearProperties();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSMessage", "clearProperties()");
        }
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "getBooleanProperty(String)", new Object[]{name});
        }
        boolean traceRet1 = this.delegateMsg.getBooleanProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSMessage", "getBooleanProperty(String)", traceRet1);
        }
        return traceRet1;
    }

    public byte getByteProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "getByteProperty(String)", new Object[]{name});
        }
        byte traceRet1 = this.delegateMsg.getByteProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSMessage", "getByteProperty(String)", new Byte(traceRet1));
        }
        return traceRet1;
    }

    public Message getDelegate() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "getDelegate()", "getter", this.delegateMsg);
        }
        return this.delegateMsg;
    }

    public double getDoubleProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "getDoubleProperty(String)", new Object[]{name});
        }
        double traceRet1 = this.delegateMsg.getDoubleProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSMessage", "getDoubleProperty(String)", new Double(traceRet1));
        }
        return traceRet1;
    }

    public float getFloatProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "getFloatProperty(String)", new Object[]{name});
        }
        float traceRet1 = this.delegateMsg.getFloatProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSMessage", "getFloatProperty(String)", new Float(traceRet1));
        }
        return traceRet1;
    }

    public int getIntProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "getIntProperty(String)", new Object[]{name});
        }
        int traceRet1 = this.delegateMsg.getIntProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSMessage", "getIntProperty(String)", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public String getJMSCorrelationID() throws JMSException {
        String traceRet1 = this.delegateMsg.getJMSCorrelationID();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "getJMSCorrelationID()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        byte[] traceRet1 = this.delegateMsg.getJMSCorrelationIDAsBytes();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "getJMSCorrelationIDAsBytes()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public int getJMSDeliveryMode() throws JMSException {
        int traceRet1 = this.delegateMsg.getJMSDeliveryMode();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "getJMSDeliveryMode()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public Destination getJMSDestination() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "getJMSDestination()");
        }
        Destination destination = null;
        destination = this.delegateMsg.getJMSDestination();
        if (destination instanceof TemporaryTopic) {
            destination = MQDestinationProxy.createTemporaryTopic((TemporaryTopic)destination);
        } else if (destination instanceof TemporaryQueue) {
            destination = MQDestinationProxy.createTemporaryQueue((TemporaryQueue)destination);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSMessage", "getJMSDestination()", destination);
        }
        return destination;
    }

    public long getJMSExpiration() throws JMSException {
        long traceRet1 = this.delegateMsg.getJMSExpiration();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "getJMSExpiration()", "getter", new Long(traceRet1));
        }
        return traceRet1;
    }

    public String getJMSMessageID() throws JMSException {
        String traceRet1 = this.delegateMsg.getJMSMessageID();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "getJMSMessageID()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public int getJMSPriority() throws JMSException {
        int traceRet1 = this.delegateMsg.getJMSPriority();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "getJMSPriority()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public boolean getJMSRedelivered() throws JMSException {
        boolean traceRet1 = this.delegateMsg.getJMSRedelivered();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "getJMSRedelivered()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public Destination getJMSReplyTo() throws JMSException {
        Destination traceRet1 = this.delegateMsg.getJMSReplyTo();
        if (traceRet1 instanceof TemporaryTopic) {
            traceRet1 = MQDestinationProxy.createTemporaryTopic((TemporaryTopic)traceRet1);
        } else if (traceRet1 instanceof TemporaryQueue) {
            traceRet1 = MQDestinationProxy.createTemporaryQueue((TemporaryQueue)traceRet1);
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "getJMSReplyTo()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public long getJMSTimestamp() throws JMSException {
        long traceRet1 = this.delegateMsg.getJMSTimestamp();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "getJMSTimestamp()", "getter", new Long(traceRet1));
        }
        return traceRet1;
    }

    public String getJMSType() throws JMSException {
        String traceRet1 = this.delegateMsg.getJMSType();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "getJMSType()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public long getLongProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "getLongProperty(String)", new Object[]{name});
        }
        long traceRet1 = this.delegateMsg.getLongProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSMessage", "getLongProperty(String)", new Long(traceRet1));
        }
        return traceRet1;
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "getObjectProperty(String)", new Object[]{name});
        }
        Object traceRet1 = this.delegateMsg.getObjectProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSMessage", "getObjectProperty(String)", traceRet1);
        }
        return traceRet1;
    }

    public Enumeration getPropertyNames() throws JMSException {
        Enumeration traceRet1 = this.delegateMsg.getPropertyNames();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "getPropertyNames()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public short getShortProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "getShortProperty(String)", new Object[]{name});
        }
        short traceRet1 = this.delegateMsg.getShortProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSMessage", "getShortProperty(String)", new Short(traceRet1));
        }
        return traceRet1;
    }

    public String getStringProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "getStringProperty(String)", new Object[]{name});
        }
        String traceRet1 = this.delegateMsg.getStringProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSMessage", "getStringProperty(String)", traceRet1);
        }
        return traceRet1;
    }

    public boolean propertyExists(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "propertyExists(String)", new Object[]{name});
        }
        boolean traceRet1 = this.delegateMsg.propertyExists(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.jms.JMSMessage", "propertyExists(String)", traceRet1);
        }
        return traceRet1;
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "setBooleanProperty(String,boolean)", new Object[]{name, value});
        }
        this.delegateMsg.setBooleanProperty(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSMessage", "setBooleanProperty(String,boolean)");
        }
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "setByteProperty(String,byte)", new Object[]{name, new Byte(value)});
        }
        this.delegateMsg.setByteProperty(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSMessage", "setByteProperty(String,byte)");
        }
    }

    public void setDelegate(Message delegateMsg) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "setDelegate(Message)", "setter", delegateMsg);
        }
        this.delegateMsg = delegateMsg;
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "setDoubleProperty(String,double)", new Object[]{name, new Double(value)});
        }
        this.delegateMsg.setDoubleProperty(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSMessage", "setDoubleProperty(String,double)");
        }
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "setFloatProperty(String,float)", new Object[]{name, new Float(value)});
        }
        this.delegateMsg.setFloatProperty(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSMessage", "setFloatProperty(String,float)");
        }
    }

    public void setIntProperty(String name, int value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "setIntProperty(String,int)", new Object[]{name, new Integer(value)});
        }
        this.delegateMsg.setIntProperty(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSMessage", "setIntProperty(String,int)");
        }
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "setJMSCorrelationID(String)", "setter", correlationID);
        }
        this.delegateMsg.setJMSCorrelationID(correlationID);
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlID) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "setJMSCorrelationIDAsBytes(byte [ ])", "setter", correlID);
        }
        this.delegateMsg.setJMSCorrelationIDAsBytes(correlID);
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "setJMSDeliveryMode(int)", "setter", new Integer(deliveryMode));
        }
        this.delegateMsg.setJMSDeliveryMode(deliveryMode);
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "setJMSDestination(Destination)", "setter", destination);
        }
        Destination dest = MQDestinationProxy.validateDestination(destination);
        this.delegateMsg.setJMSDestination(dest);
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "setJMSExpiration(long)", "setter", new Long(expiration));
        }
        this.delegateMsg.setJMSExpiration(expiration);
    }

    public void setJMSMessageID(String id) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "setJMSMessageID(String)", "setter", id);
        }
        this.delegateMsg.setJMSMessageID(id);
    }

    public void setJMSPriority(int priority) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "setJMSPriority(int)", "setter", new Integer(priority));
        }
        this.delegateMsg.setJMSPriority(priority);
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "setJMSRedelivered(boolean)", "setter", redelivered);
        }
        this.delegateMsg.setJMSRedelivered(redelivered);
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "setJMSReplyTo(Destination)", "setter", replyTo);
        }
        Destination dest = MQDestinationProxy.validateDestination(replyTo);
        this.delegateMsg.setJMSReplyTo(dest);
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "setJMSTimestamp(long)", "setter", new Long(timestamp));
        }
        this.delegateMsg.setJMSTimestamp(timestamp);
    }

    public void setJMSType(String type) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.jms.JMSMessage", "setJMSType(String)", "setter", type);
        }
        this.delegateMsg.setJMSType(type);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "setLongProperty(String,long)", new Object[]{name, new Long(value)});
        }
        this.delegateMsg.setLongProperty(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSMessage", "setLongProperty(String,long)");
        }
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "setObjectProperty(String,Object)", new Object[]{name, value});
        }
        this.delegateMsg.setObjectProperty(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSMessage", "setObjectProperty(String,Object)");
        }
    }

    public void setShortProperty(String name, short value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "setShortProperty(String,short)", new Object[]{name, new Short(value)});
        }
        this.delegateMsg.setShortProperty(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSMessage", "setShortProperty(String,short)");
        }
    }

    public void setStringProperty(String name, String value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.jms.JMSMessage", "setStringProperty(String,String)", new Object[]{name, value});
        }
        this.delegateMsg.setStringProperty(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSMessage", "setStringProperty(String,String)");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block23: {
            block22: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.jms.JMSMessage", "readObject(java.io.ObjectInputStream)", new Object[]{in});
                }
                try {
                    String connectionType = "com.ibm.msg.client.wmq";
                    Message tempMsg = null;
                    if (this.delegateMsg != null) {
                        tempMsg = this.delegateMsg;
                    }
                    this.delegateMsg = new JmsMessageImpl(connectionType);
                    if (tempMsg != null) {
                        ((JmsMessageImpl)tempMsg).copyProperties(this.delegateMsg);
                    }
                }
                catch (JMSException e) {
                    if (!Trace.isOn) break block22;
                    Trace.catchBlock(this, "com.ibm.jms.JMSMessage", "readObject(java.io.ObjectInputStream)", e, 1);
                }
            }
            ObjectInputStream.GetField fields = in.readFields();
            try {
                boolean messageCorrelSet = false;
                if (!fields.defaulted("properties")) {
                    Hashtable tempProperties = (Hashtable)fields.get("properties", null);
                    Iterator it = tempProperties.keySet().iterator();
                    while (it.hasNext()) {
                        String key;
                        Object value = tempProperties.get(key = (String)it.next());
                        this.setObjectProperty(key, value.equals(NULL_MARKER) ? null : value);
                    }
                }
                if (!fields.defaulted("correlationId")) {
                    this.setJMSCorrelationID((String)fields.get("correlationId", null));
                    messageCorrelSet = true;
                }
                if (!messageCorrelSet && !fields.defaulted("nativeCorrelId")) {
                    this.setJMSCorrelationIDAsBytes((byte[])fields.get("nativeCorrelId", null));
                    messageCorrelSet = true;
                }
                if (!fields.defaulted("deliveryMode")) {
                    this.setJMSDeliveryMode(fields.get("deliveryMode", 0));
                }
                if (!fields.defaulted("expiration")) {
                    this.setJMSExpiration(fields.get("expiration", 0L));
                }
                if (!fields.defaulted("timeToLive")) {
                    this.setLongProperty("timeToLive", fields.get("timeToLive", 0L));
                }
                if (!fields.defaulted("priority")) {
                    this.setJMSPriority(fields.get("priority", 0));
                }
                if (!fields.defaulted("redelivered")) {
                    this.setJMSRedelivered(fields.get("redelivered", false));
                }
                if (!fields.defaulted("timestamp")) {
                    this.setJMSTimestamp(fields.get("timestamp", 0L));
                }
                if (!fields.defaulted("type")) {
                    this.setJMSType((String)fields.get("type", null));
                }
                if (!fields.defaulted("messageId")) {
                    this.setJMSMessageID((String)fields.get("messageId", null));
                }
                if (!fields.defaulted("destination")) {
                    this.setJMSDestination((Destination)fields.get("destination", null));
                }
                if (!fields.defaulted("replyTo")) {
                    this.setJMSReplyTo((Destination)fields.get("replyTo", null));
                }
            }
            catch (JMSException je) {
                if (!Trace.isOn) break block23;
                Trace.catchBlock(this, "com.ibm.jms.JMSMessage", "readObject(java.io.ObjectInputStream)", je, 2);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSMessage", "readObject(java.io.ObjectInputStream)");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        block6: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.jms.JMSMessage", "writeObject(java.io.ObjectOutputStream)", new Object[]{out});
            }
            ObjectOutputStream.PutField fields = out.putFields();
            try {
                Hashtable<String, Object> tempTable = new Hashtable<String, Object>();
                Enumeration e = this.getPropertyNames();
                while (e.hasMoreElements()) {
                    String key;
                    Object propertyValue = this.getObjectProperty(key = (String)e.nextElement());
                    tempTable.put(key, propertyValue == null ? NULL_MARKER : propertyValue);
                }
                fields.put("properties", tempTable);
                fields.put("correlationId", this.getJMSCorrelationID());
                fields.put("nativeCorrelId", this.getJMSCorrelationIDAsBytes());
                fields.put("deliveryMode", this.getJMSDeliveryMode());
                fields.put("expiration", this.getJMSExpiration());
                if (this.getObjectProperty("timeToLive") != null) {
                    fields.put("timeToLive", this.getLongProperty("timeToLive"));
                }
                fields.put("priority", this.getJMSPriority());
                fields.put("redelivered", this.getJMSRedelivered());
                fields.put("timestamp", this.getJMSTimestamp());
                fields.put("type", this.getJMSType());
                fields.put("messageId", this.getJMSMessageID());
                fields.put("destination", this.getJMSDestination());
                fields.put("replyTo", this.getJMSReplyTo());
            }
            catch (JMSException je) {
                if (!Trace.isOn) break block6;
                Trace.catchBlock(this, "com.ibm.jms.JMSMessage", "writeObject(java.io.ObjectOutputStream)", je);
            }
        }
        out.writeFields();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.jms.JMSMessage", "writeObject(java.io.ObjectOutputStream)");
        }
    }

    public String toString() {
        String traceRet1 = this.delegateMsg.toString();
        return traceRet1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.jms.JMSMessage", "static", "SCCS id", (Object)"@(#) com.ibm.mq.jms/src/com/ibm/jms/JMSMessage.java, jmscc.migration.wmq, k701, k701-112-140304  1.39.1.4 11/04/14 07:13:06");
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("properties", Hashtable.class), new ObjectStreamField("correlationId", String.class), new ObjectStreamField("nativeCorrelId", [B.class), new ObjectStreamField("deliveryMode", Integer.TYPE), new ObjectStreamField("expiration", Long.TYPE), new ObjectStreamField("timeToLive", Long.TYPE), new ObjectStreamField("priority", Integer.TYPE), new ObjectStreamField("redelivered", Boolean.TYPE), new ObjectStreamField("timestamp", Long.TYPE), new ObjectStreamField("type", String.class), new ObjectStreamField("messageId", String.class), new ObjectStreamField("destination", Destination.class), new ObjectStreamField("replyTo", Destination.class)};
    }

    static class MQDestinationProxy
    extends MQDestination {
        private static final long serialVersionUID = 1627181143081591416L;

        private MQDestinationProxy() throws JMSException {
            super("");
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.jms.MQDestinationProxy", "<init>()");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.jms.MQDestinationProxy", "<init>()");
            }
        }

        protected static Destination validateDestination(Destination dest) throws JMSException {
            if (Trace.isOn) {
                Trace.entry("com.ibm.jms.MQDestinationProxy", "validateDestination(Destination)", new Object[]{dest});
            }
            Destination traceRet1 = MQDestinationProxy.proxyValidateDestination(dest);
            if (Trace.isOn) {
                Trace.exit("com.ibm.jms.MQDestinationProxy", "validateDestination(Destination)", traceRet1);
            }
            return traceRet1;
        }

        protected static MQTemporaryTopic createTemporaryTopic(TemporaryTopic tempTopic) throws JMSException {
            if (Trace.isOn) {
                Trace.entry("com.ibm.jms.MQDestinationProxy", "createTemporaryTopic(TemporaryTopic)", new Object[]{tempTopic});
            }
            MQTemporaryTopic traceRet1 = MQDestinationProxy.proxyCreateTemporaryTopic(tempTopic);
            if (Trace.isOn) {
                Trace.exit("com.ibm.jms.MQDestinationProxy", "createTemporaryTopic(TemporaryTopic)", traceRet1);
            }
            return traceRet1;
        }

        protected static MQTemporaryQueue createTemporaryQueue(TemporaryQueue tempQueue) throws JMSException {
            if (Trace.isOn) {
                Trace.entry("com.ibm.jms.MQDestinationProxy", "createTemporaryQueue(TemporaryQueue)", new Object[]{tempQueue});
            }
            MQTemporaryQueue traceRet1 = MQDestinationProxy.proxyCreateTemporaryQueue(tempQueue);
            if (Trace.isOn) {
                Trace.exit("com.ibm.jms.MQDestinationProxy", "createTemporaryQueue(TemporaryQueue)", traceRet1);
            }
            return traceRet1;
        }
    }
}

