/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.utils;

import com.ibm.mq.commonservices.Common;
import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.NativeCalls;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class QueueManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2009";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.commonservices/src/com/ibm/mq/commonservices/internal/utils/QueueManager.java, javagui, p701, p701-112-140304  1.10.1.2 11/08/31 13:09:18";
    private static final String XCSPRA_DELIMIT_0 = "\n";
    private static final String XCSPRA_DELIMIT_1 = "\u000b";
    private static final String QUEUE_MANAGER_STANZA = "QueueManager";
    private static final String QUEUE_MANAGER_STANZA_KEY = "Name";
    private static final String DEFAULT_QUEUE_MANAGER_STANZA = "DefaultQueueManager";
    public static final String PREFIX_STANZA_KEY = "Prefix";
    public static final String DIRECTORY_STANZA_KEY = "Directory";
    public static final String DATAPATH_STANZA_KEY = "DataPath";

    private QueueManager() {
        System.out.println("*** You should not be using this constructor ***");
    }

    public static ArrayList getListOfQueueManagers(Trace t) throws CommonServicesException {
        return QueueManager.getListOfQueueManagers(t, true);
    }

    public static ArrayList getListOfQueueManagers(Trace t, boolean includeStandy) throws CommonServicesException {
        String fid = "QueueManager.getListOfQueueManagers";
        ArrayList<String> queueManagers = new ArrayList<String>();
        t.entry(64, "QueueManager.getListOfQueueManagers");
        try {
            String response = NativeCalls.getAttrs(t, null, QUEUE_MANAGER_STANZA);
            String queueManagerName = QueueManager.parseStanzaAttributes(t, QUEUE_MANAGER_STANZA, QUEUE_MANAGER_STANZA_KEY, response);
            if (queueManagerName != null) {
                if (!includeStandy) {
                    if (!QueueManager.isStandby(t, queueManagerName)) {
                        queueManagers.add(queueManagerName);
                    }
                } else {
                    queueManagers.add(queueManagerName);
                }
            }
            while (queueManagerName != null) {
                String response1 = NativeCalls.getRepeatingAttrs(t, null, QUEUE_MANAGER_STANZA, QUEUE_MANAGER_STANZA_KEY, queueManagerName);
                if ((queueManagerName = QueueManager.parseStanzaAttributes(t, QUEUE_MANAGER_STANZA, QUEUE_MANAGER_STANZA_KEY, response1)) == null) continue;
                if (!includeStandy) {
                    if (QueueManager.isStandby(t, queueManagerName)) continue;
                    queueManagers.add(queueManagerName);
                    continue;
                }
                queueManagers.add(queueManagerName);
            }
        }
        catch (CommonServicesException e) {
            if (Trace.isTracing) {
                t.data(64, "QueueManager.getListOfQueueManagers", 900, "Error geting list of queue manangers" + Common.LINE_SEPARATOR + e);
            }
            t.exit(64, "QueueManager.getListOfQueueManagers");
            throw e;
        }
        t.exit(64, "QueueManager.getListOfQueueManagers");
        return queueManagers;
    }

    private static boolean isStandby(Trace t, String qm) {
        boolean standby = false;
        int i = NativeCalls.getQueueManagerStatus(t, qm);
        switch (i) {
            case 13: 
            case 14: {
                standby = true;
                break;
            }
        }
        return standby;
    }

    public static String getQueueManagerKey(Trace t, String qm, String key) {
        String prefix;
        block4: {
            String fid = "QueueManager.getQueueManagerKey";
            prefix = null;
            t.entry(64, "QueueManager.getQueueManagerKey");
            try {
                String response = NativeCalls.getAttrs(t, null, QUEUE_MANAGER_STANZA);
                String repeatingValue = QueueManager.parseStanzaAttributes(t, QUEUE_MANAGER_STANZA, QUEUE_MANAGER_STANZA_KEY, response);
                if (repeatingValue != null && repeatingValue.equals(qm)) {
                    String pr;
                    prefix = pr = QueueManager.parseStanzaAttributes(t, QUEUE_MANAGER_STANZA, key, response);
                    break block4;
                }
                while (repeatingValue != null) {
                    String pr;
                    String response1 = NativeCalls.getRepeatingAttrs(t, null, QUEUE_MANAGER_STANZA, QUEUE_MANAGER_STANZA_KEY, repeatingValue);
                    if ((repeatingValue = QueueManager.parseStanzaAttributes(t, QUEUE_MANAGER_STANZA, QUEUE_MANAGER_STANZA_KEY, response1)) == null || !repeatingValue.equals(qm)) continue;
                    prefix = pr = QueueManager.parseStanzaAttributes(t, QUEUE_MANAGER_STANZA, key, response1);
                    break;
                }
            }
            catch (CommonServicesException e) {
                if (!Trace.isTracing) break block4;
                t.data(64, "QueueManager.getQueueManagerKey", 900, "Error geting list of queue manangers" + Common.LINE_SEPARATOR + e);
            }
        }
        t.exit(64, "QueueManager.getQueueManagerKey");
        return prefix;
    }

    public static String getDefaultQueueManager(Trace t) throws CommonServicesException {
        String fid = "QueueManager.getDefaultQueueManager";
        String defaultQueueManager = null;
        t.entry(64, "QueueManager.getDefaultQueueManager");
        try {
            String response = NativeCalls.getAttrs(t, null, DEFAULT_QUEUE_MANAGER_STANZA);
            defaultQueueManager = QueueManager.parseStanzaAttributes(t, DEFAULT_QUEUE_MANAGER_STANZA, QUEUE_MANAGER_STANZA_KEY, response);
        }
        catch (CommonServicesException e) {
            if (Trace.isTracing) {
                t.data(64, "QueueManager.getDefaultQueueManager", 900, "Error geting default queue mananger name" + Common.LINE_SEPARATOR + e);
            }
            t.exit(64, "QueueManager.getDefaultQueueManager");
            throw e;
        }
        t.exit(64, "QueueManager.getDefaultQueueManager");
        return defaultQueueManager;
    }

    public static boolean isQueueManagerRunning(Trace t, String qmgr) {
        return NativeCalls.isQueueManagerRunning(t, qmgr);
    }

    public static boolean isLocalQueueManager(Trace t, String qmgr) throws CommonServicesException {
        String fid = "QueueManager.isLocalQueueManager";
        boolean isLocal = false;
        t.entry(64, "QueueManager.isLocalQueueManager");
        try {
            ArrayList list = QueueManager.getListOfQueueManagers(t);
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get(i).equals(qmgr)) continue;
                isLocal = true;
                break;
            }
        }
        catch (CommonServicesException e) {
            if (Trace.isTracing) {
                t.data(64, "QueueManager.isLocalQueueManager", 900, "Error determining local queue mananger name" + Common.LINE_SEPARATOR + e);
            }
            t.exit(64, "QueueManager.isLocalQueueManager");
            throw e;
        }
        t.exit(64, "QueueManager.isLocalQueueManager");
        return isLocal;
    }

    private static String parseStanzaAttributes(Trace t, String stanzaName, String repeatingKey, String attrs) throws CommonServicesException {
        String fid = "QueueManager.parseStanzaAttributes";
        String repeatingValue = null;
        String attributeString = null;
        t.entry(64, fid);
        if (attrs != null) {
            StringTokenizer st1 = new StringTokenizer(attrs, XCSPRA_DELIMIT_1);
            try {
                if (XCSPRA_DELIMIT_1.indexOf(attrs.charAt(0)) == -1 && st1.hasMoreTokens()) {
                    attributeString = st1.nextToken();
                    StringTokenizer st2 = new StringTokenizer(attributeString, XCSPRA_DELIMIT_0, true);
                    while (st2.hasMoreTokens()) {
                        String key = st2.nextToken();
                        if (st2.hasMoreTokens()) {
                            st2.nextToken();
                            String value = st2.nextToken();
                            if (value.equals(XCSPRA_DELIMIT_0)) {
                                value = "";
                            } else {
                                st2.nextToken();
                            }
                            if (!key.equals(repeatingKey)) continue;
                            repeatingValue = value;
                            continue;
                        }
                        if (!Trace.isTracing) continue;
                        t.data(64, fid, 900, "No attribute matching for " + stanzaName + ":" + key);
                    }
                }
            }
            catch (NoSuchElementException nsee) {
                if (Trace.isTracing) {
                    t.data(64, fid, 900, "NoSuchElementException error for " + stanzaName + ", string=" + attributeString);
                }
                t.exit(64, fid);
                throw new CommonServicesException(CommonServices.getSystemMessage("AMQ4172"), "AMQ4172", 50014, 0, 30);
            }
        }
        t.exit(64, fid);
        return repeatingValue;
    }
}

