/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.utils;

import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.NativeCalls;
import java.io.File;

public final class QueryValue {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2009";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.commonservices/src/com/ibm/mq/commonservices/internal/utils/QueryValue.java, javagui, p701, p701-112-140304  1.39.1.1 09/08/15 17:45:16";
    public static final int XCSQUERYVALUE = 0;
    public static final int XCSQUERYVALUEFORSUBPOOL = 1;
    public static final int XCSMQVERSION = 1;
    public static final int XCSCMVCLEVEL = 2;
    public static final int XCSBUILDTYPE = 3;
    public static final int XCSCODETITLE = 4;
    public static final int XCSUSERID = 1;
    public static final int XCSPID = 2;
    public static final int XCSEXECLIB = 3;
    public static final int XCSTERMINATE_REQUEST = 4;
    public static final int XCSACCOUNTING_CODE = 5;
    public static final int XCSDATALIB = 6;
    public static final int XCSGROUPID = 7;
    public static final int XCSQUEUE_MGR = 8;
    public static final int XCSALL_ATTR = 9;
    public static final int XCSGENERAL_DATALIB = 10;
    public static final int XCSPID_STRING = 11;
    public static final int XCSPROGRAM_NAME = 12;
    public static final int XCSDLL_LIB = 13;
    public static final int XCSINSTALL_LIB = 14;
    public static final int XCSSECURITY_ID = 15;
    public static final int XCSCREATORPID = 16;
    public static final int XCSQMGR_LIB = 17;
    public static final int XCSCS_LIB = 18;
    public static final int XCSERRORLIB = 19;
    public static final int XCSJAVA_LIB = 20;
    public static final int XCSECLIPSE_LIB = 21;
    public static final int XCSGSKIT_JAVA_LIB = 22;
    public static final int XCSIKEYMAN_LIB = 23;
    public static final int XCSFTA_JAVA_LIB = 26;
    public static final int XCSJAVA_BIN = 27;
    public static final int XCSPRA_SUPPORTED_VERSION = 1;
    public static final int DEFAULT_COMMAND_LEVEL = 700;
    private static final String EXITS_DIR = "exits";

    public static String queryInstallDir(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 1, 14);
    }

    public static String queryJavaLib(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 1, 20);
    }

    public static String queryGeneralDataLib(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 1, 10);
    }

    public static String queryCMVCLevel(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 0, 2);
    }

    public static String queryGSKitJavaLib(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 1, 22);
    }

    public static String queryJavaBin(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 1, 27);
    }

    public static String queryEclipseDir(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 1, 21);
    }

    public static String queryDllDir(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 1, 13);
    }

    public static String queryExecDir(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 1, 3);
    }

    public static int queryVersion(Trace t) throws CommonServicesException {
        String fid = "QueryValue.queryVersion";
        String value = null;
        int version = 700;
        t.entry(64, "QueryValue.queryVersion");
        try {
            value = QueryValue.parseVersion(t, NativeCalls.queryValue(t, 0, 1));
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            if (Trace.isTracing) {
                t.data(64, "QueryValue.queryVersion", 900, "Error coverting version : " + value);
            }
        }
        catch (CommonServicesException e) {
            t.exit(64, "QueryValue.queryVersion", e.getReasonCode());
            throw e;
        }
        t.exit(64, "QueryValue.queryVersion", 0);
        return version;
    }

    public static String queryVersionAsString(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 0, 1);
    }

    public static String queryIKeyManLib(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 1, 23);
    }

    public static String queryIKeyManProgram(Trace t) throws CommonServicesException {
        String fid = "QueryValue.queryIKeyManProgram";
        t.entry(64, "QueryValue.queryIKeyManProgram");
        StringBuffer buffer = new StringBuffer();
        try {
            if (CommonServices.isMqjbnd()) {
                buffer.append(QueryValue.queryIKeyManLib(t));
                buffer.append(File.separator);
                buffer.append("gsk7ikm");
                String platform = System.getProperty("os.name");
                if (platform.startsWith("Windows")) {
                    buffer.append(".exe");
                }
            }
        }
        catch (CommonServicesException e) {
            t.exit(64, "QueryValue.queryIKeyManProgram", e.getReasonCode());
            throw e;
        }
        t.exit(64, "QueryValue.queryIKeyManProgram", 0);
        return buffer.toString();
    }

    public static String queryBuildType(Trace t) throws CommonServicesException {
        return NativeCalls.queryValue(t, 0, 3);
    }

    public static String parseVersion(Trace t, String value) {
        String fid = "QueryValue.parseVersion";
        StringBuffer sb = new StringBuffer();
        t.entry(64, "QueryValue.parseVersion");
        char c = value.charAt(0);
        if (Character.isDigit(c)) {
            sb.append(c);
        }
        if (Character.isDigit(c = value.charAt(2))) {
            sb.append(c);
        }
        if (Character.isDigit(c = value.charAt(4))) {
            sb.append(c);
        }
        if (sb.length() != 3) {
            t.exit(64, "QueryValue.parseVersion", 50018);
            return "";
        }
        t.exit(64, "QueryValue.parseVersion");
        return sb.toString();
    }

    public static String queryExitsDir(Trace t) throws CommonServicesException {
        return QueryValue.queryGeneralDataLib(t) + File.separator + EXITS_DIR + File.separator;
    }

    private QueryValue() {
    }
}

