/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.utils;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.ConnectionName;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ConnectionNameList {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2009";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.commonservices/src/com/ibm/mq/commonservices/internal/utils/ConnectionNameList.java, javagui, p701, p701-112-140304  1.2.1.1 09/08/16 23:24:30";
    private ArrayList listOfConnNames;

    public ConnectionNameList(Trace t, String conn) throws NumberFormatException {
        String fid = "ConnectionNameList.ConnectionNameList";
        t.entry(64, "ConnectionNameList.ConnectionNameList");
        if (Trace.isTracing) {
            t.data(64, "ConnectionNameList.ConnectionNameList", 300, "Connection names are " + conn);
        }
        this.listOfConnNames = new ArrayList();
        StringTokenizer tok = new StringTokenizer(conn, ",");
        while (tok.hasMoreElements()) {
            String s = tok.nextToken();
            try {
                ConnectionName cn = new ConnectionName(t, s);
                this.listOfConnNames.add(cn);
            }
            catch (NumberFormatException e) {
                t.exit(64, "ConnectionNameList.ConnectionNameList");
                throw e;
            }
        }
        t.exit(64, "ConnectionNameList.ConnectionNameList");
    }

    public ConnectionNameList(Trace t, String[] conn) throws NumberFormatException {
        String fid = "ConnectionNameList.ConnectionNameList";
        t.entry(64, "ConnectionNameList.ConnectionNameList");
        this.listOfConnNames = new ArrayList();
        for (int i = 0; i < conn.length; ++i) {
            try {
                ConnectionName cn = new ConnectionName(t, conn[i]);
                this.listOfConnNames.add(cn);
                continue;
            }
            catch (NumberFormatException e) {
                t.exit(64, "ConnectionNameList.ConnectionNameList");
                throw e;
            }
        }
        t.exit(64, "ConnectionNameList.ConnectionNameList");
    }

    public ConnectionNameList(Trace t, ArrayList conn) throws NumberFormatException {
        String fid = "ConnectionNameList.ConnectionNameList";
        t.entry(64, "ConnectionNameList.ConnectionNameList");
        this.listOfConnNames = new ArrayList();
        for (int i = 0; i < conn.size(); ++i) {
            try {
                ConnectionName cn = new ConnectionName(t, (String)conn.get(i));
                this.listOfConnNames.add(cn);
                continue;
            }
            catch (NumberFormatException e) {
                t.exit(64, "ConnectionNameList.ConnectionNameList");
                throw e;
            }
            catch (ClassCastException e) {
                t.exit(64, "ConnectionNameList.ConnectionNameList");
                throw e;
            }
        }
        t.exit(64, "ConnectionNameList.ConnectionNameList");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int size = this.listOfConnNames.size();
        for (int i = 0; i < size; ++i) {
            stringBuffer.append(((ConnectionName)this.listOfConnNames.get(i)).toString());
            if (size <= 1 || i >= size - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectionNameList) {
            ConnectionNameList cnl = (ConnectionNameList)obj;
            ArrayList list = cnl.getListOfConnNames();
            for (int i = 0; i < this.listOfConnNames.size(); ++i) {
                ConnectionName cn = (ConnectionName)this.listOfConnNames.get(i);
                if (!list.contains(cn)) continue;
                return true;
            }
        }
        return false;
    }

    public ArrayList getListOfConnNames() {
        return this.listOfConnNames;
    }

    public int size() {
        return this.listOfConnNames.size();
    }

    public ConnectionName get(int i) {
        if (this.listOfConnNames.size() > 0) {
            return (ConnectionName)this.listOfConnNames.get(i);
        }
        return null;
    }
}

