/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.utils;

import com.ibm.mq.commonservices.internal.trace.Trace;

public class ConnectionName {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2009";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.commonservices/src/com/ibm/mq/commonservices/internal/utils/ConnectionName.java, javagui, p701, p701-112-140304  1.2.1.1 09/08/16 23:24:40";
    private String host;
    private int port;

    public ConnectionName(Trace t, String name) throws NumberFormatException {
        String fid = "ConnectionName.ConnectionName";
        t.entry(64, "ConnectionName.ConnectionName");
        if (Trace.isTracing) {
            t.data(64, "ConnectionName.ConnectionName", 300, "Connection name is " + name);
        }
        this.host = name;
        this.port = 1414;
        int i = name.indexOf("(");
        if (i != -1) {
            this.host = name.substring(0, i);
            int j = name.indexOf(")");
            if (j != -1) {
                try {
                    this.port = Integer.parseInt(name.substring(i + 1, j));
                }
                catch (NumberFormatException e) {
                    t.exit(64, "ConnectionName.ConnectionName");
                    throw e;
                }
            }
        }
        t.exit(64, "ConnectionName.ConnectionName");
    }

    public String toString() {
        return this.host + "(" + this.port + ")";
    }

    public boolean equals(Object obj) {
        ConnectionName cn;
        return obj instanceof ConnectionName && this.host.equalsIgnoreCase((cn = (ConnectionName)obj).getHost()) && this.port == cn.getPort();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

