/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.utils;

import com.ibm.mq.commonservices.Common;
import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.monitor.TraceMonitor;
import com.ibm.mq.commonservices.internal.trace.AMQLogger;
import com.ibm.mq.commonservices.internal.trace.Detail;
import com.ibm.mq.commonservices.internal.trace.EventLogger;
import com.ibm.mq.commonservices.internal.trace.Names;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.trace.TraceFormatter;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.commonservices.internal.utils.NativeCalls;
import com.ibm.mq.commonservices.internal.utils.QueryValue;
import com.ibm.mq.commonservices.internal.utils.RASProperties;
import java.io.File;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CommonServices {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2009";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.commonservices/src/com/ibm/mq/commonservices/internal/utils/CommonServices.java, javagui, p701, p701-112-140304  1.120.1.2 10/02/26 17:32:33";
    private static final String MQENVIRONMENT_CLASS = "com.ibm.mq.MQEnvironment";
    private static final String MQENVIRONMENT_ENABLE_TRACE_METHOD = "enableTracing";
    private static final String MQENVIRONMENT_DISABLE_TRACE_METHOD = "disableTracing";
    private static Class mqEnvironment = null;
    public static boolean isWMQJavaEnabled = false;
    public static final int PLATFORM_ID = CommonServices.determinePlatform();
    public static final String SYSTEM_MESSAGE_FILE = "com.ibm.mq.commonservices.internal.utils.systemMessages";
    public static final String PLATFORM_MODULE_EXTENSION = CommonServices.getPlatformModuleExtension();
    public static boolean isCommonServicesAvailable = false;
    public static boolean isServerJniLibraryAvailable = false;
    public static boolean isJLogTraceAvailable = false;
    public static int buildType = 32;
    private static Logger traceLogger = null;
    private static ConsoleHandler consoleHandler = null;
    private static FileHandler traceFileHandler = null;
    private static File workingDir = null;
    public static String handlesFilename = null;
    private static String traceFilename = null;
    private static EventLogger dmEventLogger = null;
    private static EventLogger uiEventLogger = null;
    public static boolean traceEnabled = false;
    private static Message systemMessage = null;
    public static Hashtable eventLoggers = new Hashtable(2);
    private static final String TRACE_LOGGER_ID = "com.ibm.mq.commonservices";
    private static int mqInstallType = -1;
    private static boolean mqjbnd = false;
    private static final String errorsDirectoryName = "errors";
    private static final String traceDirectoryName = "trace";
    private static Hashtable traceNames = new Hashtable();
    private static Hashtable traceNamesHashTable = new Hashtable();
    private static RASProperties rasProperties = new RASProperties();
    private static AMQLogger amqLogger = null;
    private static TraceMonitor traceMonitor = null;
    private static boolean isProcessInit = false;
    static /* synthetic */ Class class$java$io$OutputStream;

    private CommonServices() {
    }

    public static Message loadSystemMessages(Trace t) throws CommonServicesException {
        String fid = "CommonServices.loadSystemMessages";
        Message msgFile = null;
        try {
            msgFile = new Message(t, SYSTEM_MESSAGE_FILE);
        }
        catch (Exception e) {
            if (Trace.isTracing) {
                t.data(64, "CommonServices.loadSystemMessages", 900, "Error loading system messages : " + e.toString());
            }
            t.exit(64, "CommonServices.loadSystemMessages", 50026);
            throw new CommonServicesException(t, "Error loading system messages file com.ibm.mq.commonservices.internal.utils.systemMessages", "AMQ4578", 50026, 0, 40);
        }
        return msgFile;
    }

    public static void processInitialize(Trace t) throws CommonServicesException {
        String fid = "CommonServices.processInitialize";
        t.entry(64, "CommonServices.processInitialize");
        if (!isProcessInit) {
            isProcessInit = true;
            systemMessage = CommonServices.loadSystemMessages(t);
            CommonServices.processRASProperties(t);
            isCommonServicesAvailable = CommonServices.loadCommonServices(t);
            traceMonitor = CommonServices.getTraceMonitor(t);
            if (isCommonServicesAvailable) {
                buildType = CommonServices.determineBuildType(t);
                mqInstallType = CommonServices.loadServerJniLibrary(t) ? 1 : (CommonServices.checkClientDll(t) ? 2 : 3);
            } else {
                mqInstallType = 3;
            }
            mqjbnd = CommonServices.checkJavaDll(t);
            isJLogTraceAvailable = CommonServices.loadJLogServices(t);
            if (isCommonServicesAvailable) {
                try {
                    int rc = NativeCalls.xcsProcInit(0);
                    if (rc != 0) {
                        if (Trace.isTracing) {
                            t.data(64, "CommonServices.processInitialize", 900, "Error " + rc + " from xcsProcessInitialize()");
                        }
                        t.exit(64, "CommonServices.processInitialize", 50018);
                        throw new CommonServicesException(t, CommonServices.getSystemMessage(t, "AMQ4577"), "AMQ4577", 50018, 0, 40);
                    }
                }
                catch (UnsatisfiedLinkError ule) {
                    if (Trace.isTracing) {
                        t.data(64, "CommonServices.processInitialize", 900, "Error loading common services\n" + ule.toString());
                    }
                    t.exit(64, "CommonServices.processInitialize", 50018);
                    throw new CommonServicesException(t, CommonServices.getSystemMessage(t, "AMQ4579"), "AMQ4579", 50018, 0, 40);
                }
            }
            if (Trace.isTracing) {
                t.dataBox(64, "CommonServices.processInitialize", new String[]{"Plug-in name     : com.ibm.mq.commonservices"});
            }
        } else if (Trace.isTracing) {
            t.data(64, "CommonServices.processInitialize", 900, "Common services process initialize already called");
        }
        t.exit(64, "CommonServices.processInitialize", 0);
    }

    private static boolean checkJavaDll(Trace t) {
        boolean retValue = false;
        String libraryName = null;
        switch (PLATFORM_ID) {
            case 1: {
                libraryName = "mqjbnd";
                break;
            }
            case 4: {
                libraryName = "mqjbnd";
                break;
            }
            default: {
                libraryName = "mqjbnd";
            }
        }
        retValue = CommonServices.checkDLL(t, libraryName);
        return retValue;
    }

    private static boolean checkClientDll(Trace t) {
        boolean retValue = false;
        String libraryName = null;
        switch (PLATFORM_ID) {
            case 1: {
                libraryName = "mqic";
                break;
            }
            case 4: {
                libraryName = "mqic";
                break;
            }
            default: {
                libraryName = "mqic_r";
            }
        }
        retValue = CommonServices.checkDLL(t, libraryName);
        return retValue;
    }

    public static boolean processTerminate(Trace t) {
        String fid = "CommonServices.processTerminate";
        t.entry(64, "CommonServices.processTerminate");
        new Thread(){

            public void run() {
                Trace trace;
                block8: {
                    trace = Trace.getDefault();
                    if (Trace.isTracing) {
                        trace.data(64, "CommonServices.processTerminate", 300, "Closing common services");
                    }
                    this.setName("WebSphere MQ closing common services");
                    try {
                        int rc = NativeCalls.xcsProcTerm(0);
                        if (rc != 0 && Trace.isTracing) {
                            trace.data(64, "CommonServices.processTerminate", 900, "Error " + rc + " terminating common services");
                        }
                    }
                    catch (UnsatisfiedLinkError ule) {
                        if (!Trace.isTracing) break block8;
                        trace.data(64, "CommonServices.processTerminate", 900, "Error terminating common services");
                    }
                }
                if (traceMonitor != null) {
                    traceMonitor.close(trace);
                }
                if (amqLogger != null) {
                    amqLogger.close(trace);
                }
                if (consoleHandler != null) {
                    consoleHandler.close();
                }
                if (traceFileHandler != null) {
                    traceFileHandler.close();
                }
            }
        }.start();
        t.exit(64, "CommonServices.processTerminate");
        return true;
    }

    public static boolean threadInitialize(Trace t) {
        String fid = "CommonServices.threadInitialize";
        t.entry(64, "CommonServices.threadInitialize");
        if (isCommonServicesAvailable) {
            try {
                int rc = NativeCalls.xcsThreadInit(0);
                if (rc != 0) {
                    if (Trace.isTracing) {
                        t.data(64, "CommonServices.threadInitialize", 900, "Error " + rc + "initializing common services");
                    }
                    t.exit(64, "CommonServices.threadInitialize", 50018);
                    return false;
                }
            }
            catch (UnsatisfiedLinkError ule) {
                if (Trace.isTracing) {
                    t.data(64, "CommonServices.threadInitialize", 900, "Error initializing common services\n" + ule.toString());
                }
                t.exit(64, "CommonServices.threadInitialize", 50018);
                return false;
            }
        }
        t.exit(64, "CommonServices.threadInitialize", 0);
        return true;
    }

    public static boolean threadTerminate(Trace t) {
        String fid = "CommonServices.threadTerminate";
        boolean retValue = true;
        t.entry(64, "CommonServices.threadTerminate");
        try {
            int rc = NativeCalls.xcsThreadTerm(0);
            if (rc != 0) {
                if (Trace.isTracing) {
                    t.data(64, "CommonServices.threadTerminate", 900, "Error " + rc + "terminating common services");
                }
                t.exit(64, "CommonServices.threadTerminate", 50019);
                return false;
            }
        }
        catch (UnsatisfiedLinkError ule) {
            if (Trace.isTracing) {
                t.data(64, "CommonServices.threadTerminate", 900, "Error terminating common services\n" + ule.toString());
            }
            t.exit(64, "CommonServices.threadTerminate", 50019);
            return false;
        }
        t.exit(64, "CommonServices.threadTerminate", 0);
        return retValue;
    }

    public static String getPlatformModuleExtension() {
        String extension = ".so";
        switch (PLATFORM_ID) {
            case 1: {
                extension = ".dll";
                break;
            }
            case 3: {
                extension = ".a";
                break;
            }
            case 2: {
                extension = ".sl";
                break;
            }
        }
        return extension;
    }

    public static boolean loadCommonServices(Trace t) {
        String fid = "CommonServices.loadCommonServices";
        boolean retValue = false;
        t.entry(64, "CommonServices.loadCommonServices");
        if (isCommonServicesAvailable) {
            if (Trace.isTracing) {
                t.data(64, "CommonServices.loadCommonServices", 300, "Common services already loaded");
            }
            t.exit(64, "CommonServices.loadCommonServices", 0);
            return true;
        }
        String jniLibraryName = null;
        switch (PLATFORM_ID) {
            case 1: {
                jniLibraryName = "amqjxcoa";
                break;
            }
            case 4: {
                jniLibraryName = "mqjx";
                break;
            }
            default: {
                jniLibraryName = "mqjx_r";
            }
        }
        retValue = CommonServices.loadDLL(t, jniLibraryName);
        t.exit(64, "CommonServices.loadCommonServices");
        return retValue;
    }

    public static boolean loadServerJniLibrary(Trace t) {
        String fid = "CommonServices.loadServerJniLibrary";
        boolean retValue = false;
        t.entry(64, "CommonServices.loadServerJniLibrary");
        if (isServerJniLibraryAvailable) {
            if (Trace.isTracing) {
                t.data(64, "CommonServices.loadServerJniLibrary", 300, "Server JNI Library already loaded");
            }
            t.exit(64, "CommonServices.loadServerJniLibrary", 0);
            return true;
        }
        String jniLibraryName = null;
        switch (PLATFORM_ID) {
            case 1: {
                jniLibraryName = "amqjxs";
                break;
            }
            case 4: {
                jniLibraryName = "mqjxs";
                break;
            }
            default: {
                jniLibraryName = "mqjxs_r";
            }
        }
        retValue = CommonServices.loadDLL(t, jniLibraryName);
        t.exit(64, "CommonServices.loadServerJniLibrary");
        return retValue;
    }

    public static boolean checkDLL(Trace t, String dllName) {
        String fid = "CommonServices.checkDLL";
        boolean retValue = false;
        String prefix = "";
        t.entry(64, "CommonServices.checkDLL");
        String mappedName = System.mapLibraryName(dllName);
        String libPath = CommonServices.getSystemProperty(t, "java.library.path", null);
        String pathSep = CommonServices.getSystemProperty(t, "path.separator", null);
        if (libPath != null) {
            StringTokenizer strTok = new StringTokenizer(libPath, pathSep);
            if (mappedName.startsWith("lib") && !dllName.startsWith("lib")) {
                prefix = "lib";
            }
            if (!(retValue = CommonServices.fileExists(t, mappedName, strTok))) {
                if (mappedName.endsWith(".so")) {
                    strTok = new StringTokenizer(libPath, pathSep);
                    retValue = CommonServices.fileExists(t, prefix + dllName + ".a", strTok);
                } else if (mappedName.endsWith(".a")) {
                    strTok = new StringTokenizer(libPath, pathSep);
                    retValue = CommonServices.fileExists(t, prefix + dllName + ".so", strTok);
                }
            }
        }
        t.exit(64, "CommonServices.checkDLL", 0);
        return retValue;
    }

    protected static String getSystemProperty(Trace t, String propertyName, String defaultValue) {
        String returnValue = defaultValue;
        final String propertyName_final = propertyName;
        final String defaultValue_final = defaultValue;
        try {
            returnValue = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(propertyName_final, defaultValue_final);
                }
            });
        }
        catch (AccessControlException ace) {
            t.data(64, "CommonServices.getSystemProperty", "AccessControlException reading " + propertyName + ": " + ace.getMessage());
        }
        return returnValue;
    }

    private static boolean fileExists(Trace t, final String name, final StringTokenizer list) {
        String fid = "CommonServices.checkDLL";
        boolean retValue = false;
        t.entry(64, "CommonServices.checkDLL");
        Boolean retValue_obj = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                boolean canRead = false;
                while (list.hasMoreTokens()) {
                    String path = list.nextToken();
                    String filename = path + File.separator + name;
                    File ftst = new File(filename);
                    try {
                        canRead = ftst.canRead();
                    }
                    catch (AccessControlException ace) {
                        // empty catch block
                    }
                    if (!canRead) continue;
                    break;
                }
                return new Boolean(canRead);
            }
        });
        if (retValue_obj != null) {
            retValue = retValue_obj;
        }
        t.exit(64, "CommonServices.checkDLL", 0);
        return retValue;
    }

    public static boolean loadDLL(Trace t, String dllName) {
        boolean retValue;
        block6: {
            String fid = "CommonServices.loadDLL";
            retValue = false;
            t.entry(64, "CommonServices.loadDLL");
            try {
                System.loadLibrary(dllName);
                retValue = true;
            }
            catch (UnsatisfiedLinkError ule) {
                if (Trace.isTracing) {
                    t.data(64, "CommonServices.loadDLL", 1000, "Error loading runtiume library : " + ule.toString());
                }
                if (rasProperties.isTracingSystemErr()) {
                    System.err.println(ule);
                }
            }
            catch (SecurityException se) {
                if (Trace.isTracing) {
                    t.data(64, "CommonServices.loadDLL", 1000, "Error loading runtiume library : " + se.toString());
                }
                if (!rasProperties.isTracingSystemErr()) break block6;
                System.err.println(se);
            }
        }
        t.exit(64, "CommonServices.loadDLL", 0);
        return retValue;
    }

    private static int determinePlatform() {
        int retValue = 0;
        if (Common.osName.startsWith("WINDOWS")) {
            return 1;
        }
        if (Common.osName.startsWith("AIX")) {
            return 3;
        }
        if (Common.osName.startsWith("SUNOS")) {
            return 4;
        }
        if (Common.osName.startsWith("HP-UX")) {
            return 2;
        }
        if (Common.osName.startsWith("LINUX")) {
            return 5;
        }
        if (Common.osName.startsWith("OS/390")) {
            return 9;
        }
        if (Common.osName.startsWith("Z/OS")) {
            return 9;
        }
        return retValue;
    }

    private static int determineBuildType(Trace t) {
        try {
            String buildTypeString = QueryValue.queryBuildType(t);
            if (buildTypeString.startsWith("IKAP")) {
                return 8;
            }
            if (buildTypeString.startsWith("ITST")) {
                return 16;
            }
            if (buildTypeString.startsWith("ICOL")) {
                return Integer.MIN_VALUE;
            }
            if (buildTypeString.startsWith("IUSR")) {
                return -2147483647;
            }
            if (buildTypeString.startsWith("DEBUG")) {
                return -2147483646;
            }
        }
        catch (CommonServicesException commonServicesException) {
            // empty catch block
        }
        return 32;
    }

    public static boolean isProductionBuild(Trace t) {
        return (buildType & Integer.MIN_VALUE) == 0;
    }

    private static boolean loadJLogServices(Trace t) {
        String fid = "CommonServices.loadJLogServices";
        if (isJLogTraceAvailable) {
            t.exit(64, "CommonServices.loadJLogServices", 0);
            return true;
        }
        try {
            traceLogger = Logger.getLogger(TRACE_LOGGER_ID);
            if (traceLogger == null) {
                if (Trace.isTracing) {
                    t.data(64, "CommonServices.loadJLogServices", 900, "Error intializing JLog logger");
                }
                return false;
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        traceLogger.setLevel(Level.ALL);
                        traceLogger.setUseParentHandlers(false);
                    }
                    catch (AccessControlException ace) {
                        System.err.println("Failed to enable trace logging: " + ace);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (Trace.isTracing) {
                t.data(64, "CommonServices.loadJLogServices", 900, "Error intializing JLog logger : " + e.toString());
            }
            return false;
        }
        isJLogTraceAvailable = true;
        return true;
    }

    public static boolean createEventLogger(Trace t, String name, String fileName, int id) {
        Integer key;
        EventLogger logger;
        String fid = "CommonServices.createEventLogger";
        t.entry(64, "CommonServices.createEventLogger");
        if (Trace.isTracing) {
            t.data(64, "CommonServices.createEventLogger", 300, "Creating logger " + name + "(" + id + "), using file " + fileName);
        }
        if ((logger = (EventLogger)eventLoggers.get(key = new Integer(id))) != null) {
            if (Trace.isTracing) {
                t.data(64, "CommonServices.createEventLogger", 900, "Creating logger " + name + "(" + id + ") already exists");
            }
            t.exit(64, "CommonServices.createEventLogger");
            return false;
        }
        logger = new EventLogger(t, name, fileName);
        eventLoggers.put(key, logger);
        if (Trace.isTracing) {
            t.data(64, "CommonServices.createEventLogger", 900, "Creating logger " + name + "(" + id + ") created");
        }
        t.exit(64, "CommonServices.createEventLogger");
        return true;
    }

    public static void setWorkingDir(File dir) {
        workingDir = dir;
        handlesFilename = workingDir + File.separator + "WMQ_Handles.xml";
    }

    public static File getWorkingDir(Trace t) {
        return workingDir;
    }

    /*
     * Unable to fully structure code
     */
    public static void setJLogTraceLevel(Trace t, int i) {
        fid = "CommonServices.setJLogTraceLevel";
        t.entry(64, "CommonServices.setJLogTraceLevel");
        if (Trace.isTracing) {
            t.data(64, "CommonServices.setJLogTraceLevel", 300, "Setting JLog level : " + i);
        }
        if (i == 0x7FFFFFFF) {
            Trace.setUseJLogTrace(false);
        } else {
            Trace.setUseJLogTrace(true);
            CommonServices.setTraceComponents();
        }
        CommonServices.isJLogTraceAvailable = CommonServices.loadJLogServices(t);
        if (CommonServices.rasProperties.isTracingToFile()) {
            if (CommonServices.consoleHandler == null) {
                try {
                    CommonServices.consoleHandler = new ConsoleHandler();
                    CommonServices.consoleHandler.setFormatter(new TraceFormatter());
                    CommonServices.traceLogger.addHandler(CommonServices.consoleHandler);
                    if (!Trace.isTracing) ** GOTO lbl27
                    t.data(64, "CommonServices.setJLogTraceLevel", 300, "Created new console handler");
                }
                catch (Exception e) {
                    if (Trace.isTracing) {
                        t.data(64, "CommonServices.setJLogTraceLevel", 900, "Error intializing console handler : " + e.toString());
                    }
                    t.exit(64, "CommonServices.setJLogTraceLevel", 50027);
                    return;
                }
            } else if (Trace.isTracing) {
                t.data(64, "CommonServices.setJLogTraceLevel", 300, "Old level : " + CommonServices.consoleHandler.getLevel());
            }
lbl27:
            // 5 sources

            CommonServices.consoleHandler.setLevel(Detail.getLevel(i));
        }
        t.exit(64, "CommonServices.setJLogTraceLevel", 0);
    }

    public static void setJLogTraceLevel(Trace t, final int i, String fn) {
        String fid = "CommonServices.setJLogTraceLevel";
        t.entry(64, "CommonServices.setJLogTraceLevel");
        if (Trace.isTracing) {
            t.data(64, "CommonServices.setJLogTraceLevel", 300, "Setting JLog level : " + i);
        }
        if (i == Integer.MAX_VALUE) {
            Trace.setUseJLogTrace(false);
        } else {
            Trace.setUseJLogTrace(true);
            CommonServices.setTraceComponents();
        }
        isJLogTraceAvailable = CommonServices.loadJLogServices(t);
        if (traceFileHandler == null) {
            if (!CommonServices.createTraceFileHandler(t, fn)) {
                t.exit(64, "CommonServices.setJLogTraceLevel", 50027);
                return;
            }
        } else {
            if (Trace.isTracing) {
                t.data(64, "CommonServices.setJLogTraceLevel", 300, "Old level : " + traceFileHandler.getLevel());
            }
            if (!traceFilename.equals(fn)) {
                if (Trace.isTracing) {
                    t.data(64, "CommonServices.setJLogTraceLevel", 300, "Closing old file : " + traceFilename);
                }
                traceFileHandler.close();
                if (!CommonServices.createTraceFileHandler(t, fn)) {
                    t.exit(64, "CommonServices.setJLogTraceLevel", 50027);
                    return;
                }
            }
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                traceFileHandler.setLevel(Detail.getLevel(i));
                return null;
            }
        });
        traceFilename = fn;
        t.exit(64, "CommonServices.setJLogTraceLevel", 0);
    }

    private static boolean createTraceFileHandler(Trace t, final String fn) {
        String fid = "CommonServices.createTraceFileHandler";
        t.entry(64, "CommonServices.createTraceFileHandler");
        if (Trace.isTracing) {
            t.data(64, "CommonServices.createTraceFileHandler", 300, "New file handler name : " + fn);
        }
        try {
            Object anyException = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        traceFileHandler = new FileHandler(fn);
                    }
                    catch (Exception e) {
                        return e;
                    }
                    traceFileHandler.setFormatter(new TraceFormatter());
                    traceLogger.addHandler(traceFileHandler);
                    return null;
                }
            });
            if (anyException != null) {
                throw (Exception)anyException;
            }
            if (Trace.isTracing) {
                t.data(64, "CommonServices.createTraceFileHandler", 300, "Created new file handler");
            }
        }
        catch (Exception e) {
            if (Trace.isTracing) {
                t.data(64, "CommonServices.createTraceFileHandler", 900, "Error intializing file handler : " + e.toString());
            }
            t.exit(64, "CommonServices.createTraceFileHandler", 50027);
            System.err.println("Error intializing trace file handler : " + e.toString());
            return false;
        }
        t.exit(64, "CommonServices.createTraceFileHandler", 0);
        return true;
    }

    public static void setWMQTraceLevel(Trace t, int i) {
        String fid = "CommonServices.setWMQTraceLevel";
        t.entry(64, "CommonServices.setWMQTraceLevel");
        if (Trace.isTracing) {
            t.data(64, "CommonServices.setWMQTraceLevel", 300, "Setting WMQ trace level : " + i);
        }
        if (i == Integer.MAX_VALUE) {
            Trace.setUseWMQTrace(false);
        } else {
            Trace.setUseWMQTrace(true);
        }
        t.exit(64, "CommonServices.setWMQTraceLevel");
    }

    public static String getSystemMessage(Trace t, String id) {
        return CommonServices.getSystemMessage().getMessage(t, id);
    }

    public static String getSystemMessage(Trace t, String id, String insert1) {
        String[] s = new String[]{insert1};
        return CommonServices.getSystemMessage().getMessage(t, id, s);
    }

    public static String getSystemMessage(Trace t, String id, String[] inserts) {
        return CommonServices.getSystemMessage().getMessage(t, id, inserts);
    }

    public static String getSystemMessage(String id) {
        return CommonServices.getSystemMessage().getMessage(id);
    }

    public static Message getSystemMessage() {
        if (systemMessage == null) {
            try {
                systemMessage = CommonServices.loadSystemMessages(Trace.getDefault());
            }
            catch (CommonServicesException e) {
                e.printStackTrace();
            }
        }
        return systemMessage;
    }

    public static String getSystemMessage(String id, String insert1) {
        String[] s = new String[]{insert1};
        return CommonServices.getSystemMessage().getMessage(id, s);
    }

    public static String getSystemMessage(String id, String[] inserts) {
        return CommonServices.getSystemMessage().getMessage(id, inserts);
    }

    public static String getSystemMessageId(Trace t, int reasonCode) {
        String fid = "CommonServices.getSystemMessageId";
        t.entry(64, "CommonServices.getSystemMessageId");
        String messageId = null;
        String searchKey = "RC_" + reasonCode;
        messageId = CommonServices.getSystemMessage(t, searchKey);
        if (messageId == null || messageId.length() == 0 || messageId.equals(searchKey)) {
            messageId = "AMQ4999";
        }
        t.exit(64, "CommonServices.getSystemMessageId");
        return messageId;
    }

    public static int getSystemMessageSeverity(Trace t, String msgId) {
        String fid = "CommonServices.getSystemMessageSeverity";
        t.entry(64, "CommonServices.getSystemMessageSeverity");
        int severity = 20;
        String searchKey = msgId + ".SEVERITY";
        String sev = CommonServices.getSystemMessage(t, searchKey);
        try {
            severity = Integer.parseInt(sev);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        t.exit(64, "CommonServices.getSystemMessageSeverity");
        return severity;
    }

    public static Logger getTraceLogger() {
        return traceLogger;
    }

    public static EventLogger getEventLogger(int id) {
        EventLogger logger = (EventLogger)eventLoggers.get(new Integer(id));
        return logger;
    }

    public static int getMqInstallType() {
        return mqInstallType;
    }

    public static EventLogger getDmEventLogger() {
        return dmEventLogger;
    }

    public static EventLogger getUiEventLogger() {
        return uiEventLogger;
    }

    public static boolean isMqjbnd() {
        return mqjbnd;
    }

    public static boolean clearWMQFFSTandTrace(Trace t) {
        String mqDir = null;
        boolean success = false;
        try {
            mqDir = QueryValue.queryGeneralDataLib(t);
        }
        catch (CommonServicesException e) {
            return false;
        }
        if (mqDir != null) {
            File trace;
            String sep = File.separator;
            String errorsDir = mqDir + sep + errorsDirectoryName;
            String traceDir = mqDir + sep + traceDirectoryName;
            File err = new File(errorsDir);
            if (err.isDirectory()) {
                boolean result = true;
                File[] files = err.listFiles();
                for (int k = 0; k < files.length; ++k) {
                    if (files[k].delete()) continue;
                    result = false;
                }
                success = result;
            }
            if ((trace = new File(traceDir)).isDirectory()) {
                boolean result = true;
                File[] files = trace.listFiles();
                for (int k = 0; k < files.length; ++k) {
                    if (files[k].delete()) continue;
                    result = false;
                }
                if (success) {
                    success = result;
                }
            }
        }
        return success;
    }

    public static boolean registerTraceNames(int id, String[] names) {
        boolean saved = false;
        Integer key = new Integer(id);
        if (!traceNames.contains(key)) {
            traceNames.put(key, names);
            saved = true;
        }
        return saved;
    }

    public static String[] getListOfNames(int key) {
        Object table = traceNames.get(new Integer(key));
        if (table == null) {
            return null;
        }
        return (String[])table;
    }

    public static boolean registerTraceNames(int id, HashMap names) {
        boolean saved = false;
        Integer key = new Integer(id);
        if (!traceNamesHashTable.contains(key)) {
            traceNamesHashTable.put(key, names);
            saved = true;
        }
        return saved;
    }

    public static HashMap getHashMapOfNames(int key) {
        Object table = traceNamesHashTable.get(new Integer(key));
        if (table == null) {
            return null;
        }
        return (HashMap)table;
    }

    public static RASProperties getRASProperties() {
        if (rasProperties == null) {
            rasProperties = new RASProperties();
        }
        return rasProperties;
    }

    private static void processRASProperties(Trace t) {
        Trace.setUseWMQTrace(rasProperties.isTracingToWMQ());
        if (rasProperties.isTracingToFile()) {
            CommonServices.setJLogTraceLevel(t, rasProperties.getTraceDetail(), rasProperties.getTraceFilename());
        }
        if (rasProperties.isTracingToConsole()) {
            CommonServices.setJLogTraceLevel(t, rasProperties.getTraceDetail());
        }
        if ((rasProperties.isTracingToFile() || rasProperties.isTracingToConsole()) && amqLogger == null) {
            amqLogger = new AMQLogger(t, rasProperties);
        }
    }

    public static String setRASProperty(Trace t, String key, String value) {
        String oldValue = null;
        oldValue = rasProperties.setProperty(t, key, value);
        if (oldValue == null) {
            return null;
        }
        return oldValue;
    }

    public static void applyRASProperties(Trace t) {
        rasProperties.processProperties();
        CommonServices.processRASProperties(t);
    }

    public static boolean isTracingExplorer() {
        return rasProperties.isTracingExplorer();
    }

    public static boolean isTracingWMQJavaClasses() {
        return rasProperties.isTracingWMQJavaClasses();
    }

    public static boolean isTracingToWMQ() {
        return rasProperties.isTracingToWMQ();
    }

    public static void setTraceComponents() {
        if (rasProperties.isTracingAll() || rasProperties.isTracingExplorer()) {
            Trace.traceComponents = null;
            return;
        }
        int counter = 0;
        if (rasProperties.isTracingCommonServices()) {
            ++counter;
        }
        if (rasProperties.isTracingDataModel()) {
            ++counter;
        }
        if (rasProperties.isTracingFTA()) {
            ++counter;
        }
        if (rasProperties.isTracingPlugins()) {
            ++counter;
        }
        if (rasProperties.isTracingSoap()) {
            ++counter;
        }
        if (rasProperties.isTracingUI()) {
            ++counter;
        }
        if (rasProperties.isTracingWMQJavaClasses()) {
            counter += 3;
        }
        Trace.traceComponents = new int[counter];
        int index = 0;
        if (rasProperties.isTracingCommonServices()) {
            Trace.traceComponents[index++] = 64;
        }
        if (rasProperties.isTracingDataModel()) {
            Trace.traceComponents[index++] = 65;
        }
        if (rasProperties.isTracingFTA()) {
            Trace.traceComponents[index++] = 9;
        }
        if (rasProperties.isTracingPlugins()) {
            Trace.traceComponents[index++] = 66;
        }
        if (rasProperties.isTracingSoap()) {
            Trace.traceComponents[index++] = 49;
        }
        if (rasProperties.isTracingUI()) {
            Trace.traceComponents[index++] = 67;
        }
        if (rasProperties.isTracingWMQJavaClasses()) {
            Trace.traceComponents[index++] = 59;
            Trace.traceComponents[index++] = 60;
            Trace.traceComponents[index++] = 61;
        }
    }

    public static AMQLogger getAMQLogger() {
        return amqLogger;
    }

    public static TraceMonitor getTraceMonitor(Trace t) {
        TraceMonitor tm = null;
        tm = traceMonitor == null && CommonServices.isTracingToWMQ() ? new TraceMonitor(t, 10) : traceMonitor;
        return tm;
    }

    public static void stopTraceMonitor(Trace t) {
        if (traceMonitor != null) {
            traceMonitor.close(t);
            traceMonitor = null;
        }
    }

    public static void setWMQJavaTraceClass(Class cls) {
        mqEnvironment = cls;
    }

    private static Class getWMQJavaTraceClass(Trace t) {
        block3: {
            String fid = "CommonServices.getWMQJavaTraceClass";
            if (mqEnvironment == null) {
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    mqEnvironment = Class.forName(MQENVIRONMENT_CLASS, false, cl);
                }
                catch (ClassNotFoundException e) {
                    if (!Trace.isTracing) break block3;
                    t.data(64, "CommonServices.getWMQJavaTraceClass", 900, "Unable to find class com.ibm.mq.MQEnvironment");
                }
            }
        }
        return mqEnvironment;
    }

    public static void setWMQJavaClassesTraceLevel(Trace t, int level) {
        block17: {
            String fid = "CommonServices.setWMQJavaClassesTraceLevel";
            Method m = null;
            if (Trace.isTracing) {
                t.data(51, "CommonServices.setWMQJavaClassesTraceLevel", 300, "Setting WMQ Java Classes trace level to " + level);
            }
            try {
                if (CommonServices.getWMQJavaTraceClass(t) != null && mqEnvironment.getName().equals(MQENVIRONMENT_CLASS)) {
                    if (level == Integer.MAX_VALUE) {
                        m = mqEnvironment.getDeclaredMethod(MQENVIRONMENT_DISABLE_TRACE_METHOD, new Class[0]);
                        isWMQJavaEnabled = false;
                        if (m != null) {
                            m.invoke(null, (Object[])null);
                        } else if (Trace.isTracing) {
                            t.data(51, "CommonServices.setWMQJavaClassesTraceLevel", 900, "Unable to disable wmqjavaclasses trace - method disableTracing not found ");
                        }
                    } else if (!isWMQJavaEnabled) {
                        isWMQJavaEnabled = true;
                        m = mqEnvironment.getDeclaredMethod(MQENVIRONMENT_ENABLE_TRACE_METHOD, Integer.TYPE, class$java$io$OutputStream == null ? (class$java$io$OutputStream = CommonServices.class$("java.io.OutputStream")) : class$java$io$OutputStream);
                        if (m != null) {
                            m.invoke(null, new Integer(1), null);
                        } else {
                            if (Trace.isTracing) {
                                t.data(51, "CommonServices.setWMQJavaClassesTraceLevel", 900, "Unable to enable wmqjavaclasses trace - method enableTracing not found ");
                            }
                            isWMQJavaEnabled = false;
                        }
                    } else if (Trace.isTracing) {
                        t.data(51, "CommonServices.setWMQJavaClassesTraceLevel", 900, "wmqjavaclasses trace already enabled");
                    }
                }
            }
            catch (Exception e) {
                isWMQJavaEnabled = false;
                if (Trace.isTracing) {
                    t.data(51, "CommonServices.setWMQJavaClassesTraceLevel", 900, "Error setting WMQ Java Classes trace\n" + e);
                }
            }
            catch (ExceptionInInitializerError e) {
                isWMQJavaEnabled = false;
                if (!Trace.isTracing) break block17;
                t.data(51, "CommonServices.setWMQJavaClassesTraceLevel", 900, "Error setting WMQ Java Classes trace\n" + e);
            }
        }
    }

    public static void disablePreferences() {
        System.setProperty("java.util.prefs.PreferencesFactory", "com.ibm.mq.commonservices.internal.prefs.NoPreferencesFactory");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CommonServices.registerTraceNames(64, Names.getMethodNames());
    }
}

