/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BuildFeature {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2009";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.commonservices/src/com/ibm/mq/commonservices/internal/utils/BuildFeature.java, javagui, p701, p701-112-140304  1.8.2.1 09/08/15 19:43:31";
    public static ArrayList plugins = new ArrayList();

    public static void main(String[] args) {
        if (args.length < 5) {
            System.out.println("Check usage");
            System.exit(1);
        }
        String directory = args[0];
        String version = args[1];
        String outputfile = args[2];
        String featureid = args[3];
        ArrayList<String> imports = new ArrayList<String>();
        String pluginid = null;
        String imagename = null;
        String primary = null;
        String appid = null;
        System.out.println("Directory to scan: " + directory);
        System.out.println("Version number to use: " + version);
        System.out.println("Output filename: " + outputfile);
        System.out.println("Feature id: " + featureid);
        System.out.println("imports:");
        StringTokenizer st = new StringTokenizer(args[4], "/");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            System.out.println(token);
            imports.add(token);
        }
        if (args.length >= 6) {
            pluginid = args[5];
            System.out.println("Plugin id: " + pluginid);
        }
        if (args.length >= 7) {
            imagename = args[6];
            System.out.println("image: " + imagename);
        }
        if (args.length >= 8) {
            primary = args[7];
            System.out.println("primary: " + primary);
        }
        if (args.length >= 9) {
            appid = args[8];
            System.out.println("application id: " + appid);
        }
        System.out.println("Getting directory list..");
        File pf = new File(directory);
        String[] subs = pf.list();
        ArrayList<String> dirs = new ArrayList<String>(subs.length);
        for (int k = 0; k < subs.length; ++k) {
            String dirName = directory + "/" + subs[k];
            File f = new File(dirName);
            if (!f.isDirectory()) continue;
            dirs.add(subs[k]);
        }
        System.out.println("Found " + dirs.size() + " plugins");
        ArrayList pluginNames = BuildFeature.findPluginNames(dirs, directory);
        System.out.println("Creating output file");
        try {
            OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(new File(outputfile)));
            System.out.println("File created\nWriting xml header");
            osw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
            System.out.println("Writing feature information");
            osw.write("<feature\n");
            osw.write("  id=\"" + featureid + "\"\n");
            osw.write("  label=\"%featureName\"\n");
            osw.write("  version=\"" + version + "\"\n");
            osw.write("  provider-name=\"IBM\"\n");
            if (pluginid != null && pluginid.length() > 0) {
                osw.write("  plugin=\"" + pluginid + "\"\n");
            }
            if (imagename != null && imagename.length() > 0) {
                osw.write("  image=\"" + imagename + "\"\n");
            }
            if (primary != null && primary.length() > 0) {
                osw.write("  primary=\"" + primary + "\"\n");
            }
            if (appid != null && appid.length() > 0) {
                osw.write("  application=\"" + appid + "\"\n");
            }
            osw.write(">\n\n");
            osw.write("  <license url=\"%licenseURL\">%license</license>\n");
            osw.write("  <copyright>%copyright</copyright>\n\n");
            osw.write("  <requires>\n");
            Iterator i = imports.iterator();
            while (i.hasNext()) {
                String plugin = (String)i.next();
                int ind = plugin.indexOf(61);
                if (ind == -1) {
                    osw.write("    <import plugin=\"" + plugin + "\"/>\n");
                    continue;
                }
                String vers = plugin.substring(ind + 1);
                plugin = plugin.substring(0, ind);
                osw.write("    <import plugin=\"" + plugin + "\" version=\"" + vers + "\" match=\"compatible\"/>\n");
            }
            osw.write("  </requires>\n\n");
            System.out.println("Writing plugin information");
            i = pluginNames.iterator();
            while (i.hasNext()) {
                String id = (String)i.next();
                osw.write("  <plugin\n");
                osw.write("    id=\"" + id + "\"\n");
                osw.write("    download-size=\"0\"\n");
                osw.write("    install-size=\"0\"\n");
                if (!id.equals("com.ibm.mq.runtime")) {
                    osw.write("    unpack=\"false\"\n");
                }
                if (id.endsWith(".nl1")) {
                    osw.write("    fragment=\"true\"\n");
                }
                osw.write("    version=\"" + version + "\"/>\n");
                osw.write("\n");
            }
            osw.write("</feature>");
            osw.flush();
            osw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(2);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(3);
        }
        System.out.println("feature.xml creation complete.");
    }

    private static ArrayList findPluginNames(ArrayList dirs, String directory) {
        System.out.println("Getting plugin name list from plugin.xml files");
        Iterator i = dirs.iterator();
        while (i.hasNext()) {
            String pName = (String)i.next();
            String dirName = directory + "/" + pName;
            boolean found = false;
            File f = new File(dirName, "META-INF");
            if (f.canRead() && (f = new File(f, "MANIFEST.MF")).canRead()) {
                found = BuildFeature.parseManifest(f);
            }
            f = new File(dirName, "plugin.xml");
            if (!found && f.canRead()) {
                found = BuildFeature.parseXML(f);
            }
            if (found) continue;
            plugins.add(pName);
        }
        return plugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean parseManifest(File f) {
        symname = "Bundle-SymbolicName";
        reader = null;
        try {
            reader = new BufferedReader(new FileReader(f));
            line = reader.readLine();
            while (line != null) {
                block13: {
                    split = line.split("\\s*[:;]\\s*");
                    if (split.length <= 1 || !split[0].equals(symname)) break block13;
                    id = split[1];
                    BuildFeature.plugins.add(id);
                    var6_8 = true;
                    var8_9 = null;
                    if (reader == null) return var6_8;
                    ** GOTO lbl54
                }
                line = reader.readLine();
            }
            ** GOTO lbl60
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            var8_11 = null;
            if (reader == null) return false;
            try {
                reader.close();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            var8_12 = null;
            if (reader == null) return false;
            try {}
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            reader.close();
            return false;
        }
        {
            catch (Throwable var7_19) {
                var8_13 = null;
                if (reader == null) throw var7_19;
                ** try [egrp 2[TRYBLOCK] [9 : 130->137)] { 
lbl49:
                // 1 sources

                reader.close();
                throw var7_19;
lbl51:
                // 1 sources

                catch (IOException e) {
                    e.printStackTrace();
                }
                throw var7_19;
            }
lbl54:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [9 : 130->137)] { 
lbl55:
            // 1 sources

            reader.close();
            return var6_8;
lbl57:
            // 1 sources

            catch (IOException e) {
                e.printStackTrace();
            }
            return var6_8;
lbl60:
            // 1 sources

            var8_10 = null;
            if (reader == null) return false;
            try {}
            catch (IOException e) {}
            e.printStackTrace();
            return false;
            reader.close();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean parseXML(File f) {
        int sz;
        block20: {
            InputStreamReader reader = null;
            sz = plugins.size();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            reader = new FileReader(f);
            InputSource is = new InputSource(reader);
            is.setSystemId(f.getName());
            saxParser.parse(is, new DefaultHandler(){

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equals("plugin")) {
                        String id = attributes.getValue("id");
                        plugins.add(id);
                    }
                    super.startElement(uri, localName, qName, attributes);
                }
            });
            Object var7_10 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                break block20;
            }
            catch (Throwable e1) {
                System.err.println("finally throwable: " + e1.getMessage());
            }
            break block20;
            {
                catch (SAXException e) {
                    System.err.println("sax exception: " + e.getMessage());
                    Object var7_11 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block20;
                    }
                    catch (Throwable e1) {
                        System.err.println("finally throwable: " + e1.getMessage());
                    }
                    break block20;
                }
                catch (FileNotFoundException e) {
                    System.err.println("file not found: " + e.getMessage());
                    Object var7_12 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block20;
                    }
                    catch (Throwable e1) {
                        System.err.println("finally throwable: " + e1.getMessage());
                    }
                    break block20;
                }
                catch (IOException e) {
                    System.err.println("IO exception: " + e.getMessage());
                    Object var7_13 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block20;
                    }
                    catch (Throwable e1) {
                        System.err.println("finally throwable: " + e1.getMessage());
                    }
                    break block20;
                }
                catch (Throwable e) {
                    System.err.println("Throwable: " + e.getMessage());
                    Object var7_14 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block20;
                    }
                    catch (Throwable e1) {
                        System.err.println("finally throwable: " + e1.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_15 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Throwable e1) {
                    System.err.println("finally throwable: " + e1.getMessage());
                }
                throw throwable;
            }
        }
        return sz != plugins.size();
    }
}

