/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.trace;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.TimeZone;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class TraceFormatter
extends Formatter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2009";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.commonservices/src/com/ibm/mq/commonservices/internal/trace/TraceFormatter.java, javagui, p701, p701-112-140304  1.15.2.2 10/02/26 17:32:28";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final String DEPTH_SIGN = "-";
    private static final String ENTRY_SIGN = "-{";
    private static final String EXIT_SIGN = "}";
    private static final String EXIT = "RETURN";
    private static final String ENTRY = "ENTRY";
    private static String LINE_SEPARATOR = "\n";
    private Stack callStack = null;
    private final Hashtable callStacks = new Hashtable();

    public String format(LogRecord record) {
        StringBuffer buffer = new StringBuffer();
        int threadId = record.getThreadID();
        this.callStack = (Stack)this.callStacks.get(new Integer(threadId));
        if (this.callStack == null) {
            this.callStack = new Stack();
            this.callStacks.put(new Integer(threadId), this.callStack);
        }
        if (record.getMessage().startsWith(ENTRY)) {
            String method = this.formatEntryExitCall(record, buffer, ENTRY_SIGN, true);
            this.callStack.push(method);
        } else if (record.getMessage().startsWith(EXIT)) {
            String method = this.formatEntryExitCall(record, buffer, EXIT_SIGN, false);
            try {
                while (!((String)this.callStack.peek()).equals(method)) {
                    this.callStack.pop();
                }
                this.callStack.pop();
            }
            catch (EmptyStackException err) {}
        } else {
            Object[] params = record.getParameters();
            buffer.append(dateFormat.format(new Date(record.getMillis())) + " ");
            buffer.append(" " + this.formatThreadId(threadId) + " " + " ");
            buffer.append(" " + params[0] + " " + " ");
            buffer.append("  " + record.getMessage());
        }
        buffer.append(LINE_SEPARATOR);
        return buffer.toString();
    }

    private String formatEntryExitCall(LogRecord record, StringBuffer buff, String eChar, boolean entry) {
        Object[] params = null;
        int rc = 0;
        String identity = "";
        if (entry) {
            params = record.getParameters();
            identity = (String)params[0];
        } else {
            params = record.getParameters();
            Object[] o = (Object[])params[0];
            rc = (Integer)o[0];
            identity = (String)o[1];
        }
        String method = record.getSourceClassName() + "." + record.getSourceMethodName();
        buff.append(dateFormat.format(new Date(record.getMillis())) + " ");
        buff.append(" " + this.formatThreadId(record.getThreadID()) + " " + " ");
        buff.append(" " + identity + " " + " ");
        int stop = this.callStack.size();
        for (int count = 0; count < stop; ++count) {
            buff.append(DEPTH_SIGN);
        }
        buff.append(eChar);
        buff.append(" " + method + "()");
        if (!entry) {
            if (params != null) {
                buff.append(" rc=" + rc);
            } else {
                buff.append(" rc=<unknown>");
            }
        }
        return method;
    }

    private String formatThreadId(int i) {
        String threadId = String.valueOf(i);
        switch (threadId.length()) {
            case 1: {
                return "   " + threadId;
            }
            case 2: {
                return "  " + threadId;
            }
            case 3: {
                return " " + threadId;
            }
        }
        return threadId;
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    LINE_SEPARATOR = System.getProperty("line.separator");
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

