/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.trace;

import com.ibm.mq.commonservices.Common;
import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Detail;
import com.ibm.mq.commonservices.internal.trace.EventLogger;
import com.ibm.mq.commonservices.internal.trace.FFST;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;

public class Trace {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2009";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.commonservices/src/com/ibm/mq/commonservices/internal/trace/Trace.java, javagui, p701, p701-112-140304  1.77.1.5 12/10/12 13:36:06";
    private static final int MAXIMUM_LINE_LENGTH = 4096;
    private static boolean useWMQTrace = false;
    private static boolean usingWMQTrace = false;
    private static boolean useJLogTrace = false;
    public static boolean isTracing = false;
    public static boolean isEventLogging = false;
    private boolean usingConsoleHandler = false;
    private static ConsoleHandler consoleHandler = new ConsoleHandler();
    public static final int XCSCOMP_JZ = 47;
    public static final int XCSCOMP_JC = 51;
    public static final int XCSCOMP_JD = 52;
    public static final int XCSCOMP_JP = 53;
    public static final int XCSCOMP_JP2 = 47;
    public static final int XCSCOMP_JU = 54;
    public static final int XCSCOMP_JU2 = 55;
    public static final int XCSCOMP_JU3 = 56;
    public static final int XCSCOMP_JF = 9;
    public static final int XCSCOMP_SOAP = 49;
    public static final int XCSCOMP_JH = 58;
    public static final int XCSCOMP_JM = 59;
    public static final int XCSCOMP_JN = 60;
    public static final int XCSCOMP_JO = 61;
    public static final int XCSCOMP_JXC = 64;
    public static final int XCSCOMP_JXD = 65;
    public static final int XCSCOMP_JXP = 66;
    public static final int XCSCOMP_JXU = 67;
    public static final int XCSCOMP_JXA = 68;
    public static final int XCSCOMP_JXB = 69;
    public static final int XCSCOMP_JXE = 70;
    protected static final int NUM_TRACE_ENTRIES = 250;
    private int[] traceHistory = new int[1000];
    private static final int FIELD_0 = 0;
    private static final int FIELD_1 = 1;
    private static final int FIELD_2 = 2;
    private static final int FIELD_3 = 3;
    protected static final int FIELD_ENTRY = 0;
    protected static final int FIELD_EXIT = 1;
    private int nextTraceHistoryRecord = 0;
    private String title = null;
    protected int xcsRC = 0;
    private static ThreadLocal threadLocalTrace = new ThreadLocal();
    private static String DATA_MODEL_PACKAGE_PREF = "com.ibm.mq.explorer.core.internal.";
    private static String EXPLORER_PACKAGE_PREF = "com.ibm.mq.explorer.ui.internal.";
    public static String NO_LISTENER_INFO = "<no listener info>";
    public static String NO_VIEW_INFO = "<no view info>";
    public static String NOT_USED = "<not used>";
    public int currentCompId = -1;
    public String[] currentNames = null;
    public static int[] traceComponents = null;
    private Throwable cause = null;
    private Object addHistoryRecordLock = new Object();
    private String identity = "";
    private static final int IDENTITY_LENGTH = 12;

    private static native int wmq_query_trace();

    private native int wmq_trace_entry_data(int var1, int var2, int var3, String var4);

    private native int wmq_trace_entry(int var1, int var2);

    private native int wmq_trace_exit_data(int var1, int var2, int var3, int var4, String var5);

    private native int wmq_trace_exit(int var1, int var2, int var3);

    private native int wmq_trace_data(int var1, int var2, int var3, String var4);

    private native int wmq_FFST(int var1, int var2, int var3, int var4, int var5, int var6, String var7, String var8, String var9, int var10);

    private native int wmq_oo_entry_data(int var1, int var2, int var3, String var4);

    private native int wmq_oo_entry(int var1, int var2);

    private native int wmq_oo_exit_data(int var1, int var2, int var3, int var4, int var5, String var6);

    private native int wmq_oo_exit(int var1, int var2, int var3, int var4);

    private native void wmq_oo_caught(int var1, int var2, int var3);

    private native void wmq_oo_throwing(int var1, int var2, int var3);

    private native int wmq_set_thread_state(int var1, String var2, String var3);

    private native int wmq_write_log_message(int var1, int var2, int var3, String var4, String var5, String var6, String var7, int var8, int var9);

    private native int wmq_write_qm_log_message(String var1, int var2, int var3, int var4, String var5, String var6, String var7, String var8, int var9, int var10);

    public Trace(String name) {
        this.title = name;
        this.setIdentity(" ");
        for (int i = 0; i < 1000; ++i) {
            this.traceHistory[i] = 0;
        }
        Trace t = (Trace)threadLocalTrace.get();
        if (t == null) {
            threadLocalTrace.set(this);
            CommonServices.threadInitialize(this);
        }
    }

    public void entry(int compID, int functionID) {
        this.entry(compID, functionID, 0, null);
    }

    public void entry(int compID, String fid) {
        this.entry(compID, fid, 0, null);
    }

    public void entry(int compID, int functionID, int details) {
        this.entry(compID, functionID, details, null);
    }

    public void entry(int compID, String fid, int details) {
        this.entry(compID, fid, details, null);
    }

    public void entry(int compID, int functionID, int details, String data) {
        this.addHistoryRecord(0, compID, functionID, 0);
        if (isTracing) {
            this.entryWMQ(compID, functionID, details, data);
        }
        if (useJLogTrace) {
            if (CommonServices.isJLogTraceAvailable) {
                if (this.isComponentTraced(compID)) {
                    CommonServices.getTraceLogger().entering(this.getClassName(compID, functionID), this.getMethodName(compID, functionID), this.identity);
                }
            } else {
                System.err.print("*** JLog trace not available *** ");
                System.err.println("Entry into " + this.getFullName(compID, functionID) + "()");
            }
        }
    }

    public void entry(int compID, String fid, int details, String data) {
        int functionID = this.getFunctionID(compID, fid);
        this.addHistoryRecord(0, compID, functionID, 0);
        if (isTracing) {
            this.entryWMQ(compID, functionID, details, data);
        }
        if (useJLogTrace) {
            if (CommonServices.isJLogTraceAvailable) {
                if (this.isComponentTraced(compID)) {
                    CommonServices.getTraceLogger().entering(this.getClassName(fid), this.getMethodName(fid), this.identity);
                }
            } else {
                System.err.print("*** JLog trace not available *** ");
                System.err.println("Entry into " + this.getFullName(compID, functionID) + "()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHistoryRecord(int type, int compID, int functionID, int rc) {
        Object object = this.addHistoryRecordLock;
        synchronized (object) {
            this.traceHistory[this.nextTraceHistoryRecord + 0] = type;
            this.traceHistory[this.nextTraceHistoryRecord + 1] = compID;
            this.traceHistory[this.nextTraceHistoryRecord + 2] = functionID;
            this.traceHistory[this.nextTraceHistoryRecord + 3] = rc;
            this.nextTraceHistoryRecord += 4;
            if (this.nextTraceHistoryRecord >= this.traceHistory.length) {
                this.nextTraceHistoryRecord = 0;
            }
        }
    }

    public void exit(int compID, int functionID, int rc, int details) {
        this.exit(compID, functionID, rc, details, null);
    }

    public void exit(int compID, int functionID, int rc) {
        this.exit(compID, functionID, rc, 0, null);
    }

    public void exit(int compID, int functionID) {
        this.exit(compID, functionID, 0, 0, null);
    }

    public void exit(int compID, int functionID, int rc, int details, String data) {
        this.addHistoryRecord(1, compID, functionID, 0);
        if (isTracing) {
            this.exitWMQ(compID, functionID, rc, details, data);
        }
        if (useJLogTrace) {
            if (CommonServices.isJLogTraceAvailable) {
                if (this.isComponentTraced(compID)) {
                    if (data != null) {
                        this.data(compID, functionID, details, data);
                    }
                    CommonServices.getTraceLogger().exiting(this.getClassName(compID, functionID), this.getMethodName(compID, functionID), new Object[]{new Integer(rc), this.identity});
                }
            } else {
                System.err.print("*** JLog trace not available *** ");
                System.err.println("Exit from " + this.getFullName(compID, functionID) + "()");
            }
        }
    }

    public void exit(int compID, String fid, int rc, int details) {
        this.exit(compID, fid, rc, details, null);
    }

    public void exit(int compID, String fid, int rc) {
        this.exit(compID, fid, rc, 0, null);
    }

    public void exit(int compID, String fid) {
        this.exit(compID, fid, 0, 0, null);
    }

    public void exit(int compID, String fid, int rc, int details, String data) {
        int functionID = this.getFunctionID(compID, fid);
        this.addHistoryRecord(1, compID, functionID, 0);
        if (isTracing) {
            this.exitWMQ(compID, functionID, rc, details, data);
        }
        if (useJLogTrace) {
            if (CommonServices.isJLogTraceAvailable) {
                if (this.isComponentTraced(compID)) {
                    if (data != null) {
                        this.data(compID, functionID, details, data);
                    }
                    CommonServices.getTraceLogger().exiting(this.getClassName(fid), this.getMethodName(fid), new Object[]{new Integer(rc), this.identity});
                }
            } else {
                System.err.print("*** JLog trace not available *** ");
                System.err.println("Exit from " + this.getFullName(compID, functionID) + "()");
            }
        }
    }

    private void entryWMQ(int compID, int fid, int details, String data) {
        block9: {
            if (useWMQTrace && usingWMQTrace) {
                if (CommonServices.isCommonServicesAvailable) {
                    try {
                        if (!this.isWMQSupportedFID(compID, fid)) {
                            fid = 0;
                        }
                        if (data == null) {
                            this.xcsRC = this.wmq_trace_entry(compID, fid);
                            break block9;
                        }
                        if (data.length() > 4096) {
                            this.xcsRC = this.wmq_trace_entry(compID, fid);
                            this.parseData(compID, fid, details, data);
                            break block9;
                        }
                        this.xcsRC = this.wmq_trace_entry_data(compID, fid, details, data);
                    }
                    catch (UnsatisfiedLinkError ule) {
                        System.err.println("JNI error" + Common.LINE_SEPARATOR + ule);
                    }
                } else if (CommonServices.PLATFORM_ID != 9) {
                    System.err.print("*** WMQ trace not available *** ");
                    System.err.println("WMQ trace entry into " + this.getFullName(compID, fid) + "()");
                }
            }
        }
    }

    private void exitWMQ(int compID, int fid, int rc, int details, String data) {
        block9: {
            if (useWMQTrace && usingWMQTrace) {
                if (CommonServices.isCommonServicesAvailable) {
                    try {
                        if (!this.isWMQSupportedFID(compID, fid)) {
                            fid = 0;
                        }
                        if (data == null) {
                            this.xcsRC = this.wmq_trace_exit(compID, fid, rc);
                            break block9;
                        }
                        if (data.length() > 4096) {
                            this.parseData(compID, fid, details, data);
                            this.xcsRC = this.wmq_trace_exit(compID, fid, rc);
                            break block9;
                        }
                        this.xcsRC = this.wmq_trace_exit_data(compID, fid, rc, details, data);
                    }
                    catch (UnsatisfiedLinkError ule) {
                        System.err.println("JNI error" + Common.LINE_SEPARATOR + ule);
                    }
                } else if (CommonServices.PLATFORM_ID != 9) {
                    System.err.print("*** WMQ trace not available *** ");
                    System.err.println("WMQ trace exit from " + this.getFullName(compID, fid) + "()");
                }
            }
        }
    }

    private void writeData(int compID, int functionID, int detail, String data) {
        if (!isTracing) {
            return;
        }
        if (useWMQTrace && usingWMQTrace) {
            if (CommonServices.isCommonServicesAvailable) {
                try {
                    if (!this.isWMQSupportedFID(compID, functionID)) {
                        functionID = 0;
                    }
                    this.xcsRC = this.wmq_trace_data(compID, functionID, detail, data);
                }
                catch (UnsatisfiedLinkError ule) {
                    System.err.println("JNI error" + Common.LINE_SEPARATOR + ule);
                }
            } else if (CommonServices.PLATFORM_ID != 9) {
                System.err.print("*** WMQ trace not available *** ");
                System.err.println("WMQ trace data from " + this.getFullName(compID, functionID) + "() - " + data);
            }
        }
        if (useJLogTrace) {
            if (CommonServices.isJLogTraceAvailable) {
                if (this.isComponentTraced(compID)) {
                    CommonServices.getTraceLogger().logp(Detail.getLevel(detail), this.getClassName(compID, functionID), this.getMethodName(compID, functionID), data, this.identity);
                }
            } else {
                System.err.print("*** JLog trace not available *** ");
                System.err.println("Data from " + this.getFullName(compID, functionID) + "() - " + data);
            }
        }
    }

    public void data(int compID, int functionID, String data) {
        if (!isTracing) {
            return;
        }
        this.data(compID, functionID, 300, data);
    }

    public void data(int compID, String fid, String data) {
        if (!isTracing) {
            return;
        }
        this.data(compID, fid, 300, data);
    }

    public void dataBox(int compID, int functionID, String[] data) {
        int i;
        if (!isTracing) {
            return;
        }
        int lineLength = 1;
        for (i = 0; i < data.length; ++i) {
            if (data[i].length() <= lineLength) continue;
            lineLength = data[i].length();
        }
        this.data(compID, functionID, 300, this.formatString("-", lineLength, "+", "-"));
        this.data(compID, functionID, 300, this.formatString(" ", lineLength, "|", " "));
        for (i = 0; i < data.length; ++i) {
            this.data(compID, functionID, 300, this.formatString(data[i], lineLength, "|", " "));
        }
        this.data(compID, functionID, 300, this.formatString(" ", lineLength, "|", " "));
        this.data(compID, functionID, 300, this.formatString("-", lineLength, "+", "-"));
    }

    public void dataBox(int compID, String fid, String[] data) {
        int functionID = this.getFunctionID(compID, fid);
        this.dataBox(compID, functionID, data);
    }

    public void dataBox(int compID, int functionID, String pluginName, String pluginVersion, String pluginLocation) {
        if (!isTracing) {
            return;
        }
        String line1 = "Plug-in name     : " + pluginName;
        String line2 = "Plug-in version  : " + pluginVersion;
        String line3 = "Plug-in location : " + pluginLocation;
        String[] data = new String[]{line1, line2, line3};
        this.dataBox(compID, functionID, data);
    }

    public void dataBox(int compID, String fid, String pluginName, String pluginVersion, String pluginLocation) {
        int functionID = this.getFunctionID(compID, fid);
        this.dataBox(compID, functionID, pluginName, pluginVersion, pluginLocation);
    }

    private String formatString(String s, int length, String delimeter, String pad) {
        StringBuffer sb = new StringBuffer(s);
        int actualLength = s.length();
        if (actualLength > length) {
            return delimeter + pad + s.substring(actualLength - length) + pad + delimeter;
        }
        for (int j = actualLength; j < length; ++j) {
            sb.append(pad);
        }
        return delimeter + pad + sb.toString() + pad + delimeter;
    }

    public void eventListenerAdded(int functionID, int loggerID, String data) {
        EventLogger eLogger;
        if (!isEventLogging) {
            return;
        }
        if (CommonServices.isJLogTraceAvailable && (eLogger = CommonServices.getEventLogger(loggerID)) != null) {
            eLogger.getEventLogger().logp(Level.FINE, NOT_USED, NOT_USED, data);
        }
    }

    public void eventListenerAdded(String fid, int loggerID, String data) {
        EventLogger eLogger;
        if (!isEventLogging) {
            return;
        }
        if (CommonServices.isJLogTraceAvailable && (eLogger = CommonServices.getEventLogger(loggerID)) != null) {
            eLogger.getEventLogger().logp(Level.FINE, NOT_USED, NOT_USED, data);
        }
    }

    public void eventListenerRemoved(int functionID, int loggerID, String data) {
        EventLogger eLogger;
        if (!isEventLogging) {
            return;
        }
        if (CommonServices.isJLogTraceAvailable && (eLogger = CommonServices.getEventLogger(loggerID)) != null) {
            eLogger.getEventLogger().logp(Level.FINEST, NOT_USED, NOT_USED, data);
        }
    }

    public void eventListenerRemoved(String fid, int loggerID, String data) {
        EventLogger eLogger;
        if (!isEventLogging) {
            return;
        }
        if (CommonServices.isJLogTraceAvailable && (eLogger = CommonServices.getEventLogger(loggerID)) != null) {
            eLogger.getEventLogger().logp(Level.FINEST, NOT_USED, NOT_USED, data);
        }
    }

    public void eventListenerNotified(int functionID, int loggerID, String data) {
        EventLogger eLogger;
        if (!isEventLogging) {
            return;
        }
        if (CommonServices.isJLogTraceAvailable && (eLogger = CommonServices.getEventLogger(loggerID)) != null) {
            eLogger.getEventLogger().logp(Level.FINER, NOT_USED, NOT_USED, data);
        }
    }

    public void eventReceived(int functionID, int loggerID, String data) {
        EventLogger eLogger;
        if (!isEventLogging) {
            return;
        }
        if (CommonServices.isJLogTraceAvailable && (eLogger = CommonServices.getEventLogger(loggerID)) != null) {
            eLogger.getEventLogger().logp(Level.INFO, NOT_USED, NOT_USED, data);
        }
    }

    public void FFST(int compID, int functionID, int probeID, int rc, int insert1, int insert2) {
        this.FFST(compID, functionID, probeID, rc, insert1, insert2, null, null, null, 0, null);
    }

    public void FFST(int compID, int functionID, int probeID, int rc, String insert1) {
        this.FFST(compID, functionID, probeID, rc, 0, 0, insert1, null, null, 0, null);
    }

    public void FFST(int compID, int functionID, int probeID, int rc, int insert1, int insert2, String insert3, String insert4, String insert5) {
        this.FFST(compID, functionID, probeID, rc, insert1, insert2, insert3, insert4, insert5, 0, null);
    }

    public void FFST(int compID, int functionID, int probeID, int rc, int insert1, int insert2, String insert3, String insert4, String insert5, Throwable throwable) {
        this.FFST(compID, functionID, probeID, rc, insert1, insert2, insert3, insert4, insert5, 0, throwable);
    }

    private void FFST(int compID, int functionID, int probeID, int rc, int insert1, int insert2, String insert3, String insert4, String insert5, int alert, Throwable throwable) {
        this.cause = throwable;
        if (CommonServices.isCommonServicesAvailable && useWMQTrace) {
            try {
                this.xcsRC = this.wmq_FFST(compID, functionID, probeID, rc, insert1, insert2, insert3, insert4, insert5, alert);
            }
            catch (UnsatisfiedLinkError ule) {
                System.err.println("JNI error" + Common.LINE_SEPARATOR + ule);
            }
        }
        if (useJLogTrace) {
            FFST ffst = null;
            try {
                ffst = new FFST(this, CommonServices.getRASProperties(), this.getTraceHistory(), this.nextTraceHistoryRecord);
                ffst.writeFFST(this, compID, functionID, probeID, rc, insert1, insert2, insert3, insert4, insert5);
            }
            catch (CommonServicesException e) {
                // empty catch block
            }
        }
        this.cause = null;
    }

    public void eventListenerNotified(String fid, int loggerID, String data) {
        EventLogger eLogger;
        if (!isEventLogging) {
            return;
        }
        if (CommonServices.isJLogTraceAvailable && (eLogger = CommonServices.getEventLogger(loggerID)) != null) {
            eLogger.getEventLogger().logp(Level.FINER, NOT_USED, NOT_USED, data);
        }
    }

    public void eventReceived(String fid, int loggerID, String data) {
        EventLogger eLogger;
        if (!isEventLogging) {
            return;
        }
        if (CommonServices.isJLogTraceAvailable && (eLogger = CommonServices.getEventLogger(loggerID)) != null) {
            eLogger.getEventLogger().logp(Level.INFO, NOT_USED, NOT_USED, data);
        }
    }

    public void FFST(int compID, String fid, int probeID, int rc, int insert1, int insert2) {
        this.FFST(compID, fid, probeID, rc, insert1, insert2, null, null, null, 0, null);
    }

    public void FFST(int compID, String fid, int probeID, int rc, String insert1) {
        this.FFST(compID, fid, probeID, rc, 0, 0, insert1, null, null, 0, null);
    }

    public void FFST(int compID, String fid, int probeID, int rc, int insert1, int insert2, String insert3, String insert4, String insert5) {
        this.FFST(compID, fid, probeID, rc, insert1, insert2, insert3, insert4, insert5, 0, null);
    }

    public void FFST(int compID, String fid, int probeID, int rc, int insert1, int insert2, String insert3, String insert4, String insert5, Throwable throwable) {
        this.FFST(compID, fid, probeID, rc, insert1, insert2, insert3, insert4, insert5, 0, throwable);
    }

    private void FFST(int compID, String fid, int probeID, int rc, int insert1, int insert2, String insert3, String insert4, String insert5, int alert, Throwable throwable) {
        int functionID = this.getFunctionID(compID, fid);
        this.FFST(compID, functionID, probeID, rc, insert1, insert2, insert3, insert4, insert5, alert, throwable);
    }

    public void setThreadState(int index, String key, String value) {
        String theValue = value;
        String theKey = key;
        if (CommonServices.isCommonServicesAvailable) {
            if (theValue == null) {
                theValue = "<empty>";
            }
            if (theKey == null) {
                theKey = "<empty>";
            }
            try {
                this.xcsRC = this.wmq_set_thread_state(index, theKey, theValue);
            }
            catch (UnsatisfiedLinkError ule) {
                System.err.println("JNI error" + Common.LINE_SEPARATOR + ule);
            }
        }
    }

    public static boolean queryWMQTrace() {
        boolean tracing = false;
        if (CommonServices.isCommonServicesAvailable) {
            try {
                if (Trace.wmq_query_trace() == 0) {
                    if (tracing) {
                        CommonServices.setWMQJavaClassesTraceLevel(Trace.getDefault(), Integer.MAX_VALUE);
                    }
                    tracing = false;
                    if (!useJLogTrace) {
                        isTracing = false;
                    }
                } else {
                    if (!tracing) {
                        CommonServices.setWMQJavaClassesTraceLevel(Trace.getDefault(), Integer.MIN_VALUE);
                    }
                    tracing = true;
                    isTracing = true;
                }
            }
            catch (UnsatisfiedLinkError ule) {
                System.err.println("JNI error" + Common.LINE_SEPARATOR + ule);
            }
        }
        usingWMQTrace = tracing;
        return tracing;
    }

    public void log(int rc, int insert1, int insert2, String insert3, String insert4, String insert5, String fileName, int lineNum, int options) {
        if (useWMQTrace && CommonServices.isCommonServicesAvailable) {
            try {
                this.xcsRC = this.wmq_write_log_message(rc, insert1, insert2, insert3, insert4, insert5, fileName, lineNum, options);
            }
            catch (UnsatisfiedLinkError ule) {
                System.err.println("JNI error" + Common.LINE_SEPARATOR + ule);
            }
        }
        if (useJLogTrace) {
            CommonServices.getAMQLogger().addLogEntry(this, rc, insert1, insert2, insert3, insert4, insert5, fileName, lineNum, options);
        }
    }

    public void logQM(String qmName, int rc, int insert1, int insert2, String insert3, String insert4, String insert5, String fileName, int lineNum, int options) {
        if (useWMQTrace && CommonServices.isCommonServicesAvailable) {
            try {
                this.xcsRC = this.wmq_write_qm_log_message(qmName, rc, insert1, insert2, insert3, insert4, insert5, fileName, lineNum, options);
            }
            catch (UnsatisfiedLinkError ule) {
                System.err.println("JNI error" + Common.LINE_SEPARATOR + ule);
            }
        }
        if (useJLogTrace) {
            CommonServices.getAMQLogger().addLogEntry(this, rc, insert1, insert2, insert3, insert4, insert5, fileName, lineNum, options);
        }
    }

    public void close() {
        for (int i = 0; i < 1000; ++i) {
            this.traceHistory[i] = 0;
        }
        if (this.usingConsoleHandler) {
            consoleHandler.close();
        }
    }

    public void setJLogTraceLevel(int i) {
        if (!this.usingConsoleHandler) {
            CommonServices.getTraceLogger().addHandler(consoleHandler);
            this.usingConsoleHandler = true;
        }
        if (i == Integer.MAX_VALUE) {
            useJLogTrace = false;
        } else {
            useJLogTrace = true;
            isTracing = true;
        }
        consoleHandler.setLevel(Detail.getLevel(i));
    }

    public static void setUseWMQTrace(boolean t) {
        useWMQTrace = t;
    }

    public static void setUseJLogTrace(boolean t) {
        useJLogTrace = t;
        if (useJLogTrace) {
            isTracing = true;
        } else if (!useWMQTrace) {
            isTracing = false;
        }
    }

    public String getJavaStack(Throwable th) {
        StackTraceElement[] ste = th.getStackTrace();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ste.length; ++i) {
            sb = sb.append(ste[i].toString() + Common.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    public String getJavaStack() {
        Throwable th = new Throwable();
        StringBuffer sb = new StringBuffer(this.getJavaStack(th));
        if (this.cause != null) {
            th = this.cause;
            sb.append(Common.LINE_SEPARATOR + "Cause is :");
            while (th != null) {
                sb.append(Common.LINE_SEPARATOR + th.toString());
                sb.append(Common.LINE_SEPARATOR + this.getJavaStack(th));
                if (th.equals(th.getCause())) break;
                if ((th = th.getCause()) == null) continue;
                sb.append(Common.LINE_SEPARATOR + "Caused by :");
            }
        }
        return sb.toString();
    }

    public static synchronized Trace getDefault() {
        Trace t = (Trace)threadLocalTrace.get();
        if (t == null) {
            t = new Trace(Thread.currentThread().getName());
            threadLocalTrace.set(t);
            CommonServices.threadInitialize(t);
        }
        return t;
    }

    public static synchronized void setDefault(Trace t) {
        threadLocalTrace.set(t);
    }

    public String formatEventListenerData(Trace t, Object view, Object listener, String type) {
        String vName = NO_VIEW_INFO;
        String lName = NO_LISTENER_INFO;
        if (view != null) {
            vName = this.shrinkName(view.toString());
        }
        if (listener != null) {
            lName = this.shrinkName(listener.getClass().getName() + "@" + Integer.toHexString(listener.hashCode()));
        }
        return this.formatString(vName, 56) + " : " + this.formatString(type, 50) + " : " + this.formatString(lName, 50);
    }

    public String formatEventListenerData(Trace t, Object view, Object listener, String type, String name, String last) {
        String vName = NO_VIEW_INFO;
        String lName = NO_LISTENER_INFO;
        if (view != null) {
            vName = this.shrinkName(view.toString());
        }
        if (listener != null) {
            lName = this.shrinkName(listener.getClass().getName() + "@" + Integer.toHexString(listener.hashCode()));
        }
        return this.formatString(type, 3) + " : " + this.formatString(name, 50) + " : " + this.formatString(vName, 50) + " : " + this.formatString(lName, 50) + " : " + last;
    }

    private String shrinkName(String name) {
        if (name.startsWith(DATA_MODEL_PACKAGE_PREF)) {
            return "..." + name.substring(DATA_MODEL_PACKAGE_PREF.length());
        }
        if (name.startsWith(EXPLORER_PACKAGE_PREF)) {
            return "..." + name.substring(EXPLORER_PACKAGE_PREF.length());
        }
        return name;
    }

    private String formatString(String s, int length) {
        StringBuffer sb = new StringBuffer(s);
        int actualLength = s.length();
        if (actualLength > length) {
            return s.substring(actualLength - length);
        }
        for (int j = actualLength; j < length; ++j) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public String getTitle() {
        return this.title.trim();
    }

    public static void setEventLogging(boolean b) {
        isEventLogging = b;
    }

    private String getClassName(int compId, int funId) {
        if (this.currentCompId != compId || this.currentNames == null) {
            this.currentNames = CommonServices.getListOfNames(compId);
            if (this.currentNames == null) {
                return "***Unknown class name (" + compId + "/" + funId + ") ***";
            }
            this.currentCompId = compId;
        }
        String name = null;
        try {
            name = this.currentNames[funId];
        }
        catch (ArrayIndexOutOfBoundsException iobe) {
            return "***Unknown class name (" + compId + "/" + funId + ") ***";
        }
        catch (NullPointerException npe) {
            return "***Unknown class name (" + compId + "/" + funId + ") ***";
        }
        int i = name.indexOf(".");
        if (i < 1) {
            return name;
        }
        return name.substring(0, i);
    }

    private String getClassName(String name) {
        int i = name.indexOf(".");
        if (i < 1) {
            return name;
        }
        return name.substring(0, i);
    }

    private String getMethodName(int compId, int funId) {
        if (this.currentCompId != compId || this.currentNames == null) {
            this.currentNames = CommonServices.getListOfNames(compId);
            if (this.currentNames == null) {
                return "***Unknown method name (" + compId + "/" + funId + ") ***";
            }
            this.currentCompId = compId;
        }
        String name = null;
        try {
            name = this.currentNames[funId];
        }
        catch (ArrayIndexOutOfBoundsException iobe) {
            return "***Unknown method name (" + compId + "/" + funId + ") ***";
        }
        catch (NullPointerException npe) {
            return "***Unknown method name (" + compId + "/" + funId + ") ***";
        }
        int i = name.indexOf(".");
        if (i < 1) {
            return name;
        }
        return name.substring(i + 1);
    }

    private String getMethodName(String name) {
        int i = name.indexOf(".");
        if (i < 1) {
            return name;
        }
        return name.substring(i + 1);
    }

    private String getFullName(int compId, int funId) {
        if (this.currentCompId != compId || this.currentNames == null) {
            this.currentNames = CommonServices.getListOfNames(compId);
            if (this.currentNames == null) {
                return "***Unknown class/method name (" + compId + "/" + funId + ") ***";
            }
            this.currentCompId = compId;
        }
        String name = null;
        try {
            name = this.currentNames[funId];
        }
        catch (ArrayIndexOutOfBoundsException iobe) {
            return "***Unknown class/method name (" + compId + "/" + funId + ") ***";
        }
        catch (NullPointerException npe) {
            return "***Unknown class/method name (" + compId + "/" + funId + ") ***";
        }
        return name;
    }

    private boolean isComponentTraced(int compId) {
        if (traceComponents == null) {
            return true;
        }
        for (int i = 0; i < traceComponents.length; ++i) {
            if (traceComponents[i] != compId) continue;
            return true;
        }
        return false;
    }

    public int[] getTraceHistory() {
        int[] history = (int[])this.traceHistory.clone();
        return history;
    }

    public void data(int compID, int functionID, int detail, String data) {
        if (isTracing && (useJLogTrace || useWMQTrace && usingWMQTrace)) {
            StringTokenizer tokenizedString = new StringTokenizer(data, Common.LINE_SEPARATOR);
            while (tokenizedString.hasMoreTokens()) {
                String token = tokenizedString.nextToken();
                if (token.length() > 4096) {
                    this.parseData(compID, functionID, detail, token);
                    continue;
                }
                this.writeData(compID, functionID, detail, token);
            }
        }
    }

    public void data(int compID, String fid, int detail, byte[] data) {
        int functionID = this.getFunctionID(compID, fid);
        this.data(compID, functionID, detail, data);
    }

    public void data(int compID, int functionID, int detail, byte[] data) {
        int[] segment = new int[16];
        boolean eol = false;
        int offset = 0;
        ByteBuffer bb = ByteBuffer.allocate(data.length);
        StringBuffer formattedString = new StringBuffer();
        if (isTracing && (useJLogTrace || useWMQTrace && usingWMQTrace)) {
            bb.put(data, 0, data.length);
            bb.flip();
            while (!eol) {
                int i;
                try {
                    for (i = 0; i < 16; ++i) {
                        segment[i] = bb.get();
                        if (segment[i] >= 0) continue;
                        segment[i] = segment[i] << 24;
                        segment[i] = segment[i] >>> 24;
                    }
                }
                catch (BufferUnderflowException bue) {
                    eol = true;
                    for (i = 0; i < 16; ++i) {
                        segment[i] = 0;
                    }
                }
                formattedString.append(this.formatSegment(segment, offset));
                ++offset;
            }
            this.data(compID, functionID, detail, formattedString.toString());
        }
    }

    private String formatSegment(int[] segment, int offset) {
        char c;
        int i = 0;
        String str = "";
        str = str + this.rightJustify(Integer.toHexString(offset * 16), 5) + "   ";
        for (i = 0; i < 7; ++i) {
            str = str + this.rightJustify(Integer.toHexString(segment[i]), 2) + " ";
        }
        str = str + this.rightJustify(Integer.toHexString(segment[i++]), 2);
        str = str + "--";
        while (i < 16) {
            str = str + this.rightJustify(Integer.toHexString(segment[i]), 2) + " ";
            ++i;
        }
        str = str + " |";
        for (i = 0; i < 8; ++i) {
            c = (char)segment[i];
            if (!this.isPrintableAscii(c)) {
                c = '.';
            }
            str = str + c;
        }
        while (i < 16) {
            c = (char)segment[i];
            if (!this.isPrintableAscii(c)) {
                c = '.';
            }
            str = str + c;
            ++i;
        }
        str = str + "|\n";
        return str;
    }

    private String rightJustify(String str, int width) {
        StringBuffer retValue = new StringBuffer(str);
        for (int i = width - str.length(); i > 0; --i) {
            retValue.insert(0, "0");
        }
        return retValue.toString();
    }

    private boolean isPrintableAscii(char c) {
        return !Character.isISOControl(c);
    }

    public void data(int compID, String fid, int detail, String data) {
        int functionID = this.getFunctionID(compID, fid);
        this.data(compID, functionID, detail, data);
    }

    private void parseData(int compID, int functionID, int detail, String data) {
        String theData = data;
        while (theData.length() > 4096) {
            String string = theData.substring(0, 4095);
            this.writeData(compID, functionID, detail, string);
            theData = theData.substring(4096);
        }
        this.writeData(compID, functionID, detail, theData);
    }

    public int entry_OO(int compID, int functionID) {
        return this.entry_OO(compID, functionID, 0, null);
    }

    public int entry_OO(int compID, int functionID, int details) {
        return this.entry_OO(compID, functionID, details, null);
    }

    public int entry_OO(int compID, int functionID, int details, String data) {
        int traceIndent;
        block13: {
            traceIndent = 0;
            this.addHistoryRecord(0, compID, functionID, 0);
            if (useWMQTrace && usingWMQTrace) {
                if (CommonServices.isCommonServicesAvailable) {
                    try {
                        if (!this.isWMQSupportedFID(compID, functionID)) {
                            functionID = 0;
                        }
                        if (data == null) {
                            traceIndent = this.wmq_oo_entry(compID, functionID);
                            break block13;
                        }
                        if (data.length() > 4096) {
                            traceIndent = this.wmq_oo_entry(compID, functionID);
                            this.parseData(compID, functionID, details, data);
                            break block13;
                        }
                        traceIndent = this.wmq_oo_entry_data(compID, functionID, details, data);
                    }
                    catch (UnsatisfiedLinkError ule) {
                        System.err.println("JNI error" + Common.LINE_SEPARATOR + ule);
                    }
                } else if (CommonServices.PLATFORM_ID != 9) {
                    System.err.print("*** WMQ trace not available *** ");
                    System.err.println("WMQ trace entry into " + this.getFullName(compID, functionID) + "()");
                }
            }
        }
        if (useJLogTrace) {
            if (CommonServices.isJLogTraceAvailable) {
                if (this.isComponentTraced(compID)) {
                    CommonServices.getTraceLogger().entering(this.getClassName(compID, functionID), this.getMethodName(compID, functionID), this.identity);
                }
            } else {
                System.err.print("*** JLog trace not available *** ");
                System.err.println("Entry into " + this.getFullName(compID, functionID) + "()");
            }
        }
        return traceIndent;
    }

    public void exit_OO(int ctx, int compID, int functionID, int rc, int details) {
        this.exit_OO(ctx, compID, functionID, rc, details, null);
    }

    public void exit_OO(int ctx, int compID, int functionID, int rc) {
        this.exit_OO(ctx, compID, functionID, rc, 0, null);
    }

    public void exit_OO(int ctx, int compID, int functionID) {
        this.exit_OO(ctx, compID, functionID, 0, 0, null);
    }

    public void exit_OO(int ctx, int compID, int functionID, int rc, int details, String data) {
        block14: {
            this.addHistoryRecord(1, compID, functionID, 0);
            if (useWMQTrace && usingWMQTrace) {
                if (CommonServices.isCommonServicesAvailable) {
                    try {
                        if (!this.isWMQSupportedFID(compID, functionID)) {
                            functionID = 0;
                        }
                        if (data == null) {
                            this.xcsRC = this.wmq_oo_exit(ctx, compID, functionID, rc);
                            break block14;
                        }
                        if (data.length() > 4096) {
                            this.parseData(compID, functionID, details, data);
                            this.xcsRC = this.wmq_oo_exit(ctx, compID, functionID, rc);
                            break block14;
                        }
                        this.xcsRC = this.wmq_oo_exit_data(ctx, compID, functionID, rc, details, data);
                    }
                    catch (UnsatisfiedLinkError ule) {
                        System.err.println("JNI error" + Common.LINE_SEPARATOR + ule);
                    }
                } else if (CommonServices.PLATFORM_ID != 9) {
                    System.err.print("*** WMQ trace not available *** ");
                    System.err.println("WMQ trace exit from " + this.getFullName(compID, functionID) + "()");
                }
            }
        }
        if (useJLogTrace) {
            if (CommonServices.isJLogTraceAvailable) {
                if (this.isComponentTraced(compID)) {
                    if (data != null) {
                        this.data(compID, functionID, details, data);
                    }
                    CommonServices.getTraceLogger().exiting(this.getClassName(compID, functionID), this.getMethodName(compID, functionID), new Object[]{new Integer(rc), this.identity});
                }
            } else {
                System.err.print("*** JLog trace not available *** ");
                System.err.println("Exit from " + this.getFullName(compID, functionID) + "()");
            }
        }
    }

    public void caught_OO(int ctx, int compID, int functionID) {
        this.addHistoryRecord(1, compID, functionID, 0);
        if (useWMQTrace && usingWMQTrace) {
            if (CommonServices.isCommonServicesAvailable) {
                try {
                    if (!this.isWMQSupportedFID(compID, functionID)) {
                        functionID = 0;
                    }
                    this.wmq_oo_caught(ctx, compID, functionID);
                }
                catch (UnsatisfiedLinkError ule) {
                    System.err.println("JNI error" + Common.LINE_SEPARATOR + ule);
                }
            } else if (CommonServices.PLATFORM_ID != 9) {
                System.err.print("*** WMQ trace not available *** ");
                System.err.println("WMQ trace exit from " + this.getFullName(compID, functionID) + "()");
            }
        }
    }

    public void throwing_OO(int ctx, int compID, int functionID) {
        this.addHistoryRecord(1, compID, functionID, 0);
        if (useWMQTrace && usingWMQTrace) {
            if (CommonServices.isCommonServicesAvailable) {
                try {
                    if (!this.isWMQSupportedFID(compID, functionID)) {
                        functionID = 0;
                    }
                    this.wmq_oo_throwing(ctx, compID, functionID);
                }
                catch (UnsatisfiedLinkError ule) {
                    System.err.println("JNI error" + Common.LINE_SEPARATOR + ule);
                }
            } else if (CommonServices.PLATFORM_ID != 9) {
                System.err.print("*** WMQ trace not available *** ");
                System.err.println("WMQ trace exit from " + this.getFullName(compID, functionID) + "()");
            }
        }
    }

    private int getFunctionID(int compID, String fid) {
        Integer functionID;
        HashMap names = CommonServices.getHashMapOfNames(compID);
        int functionId = 0;
        if (names != null && (functionID = (Integer)names.get(fid)) != null) {
            functionId = functionID;
        }
        return functionId;
    }

    public void setIdentity(String id) {
        int length = id.length();
        if (length >= 12) {
            this.identity = id.substring(0, 11);
        } else {
            StringBuffer sb = new StringBuffer(id);
            for (int i = 0; i < 12 - length; ++i) {
                sb.append(" ");
            }
            this.identity = sb.toString();
        }
    }

    private boolean isWMQSupportedFID(int compID, int functionID) {
        boolean supported = false;
        switch (compID) {
            case 58: {
                if (functionID > 824) break;
                supported = true;
                break;
            }
            case 59: {
                if (functionID > 1050) break;
                supported = true;
                break;
            }
            case 60: {
                if (functionID > 800) break;
                supported = true;
                break;
            }
            case 61: {
                if (functionID > 1023) break;
                supported = true;
                break;
            }
            default: {
                supported = true;
            }
        }
        return supported;
    }
}

