/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.trace;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class EventTraceFormatter
extends Formatter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2009";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.commonservices/src/com/ibm/mq/commonservices/internal/trace/EventTraceFormatter.java, javagui, p701, p701-112-140304  1.9.2.1 09/08/15 18:39:58";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final String LINE_SEPARATOR;

    public String format(LogRecord record) {
        StringBuffer buffer = new StringBuffer();
        buffer = buffer.append(DATE_FORMAT.format(new Date(record.getMillis())) + " ");
        buffer = buffer.append(" " + this.formatThreadId(record.getThreadID()) + "  ");
        switch (record.getLevel().intValue()) {
            case 500: {
                buffer = buffer.append("  >> " + record.getMessage() + LINE_SEPARATOR);
                break;
            }
            case 400: {
                buffer = buffer.append("  -> " + record.getMessage() + LINE_SEPARATOR);
                break;
            }
            case 300: {
                buffer = buffer.append("  << " + record.getMessage() + LINE_SEPARATOR);
                break;
            }
            case 800: {
                buffer = buffer.append("  >- " + record.getMessage() + LINE_SEPARATOR);
                break;
            }
        }
        return buffer.toString();
    }

    private String formatThreadId(int i) {
        String threadId = String.valueOf(i);
        switch (threadId.length()) {
            case 1: {
                return "   " + threadId;
            }
            case 2: {
                return "  " + threadId;
            }
            case 3: {
                return " " + threadId;
            }
        }
        return threadId;
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        LINE_SEPARATOR = System.getProperty("line.separator");
    }
}

