/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.trace;

import com.ibm.mq.commonservices.internal.trace.EventTraceFormatter;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import java.io.File;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventLogger {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2009";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.commonservices/src/com/ibm/mq/commonservices/internal/trace/EventLogger.java, javagui, p701, p701-112-140304  1.18.1.1 09/08/15 19:17:08";
    private Logger logger = null;
    private FileHandler eventFileHandler = null;
    private String eventFilename = null;
    private static final String USER_HOME = System.getProperty("user.home");
    public static final String DM_EVENT_LOGGER_NAME = "com.ibm.mq.explorer.dm.event";
    public static final int DM_EVENT_LOGGER_ID = 1;
    public static final String UI_EVENT_LOGGER_NAME = "com.ibm.mq.explorer.ui.event";
    public static final int UI_EVENT_LOGGER_ID = 2;
    public static String DM_EVENT_FILENAME = "dmEvents.txt";
    public static String UI_EVENT_FILENAME = "uiEvents.txt";

    public EventLogger(Trace t, String id, String fn) {
        String fid = "EventLogger.constructor";
        t.entry(64, "EventLogger.constructor");
        File workingDir = CommonServices.getWorkingDir(t);
        this.eventFilename = workingDir != null ? workingDir.getAbsolutePath() + File.separatorChar + fn : USER_HOME + File.separatorChar + fn;
        EventTraceFormatter formatter = new EventTraceFormatter();
        this.createLogger(t, id, this.eventFilename, formatter);
        t.exit(64, "EventLogger.constructor");
    }

    public EventLogger(Trace t, String id, String fn, Formatter formatter) {
        String fid = "EventLogger.constructor";
        t.entry(64, "EventLogger.constructor");
        this.createLogger(t, id, fn, formatter);
        t.exit(64, "EventLogger.constructor");
    }

    private void createLogger(Trace t, String id, String fn, Formatter formatter) {
        String fid = "EventLogger.createLogger";
        t.entry(64, "EventLogger.createLogger");
        try {
            this.logger = Logger.getLogger(id);
            if (this.logger == null) {
                if (Trace.isTracing) {
                    t.data(64, "EventLogger.createLogger", 900, "Error intializing JLog logger");
                }
                t.exit(64, "EventLogger.createLogger", 50018);
                return;
            }
            this.logger.setLevel(Level.ALL);
            this.logger.setUseParentHandlers(false);
        }
        catch (Exception e) {
            if (Trace.isTracing) {
                t.data(64, "EventLogger.createLogger", 900, "Error intializing JLog logger : " + e.toString());
            }
            t.exit(64, "EventLogger.createLogger", 50018);
            return;
        }
        if (Trace.isTracing) {
            t.data(64, "EventLogger.createLogger", 300, "Event log name is " + this.eventFilename);
        }
        if (!this.createEventFileHandler(t, fn, formatter)) {
            t.exit(64, "EventLogger.createLogger", 50027);
            return;
        }
        t.exit(64, "EventLogger.createLogger");
    }

    private boolean createEventFileHandler(Trace t, String fn, Formatter formatter) {
        String fid = "EventLogger.createEventFileHandler";
        t.entry(64, "EventLogger.createEventFileHandler");
        if (Trace.isTracing) {
            t.data(64, "EventLogger.createEventFileHandler", 300, "New event file handler name : " + fn);
        }
        try {
            this.eventFileHandler = new FileHandler(fn);
            this.eventFileHandler.setFormatter(formatter);
            this.logger.addHandler(this.eventFileHandler);
            this.logger.setLevel(Level.ALL);
            if (Trace.isTracing) {
                t.data(64, "EventLogger.createEventFileHandler", 300, "Created new event file handler");
            }
        }
        catch (Exception e) {
            if (Trace.isTracing) {
                t.data(64, "EventLogger.createEventFileHandler", 900, "Error intializing event file handler : " + e.toString());
            }
            t.exit(64, "EventLogger.createEventFileHandler", 50027);
            return false;
        }
        t.exit(64, "EventLogger.createEventFileHandler", 0);
        return true;
    }

    public Logger getEventLogger() {
        return this.logger;
    }
}

