/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.trace;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;

public class CreateTraceInfo2 {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2009";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.commonservices/src/com/ibm/mq/commonservices/internal/trace/CreateTraceInfo2.java, javagui, p701, p701-112-140304  1.6.2.1 09/08/16 06:45:39";
    private static BufferedReader brSkeletonFile = null;
    private static final int PADDING = 50;
    private static BufferedWriter bwIncludeFile = null;
    private static String lastNum = null;
    private static BufferedWriter bwStaticIDDefinitions = null;
    private String[] names;
    private String prefix;

    private CreateTraceInfo2() {
    }

    public static void main(String[] args) {
        if (args.length < 5) {
            CreateTraceInfo2.showHelp();
        } else {
            CreateTraceInfo2 info = new CreateTraceInfo2();
            info.createIncludeFile(args[0], args[1], args[2], args[3], args[4]);
        }
    }

    private void createIncludeFile(String namesClassName, String aPrefix, String skeletonFile, String includeFile, String idFile) {
        String text = null;
        this.prefix = aPrefix;
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            System.out.println("Loading Names class: " + namesClassName);
            Class<?> namesClass = loader.loadClass(namesClassName);
            if (namesClass == null) {
                System.out.println("Error loading class: " + namesClassName);
                System.exit(999);
            } else {
                System.out.println("Getting the \"getNames()\" method");
                Method getNames = namesClass.getMethod("getNames", null);
                if (getNames == null) {
                    System.out.println("Error getting method \"getNames()\"");
                    System.exit(999);
                } else {
                    System.out.println("Getting the array of method names");
                    this.names = (String[])getNames.invoke(null, null);
                    if (this.names == null) {
                        System.out.println("getNames() returned \"null\"");
                        System.exit(999);
                    }
                }
            }
            System.out.println("Opening skeleton file : " + skeletonFile);
            brSkeletonFile = new BufferedReader(new FileReader(skeletonFile));
            System.out.println("Opening new include file : " + includeFile);
            bwIncludeFile = new BufferedWriter(new FileWriter(includeFile));
            System.out.println("Opening new ID file : " + idFile);
            bwStaticIDDefinitions = new BufferedWriter(new FileWriter(idFile));
            String startFunctions = "#define " + this.prefix + "FUNCTIONS";
            String lastNumberString = "#define " + this.prefix + "LASTNUM";
            String startFuncDefs = "FuncDef(" + this.prefix + "STRINGS";
            String startFuncStrings = "FuncString(" + this.prefix + "STRINGS";
            while ((text = brSkeletonFile.readLine()) != null) {
                if (text.trim().startsWith(startFunctions)) {
                    this.insertHashDefines();
                    continue;
                }
                if (text.trim().startsWith(lastNumberString)) {
                    bwIncludeFile.write(lastNumberString + "   " + lastNum);
                    bwIncludeFile.newLine();
                    continue;
                }
                if (text.trim().startsWith(startFuncDefs)) {
                    this.insertFuncDefs();
                    continue;
                }
                if (text.trim().startsWith(startFuncStrings)) {
                    this.insertFuncStrings();
                    continue;
                }
                bwIncludeFile.write(text);
                bwIncludeFile.newLine();
            }
            brSkeletonFile.close();
            bwIncludeFile.close();
            bwStaticIDDefinitions.close();
            System.out.println("Closed all files");
        }
        catch (Exception e) {
            System.out.println("Error\n" + e.getClass() + ": " + e.getMessage());
            try {
                brSkeletonFile.close();
                bwIncludeFile.close();
                bwStaticIDDefinitions.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
    }

    private void insertHashDefines() throws IOException {
        String output = "***";
        String className = "***";
        String methodName = "***";
        for (int i = 0; i < this.names.length; ++i) {
            output = this.names[i];
            int j = this.names[i].indexOf(".");
            if (j > 0) {
                className = this.names[i].substring(0, j);
                methodName = this.names[i].substring(j + 1);
                output = className + "_" + methodName;
            }
            bwIncludeFile.write("#define " + this.prefix + CreateTraceInfo2.leftJustify(output.toUpperCase(), 50) + " " + Integer.toString(i));
            bwIncludeFile.newLine();
            bwStaticIDDefinitions.write("  /**");
            bwStaticIDDefinitions.newLine();
            bwStaticIDDefinitions.write("   * WMQ trace id for " + className + " class, " + methodName + " method.");
            bwStaticIDDefinitions.newLine();
            bwStaticIDDefinitions.write("   * This value must match the appropriate string index in the traceEntryName array.");
            bwStaticIDDefinitions.newLine();
            bwStaticIDDefinitions.write("   */");
            bwStaticIDDefinitions.newLine();
            bwStaticIDDefinitions.write("  public static final int " + output.toUpperCase() + " = " + i + ";");
            bwStaticIDDefinitions.newLine();
        }
        lastNum = this.prefix + output.toUpperCase();
    }

    private void insertFuncDefs() throws IOException {
        for (int i = 0; i < this.names.length; ++i) {
            String name = this.names[i].toUpperCase().replaceAll("\\.", "_");
            bwIncludeFile.write("FuncDef(" + CreateTraceInfo2.leftJustify(name + ", ", 50) + "\"" + this.names[i] + "\")");
            bwIncludeFile.newLine();
        }
    }

    private void insertFuncStrings() throws IOException {
        if (this.names.length > 0) {
            String name = this.names[0].toUpperCase().replaceAll("\\.", "_");
            bwIncludeFile.write("    FuncString(" + name + ")");
            for (int i = 1; i < this.names.length; ++i) {
                name = this.names[i].toUpperCase().replaceAll("\\.", "_");
                bwIncludeFile.write(",");
                bwIncludeFile.newLine();
                bwIncludeFile.write("    FuncString(" + name + ")");
            }
            bwIncludeFile.newLine();
        }
    }

    public static String rightJustify(String str, int width) {
        String ret = str;
        for (int i = width - ret.length(); i > 0; --i) {
            ret = "0" + ret;
        }
        return ret;
    }

    public static String leftJustify(String str, int width) {
        String ret = str;
        for (int i = width - ret.length(); i > 0; --i) {
            ret = ret + " ";
        }
        return ret;
    }

    private static void showHelp() {
        System.out.println("java com.ibm.mq.explorer.core.commonservices.trace.CreateTraceEntry <input_directory> <output_directory>");
        System.out.println("");
        System.out.println("This is used to generate the include file called AMQJXTHA.H, needed during the");
        System.out.println("WMQ build process for the Eclipse Explorer. It will also generate a temporary");
        System.out.println("file defining a complete list of xxx_yyy values, needed in the Trace class.");
        System.out.println("");
        System.out.println(" where :");
        System.out.println("   input_directory  is the directory containing the skeleton include file");
        System.out.println("   output_directory is where the 2 new files will be written");
        System.out.println("");
    }
}

