/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.trace;

import com.ibm.mq.commonservices.internal.trace.Names;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class CreateTraceInfo {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2009";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.commonservices/src/com/ibm/mq/commonservices/internal/trace/CreateTraceInfo.java, javagui, p701, p701-112-140304  1.15.2.1 09/08/15 17:43:26";
    private static final String SKELETON_FILE = "amqjxtha.txt";
    private static final String INCLUDE_FILE = "amqjxtha.h";
    private static final String ID_FILE = "ID.java";
    private static BufferedReader brSkeletonFile = null;
    private static final int PADDING = 50;
    private static BufferedWriter bwIncludeFile = null;
    private static String jxplLastNum = null;
    private static BufferedWriter bwStaticIDDefinitions = null;

    private CreateTraceInfo() {
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            CreateTraceInfo.showHelp();
        } else {
            CreateTraceInfo.createIncludeFile(args[0], args[1]);
        }
    }

    private static boolean createIncludeFile(String inFile, String outFile) {
        String text = null;
        try {
            brSkeletonFile = new BufferedReader(new FileReader(inFile + File.separator + SKELETON_FILE));
            System.out.println("Reading skeleton file : " + inFile + File.separator + SKELETON_FILE);
            bwIncludeFile = new BufferedWriter(new FileWriter(outFile + File.separator + INCLUDE_FILE));
            System.out.println("Creating new include file : " + outFile + File.separator + INCLUDE_FILE);
            bwStaticIDDefinitions = new BufferedWriter(new FileWriter(outFile + File.separator + ID_FILE));
            System.out.println("Creating new ID file : " + outFile + File.separator + ID_FILE);
            CreateTraceInfo.writeProlog();
            while ((text = brSkeletonFile.readLine()) != null) {
                if (text.trim().startsWith("#define jxplFUNCTIONS")) {
                    CreateTraceInfo.insertHashDefines();
                    continue;
                }
                if (text.trim().startsWith("#define jxplLASTNUM")) {
                    bwIncludeFile.write("#define jxplLASTNUM   " + jxplLastNum);
                    bwIncludeFile.newLine();
                    continue;
                }
                if (text.trim().startsWith("\"jxplSTRINGS\"")) {
                    CreateTraceInfo.insertDescriptions();
                    continue;
                }
                bwIncludeFile.write(text);
                bwIncludeFile.newLine();
            }
            CreateTraceInfo.writeEpilog();
            brSkeletonFile.close();
            bwIncludeFile.close();
            bwStaticIDDefinitions.close();
            System.out.println("Closed all files");
        }
        catch (Exception e) {
            System.out.println("Exception reading/writing/closing file\n" + e.getMessage());
            try {
                brSkeletonFile.close();
            }
            catch (Exception e1) {
                System.out.println("Exception closing file\n" + e1.getMessage());
            }
            try {
                bwIncludeFile.close();
            }
            catch (Exception e2) {
                System.out.println("Exception closing file\n" + e2.getMessage());
            }
            try {
                bwStaticIDDefinitions.close();
            }
            catch (Exception e3) {
                System.out.println("Exception closing file\n" + e3.getMessage());
            }
            return false;
        }
        return true;
    }

    private static void insertHashDefines() throws IOException {
        String output = "***";
        String className = "***";
        String methodName = "***";
        for (int i = 0; i < Names.traceEntryName.length; ++i) {
            output = Names.traceEntryName[i];
            int j = Names.traceEntryName[i].indexOf(".");
            if (j > 0) {
                className = Names.traceEntryName[i].substring(0, j);
                methodName = Names.traceEntryName[i].substring(j + 1);
                output = className + "_" + methodName;
            }
            bwIncludeFile.write("#define jxpl" + CreateTraceInfo.leftJustify(output.toUpperCase(), 50) + " " + Integer.toString(i));
            bwIncludeFile.newLine();
            bwStaticIDDefinitions.write("  /**");
            bwStaticIDDefinitions.newLine();
            bwStaticIDDefinitions.write("   * WMQ trace id for " + className + " class, " + methodName + " method.");
            bwStaticIDDefinitions.newLine();
            bwStaticIDDefinitions.write("   * This value must match the appropriate string index in the traceEntryName array.");
            bwStaticIDDefinitions.newLine();
            bwStaticIDDefinitions.write("   */");
            bwStaticIDDefinitions.newLine();
            bwStaticIDDefinitions.write("  public static final int " + output.toUpperCase() + " = " + i + ";");
            bwStaticIDDefinitions.newLine();
        }
        jxplLastNum = "jxpl" + output.toUpperCase();
    }

    private static void insertDescriptions() throws IOException {
        for (int i = 0; i < Names.traceEntryName.length; ++i) {
            bwIncludeFile.write("    \"jxpl" + Names.traceEntryName[i] + "\"" + ",");
            bwIncludeFile.newLine();
        }
    }

    private static void writeProlog() throws IOException {
        bwStaticIDDefinitions.write("/*");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" * <OCO_COPYRIGHT>");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" * IBM Confidential");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" *");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" * OCO Source Materials");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" *");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" * 63H9336");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" * (C) Copyright IBM Corp. 2003,2005");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" *");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" * The source code for this program is not published or other-");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" * wise divested of its trade secrets, irrespective of what has");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" * been deposited with the U.S. CopyRight Office");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" * <END_COPYRIGHT>");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" */");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write("package com.ibm.mq.commonservices.internal.trace;");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write("import com.ibm.mq.commonservices.Common;");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write("/**");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" * This class contains all the static Trace ids used to identify classes and methods");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" * that have implemented tracing from this package.");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" * <p>");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" * The int value of each id must match the index of the same name as defined in");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" * {@link com.ibm.mq.explorer.core.commonservices.trace.Names#traceEntryName}.");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" * <p>");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" * The static variables can be generated automatically by running");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" * {@link com.ibm.mq.explorer.core.commonservices.trace.CreateTraceInfo#main(String[])}.");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write(" */");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write("public class ID {");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write("  /**");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write("   * Common copyright notice");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write("   */");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write("  public static final String COPYRIGHT_NOTICE = Common.SHORT_COPYRIGHT_STRING;");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write("  /**");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write("   * CMVC descriptors - expanded during extraction");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write("   */");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write("  public static final String SCCSID = \"@(#) eclipse/com.ibm.mq.commonservices/src/com/ibm/mq/commonservices/internal/trace/CreateTraceInfo.java, javagui, p701, p701-112-140304  1.15.2.1 09/08/15 17:43:26\";");
        bwStaticIDDefinitions.newLine();
    }

    private static void writeEpilog() throws IOException {
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write("  /**");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write("   * Default unused constructor for an ID");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write("   */");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write("  private ID() {");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write("  }");
        bwStaticIDDefinitions.newLine();
        bwStaticIDDefinitions.write("}");
        bwStaticIDDefinitions.newLine();
    }

    public static String rightJustify(String str, int width) {
        for (int i = width - str.length(); i > 0; --i) {
            str = "0" + str;
        }
        return str;
    }

    public static String leftJustify(String str, int width) {
        for (int i = width - str.length(); i > 0; --i) {
            str = str + " ";
        }
        return str;
    }

    private static void showHelp() {
        System.out.println("java com.ibm.mq.explorer.core.commonservices.trace.CreateTraceEntry <input_directory> <output_directory>");
        System.out.println("");
        System.out.println("This is used to generate the include file called AMQJXTHA.H, needed during the");
        System.out.println("WMQ build process for the Eclipse Explorer. It will also generate a temporary");
        System.out.println("file defining a complete list of xxx_yyy values, needed in the Trace class.");
        System.out.println("");
        System.out.println(" where :");
        System.out.println("   input_directory  is the directory containing the skeleton include file");
        System.out.println("   output_directory is where the 2 new files will be written");
        System.out.println("");
    }
}

